/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.utils.Constants;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.caf.tools.velocity.utils.PackageGenerator;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.caf.tools.velocity.utils.VelocityConverter;
import java.io.PrintWriter;
import java.util.HashMap;

public class MPConnectorGenerator {
    public HashMap initContext = null;
    ProjectLocations locations;
    PrintWriter log;
    String packageName;
    String appName;
    String providerName;
    boolean clearBeforeGeneration;

    public MPConnectorGenerator(String appName, String providerName, ProjectLocations locations, PrintWriter log, boolean clearBeforeGeneration) {
        this.log = log;
        this.locations = locations;
        this.clearBeforeGeneration = clearBeforeGeneration;
        this.appName = appName;
        this.providerName = providerName;
    }

    public synchronized void generateClass(GenerationMonitor monitor, DTRContentHolder contentHolder) throws GeneratorException {
        this.log.println("    Starting Message type generation: MPConnector.java & ValueClass.java");
        try {
            this.packageName = PackageGenerator.getExternalServicePackage(null, this.appName, this.providerName);
            this.initContext = this.generateInitContext();
            String generatorPath = this.locations.getExternalServicesPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + this.packageName.replace('.', '/');
            if (this.clearBeforeGeneration) {
                FileUtils.deleteDir(generatorPath + "/MPConnector.java", this.log, contentHolder.getDeleteQueue(), contentHolder.getFileList());
                FileUtils.deleteDir(generatorPath + "/ValueClass.java", this.log, contentHolder.getDeleteQueue(), contentHolder.getFileList());
            }
            this.log.println("      Generating class (at " + generatorPath + ")");
            String genFile = FileUtils.generateOutputFileName(generatorPath, "MPConnector");
            String beanTemplateName = "MPConnector_Template.vm";
            VelocityConverter.processTemplete(genFile, beanTemplateName, this.initContext, contentHolder, this.log);
            this.log.println("      Class generated successful");
            this.log.println("      Generating class (at " + generatorPath + ")");
            genFile = FileUtils.generateOutputFileName(generatorPath, "ValueClass");
            beanTemplateName = "ValueClass_Template.vm";
            VelocityConverter.processTemplete(genFile, beanTemplateName, this.initContext, contentHolder, this.log);
            this.log.println("      Class generated successful");
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
        this.log.println("   MPConnector generated successful");
        this.log.println("   ValueClass generated successful");
        this.log.println("   Dumpable generated successful");
    }

    private HashMap generateInitContext() throws CAFBaseException {
        HashMap<String, String> initContext = new HashMap<String, String>();
        initContext.put("package", this.packageName);
        return initContext;
    }
}

