/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.utils.GeneratedFilesList;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.ESMessageAttribute;
import com.sap.caf.tools.velocity.utils.Constants;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.caf.tools.velocity.utils.VelocityConverter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ExternalServiceParameterTypeGenerator {
    public static HashMap initContext = null;
    private String appName;
    private String extSvcName;
    private String proxyClassName;
    private String providerName;
    private ProjectLocations locations;
    private PrintWriter log;
    private ESMessageAttribute mdef;
    boolean clearBeforeGeneration;

    public ExternalServiceParameterTypeGenerator(ESMessageAttribute mdef, String extSvcName, String proxyClassName, String appName, String providerName, ProjectLocations locations, PrintWriter log, boolean clearBeforeGeneration) {
        this.mdef = mdef;
        this.appName = appName;
        this.extSvcName = extSvcName;
        this.proxyClassName = proxyClassName;
        this.providerName = providerName;
        this.locations = locations;
        this.log = log;
        this.clearBeforeGeneration = clearBeforeGeneration;
    }

    public void clear(String className, Map deleteQueue, GeneratedFilesList generatedFilesList) throws GeneratorException {
        try {
            String generatorPath = this.locations.getExternalServicesPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + this.mdef.getPackage().replace('.', '/') + "/" + className;
            FileUtils.deleteDir(generatorPath, this.log, deleteQueue, generatedFilesList);
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
    }

    public synchronized void generateClass(GenerationMonitor monitor, DTRContentHolder contentHolder) throws GeneratorException {
        this.log.println("    Starting Message type generation: " + this.mdef.getClassName());
        try {
            String packageName = this.mdef.getPackage();
            initContext = this.generateInitContext(this.mdef.getMembers());
            String generatorPath = this.locations.getExternalServicesPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + packageName.replace('.', '/');
            if (this.clearBeforeGeneration) {
                FileUtils.deleteDir(generatorPath + "/" + this.mdef.getClassName() + ".java", this.log, contentHolder.getDeleteQueue(), contentHolder.getFileList());
            }
            this.log.println("      Generating class (at " + generatorPath + ")");
            String beanFile = FileUtils.generateOutputFileName(generatorPath, this.mdef.getClassName());
            String beanTemplateName = "ExternalServiceParameterType_Template.vm";
            VelocityConverter.processTemplete(beanFile, beanTemplateName, initContext, contentHolder, this.log);
            this.log.println("      Class generated successful");
            if (monitor != null) {
                monitor.registerSubTask("Generating class (at " + generatorPath + ")");
            }
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
        this.log.println("    ExternalInterface generated successful: " + this.mdef.getClassName());
    }

    private HashMap generateInitContext(HashMap members) {
        HashMap<String, Object> initContext = new HashMap<String, Object>();
        Vector imports = new Vector();
        initContext.put("package", this.mdef.getPackage());
        initContext.put("attribute", this.mdef);
        initContext.put("name", this.mdef.getClassName());
        initContext.put("providerName", this.providerName);
        initContext.put("applicationName", this.appName);
        initContext.put("imports", imports);
        initContext.put("members", ESMessageAttribute.mapToVector(members));
        return initContext;
    }
}

