/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.utils.GeneratedFilesList;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.ExternalInterface;
import com.sap.caf.metamodel.FaultMessage;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.ESMessageAttribute;
import com.sap.caf.tools.velocity.ExternalServiceParameterTypeGenerator;
import com.sap.caf.tools.velocity.utils.Constants;
import com.sap.caf.tools.velocity.utils.DDicConverter;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.caf.tools.velocity.utils.NamingRestrictions;
import com.sap.caf.tools.velocity.utils.PackageGenerator;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.caf.tools.velocity.utils.StringUtils;
import com.sap.caf.tools.velocity.utils.VelocityConverter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ExternalServiceGenerator {
    public static HashMap initContext = null;
    private ExternalInterface ei;
    private String extSvcName;
    private String proxyClassName;
    private String packageName;
    private String appName;
    private String providerName;
    private ProjectLocations locations;
    private PrintWriter log;
    private boolean clearBeforeGeneration;
    private Vector methods;
    private HashMap types;
    private String extSvcBasePackage;

    public ExternalServiceGenerator(ExternalInterface ei, String appName, String providerName, ProjectLocations locations, PrintWriter log, boolean clearBeforeGeneration) {
        this.ei = ei;
        this.appName = appName;
        this.providerName = providerName;
        this.locations = locations;
        this.log = log;
        this.clearBeforeGeneration = clearBeforeGeneration;
        this.extSvcName = ei.getObjectName();
        this.proxyClassName = NamingRestrictions.constructJavaIdentifier(this.extSvcName);
        this.methods = new Vector();
        this.types = new HashMap();
    }

    public void clear(Map deleteQueue, GeneratedFilesList generatedFilesList) throws GeneratorException {
        try {
            String packageName = PackageGenerator.getExternalServicePackage(this.ei);
            String generatorPath = this.locations.getExternalServicesPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + packageName.replace('.', '/');
            FileUtils.deleteDir(generatorPath, this.log, deleteQueue, generatedFilesList);
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
    }

    public synchronized void generateClass(boolean hasFaults, GenerationMonitor monitor, DTRContentHolder contentHolder) throws GeneratorException {
        if (this.ei == null || this.proxyClassName == null) {
            throw new GeneratorException("Invalid ExternalInterface object found: " + this.extSvcName + ". Aborting generation.");
        }
        this.log.println("    Starting ExternalInterface generation: " + this.extSvcName);
        try {
            this.packageName = PackageGenerator.getExternalServicePackage(this.proxyClassName, this.appName, this.providerName);
            if (hasFaults) {
                String exceptionPackage = PackageGenerator.getExceptionsPackage(this.appName, this.providerName);
                String exceptionGenPath = this.locations.getExternalServicesPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + exceptionPackage.replace('.', '/');
                FileUtils.generatePackageStructure(exceptionGenPath);
            }
            initContext = this.generateInitContext();
            String generatorPath = this.locations.getExternalServicesPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + this.packageName.replace('.', '/');
            if (this.clearBeforeGeneration) {
                FileUtils.deleteDir(generatorPath, this.log, contentHolder.getDeleteQueue(), contentHolder.getFileList());
            }
            String generatorFileName = generatorPath + "/" + this.proxyClassName + "Bean.java";
            String beanTemplateName = "ExternalServiceBean_Template.vm";
            this.log.println("      Generating proxy ejb (file: " + generatorFileName + ")");
            String beanFile = FileUtils.generateOutputFileName(generatorPath, this.proxyClassName + "Bean");
            VelocityConverter.processTemplete(beanFile, beanTemplateName, initContext, contentHolder, this.log);
            generatorFileName = generatorPath + "/" + this.proxyClassName + "Local.java";
            beanTemplateName = "ExternalServiceLocal_Template.vm";
            this.log.println("      Generating proxy ejb(file: " + generatorFileName + ")");
            beanFile = FileUtils.generateOutputFileName(generatorPath, this.proxyClassName + "Local");
            VelocityConverter.processTemplete(beanFile, beanTemplateName, initContext, contentHolder, this.log);
            generatorFileName = generatorPath + "/" + this.proxyClassName + "LocalHome.java";
            beanTemplateName = "ExternalServiceLocalHome_Template.vm";
            this.log.println("      Generating proxy ejb (file: " + generatorFileName + ")");
            beanFile = FileUtils.generateOutputFileName(generatorPath, this.proxyClassName + "LocalHome");
            VelocityConverter.processTemplete(beanFile, beanTemplateName, initContext, contentHolder, this.log);
            this.log.println("      Proxy bean generated successfully");
            int i = 0;
            while (i < this.methods.size()) {
                this.generateMessageClass((Vector)((Map)this.methods.get(i)).get("METHOD_INPUT_STRUCTURE"), monitor, contentHolder);
                this.generateMessageClass((Vector)((Map)this.methods.get(i)).get("METHOD_OUTPUT_STRUCTURE"), monitor, contentHolder);
                ++i;
            }
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
        this.log.println("    ExternalInterface generated successful: " + this.proxyClassName);
    }

    public static void printTree(Object root, PrintWriter log, int offset) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < offset) {
            sb.append(" ");
            ++i;
        }
        ++offset;
        if (root instanceof MOFInterface) {
            ExternalServiceGenerator.printTree(((MOFInterface)root).getOperations(), log, offset);
        } else if (root instanceof Operation) {
            ExternalServiceGenerator.printTree(((Operation)root).getInput(), log, offset);
            ExternalServiceGenerator.printTree(((Operation)root).getOutput(), log, offset);
        } else if (root instanceof Message) {
            ExternalServiceGenerator.printTree(((Message)root).getMessageParts(), log, offset);
        } else if (root instanceof ESMessageAttribute) {
            log.println(sb.toString() + "ESM -> name=" + ((ESMessageAttribute)root).getMemberName() + ", class=" + ((ESMessageAttribute)root).getFullClassName());
            ExternalServiceGenerator.printTree(((ESMessageAttribute)root).getMembers(), log, offset);
        } else if (root instanceof Attribute) {
            Attribute attr = (Attribute)root;
            if (attr.getTypeJavaDdic() == null) {
                ExternalServiceGenerator.printTree(attr.getReferencedObject(), log, offset);
            } else {
                ExternalServiceGenerator.printTree(attr.getObjectName() + " - " + attr.getTypeJavaDdic(), log, offset);
            }
        } else if (root instanceof DataStructure) {
            ExternalServiceGenerator.printTree(((DataStructure)root).getAttributes(), log, offset);
        } else if (root instanceof Map) {
            ExternalServiceGenerator.printTree(((Map)root).values(), log, offset);
        } else if (root instanceof Hashtable) {
            ExternalServiceGenerator.printTree(((Hashtable)root).values(), log, offset);
        } else if (root instanceof Collection) {
            Iterator it = ((Collection)root).iterator();
            while (it.hasNext()) {
                ExternalServiceGenerator.printTree(it.next(), log, offset);
            }
        } else {
            if (root != null) {
                log.println(sb.append(root).append(root.getClass().getName()).toString());
            }
            return;
        }
    }

    private String composePackage(String parentType, boolean input) throws CAFBaseException {
        String pkg = PackageGenerator.getExternalMessagesPackage(null, this.proxyClassName, this.appName, this.providerName, input);
        if (parentType != null) {
            pkg = pkg + "." + StringUtils.capitalize(parentType);
        }
        return pkg;
    }

    private HashMap generateInitContext() throws CAFBaseException {
        HashMap<String, Object> initContext = new HashMap<String, Object>();
        Vector<String> imports = new Vector<String>();
        this.methods = new Vector();
        HashMap dependencies = new HashMap();
        List usedInterfaces = this.ei.getUsedInterfaces();
        this.extSvcBasePackage = PackageGenerator.getExternalServicePackage(null, this.appName, this.providerName);
        int i = 0;
        while (i < usedInterfaces.size()) {
            MOFInterface depInt = (MOFInterface)usedInterfaces.get(i);
            Vector<String> temp = new Vector<String>();
            String depApplicationName = null;
            String depProviderName = null;
            Application depApp = depInt.getApplication();
            if (depApp != null) {
                depApplicationName = depApp.getObjectName();
                depProviderName = depApp.getProviderName();
            }
            if (depApplicationName == null || depProviderName == null) {
                throw new CAFBaseException("Invalid dependency properties: app name: " + depApplicationName + ", provider name: " + depProviderName);
            }
            temp.addElement(depApplicationName);
            temp.addElement(depProviderName);
            dependencies.put(depInt.getObjectName(), temp);
            this.log.println("Adding dep: " + depInt.getObjectName());
            String servicePackage = null;
            if (depInt instanceof BusinessEntityInterface) {
                servicePackage = PackageGenerator.getBusinessServicePackage((BusinessEntityInterface)depInt, this.locations.getCoreName());
            } else if (depInt instanceof ExternalInterface) {
                servicePackage = PackageGenerator.getExternalServicePackage((ExternalInterface)depInt);
            } else {
                throw new CAFBaseException("Interface not supported: " + depInt.getClass().getName());
            }
            imports.addElement(servicePackage + "." + depInt.getObjectName() + "Local");
            imports.addElement(servicePackage + "." + depInt.getObjectName() + "LocalHome");
            if (i == 0) {
                imports.add(PackageGenerator.getUtilsPackage(this.appName, this.providerName) + ".HomeFactory");
            }
            ++i;
        }
        List operations = this.ei.getOperations();
        HashMap inputMessage = new HashMap();
        int i2 = 0;
        while (i2 < operations.size()) {
            Message outputMsg;
            Collection faultsMsg;
            HashMap method = new HashMap();
            Operation currOp = (Operation)operations.get(i2);
            String retValue = null;
            String inValue = null;
            String exceptions = null;
            String remoteExceptions = null;
            String javaDoc = "/**\n";
            HashMap outputMessage = new HashMap();
            String opLongText = currOp.getLongText();
            javaDoc = opLongText == null ? javaDoc + "     * Operation.longText\n" : javaDoc + "     * " + opLongText + "\n";
            Message inputMsg = currOp.getInput();
            if (inputMsg != null) {
                List attributes = inputMsg.getMessageParts();
                int j = 0;
                while (j < attributes.size()) {
                    Attribute currAttrib = (Attribute)attributes.get(j);
                    inValue = this.renderMessage((BaseObject)currAttrib, inputMessage, null, true);
                    String attrShortText = currAttrib.getShortText();
                    javaDoc = attrShortText == null ? javaDoc + "     * @param " + currAttrib.getObjectName() + " Attribute.shortText\n" : javaDoc + "     * @param " + currAttrib.getObjectName() + " " + attrShortText + "\n";
                    ++j;
                }
            }
            if ((faultsMsg = currOp.getFault()) != null && faultsMsg.size() > 0) {
                Object[] faultsColl = faultsMsg.toArray();
                int j = 0;
                while (j < faultsColl.length) {
                    String excShortText;
                    FaultMessage fm = (FaultMessage)faultsColl[j];
                    String excName = PackageGenerator.getExceptionName(fm);
                    exceptions = exceptions + excName;
                    remoteExceptions = remoteExceptions + excName;
                    if (j < faultsColl.length - 1) {
                        exceptions = exceptions + ", ";
                        remoteExceptions = remoteExceptions + ", ";
                    }
                    javaDoc = (excShortText = fm.getShortText()) == null ? javaDoc + "     * @exception " + excName + " FaultMessage.shortText\n" : javaDoc + "     * @exception " + excName + " " + excShortText + "\n";
                    ++j;
                }
            }
            if (exceptions == null) {
                if (exceptions == null) {
                    exceptions = "";
                }
                if (remoteExceptions == null) {
                    remoteExceptions = "";
                }
            }
            if ((outputMsg = currOp.getOutput()) != null) {
                List retList = outputMsg.getMessageParts();
                if (retList.size() > 1) {
                    throw new CAFBaseException("Wrong return values detected - there should be only one, " + retList.size() + " detected");
                }
                if (retList.size() == 1) {
                    Attribute retAttribute = (Attribute)retList.get(0);
                    retValue = this.renderMessage((BaseObject)retAttribute, outputMessage, null, false);
                    String retShortText = retAttribute.getShortText();
                    javaDoc = retShortText == null ? javaDoc + "     * @return Attribute.shortText\n" : javaDoc + "     * @return " + retShortText + "\n";
                } else {
                    retValue = "void";
                }
            } else {
                retValue = "void";
            }
            javaDoc = javaDoc + "     */";
            String transactionType = Constants.transactionTypes[currOp.getTransactionType()];
            ExternalServiceGenerator.printTree(inputMessage, this.log, 0);
            ExternalServiceGenerator.printTree(outputMessage, this.log, 0);
            method.put("METHOD_IN_VALUE", this.types.get(inValue));
            method.put("METHOD_RET_VALUE", this.types.get(retValue));
            method.put("METHOD_FAULT", exceptions);
            method.put("METHOD_REMOTE_FAULT", remoteExceptions);
            method.put("METHOD_JAVADOC", javaDoc);
            method.put("METHOD_TRANSACTION_TYPE", transactionType);
            method.put("METHOD_INPUT_STRUCTURE", ESMessageAttribute.mapToVector(inputMessage));
            method.put("METHOD_OUTPUT_STRUCTURE", ESMessageAttribute.mapToVector(outputMessage));
            method.put("METHOD_NAME", NamingRestrictions.constructJavaIdentifier(currOp.getObjectName()));
            method.put("XS_OPERATION_NAME", currOp.getObjectName());
            this.methods.addElement(method);
            ++i2;
        }
        initContext.put("dependencies", dependencies);
        initContext.put("objectGUID", this.ei.getObjectId());
        initContext.put("package", this.packageName);
        initContext.put("extSvcBasePackage", this.extSvcBasePackage);
        initContext.put("extSvcName", this.extSvcName);
        initContext.put("proxyClassName", this.proxyClassName);
        initContext.put("providerName", this.providerName);
        initContext.put("applicationName", this.appName);
        initContext.put("externalService", this.ei);
        initContext.put("imports", imports);
        initContext.put("methods", this.methods);
        ExternalServiceGenerator.printTree(this.ei, this.log, 0);
        initContext.put("METHOD_JAVADOC", "METHOD_JAVADOC");
        initContext.put("METHOD_RET_VALUE", "METHOD_RET_VALUE");
        initContext.put("METHOD_IN_VALUE", "METHOD_IN_VALUE");
        initContext.put("METHOD_HEADER", "METHOD_HEADER");
        initContext.put("METHOD_HEADER_FULL", "METHOD_HEADER_FULL");
        initContext.put("METHOD_FAULT", "METHOD_FAULT");
        initContext.put("METHOD_REMOTE_FAULT", "METHOD_REMOTE_FAULT");
        initContext.put("METHOD_PARAM_WRAPPERS", "METHOD_PARAM_WRAPPERS");
        initContext.put("METHOD_TRANSACTION_TYPE", "METHOD_TRANSACTION_TYPE");
        initContext.put("METHOD_INPUT_STRUCTURE", "METHOD_INPUT_STRUCTURE");
        initContext.put("METHOD_OUTPUT_STRUCTURE", "METHOD_OUTPUT_STRUCTURE");
        initContext.put("METHOD_NAME", "METHOD_NAME");
        initContext.put("XS_OPERATION_NAME", "XS_OPERATION_NAME");
        return initContext;
    }

    private void generateMessageClass(Vector vec, GenerationMonitor monitor, DTRContentHolder contentHolder) throws CAFBaseException {
        int i = 0;
        while (i < vec.size()) {
            ESMessageAttribute md = (ESMessageAttribute)vec.get(i);
            if (md.isValidStructure() && md.isClassFileGenerationNeeded() && !md.isGenerated()) {
                ExternalServiceParameterTypeGenerator emtg = new ExternalServiceParameterTypeGenerator(md, this.extSvcName, this.proxyClassName, this.appName, this.providerName, this.locations, this.log, this.clearBeforeGeneration);
                emtg.generateClass(monitor, contentHolder);
                md.setGenerated();
            }
            ++i;
        }
    }

    private String renderMessage(BaseObject messagePart, HashMap resultSubItems, String parentType, boolean input) throws CAFBaseException {
        String attribType = null;
        String attributeName = NamingRestrictions.constructJavaIdentifier(messagePart.getObjectName());
        String memberIdentifier = attributeName.toLowerCase();
        String resultType = null;
        if (messagePart instanceof Attribute) {
            Attribute attrib = (Attribute)messagePart;
            int maxOccurs = attrib.getMaxOccurs();
            if (maxOccurs == -1) {
                int listType = attrib.getListType();
                if (listType == 0) {
                    attribType = "java.util.Collection";
                } else if (listType == 1) {
                    attribType = "java.util.List";
                }
                HashMap mParts = null;
                if (attrib.getReferencedObject() != null) {
                    mParts = new HashMap();
                    this.renderMessage((BaseObject)attrib.getReferencedObject(), mParts, parentType, input);
                }
                ESMessageAttribute md = ESMessageAttribute.getESMessageAttribute(this.types, attribType, attributeName, null, mParts);
                md.setTypeOfCollection(true);
                resultSubItems.put(md, md);
                return attribType;
            }
            String ddicType = attrib.getTypeJavaDdic();
            if (ddicType != null) {
                String shortDDic = DDicConverter.getShortDDicType(ddicType, this.locations);
                attribType = DDicConverter.getJavaType(shortDDic);
                ESMessageAttribute esa = ESMessageAttribute.getESMessageAttribute(this.types, attribType, attributeName, null, null);
                esa.setSimpleType(true);
                resultSubItems.put(esa, esa);
                return attribType;
            }
            messagePart = attrib.getReferencedObject();
        }
        HashMap mParts = null;
        if (messagePart instanceof DataStructure) {
            DataStructure dStruct = (DataStructure)messagePart;
            mParts = new HashMap();
            String type = null;
            int i = 0;
            while (i < dStruct.getAttributes().size()) {
                String parentChain = memberIdentifier;
                if (parentType != null) {
                    parentChain = parentType + "." + memberIdentifier;
                }
                type = this.renderMessage((BaseObject)dStruct.getAttributes().get(i), mParts, parentChain, input);
                ++i;
            }
            if (parentType == null && dStruct.getAttributes().size() == 1) {
                resultType = type;
            }
        }
        ESMessageAttribute result = null;
        if (!attributeName.equals("")) {
            result = ESMessageAttribute.getESMessageAttribute(this.types, attributeName, this.composePackage(parentType, input), mParts);
            resultSubItems.put(result, result);
            if (result.isValidStructure()) {
                if (resultType != null) {
                    return resultType;
                }
                return result.getFullClassName();
            }
        }
        return "void";
    }
}

