/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.FaultMessage;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.utils.Constants;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.caf.tools.velocity.utils.PackageGenerator;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.caf.tools.velocity.utils.VelocityConverter;
import java.io.PrintWriter;
import java.util.HashMap;

public class ExceptionGenerator {
    public static void generateClass(FaultMessage fm, String appName, String providerName, ProjectLocations locations, PrintWriter log, GenerationMonitor monitor, DTRContentHolder contentHandler) throws GeneratorException {
        String excFullName = null;
        if (fm == null || (excFullName = fm.getObjectName()) == null) {
            log.println("    Invalid FaultMessage object found: " + excFullName + ". Aborting generation.");
            return;
        }
        try {
            Application excApp = fm.getApplication();
            if (excApp == null || locations.getCoreName().equals(excApp.getProviderName())) {
                log.println("    Core FaultMessage object found: " + excFullName + ". Skipping generation.");
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneratorException(e);
        }
        log.println("    Starting FaultMessage generation: " + excFullName);
        try {
            String packageName = PackageGenerator.getExceptionsPackage(appName, providerName);
            String excSimpleName = PackageGenerator.getExceptionName(fm);
            HashMap initContext = ExceptionGenerator.generateInitContext(packageName, excSimpleName);
            String generatorPath = locations.getApplicationServicesPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + packageName.replace('.', '/');
            String exceptionFile = FileUtils.generateOutputFileName(generatorPath, excSimpleName);
            String exceptionTemplateName = "Exception_Template.vm";
            VelocityConverter.processTemplete(exceptionFile, exceptionTemplateName, initContext, contentHandler, log);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneratorException(e);
        }
        log.println("    FaultMessage generated successful: " + excFullName);
    }

    private static HashMap generateInitContext(String packageName, String fmName) {
        HashMap<String, String> initContext = new HashMap<String, String>();
        initContext.put("name", fmName);
        initContext.put("package", packageName);
        return initContext;
    }
}

