/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.tools.velocity.utils.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class ESMessageAttribute {
    private String className;
    private String memberName;
    private String pkg;
    private HashMap members;
    private boolean classFileGenerationNeeded;
    private boolean typeOfCollection = false;
    private boolean generated = false;
    private boolean simpleType = false;

    public static ESMessageAttribute getESMessageAttribute(HashMap types, String className, String memberName, String pkg, HashMap members) {
        ESMessageAttribute temp;
        ESMessageAttribute result = new ESMessageAttribute(className, memberName, pkg, members);
        String key = result.getFullClassName();
        if (types.containsKey(key) && !(temp = (ESMessageAttribute)types.get(key)).isTypeOfCollection() && !temp.isSimpleType()) {
            result = temp;
            if (members != null) {
                if (result.getMembers() == null) {
                    result.setMembers(new HashMap());
                }
                result.getMembers().putAll(members);
            }
            return result;
        }
        types.put(key, result);
        return result;
    }

    public static ESMessageAttribute getESMessageAttribute(HashMap types, String memberName, String pkg, HashMap members) {
        ESMessageAttribute temp;
        ESMessageAttribute result = new ESMessageAttribute(memberName, pkg, members);
        String key = result.getFullClassName();
        if (types.containsKey(key) && !(temp = (ESMessageAttribute)types.get(key)).isTypeOfCollection() && !temp.isSimpleType()) {
            result = temp;
            if (members != null) {
                if (result.getMembers() == null) {
                    result.setMembers(new HashMap());
                }
                result.getMembers().putAll(members);
            }
            return result;
        }
        types.put(key, result);
        return result;
    }

    private ESMessageAttribute(String className, String memberName, String pkg, HashMap members) {
        this.setClassNameSimpleType(className);
        this.setMemberName(memberName);
        this.setPackage(pkg);
        this.setMembers(members);
        this.setClassFileGenerationNeeded(true);
    }

    private ESMessageAttribute(String memberName, String pkg, HashMap members) {
        this.setClassNameComplexType(memberName);
        this.setMemberName(memberName);
        this.setPackage(pkg);
        this.setMembers(members);
        this.setClassFileGenerationNeeded(true);
    }

    public String getChildrenPackage() {
        return this.pkg;
    }

    public void setClassFileGenerationNeeded(boolean b) {
        this.classFileGenerationNeeded = b;
    }

    public boolean isClassFileGenerationNeeded() {
        return this.classFileGenerationNeeded;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassNameComplexType(String string) {
        this.className = StringUtils.capitalize(string);
    }

    public void setClassNameSimpleType(String string) {
        this.className = string;
    }

    public String getFullClassName() {
        if (this.pkg != null && !this.pkg.equals("")) {
            return this.pkg + "." + this.className;
        }
        return this.className;
    }

    public String getMemberGetter() {
        return "get" + StringUtils.capitalize(this.memberName);
    }

    public void setMemberName(String string) {
        this.memberName = string;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getMemberNameCapitalized() {
        return StringUtils.capitalize(this.memberName);
    }

    public String getMemberNameUncapitalized() {
        return StringUtils.uncapitalize(this.memberName);
    }

    public String getMemberSetter() {
        return "set" + StringUtils.capitalize(this.memberName);
    }

    public void setMembers(HashMap vector) {
        this.members = vector;
    }

    public HashMap getMembers() {
        return this.members;
    }

    public Vector getMembersAsVector() {
        return ESMessageAttribute.mapToVector(this.members);
    }

    public void setPackage(String string) {
        this.pkg = string;
    }

    public String getPackage() {
        return this.pkg;
    }

    public void setTypeOfCollection(boolean b) {
        this.typeOfCollection = b;
    }

    public boolean isTypeOfCollection() {
        return this.typeOfCollection;
    }

    public boolean isValidStructure() {
        return this.memberName != null && !this.memberName.equals("");
    }

    public boolean hasMembers() {
        return this.members != null && this.members.size() > 0;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setGenerated() {
        this.generated = true;
    }

    public static Vector mapToVector(HashMap map) {
        Vector vec = new Vector();
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            vec.add(it.next());
        }
        return vec;
    }

    public boolean isSimpleType() {
        return this.simpleType;
    }

    public void setSimpleType(boolean b) {
        this.simpleType = b;
    }
}

