/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.caf.tools.velocity.utils.PackageGenerator;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.caf.tools.velocity.utils.VelocityConverter;
import java.io.PrintWriter;
import java.util.HashMap;

public class EARMetadataGenerator {
    public static synchronized void generateDescriptors(String appName, String providerName, ProjectLocations locations, HashMap generationExtraParameters, PrintWriter log, GenerationMonitor monitor, DTRContentHolder contentHandler) throws GeneratorException {
        try {
            log.println("    Starting EAR META-INF generation for appName=" + appName);
            String generatorPath = locations.getEarProjectPath() + "/META-INF";
            HashMap<String, String> initContext = new HashMap<String, String>();
            initContext.put("providerName", providerName);
            initContext.put("providerNameReverted", EARMetadataGenerator.getRevertedProvider(providerName));
            initContext.put("appName", appName);
            initContext.put("ejbName", EARMetadataGenerator.getMiddlePartOfEjbFileName(appName));
            if (generationExtraParameters != null) {
                initContext.putAll(generationExtraParameters);
            }
            log.println("      Generating log-configuration.xml");
            String metaLogConfigFile = FileUtils.generateOutputFileName(generatorPath, "log-configuration", "xml");
            String metaLogConfigTemplateName = "Log-configuration_xml_template.vm";
            VelocityConverter.processTemplete(metaLogConfigFile, metaLogConfigTemplateName, initContext, contentHandler, log);
            log.println("      log-configuration.xml generated successful");
            log.println("      Generating application.xml");
            String metaApplFile = FileUtils.generateOutputFileName(generatorPath, "application", "xml");
            String metaApplTemplateName = "Application_xml_template.vm";
            VelocityConverter.processTemplete(metaApplFile, metaApplTemplateName, initContext, contentHandler, log);
            log.println("      application.xml generated successful");
            if (PackageGenerator.existOutputFile(generatorPath, "application-j2ee-engine", "xml", monitor)) {
                log.println("      application-j2ee-engine.xml generated skiped");
            } else {
                log.println("      Generating application-j2ee-engine.xml");
                String metaApplJ2EEFile = FileUtils.generateOutputFileName(generatorPath, "application-j2ee-engine", "xml");
                String metaApplJ2EETemplateName = "application-j2ee-engine.xml.vm";
                VelocityConverter.processTemplete(metaApplJ2EEFile, metaApplJ2EETemplateName, initContext, contentHandler, log);
                log.println("      application-j2ee-engine.xml generated successful");
            }
            log.println("    EAR META-INF generated successful");
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
    }

    private static String getMiddlePartOfEjbFileName(String appName) {
        String ejbProjectName = BOMSystem.getBOMSystem(BOMSystem.getProjectNameFromAppName(appName)).getRelatedProjectNameByType("EJB");
        if (ejbProjectName == null) {
            return appName;
        }
        int firstIndexOf = ejbProjectName.indexOf("~");
        int lastIndexOf = ejbProjectName.lastIndexOf("~");
        return ejbProjectName.substring(firstIndexOf + 1, lastIndexOf).replace('.', '~').replace('/', '~').replace('\\', '~');
    }

    private static String getRevertedProvider(String providerName) {
        StringBuffer result = new StringBuffer(providerName.length());
        StringBuffer providerSB = new StringBuffer(providerName);
        int lastIndex = providerSB.toString().lastIndexOf(46);
        int prevLastindex = providerSB.length();
        while (lastIndex > 0) {
            result.append(providerSB.substring(lastIndex + 1, prevLastindex));
            result.append(".");
            providerSB.replace(lastIndex, lastIndex + 1, "~");
            prevLastindex = lastIndex;
            lastIndex = providerSB.toString().lastIndexOf(46);
        }
        result.append(providerSB.substring(0, prevLastindex));
        return result.toString();
    }
}

