/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.utils.Constants;
import com.sap.caf.tools.velocity.utils.DDicConverter;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.caf.tools.velocity.utils.PackageGenerator;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.caf.tools.velocity.utils.VelocityConverter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class DataStructureGenerator {
    public static synchronized void generateClass(DataStructure ds, String appName, String providerName, ProjectLocations locations, PrintWriter log, GenerationMonitor monitor, DTRContentHolder contentHandler) throws GeneratorException {
        String dsName = null;
        if (ds == null || (dsName = ds.getObjectName()) == null) {
            log.println("    Invalid DataStructure object found: " + dsName + ". Aborting generation.");
            return;
        }
        log.println("    Starting DataStructure generation: " + dsName);
        try {
            String packageName = PackageGenerator.getDataStructurePackage(appName, providerName);
            String generatorPath = locations.getApplicationServicesPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + packageName.replace('.', '/');
            String outputFile = FileUtils.generateOutputFileName(generatorPath, dsName);
            String templateName = "DTO_Template.vm";
            HashMap initContext = DataStructureGenerator.generateInitContext(ds, packageName, dsName, locations, log, providerName, appName);
            VelocityConverter.processTemplete(outputFile, templateName, initContext, contentHandler, log);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneratorException(e);
        }
        log.println("    DataStructure generated successful: " + dsName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap generateInitContext(DataStructure ds, String packageName, String className, ProjectLocations locations, PrintWriter log, String currProviderName, String currAppName) throws CAFBaseException {
        try {
            HashMap<String, Object> initContext = new HashMap<String, Object>();
            Vector<String> imports = new Vector<String>();
            HashMap attribs = new HashMap();
            imports.addElement("java.util.List");
            imports.addElement("java.util.ArrayList");
            List attributes = ds.getAttributes();
            int i = 0;
            while (i < attributes.size()) {
                HashMap<String, String> attrContent = new HashMap<String, String>();
                String getStart = null;
                String getEnd = null;
                String setStart = null;
                String setEnd = null;
                Attribute currAttrib = (Attribute)attributes.get(i);
                String attribType = DDicConverter.getAttributeType(currAttrib, locations, packageName);
                int ind = attribType.lastIndexOf(46);
                String val = attribType;
                if (ind == -1) {
                    String wrapperType = DDicConverter.getJavaWrapper(attribType);
                    if (wrapperType == null) {
                        getStart = "";
                        getEnd = "";
                        setStart = "(" + attribType + ") ";
                        setEnd = "";
                    } else {
                        getStart = "new " + wrapperType + "(";
                        getEnd = ")";
                        setStart = "((" + wrapperType + ") ";
                        if (wrapperType.equals("java.lang.Integer")) {
                            setEnd = ").intValue()";
                        } else if (wrapperType.equals("java.lang.Float")) {
                            setEnd = ").floatValue()";
                        } else if (wrapperType.equals("java.lang.Double")) {
                            setEnd = ").doubleValue()";
                        } else if (wrapperType.equals("java.lang.Short")) {
                            setEnd = ").shortValue()";
                        } else if (wrapperType.equals("java.lang.Long")) {
                            setEnd = ").longValue()";
                        } else if (wrapperType.equals("java.lang.Character")) {
                            setEnd = ").charValue()";
                        } else if (wrapperType.equals("java.lang.Byte")) {
                            setEnd = ").byteValue()";
                        } else {
                            if (!wrapperType.equals("java.lang.Boolean")) throw new CAFBaseException("Wrapper not supported: " + wrapperType);
                            setEnd = ").booleanValue()";
                        }
                    }
                } else {
                    getStart = "";
                    getEnd = "";
                    setStart = "(" + attribType + ") ";
                    setEnd = "";
                }
                attrContent.put("ATTRIBUTE_GET_END", getEnd);
                attrContent.put("ATTRIBUTE_GET_START", getStart);
                attrContent.put("ATTRIBUTE_SET_END", setEnd);
                attrContent.put("ATTRIBUTE_SET_START", setStart);
                attrContent.put("ATTRIBUTE_TYPE", val);
                attribs.put(currAttrib.getObjectName(), attrContent);
                ++i;
            }
            initContext.put("package", packageName);
            initContext.put("name", className);
            initContext.put("imports", imports);
            initContext.put("attributes", attribs);
            initContext.put("ATTRIBUTE_TYPE", "ATTRIBUTE_TYPE");
            initContext.put("ATTRIBUTE_GET_START", "ATTRIBUTE_GET_START");
            initContext.put("ATTRIBUTE_GET_END", "ATTRIBUTE_GET_END");
            initContext.put("ATTRIBUTE_SET_START", "ATTRIBUTE_SET_START");
            initContext.put("ATTRIBUTE_SET_END", "ATTRIBUTE_SET_END");
            return initContext;
        }
        catch (Exception ex) {
            throw new CAFBaseException(ex);
        }
    }
}

