/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.Field;
import com.sap.caf.metamodel.Property;
import com.sap.caf.metamodel.Table;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.caf.tools.velocity.utils.VelocityConverter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;

public class BERelationsGenerator {
    private static final String[] PROTECTED_ATTRIBUTES = new String[]{"createdAt", "createdBy", "lastChangedAt", "lastChangedBy", "key"};

    public static void generateClass(HashMap relations, HashMap relationsTables, String packageName, String generatorPath, DataObject be, String appName, String providerName, ProjectLocations locations, PrintWriter log, GenerationMonitor monitor, DTRContentHolder contentHolder) throws GeneratorException {
        try {
            boolean counterFK = false;
            if (relations != null && relations.size() > 0) {
                Iterator it = relations.keySet().iterator();
                while (it.hasNext()) {
                    HashMap<String, Object> relInitContext = new HashMap<String, Object>();
                    String relName = (String)it.next();
                    String relTable = (String)relationsTables.get(relName);
                    String relType = (String)((HashMap)relations.get(relName)).get("RELATION_TYPE");
                    Boolean doubleLocal = (Boolean)((HashMap)relations.get(relName)).get("DOUBLE_LOCAL_RELATION");
                    String parentName = be.getObjectName();
                    relInitContext.put("name", relName);
                    relInitContext.put("package", packageName);
                    relInitContext.put("tableName", relTable);
                    relInitContext.put("parentName", parentName);
                    relInitContext.put("parentApp", appName);
                    relInitContext.put("parentProvider", providerName);
                    relInitContext.put("relType", relType);
                    relInitContext.put("doubleLocal", doubleLocal);
                    String fieldBiDirectionalName = parentName.substring(0, 1).toLowerCase() + parentName.substring(1);
                    relInitContext.put("fieldBiDirectionalName", fieldBiDirectionalName);
                    Iterator attribIterator = be.getAttributes().iterator();
                    while (attribIterator.hasNext()) {
                        Property currentProperty = (Property)attribIterator.next();
                        if (!relName.equalsIgnoreCase(currentProperty.getObjectName())) continue;
                        Iterator iFields = currentProperty.getField().iterator();
                        while (iFields.hasNext()) {
                            String refTableName;
                            DataObject targetDO;
                            Field currentField = (Field)iFields.next();
                            if (!currentField.getFieldName().equalsIgnoreCase("PRIMARYKEY")) continue;
                            String masterTableName = currentField.getTable().getTableName();
                            relInitContext.put("masterTableName", masterTableName);
                            Table master = currentField.getTable();
                            if (master == null || (targetDO = master.getTargetDataObject()) == null || targetDO.getMasterTable() == null || (refTableName = targetDO.getMasterTable().getTableName()) == null) continue;
                            relInitContext.put("refTableName", refTableName);
                        }
                    }
                    String fieldBiDirectionalTableName = be.getMasterTable().getTableName();
                    relInitContext.put("fieldBiDirectionalTableName", fieldBiDirectionalTableName);
                    String foreignKeyName = relName.substring(0, 1).toLowerCase() + relName.substring(1) + "_" + fieldBiDirectionalTableName + "_" + "FK";
                    relInitContext.put("foreignKeyName", foreignKeyName);
                    String foreignKeyRefObjectName = relName + fieldBiDirectionalTableName + "_" + "FK";
                    if (foreignKeyRefObjectName.length() > 17) {
                        foreignKeyRefObjectName.substring(0, 16);
                    }
                    foreignKeyRefObjectName = foreignKeyRefObjectName + "_";
                    relInitContext.put("foreignKeyRefObjectName", foreignKeyRefObjectName);
                    log.println("      Generating relation: " + relName + "VO");
                    String relFile = FileUtils.generateOutputFileName(generatorPath, relName + "VO");
                    String relTemplateName = "BusinessEntity_REL_VO_Template.vm";
                    VelocityConverter.processTemplete(relFile, relTemplateName, relInitContext, contentHolder, log);
                    log.println("      Relation generated successful");
                    log.println("      Generating relation: " + relName + "VOPK");
                    String relPKFile = FileUtils.generateOutputFileName(generatorPath, relName + "VOPK");
                    String relPKTemplateName = "BusinessEntity_REL_VOPK_Template.vm";
                    VelocityConverter.processTemplete(relPKFile, relPKTemplateName, relInitContext, contentHolder, log);
                    log.println("      Relation generated successful");
                    log.println("      Generating " + relName + "VO.jdo");
                    String relJdoFile = FileUtils.generateOutputFileName(generatorPath, relName + "VO", "jdo");
                    String relJdoTemplateName = "BusinessEntity_REL_VO_JDO_Template.vm";
                    VelocityConverter.processTemplete(relJdoFile, relJdoTemplateName, relInitContext, contentHolder, log);
                    log.println("      " + relName + "VO.jdo generated successful");
                    log.println("      Generating " + relName + "VO.map");
                    String relMapFile = FileUtils.generateOutputFileName(generatorPath, relName + "VO", "map");
                    String relMapTemplateName = "BusinessEntity_REL_VO_MAP_Template.vm";
                    VelocityConverter.processTemplete(relMapFile, relMapTemplateName, relInitContext, contentHolder, log);
                    log.println("      " + relName + "VO.map generated successful");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneratorException(e);
        }
    }
}

