/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.Field;
import com.sap.caf.metamodel.Property;
import com.sap.caf.metamodel.Table;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.utils.Constants;
import com.sap.caf.tools.velocity.utils.DDicConverter;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.caf.tools.velocity.utils.PackageGenerator;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.caf.tools.velocity.utils.VelocityConverter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class BEMultipleTypeGenerator {
    public static void generateClass(Attribute attr, boolean isLocal, String appName, String providerName, String parentType, ProjectLocations locations, PrintWriter log, GenerationMonitor monitor, DTRContentHolder contentHolder) throws GeneratorException {
        String attrName = null;
        if (attr == null || (attrName = attr.getObjectName()) == null) {
            log.println("    Invalid complex type found: " + attrName + ". Aborting generation.");
            return;
        }
        try {
            attrName = attrName.substring(0, 1).toUpperCase() + attrName.substring(1);
            String packageName = PackageGenerator.getBusinessEntityPackage(parentType, appName, providerName, locations.getCoreName());
            HashMap initContext = BEMultipleTypeGenerator.generateInitContext(attr, packageName, attrName, appName, providerName, parentType, locations, log);
            String generatorPath = locations.getBusinessEntityPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + packageName.replace('.', '/');
            log.println("      Generating multiple attribute: " + attrName);
            String beFile = FileUtils.generateOutputFileName(generatorPath, attrName);
            String beTemplateName = "BusinessEntity_Multiple_Attr_Template.vm";
            VelocityConverter.processTemplete(beFile, beTemplateName, initContext, contentHolder, log);
            log.println("      Multiple attribute generated successful");
            log.println("      Generating multiple attribute PK: " + attrName + "PK");
            String bePKFile = FileUtils.generateOutputFileName(generatorPath, attrName + "PK");
            String bePKTemplateName = "BusinessEntity_Multiple_Attr_PK_Template.vm";
            VelocityConverter.processTemplete(bePKFile, bePKTemplateName, initContext, contentHolder, log);
            log.println("      Multiple attribute PK generated successful");
            if (isLocal) {
                log.println("      Generating " + attrName + ".jdo");
                String relJdoFile = FileUtils.generateOutputFileName(generatorPath, attrName, "jdo");
                String relJdoTemplateName = "BusinessEntity_Multiple_Attr_JDO_Template.vm";
                VelocityConverter.processTemplete(relJdoFile, relJdoTemplateName, initContext, contentHolder, log);
                log.println("      " + attrName + ".jdo generated successful");
                log.println("      Generating " + attrName + ".map");
                String relMapFile = FileUtils.generateOutputFileName(generatorPath, attrName, "map");
                String relMapTemplateName = "BusinessEntity_Multiple_Attr_MAP_Template.vm";
                VelocityConverter.processTemplete(relMapFile, relMapTemplateName, initContext, contentHolder, log);
                log.println("      " + attrName + ".map generated successful");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneratorException(e);
        }
    }

    private static String getFieldName(int position) {
        String sPosition = "" + position;
        StringBuffer result = new StringBuffer("field".length() + sPosition.length() + 1);
        result.append("field");
        int countUnd = 10 - sPosition.length();
        int i = 0;
        while (i < countUnd) {
            result.append("0");
            ++i;
        }
        result.append(sPosition);
        return result.toString();
    }

    private static void checkUpdateImports(Vector imports, String packageName, String attribType, PrintWriter log) {
        String restPackage = DDicConverter.replaceFirst(packageName + ".", "", attribType);
        if (restPackage.indexOf(46) != -1 && !imports.contains(attribType)) {
            log.println("      Adding import: " + attribType);
            imports.addElement(attribType);
        }
    }

    private static HashMap generateInitContext(Attribute attrib, String packageName, String beName, String appName, String providerName, String parentType, ProjectLocations locations, PrintWriter log) throws CAFBaseException {
        HashMap<String, Object> initContext = new HashMap<String, Object>();
        Vector imports = new Vector();
        HashMap attributes = new HashMap();
        Table masterTable = ((Field)((Property)attrib).getField().iterator().next()).getTable();
        String masterTableName = masterTable.getTableName();
        TreeMap fields = new TreeMap();
        int iCount = 0;
        Iterator fieldsIterator = masterTable.getFields().iterator();
        while (fieldsIterator.hasNext()) {
            Field currentField = (Field)fieldsIterator.next();
            HashMap fieldMap = new HashMap();
            String fieldName = "";
            String persistence_modifier = "persistent";
            String primary_key = "false";
            String embedded = "true";
            String default_fetch_group = "true";
            String columnName = currentField.getFieldName();
            if (currentField.getProperty() != null) {
                fieldName = currentField.getProperty().getObjectName();
            } else if ("OBJECTKEY".equals(columnName)) {
                fieldName = "key";
                primary_key = "true";
            } else if ("PARENTKEY".equals(columnName)) {
                fieldName = "parentKey";
            } else if ("PRIMARYKEY".equals(columnName)) {
                fieldName = "key";
                primary_key = "true";
            } else {
                fieldName = "key";
                primary_key = "true";
            }
            if ("OBJECTKEY".equalsIgnoreCase(columnName)) {
                columnName = "OBJECTKEY";
                embedded = null;
                primary_key = "true";
            }
            if (currentField.getProperty() != null && CAFBusinessEntityInterface.isComplexAttribute((Attribute)currentField.getProperty())) {
                fieldName = "key";
                primary_key = "true";
            }
            BEMultipleTypeGenerator.putObjectToMap(fieldName, "fieldName", fieldMap);
            BEMultipleTypeGenerator.putObjectToMap(persistence_modifier, "persistence_modifier", fieldMap);
            BEMultipleTypeGenerator.putObjectToMap(primary_key, "primary_key", fieldMap);
            BEMultipleTypeGenerator.putObjectToMap(embedded, "embedded", fieldMap);
            BEMultipleTypeGenerator.putObjectToMap(default_fetch_group, "default_fetch_group", fieldMap);
            BEMultipleTypeGenerator.putObjectToMap(columnName, "columnName", fieldMap);
            BEMultipleTypeGenerator.putObjectToMap(masterTableName, "tableName", fieldMap);
            BEMultipleTypeGenerator.putObjectToMap(fieldMap, BEMultipleTypeGenerator.getFieldName(iCount++), fields);
        }
        initContext.put("masterTableName", masterTableName);
        initContext.put("fields", fields);
        if (attrib.getReferencedObject() == null) {
            BEMultipleTypeGenerator.handleAttribute(attrib, attributes, locations, providerName, packageName, appName, log, imports);
        } else if (attrib.getReferencedObject() instanceof DataObject) {
            DataObject obj = (DataObject)attrib.getReferencedObject();
            List attribs = obj.getAttributes();
            int i = 0;
            while (i < attribs.size()) {
                Attribute currAttrib = (Attribute)attribs.get(i);
                BEMultipleTypeGenerator.handleAttribute(currAttrib, attributes, locations, providerName, packageName, appName, log, imports);
                ++i;
            }
        } else {
            throw new CAFBaseException("Invalid attribute type: " + attrib);
        }
        boolean isComplexAttr = CAFBusinessEntityInterface.isComplexAttribute(attrib);
        initContext.put("name", beName);
        initContext.put("package", packageName);
        initContext.put("appName", appName);
        initContext.put("providerName", providerName);
        initContext.put("attributes", attributes);
        initContext.put("imports", imports);
        initContext.put("parentType", parentType);
        initContext.put("isComplexAttr", new Boolean(isComplexAttr));
        initContext.put("ATTRIBUTE_IS_PROTECTED", "ATTRIBUTE_IS_PROTECTED");
        initContext.put("ATTRIBUTE_TYPE", "ATTRIBUTE_TYPE");
        initContext.put("ATTRIBUTE_GET_START", "ATTRIBUTE_GET_START");
        initContext.put("ATTRIBUTE_GET_END", "ATTRIBUTE_GET_END");
        initContext.put("ATTRIBUTE_SET_START", "ATTRIBUTE_SET_START");
        initContext.put("ATTRIBUTE_SET_END", "ATTRIBUTE_SET_END");
        return initContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleAttribute(Attribute currAttrib, HashMap storageMap, ProjectLocations locations, String providerName, String packageName, String appName, PrintWriter log, Vector imports) throws CAFBaseException {
        String fqAttribType;
        String currAttribName = currAttrib.getObjectName();
        HashMap<String, String> currAttribProps = new HashMap<String, String>();
        String getStart = null;
        String getEnd = null;
        String setStart = null;
        String setEnd = null;
        if (currAttribName == null) {
            throw new CAFBaseException("Null name not allowed for Attribute object");
        }
        if (currAttrib.getReferencedObject() != null && currAttrib.getReferencedObject() instanceof DataObject) {
            DataObject refObj = (DataObject)currAttrib.getReferencedObject();
            if (currAttrib.getTypeJavaDdic() == null && refObj.getBusinessEntityInterface() != null) {
                throw new CAFBaseException("Invalid attribute for multiple type " + refObj.getObjectName() + ": " + currAttribName);
            }
        }
        String attribType = fqAttribType = DDicConverter.getSimpleAttributeType(currAttrib, locations, providerName, appName);
        if (fqAttribType.indexOf(46) == -1) {
            String wrapperType = DDicConverter.getJavaWrapper(fqAttribType);
            if (wrapperType == null) {
                getStart = "";
                getEnd = "";
                setStart = "(" + attribType + ") ";
                setEnd = "";
            } else {
                getStart = "new " + wrapperType + "(";
                getEnd = ")";
                setStart = "((" + wrapperType + ") ";
                if (wrapperType.equals("java.lang.Integer")) {
                    setEnd = ").intValue()";
                } else if (wrapperType.equals("java.lang.Float")) {
                    setEnd = ").floatValue()";
                } else if (wrapperType.equals("java.lang.Double")) {
                    setEnd = ").doubleValue()";
                } else if (wrapperType.equals("java.lang.Short")) {
                    setEnd = ").shortValue()";
                } else if (wrapperType.equals("java.lang.Long")) {
                    setEnd = ").longValue()";
                } else if (wrapperType.equals("java.lang.Character")) {
                    setEnd = ").charValue()";
                } else if (wrapperType.equals("java.lang.Byte")) {
                    setEnd = ").byteValue()";
                } else {
                    if (!wrapperType.equals("java.lang.Boolean")) throw new CAFBaseException("Wrapper not supported: " + wrapperType);
                    setEnd = ").booleanValue()";
                }
            }
        } else {
            getStart = "";
            getEnd = "";
            setStart = "(" + attribType + ") ";
            setEnd = "";
        }
        currAttribProps.put("ATTRIBUTE_GET_START", getStart);
        currAttribProps.put("ATTRIBUTE_GET_END", getEnd);
        currAttribProps.put("ATTRIBUTE_SET_START", setStart);
        currAttribProps.put("ATTRIBUTE_SET_END", setEnd);
        currAttribProps.put("ATTRIBUTE_TYPE", attribType);
        storageMap.put(currAttribName, currAttribProps);
    }

    private static void putObjectToMap(Object object, String key, Map hMap) {
        if (object != null) {
            hMap.put(key, object);
        }
    }
}

