/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.utils.GeneratedFilesList;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.FaultMessage;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.metamodel.Property;
import com.sap.caf.tools.velocity.BEGenerator;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.utils.Constants;
import com.sap.caf.tools.velocity.utils.DDicConverter;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.caf.tools.velocity.utils.PackageGenerator;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.caf.tools.velocity.utils.StringUtils;
import com.sap.caf.tools.velocity.utils.VelocityConverter;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class BEIGenerator {
    public static final String FIND_BY_TYPE = "QueryFilter";
    public static HashMap initContext = null;
    private static Vector ignoreMethods = new Vector();

    public static File getGeneratedImplementation(BusinessEntityInterface bei, String appName, String providerName, ProjectLocations locations) throws CAFBaseException {
        String beServName = null;
        if (bei == null || (beServName = bei.getObjectName()) == null) {
            throw new GeneratorException("Invalid BusinessEntityInterface object found: " + beServName + ". Aborting generation.");
        }
        String packageName = PackageGenerator.getBusinessServicePackage(bei, locations.getCoreName());
        String generatorPath = locations.getBusinessEntityPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + packageName.replace('.', '/');
        String beanFile = FileUtils.generateOutputFileName(generatorPath, beServName + "Bean");
        return new File(beanFile);
    }

    public static void clear(BusinessEntityInterface bei, ProjectLocations locations, PrintWriter log, Map deleteQueue, GeneratedFilesList generatedFilesList) throws GeneratorException {
        try {
            String packageName = PackageGenerator.getBusinessServicePackage(bei, locations.getCoreName());
            String generatorPath = locations.getBusinessEntityPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + packageName.replace('.', '/');
            FileUtils.deleteDir(generatorPath, log, deleteQueue, generatedFilesList);
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
    }

    public static void generateClass(BusinessEntityInterface bei, String appName, String providerName, ProjectLocations locations, PrintWriter log, boolean clearBeforeGeneration, GenerationMonitor monitor, DTRContentHolder contentHolder) throws GeneratorException {
        String beServName = null;
        if (bei == null || (beServName = bei.getObjectName()) == null) {
            throw new GeneratorException("Invalid BusinessEntityInterface object found: " + beServName + ". Aborting generation.");
        }
        log.println("    Starting BusinessEntityInterface generation: " + beServName);
        try {
            String packageName = PackageGenerator.getBusinessServicePackage(bei, appName, providerName, locations.getCoreName());
            initContext = BEIGenerator.generateInitContext(bei, packageName, beServName, appName, providerName, locations, log);
            String generatorPath = locations.getBusinessEntityPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + packageName.replace('.', '/');
            if (clearBeforeGeneration) {
                FileUtils.deleteDir(generatorPath, log, contentHolder.getDeleteQueue(), contentHolder.getFileList());
            }
            BEGenerator.generateClass(bei.getBusinessEntity(), appName, providerName, locations, log, monitor, contentHolder);
            log.println("      Generating PK");
            String pkFile = FileUtils.generateOutputFileName(generatorPath, bei.getBusinessEntity().getObjectName() + "PK");
            String pkTemplateName = "BusinessEntity_PK_Template.vm";
            VelocityConverter.processTemplete(pkFile, pkTemplateName, initContext, contentHolder, log);
            log.println("      PK generated successful");
            log.println("      Generating bean");
            String beanFile = FileUtils.generateOutputFileName(generatorPath, beServName + "Bean");
            String beanTemplateName = "BusinessEntityServiceBean_Template.vm";
            VelocityConverter.processTemplete(beanFile, beanTemplateName, initContext, contentHolder, log);
            log.println("      Bean generated successful");
            log.println("      Generating local interface");
            String localFile = FileUtils.generateOutputFileName(generatorPath, beServName + "Local");
            String localTemplateName = "BusinessEntityServiceLocal_Template.vm";
            VelocityConverter.processTemplete(localFile, localTemplateName, initContext, contentHolder, log);
            log.println("      Local interface generated successful");
            log.println("      Generating local home interface");
            String localHomeFile = FileUtils.generateOutputFileName(generatorPath, beServName + "LocalHome");
            String localHomeTemplateName = "BusinessEntityServiceLocalHome_Template.vm";
            VelocityConverter.processTemplete(localHomeFile, localHomeTemplateName, initContext, contentHolder, log);
            log.println("      Local home interface generated successful");
            String projectName = BOMSystem.getProjectNameFromAppName(appName);
            BOMSystem bSystem = BOMSystem.getBOMSystem(projectName);
            String dictProjectName = bSystem.getRelatedProjectNameByType("DICT");
            MetamodelManager.reloadMetamodel((String)dictProjectName);
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
        log.println("    BusinessEntityInterface generated successful: " + beServName);
    }

    private static void checkUpdateImports(Vector imports, String asPackageName, String attribType, PrintWriter log) {
        String restPackage = DDicConverter.replaceFirst(asPackageName + ".", "", attribType);
        if (restPackage.indexOf(46) != -1 && !imports.contains(attribType)) {
            log.println("      Adding import: " + attribType);
            imports.addElement(attribType);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static HashMap generateInitContext(BusinessEntityInterface bei, String packageName, String beServiceName, String appName, String providerName, ProjectLocations locations, PrintWriter log) throws CAFBaseException {
        HashMap<String, Object> initContext = new HashMap<String, Object>();
        Vector<String> imports = new Vector<String>();
        Vector methods = new Vector();
        HashMap compositionRelations = new HashMap();
        Vector<String> dependencies = new Vector<String>();
        Boolean findByExist = new Boolean(false);
        Iterator attribsListIt = bei.getBusinessEntity().getAttributes().iterator();
        while (attribsListIt.hasNext()) {
            Attribute a = (Attribute)attribsListIt.next();
            if (a.getRelationType() == null || a.getRelationType() != 1 || a.getReferencedObject() == null || !(a.getReferencedObject() instanceof DataObject)) continue;
            DataObject doRel = (DataObject)a.getReferencedObject();
            String doRelImport = PackageGenerator.getBusinessServicePackage(doRel.getBusinessEntityInterface(), locations.getCoreName()) + "." + doRel.getObjectName();
            if (!imports.contains(doRelImport + "ServiceLocal")) {
                imports.addElement(doRelImport + "ServiceLocal");
                imports.addElement(doRelImport + "ServiceLocalHome");
            }
            String rName = doRel.getObjectName();
            Boolean rType = null;
            rType = a.getMaxOccurs() == 1 ? Boolean.TRUE : Boolean.FALSE;
            String relAttrName = a.getObjectName();
            relAttrName = relAttrName.substring(0, 1).toUpperCase() + relAttrName.substring(1);
            HashMap<String, Object> compRel = new HashMap<String, Object>();
            compRel.put("REL_TYPE_SINGLE", rType);
            compRel.put("REL_ATTR_NAME", rName);
            compositionRelations.put(relAttrName, compRel);
        }
        List usedInterfaces = bei.getUsedInterfaces();
        if (usedInterfaces.size() != 0) {
            imports.add("com.sap.caf.rt.exception.ServiceException");
            imports.add("com.sap.rixapp.exception.CAFPermissionException");
        }
        int i = 0;
        while (i < usedInterfaces.size()) {
            MOFInterface depInt = (MOFInterface)usedInterfaces.get(i);
            dependencies.addElement(depInt.getObjectName());
            String servicePackage = null;
            if (depInt instanceof BusinessEntityInterface) {
                servicePackage = PackageGenerator.getBusinessServicePackage((BusinessEntityInterface)depInt, appName, packageName, locations.getCoreName());
            } else {
                if (!(depInt instanceof ApplicationInterface)) {
                    throw new CAFBaseException("Interface not supported: " + depInt.getClass().getName());
                }
                servicePackage = PackageGenerator.getApplicationServicePackage(depInt.getObjectName(), appName, packageName);
            }
            imports.addElement(servicePackage + "." + depInt.getObjectName() + "Local");
            imports.addElement(servicePackage + "." + depInt.getObjectName() + "LocalHome");
            ++i;
        }
        List operations = bei.getOperations();
        int i2 = 0;
        while (i2 < operations.size()) {
            block35: {
                Operation currOp = (Operation)operations.get(i2);
                String opCurrName = currOp.getObjectName();
                if (opCurrName != null && !ignoreMethods.contains(opCurrName)) {
                    int j;
                    HashMap<String, Object> method = new HashMap<String, Object>();
                    methods.addElement(method);
                    boolean implCheck = false;
                    if (currOp.getPermission().getImplicitCheck() == 1) {
                        implCheck = true;
                    }
                    method.put("METHOD_IMPL_CHECK", new Boolean(implCheck));
                    String javaDoc = null;
                    Integer pattern = currOp.getPatternType();
                    int currOpPattern = pattern;
                    method.put("METHOD_TYPE", pattern);
                    switch (currOpPattern) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            break block35;
                        }
                        case 3: {
                            break block35;
                        }
                        case 4: {
                            break block35;
                        }
                        case 5: {
                            String mName = currOp.getObjectName();
                            findByExist = new Boolean(true);
                            break;
                        }
                        case 0: {
                            throw new CAFBaseException("Pattern type 0 is currently not used with BusinessEntity services");
                        }
                    }
                    String methodName = currOp.getObjectName();
                    String header = currOp.getObjectName() + "(";
                    String headerFull = currOp.getObjectName() + "(";
                    String exceptions = "";
                    String paramWrappers = "{";
                    javaDoc = "/**\n";
                    HashMap<String, Boolean> paramRelation = new HashMap<String, Boolean>();
                    HashMap<String, Boolean> paramMultiple = new HashMap<String, Boolean>();
                    HashMap<String, Boolean> paramComplex = new HashMap<String, Boolean>();
                    HashMap paramType = new HashMap();
                    String opLongText = currOp.getLongText();
                    javaDoc = opLongText == null ? javaDoc + "    * Operation.longText\n" : javaDoc + "    * " + opLongText + "\n";
                    Message inMsg = currOp.getInput();
                    if (inMsg != null) {
                        boolean isFirstMandatory = true;
                        ArrayList attributes = null;
                        if (currOpPattern == 1) {
                            attributes = new ArrayList();
                            attributes.addAll(bei.getBusinessEntity().getKeys());
                            attributes.addAll(bei.getBusinessEntity().getAttributes());
                        } else {
                            attributes = inMsg.getMessageParts();
                        }
                        j = 0;
                        while (j < attributes.size()) {
                            Attribute currAttrib = (Attribute)attributes.get(j);
                            if (currOpPattern != 1 || currAttrib.getMinOccurs() == 1) {
                                if (isFirstMandatory) {
                                    isFirstMandatory = false;
                                } else {
                                    header = header + ", ";
                                    headerFull = headerFull + ", ";
                                    paramWrappers = paramWrappers + ", ";
                                }
                                boolean isRelation = CAFBusinessEntityInterface.isEntityAttribute(currAttrib);
                                boolean isComplex = CAFBusinessEntityInterface.isComplexAttribute(currAttrib);
                                boolean isMultiple = false;
                                isMultiple = currAttrib.getMaxOccurs() == -1;
                                String attribName = null;
                                if (currAttrib.getObjectName() == null) {
                                    throw new CAFBaseException("Null attribute name not allowed.");
                                }
                                attribName = currAttrib.getObjectName();
                                paramRelation.put(attribName, new Boolean(isRelation));
                                paramMultiple.put(attribName, new Boolean(isMultiple));
                                paramComplex.put(attribName, new Boolean(isComplex));
                                String attribNameNoDots = attribName.replace('.', '_');
                                String attrShortText = currAttrib.getShortText();
                                javaDoc = attrShortText == null ? javaDoc + "     * @param " + attribNameNoDots + " Attribute.shortText\n" : javaDoc + "     * @param " + attribNameNoDots + " " + attrShortText + "\n";
                                String newWrapper = null;
                                if (currOpPattern == 5) {
                                    newWrapper = FIND_BY_TYPE;
                                    header = header + FIND_BY_TYPE;
                                    headerFull = headerFull + FIND_BY_TYPE + " " + attribNameNoDots + "Filter";
                                } else {
                                    String wrappType;
                                    String attribType = DDicConverter.getAttributeType(currAttrib, locations, packageName);
                                    newWrapper = attribType.indexOf(46) == -1 ? ((wrappType = DDicConverter.getJavaWrapper(attribType)) == null ? attribName : "new " + wrappType + "(" + attribName + ")") : (isRelation && !isMultiple ? attribNameNoDots + "Key" : attribNameNoDots);
                                    header = header + BEIGenerator.getAttributeTypeInterface(attribType);
                                    headerFull = isRelation && !isMultiple ? headerFull + "String " + attribNameNoDots + "Key" : headerFull + BEIGenerator.getAttributeTypeInterface(attribType) + " " + attribNameNoDots;
                                }
                                paramWrappers = paramWrappers + newWrapper;
                            }
                            ++j;
                        }
                    }
                    header = header + ")";
                    headerFull = headerFull + ")";
                    paramWrappers = paramWrappers + "}";
                    Collection faultsCollection = currOp.getFault();
                    if (faultsCollection != null) {
                        Object[] faultsColl = faultsCollection.toArray();
                        j = 0;
                        while (j < faultsColl.length) {
                            String excShortText;
                            if (j == 0) {
                                exceptions = "throws ";
                            }
                            FaultMessage fm = (FaultMessage)faultsColl[j];
                            exceptions = exceptions + fm.getObjectName();
                            if (j < faultsColl.length - 1) {
                                exceptions = exceptions + ", ";
                            }
                            javaDoc = (excShortText = fm.getShortText()) == null ? javaDoc + "     * @exception " + fm.getObjectName() + " FaultMessage.shortText\n" : javaDoc + "     * @exception " + fm.getObjectName() + " " + excShortText + "\n";
                            ++j;
                        }
                    }
                    javaDoc = javaDoc + "     */";
                    String transactionType = Constants.transactionTypes[currOp.getTransactionType()];
                    method.put("METHOD_JAVADOC", javaDoc);
                    method.put("METHOD_NAME", methodName);
                    method.put("METHOD_HEADER", header);
                    method.put("METHOD_HEADER_FULL", headerFull);
                    method.put("METHOD_PARAMETER_RELATION", paramRelation);
                    method.put("METHOD_PARAMETER_COMPLEX", paramComplex);
                    method.put("METHOD_PARAMETER_MULTIPLE", paramMultiple);
                    method.put("METHOD_PARAM_WRAPPERS", paramWrappers);
                    method.put("METHOD_TRANSACTION_TYPE", transactionType);
                }
            }
            ++i2;
        }
        String beName = bei.getBusinessEntity().getObjectName();
        boolean instChecked = false;
        if (bei.getInstancePermission() == 1) {
            instChecked = true;
        }
        Boolean isLocalBE = null;
        isLocalBE = bei.getBackend() == 0 ? new Boolean(true) : new Boolean(false);
        Boolean containsLD = new Boolean(false);
        List beAttribs = bei.getBusinessEntity().getAttributes();
        int i3 = 0;
        while (i3 < beAttribs.size()) {
            Boolean tempLD;
            Attribute tempA = (Attribute)beAttribs.get(i3);
            if (tempA instanceof Property && (tempLD = ((Property)tempA).isLanguageDependent()) != null && tempLD.booleanValue()) {
                containsLD = new Boolean(true);
                break;
            }
            ++i3;
        }
        HashMap attributes = new HashMap();
        BEIGenerator.handleAttribute(beAttribs, attributes, locations, providerName, packageName, appName, bei.getBusinessEntity(), log);
        Boolean classifiable = null;
        classifiable = bei.isClassifiable() != null ? bei.isClassifiable() : new Boolean(false);
        Boolean searchAndRetrieval = null;
        searchAndRetrieval = bei.isSearchAndRetrieval() != null ? bei.isSearchAndRetrieval() : new Boolean(false);
        initContext.put("beName", beName);
        initContext.put("pkeyName", beName + "PK");
        initContext.put("dependencies", dependencies);
        initContext.put("objectGUID", bei.getObjectId());
        initContext.put("package", packageName);
        initContext.put("serviceName", bei.getObjectName());
        initContext.put("providerName", providerName);
        initContext.put("appName", appName);
        initContext.put("imports", imports);
        initContext.put("attributes", attributes);
        initContext.put("methods", methods);
        initContext.put("compositionRelations", compositionRelations);
        initContext.put("isLocal", isLocalBE);
        initContext.put("findByExist", findByExist);
        initContext.put("INSTANCE_CHECKED", new Boolean(instChecked));
        initContext.put("containsLangDepAttr", containsLD);
        initContext.put("classifiable", classifiable);
        initContext.put("searchAndRetrieval", searchAndRetrieval);
        initContext.put("METHOD_TYPE", "METHOD_TYPE");
        initContext.put("METHOD_JAVADOC", "METHOD_JAVADOC");
        initContext.put("METHOD_NAME", "METHOD_NAME");
        initContext.put("METHOD_HEADER", "METHOD_HEADER");
        initContext.put("METHOD_HEADER_FULL", "METHOD_HEADER_FULL");
        initContext.put("METHOD_PARAM_WRAPPERS", "METHOD_PARAM_WRAPPERS");
        initContext.put("METHOD_PARAMETER_MULTIPLE", "METHOD_PARAMETER_MULTIPLE");
        initContext.put("METHOD_PARAMETER_RELATION", "METHOD_PARAMETER_RELATION");
        initContext.put("METHOD_PARAMETER_COMPLEX", "METHOD_PARAMETER_COMPLEX");
        initContext.put("ATTRIBUTE_TYPE", "ATTRIBUTE_TYPE");
        initContext.put("ATTRIBUTE_KIND_IS_COMPLEX", "ATTRIBUTE_KIND_IS_COMPLEX");
        initContext.put("ATTRIBUTE_KIND_IS_MULTIPLE", "ATTRIBUTE_KIND_IS_MULTIPLE");
        initContext.put("ATTRIBUTE_KIND_IS_RELATION", "ATTRIBUTE_KIND_IS_RELATION");
        initContext.put("ATTRIBUTE_IS_LANG_DEP", "ATTRIBUTE_IS_LANG_DEP");
        initContext.put("ATTRIBUTE_DOMAIN_TYPE", "ATTRIBUTE_DOMAIN_TYPE");
        initContext.put("DOUBLE_LOCAL_RELATION", "DOUBLE_LOCAL_RELATION");
        initContext.put("DOUBLE_LOCAL_DETAILS", "DOUBLE_LOCAL_DETAILS");
        initContext.put("METHOD_IMPL_CHECK", "METHOD_IMPL_CHECK");
        initContext.put("METHOD_TRANSACTION_TYPE", "METHOD_TRANSACTION_TYPE");
        return initContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleAttribute(List beAttribs, HashMap storageMap, ProjectLocations locations, String providerName, String packageName, String appName, DataObject be, PrintWriter log) throws CAFBaseException {
        boolean isLocal = BEIGenerator.isLocalEntity(be);
        String beName = be.getObjectName();
        if (beAttribs == null || beAttribs.size() <= 0) return;
        int i = 0;
        while (i < beAttribs.size()) {
            String fqAttribType;
            Attribute currAttrib = (Attribute)beAttribs.get(i);
            String currAttribName = currAttrib.getObjectName();
            HashMap<String, Object> currAttribProps = new HashMap<String, Object>();
            String getStart = null;
            String getEnd = null;
            String setStart = null;
            String setEnd = null;
            if (currAttribName == null) {
                throw new CAFBaseException("Null name not allowed for Attribute object");
            }
            String attribType = fqAttribType = DDicConverter.getAttributeType(currAttrib, locations, packageName);
            if (fqAttribType.indexOf(46) == -1) {
                String wrapperType = DDicConverter.getJavaWrapper(fqAttribType);
                if (wrapperType == null) {
                    getStart = "";
                    getEnd = "";
                    setStart = "(" + attribType + ") ";
                    setEnd = "";
                } else {
                    getStart = "new " + wrapperType + "(";
                    getEnd = ")";
                    setStart = "((" + wrapperType + ") ";
                    if (wrapperType.equals("java.lang.Integer")) {
                        setEnd = ").intValue()";
                    } else if (wrapperType.equals("java.lang.Float")) {
                        setEnd = ").floatValue()";
                    } else if (wrapperType.equals("java.lang.Double")) {
                        setEnd = ").doubleValue()";
                    } else if (wrapperType.equals("java.lang.Short")) {
                        setEnd = ").shortValue()";
                    } else if (wrapperType.equals("java.lang.Long")) {
                        setEnd = ").longValue()";
                    } else if (wrapperType.equals("java.lang.Character")) {
                        setEnd = ").charValue()";
                    } else if (wrapperType.equals("java.lang.Byte")) {
                        setEnd = ").byteValue()";
                    } else {
                        if (!wrapperType.equals("java.lang.Boolean")) throw new CAFBaseException("Wrapper not supported: " + wrapperType);
                        setEnd = ").booleanValue()";
                    }
                }
            } else {
                getStart = "";
                getEnd = "";
                setStart = "(" + attribType + ") ";
                setEnd = "";
            }
            String domainTypeName = PackageGenerator.getBusinessEntityPackage(beName, appName, providerName, locations.getCoreName()) + "." + StringUtils.capitalize(currAttribName);
            boolean isRelation = CAFBusinessEntityInterface.isEntityAttribute(currAttrib);
            if (isRelation) {
                domainTypeName = domainTypeName + "VO";
            }
            boolean doubleLocal = false;
            HashMap attributeDetails = null;
            String relationVOIdentifier = null;
            if (isRelation) {
                DataObject beAttrb = (DataObject)currAttrib.getReferencedObject();
                if (isLocal && BEIGenerator.isLocalEntity(beAttrb)) {
                    doubleLocal = true;
                    attributeDetails = BEIGenerator.getAttributeDetails(beAttrb, locations);
                    relationVOIdentifier = packageName + "." + currAttrib.getObjectName().substring(0, 1).toUpperCase() + currAttrib.getObjectName().substring(1) + "VO";
                }
            }
            Boolean isLangDep = null;
            if (currAttrib instanceof Property) {
                isLangDep = ((Property)currAttrib).isLanguageDependent();
                if (isLangDep.booleanValue()) {
                    domainTypeName = PackageGenerator.getBusinessEntityPackage(beName, appName, providerName, locations.getCoreName()) + "." + beName + "LDVO";
                }
            } else {
                isLangDep = new Boolean(false);
            }
            currAttribProps.put("ATTRIBUTE_GET_START", getStart);
            currAttribProps.put("ATTRIBUTE_GET_END", getEnd);
            currAttribProps.put("ATTRIBUTE_SET_START", setStart);
            currAttribProps.put("ATTRIBUTE_SET_END", setEnd);
            currAttribProps.put("ATTRIBUTE_TYPE", attribType);
            currAttribProps.put("ATTRIBUTE_KIND_IS_MULTIPLE", new Boolean(currAttrib.getMaxOccurs() == -1));
            currAttribProps.put("ATTRIBUTE_KIND_IS_COMPLEX", new Boolean(CAFBusinessEntityInterface.isComplexAttribute(currAttrib)));
            currAttribProps.put("ATTRIBUTE_KIND_IS_RELATION", new Boolean(isRelation));
            currAttribProps.put("ATTRIBUTE_IS_LANG_DEP", isLangDep);
            currAttribProps.put("ATTRIBUTE_DOMAIN_TYPE", domainTypeName);
            currAttribProps.put("DOUBLE_LOCAL_RELATION", new Boolean(doubleLocal));
            if (doubleLocal) {
                currAttribProps.put("DOUBLE_LOCAL_DETAILS", attributeDetails);
                currAttribProps.put("RELATION_VO_IDENTIFIER", relationVOIdentifier);
            }
            storageMap.put(currAttribName, currAttribProps);
            ++i;
        }
    }

    private static HashMap getAttributeDetails(DataObject beAttrib, ProjectLocations locations) throws CAFBaseException {
        HashMap details = new HashMap();
        List attribs = beAttrib.getAttributes();
        int i = 0;
        while (i < attribs.size()) {
            HashMap<String, Object> subDetails = new HashMap<String, Object>();
            Attribute attr = (Attribute)attribs.get(i);
            String packageName = PackageGenerator.getBusinessServicePackage(beAttrib.getBusinessEntityInterface(), locations.getCoreName());
            String attribType = DDicConverter.getAttributeType(attr, locations, packageName);
            boolean isRelation = CAFBusinessEntityInterface.isEntityAttribute(attr);
            boolean isLocalRelation = false;
            if (isRelation) {
                isLocalRelation = BEIGenerator.isLocalEntity((DataObject)attr.getReferencedObject());
            }
            Boolean isLangDep = null;
            isLangDep = attr instanceof Property ? ((Property)attr).isLanguageDependent() : new Boolean(false);
            String domainTypeName = packageName + ".";
            if (isLangDep.booleanValue()) {
                domainTypeName = domainTypeName + beAttrib.getObjectName() + "LDVO";
            } else {
                domainTypeName = domainTypeName + StringUtils.capitalize(attr.getObjectName());
                if (isRelation) {
                    domainTypeName = domainTypeName + "VO";
                }
            }
            subDetails.put("ATTRIBUTE_TYPE", attribType);
            subDetails.put("ATTRIBUTE_KIND_IS_MULTIPLE", new Boolean(attr.getMaxOccurs() == -1));
            subDetails.put("ATTRIBUTE_KIND_IS_COMPLEX", new Boolean(CAFBusinessEntityInterface.isComplexAttribute(attr)));
            subDetails.put("ATTRIBUTE_KIND_IS_RELATION", new Boolean(isRelation));
            subDetails.put("DOUBLE_LOCAL_RELATION", new Boolean(isLocalRelation));
            subDetails.put("ATTRIBUTE_IS_LANG_DEP", isLangDep);
            subDetails.put("ATTRIBUTE_DOMAIN_TYPE", domainTypeName);
            details.put(attr.getObjectName(), subDetails);
            ++i;
        }
        return details;
    }

    private static boolean isLocalEntity(DataObject be) {
        boolean isLocal = false;
        if (be.getBusinessEntityInterface().getBackend() != null && be.getBusinessEntityInterface().getBackend() == 0) {
            isLocal = true;
        }
        return isLocal;
    }

    private static String getAttributeTypeInterface(String attrType) {
        String retValueInterface = null;
        retValueInterface = attrType.equals("java.util.ArrayList") ? "java.util.List" : (attrType.equals("java.util.HashSet") ? "java.util.Set" : attrType);
        return retValueInterface;
    }

    static {
        ignoreMethods.addElement("addAuthUser");
        ignoreMethods.addElement("removeAuthUser");
        ignoreMethods.addElement("getAuthUser");
        ignoreMethods.addElement("addPermission");
        ignoreMethods.addElement("removePermission");
        ignoreMethods.addElement("getPrincipalPermission");
        ignoreMethods.addElement("getCategories");
        ignoreMethods.addElement("getClassification");
        ignoreMethods.addElement("addClassification");
        ignoreMethods.addElement("removeClassification");
        ignoreMethods.addElement("findByKMPropertySearch");
        ignoreMethods.addElement("searchidxForSimilar");
        ignoreMethods.addElement("findByMultipleParameters");
    }
}

