/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.Field;
import com.sap.caf.metamodel.Property;
import com.sap.caf.metamodel.Table;
import com.sap.caf.tools.velocity.BEComplexTypeGenerator;
import com.sap.caf.tools.velocity.BEMultipleTypeGenerator;
import com.sap.caf.tools.velocity.BERelationsGenerator;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.utils.Constants;
import com.sap.caf.tools.velocity.utils.DDicConverter;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.caf.tools.velocity.utils.PackageGenerator;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.caf.tools.velocity.utils.VelocityConverter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class BEGenerator {
    private static final String[] PROTECTED_ATTRIBUTES = new String[]{"createdAt", "createdBy", "lastChangedAt", "lastChangedBy", "key"};

    public static void generateClass(DataObject be, String appName, String providerName, ProjectLocations locations, PrintWriter log, GenerationMonitor monitor, DTRContentHolder contentHolder) throws GeneratorException {
        String beName = null;
        if (be == null || (beName = be.getObjectName()) == null) {
            log.println("    Invalid BusinessEntity object found: " + beName + ". Aborting generation.");
            return;
        }
        try {
            String packageName = PackageGenerator.getBusinessEntityPackage(beName, appName, providerName, locations.getCoreName());
            HashMap initContext = BEGenerator.generateInitContext(be, packageName, beName, appName, providerName, locations, log, monitor, contentHolder);
            String generatorPath = locations.getBusinessEntityPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + packageName.replace('.', '/');
            log.println("      Generating BusinessEntity: " + beName);
            String beFile = FileUtils.generateOutputFileName(generatorPath, beName);
            String beTemplateName = "BusinessEntity_Template.vm";
            VelocityConverter.processTemplete(beFile, beTemplateName, initContext, contentHolder, log);
            log.println("      BusinessEntity generated successful");
            log.println("      Generating " + beName + ".jdo");
            String jdoFile = FileUtils.generateOutputFileName(generatorPath, beName, "jdo");
            String jdoTemplateName = "BusinessEntity_JDO_Template.vm";
            VelocityConverter.processTemplete(jdoFile, jdoTemplateName, initContext, contentHolder, log);
            log.println("      " + beName + ".jdo generated successful");
            log.println("      Generating " + beName + ".map");
            String mapFile = FileUtils.generateOutputFileName(generatorPath, beName, "map");
            String mapTemplateName = "BusinessEntity_MAP_Template.vm";
            VelocityConverter.processTemplete(mapFile, mapTemplateName, initContext, contentHolder, log);
            log.println("      " + beName + ".map generated successful");
            boolean hasLDAttr = false;
            Boolean ldA = (Boolean)initContext.get("containsLangDepAttr");
            if (ldA != null) {
                hasLDAttr = ldA;
            }
            if (hasLDAttr) {
                log.println("      Generating " + beName + "LDVO");
                String ldvoFile = FileUtils.generateOutputFileName(generatorPath, beName + "LDVO");
                String ldvoTemplateName = "BusinessEntity_LDVO_Template.vm";
                VelocityConverter.processTemplete(ldvoFile, ldvoTemplateName, initContext, contentHolder, log);
                log.println("      " + beName + "LDVO generated successful");
                log.println("      Generating " + beName + "LDVOPK");
                String ldvopkFile = FileUtils.generateOutputFileName(generatorPath, beName + "LDVOPK");
                String ldvopkTemplateName = "BusinessEntity_LDVOPK_Template.vm";
                VelocityConverter.processTemplete(ldvopkFile, ldvopkTemplateName, initContext, contentHolder, log);
                log.println("      " + beName + "LDVOPK generated successful");
                boolean isLocal = false;
                if (be != null && be.getBusinessEntityInterface() != null && be.getBusinessEntityInterface().getBackend() != null) {
                    boolean bl = isLocal = be.getBusinessEntityInterface().getBackend() == 0;
                }
                if (isLocal) {
                    log.println("      Generating " + beName + ".jdo");
                    String jdoFileLD = FileUtils.generateOutputFileName(generatorPath, beName + "LDVO", "jdo");
                    String jdoTemplateLDName = "BusinessEntity_LDVO_JDO_Template.vm";
                    VelocityConverter.processTemplete(jdoFileLD, jdoTemplateLDName, initContext, contentHolder, log);
                    log.println("      " + beName + ".jdo generated successful");
                    log.println("      Generating " + beName + ".map");
                    String mapFileLD = FileUtils.generateOutputFileName(generatorPath, beName + "LDVO", "map");
                    String mapTemplateLDName = "BusinessEntity_LDVO_MAP_Template.vm";
                    VelocityConverter.processTemplete(mapFileLD, mapTemplateLDName, initContext, contentHolder, log);
                    log.println("      " + beName + ".map generated successful");
                }
            }
            HashMap relations = (HashMap)initContext.get("relations");
            HashMap relationsTables = (HashMap)initContext.get("relationsTables");
            BERelationsGenerator.generateClass(relations, relationsTables, packageName, generatorPath, be, appName, providerName, locations, log, monitor, contentHolder);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneratorException(e);
        }
    }

    private static String getFieldName(int position) {
        String sPosition = "" + position;
        StringBuffer result = new StringBuffer("field".length() + sPosition.length() + 1);
        result.append("field");
        int countUnd = 10 - sPosition.length();
        int i = 0;
        while (i < countUnd) {
            result.append("0");
            ++i;
        }
        result.append(sPosition);
        return result.toString();
    }

    private static Boolean checkProtectedStatus(String name) {
        int i = 0;
        while (i < PROTECTED_ATTRIBUTES.length) {
            if (name.equals(PROTECTED_ATTRIBUTES[i])) {
                return new Boolean(true);
            }
            ++i;
        }
        return new Boolean(false);
    }

    private static void checkUpdateImports(Vector imports, String packageName, String attribType, PrintWriter log) {
        String restPackage = DDicConverter.replaceFirst(packageName + ".", "", attribType);
        if (restPackage.indexOf(46) != -1 && !imports.contains(attribType)) {
            log.println("      Adding import: " + attribType);
            imports.addElement(attribType);
        }
    }

    private static HashMap generateInitContext(DataObject be, String packageName, String beName, String appName, String providerName, ProjectLocations locations, PrintWriter log, GenerationMonitor monitor, DTRContentHolder contentHolder) throws CAFBaseException {
        String update;
        String multiplicity;
        String default_fetch_group;
        String persistence_modifier;
        String fieldName;
        HashMap fieldMap;
        HashMap<String, Object> initContext = new HashMap<String, Object>();
        Vector imports = new Vector();
        Vector mapProperties = new Vector();
        HashMap relationsTables = new HashMap();
        HashMap attributes = new HashMap();
        HashMap relations = new HashMap();
        HashMap keys = new HashMap();
        Table masterTable = be.getMasterTable();
        String masterTableName = masterTable.getTableName();
        TreeMap fields = new TreeMap();
        TreeMap complexFields = new TreeMap();
        TreeMap multipleFields = new TreeMap();
        TreeMap ldFields = new TreeMap();
        TreeMap fieldsAssociationOne = new TreeMap();
        int i = 0;
        boolean isLocal = false;
        if (be != null && be.getBusinessEntityInterface() != null && be.getBusinessEntityInterface().getBackend() != null) {
            isLocal = be.getBusinessEntityInterface().getBackend() == 0;
        }
        Iterator fieldsIterator = masterTable.getFields().iterator();
        while (fieldsIterator.hasNext()) {
            Field currentField = (Field)fieldsIterator.next();
            HashMap fieldMap2 = new HashMap();
            String fieldName2 = "";
            String persistence_modifier2 = "none";
            if (currentField.getTable() != be.getMasterTable() || isLocal || CAFBusinessEntityInterface.isDefaultAttribute((Attribute)currentField.getProperty()) || be.getBusinessEntityInterface().getBusinessEntity().getKeys().contains(currentField.getProperty())) {
                BEGenerator.putObjectToMap("true", "local", fieldMap2);
                persistence_modifier2 = "persistent";
            }
            String primary_key = "false";
            String embedded = "false";
            String default_fetch_group2 = "true";
            String columnName = currentField.getFieldName();
            fieldName2 = currentField.getProperty() != null ? currentField.getProperty().getObjectName() : "key";
            if ("OBJECTKEY".equalsIgnoreCase(columnName)) {
                columnName = "OBJECTKEY";
                embedded = null;
                primary_key = "true";
            }
            BEGenerator.putObjectToMap(fieldName2, "fieldName", fieldMap2);
            BEGenerator.putObjectToMap(persistence_modifier2, "persistence_modifier", fieldMap2);
            BEGenerator.putObjectToMap(primary_key, "primary_key", fieldMap2);
            BEGenerator.putObjectToMap(embedded, "embedded", fieldMap2);
            BEGenerator.putObjectToMap(default_fetch_group2, "default_fetch_group", fieldMap2);
            BEGenerator.putObjectToMap(columnName, "columnName", fieldMap2);
            BEGenerator.putObjectToMap(masterTableName, "tableName", fieldMap2);
            BEGenerator.putObjectToMap(fieldMap2, BEGenerator.getFieldName(i++), fields);
        }
        Iterator iProperties = be.getAttributes().iterator();
        while (iProperties.hasNext()) {
            Property property = (Property)iProperties.next();
            if (!CAFBusinessEntityInterface.isEntityAttribute((Attribute)property) || property.getMaxOccurs() != null && property.getMaxOccurs() < 0) continue;
            HashMap fieldMap3 = new HashMap();
            String fieldName3 = "";
            String persistence_modifier3 = "persistent";
            String primary_key = "false";
            String embedded = "false";
            String default_fetch_group3 = "false";
            fieldName3 = property.getObjectName();
            String multiplicity2 = "one";
            String update2 = "false";
            String foreign_key_table = ((Field)property.getField().iterator().next()).getTable().getTableName();
            String foreign_key_name = fieldName3 + "_" + masterTableName + "_" + "FK";
            BEGenerator.putObjectToMap(fieldName3, "fieldName", fieldMap3);
            BEGenerator.putObjectToMap(foreign_key_name, "foreign_key_name", fieldMap3);
            BEGenerator.putObjectToMap(persistence_modifier3, "persistence_modifier", fieldMap3);
            BEGenerator.putObjectToMap(primary_key, "primary_key", fieldMap3);
            BEGenerator.putObjectToMap(embedded, "embedded", fieldMap3);
            BEGenerator.putObjectToMap(default_fetch_group3, "default_fetch_group", fieldMap3);
            BEGenerator.putObjectToMap(multiplicity2, "multiplicity", fieldMap3);
            BEGenerator.putObjectToMap(update2, "update", fieldMap3);
            BEGenerator.putObjectToMap(foreign_key_table, "foreign_key_table", fieldMap3);
            BEGenerator.putObjectToMap(masterTableName, "primary_key_table", fieldMap3);
            BEGenerator.putObjectToMap(masterTableName, "tableName", fieldMap3);
            BEGenerator.putObjectToMap(fieldMap3, BEGenerator.getFieldName(i++), fieldsAssociationOne);
        }
        Iterator iProperties2 = be.getAttributes().iterator();
        while (iProperties2.hasNext()) {
            Property property = (Property)iProperties2.next();
            if (!CAFBusinessEntityInterface.isComplexAttribute((Attribute)property) || property.getMaxOccurs() != null && property.getMaxOccurs() < 0) continue;
            Field complexField = (Field)property.getField().iterator().next();
            Table complexTable = complexField.getTable();
            String complexTableName = complexTable.getTableName();
            fieldMap = new HashMap();
            fieldName = property.getObjectName();
            persistence_modifier = "persistent";
            persistence_modifier = !isLocal ? "none" : "persistent";
            String primary_key = "false";
            String embedded = "false";
            default_fetch_group = "false";
            multiplicity = "";
            multiplicity = property.getMaxOccurs() == 1 ? "one" : "many";
            update = "";
            update = multiplicity.equals("one") ? "false" : "true";
            String foreign_key_table = complexTableName;
            String foreign_key_name = fieldName + "_" + masterTableName + "_" + "FK";
            BEGenerator.putObjectToMap(fieldName, "fieldName", fieldMap);
            BEGenerator.putObjectToMap(persistence_modifier, "persistence_modifier", fieldMap);
            BEGenerator.putObjectToMap(primary_key, "primary_key", fieldMap);
            BEGenerator.putObjectToMap(embedded, "embedded", fieldMap);
            BEGenerator.putObjectToMap(default_fetch_group, "default_fetch_group", fieldMap);
            BEGenerator.putObjectToMap(multiplicity, "multiplicity", fieldMap);
            BEGenerator.putObjectToMap(update, "update", fieldMap);
            BEGenerator.putObjectToMap(foreign_key_table, "foreign_key_table", fieldMap);
            BEGenerator.putObjectToMap(foreign_key_name, "foreign_key_name", fieldMap);
            BEGenerator.putObjectToMap(masterTableName, "primary_key_table", fieldMap);
            BEGenerator.putObjectToMap(masterTableName, "tableName", fieldMap);
            BEGenerator.putObjectToMap(fieldMap, BEGenerator.getFieldName(i++), complexFields);
        }
        Iterator iProperties3 = be.getAttributes().iterator();
        while (iProperties3.hasNext()) {
            Property property = (Property)iProperties3.next();
            if (property.getMaxOccurs() == null || property.getMaxOccurs() >= 0) continue;
            Table multipleTable = ((Field)property.getField().iterator().next()).getTable();
            String multipleTableName = multipleTable.getTableName();
            fieldMap = new HashMap();
            fieldName = property.getObjectName();
            persistence_modifier = "persistent";
            persistence_modifier = !isLocal ? "none" : "persistent";
            if (CAFBusinessEntityInterface.isEntityAttribute((Attribute)property)) {
                persistence_modifier = "persistent";
            }
            String embedded = "false";
            String primary_key = "false";
            default_fetch_group = "false";
            multiplicity = "";
            multiplicity = property.getMaxOccurs() == 1 ? "one" : "many";
            update = "";
            update = multiplicity.equals("one") ? "true" : "false";
            String foreign_key_name = fieldName + "_" + masterTableName + "_" + "FK";
            String foreign_key_table = multipleTableName;
            BEGenerator.putObjectToMap(fieldName, "fieldName", fieldMap);
            BEGenerator.putObjectToMap(persistence_modifier, "persistence_modifier", fieldMap);
            BEGenerator.putObjectToMap(primary_key, "primary_key", fieldMap);
            BEGenerator.putObjectToMap(embedded, "embedded", fieldMap);
            BEGenerator.putObjectToMap(default_fetch_group, "default_fetch_group", fieldMap);
            BEGenerator.putObjectToMap(multiplicity, "multiplicity", fieldMap);
            BEGenerator.putObjectToMap(update, "update", fieldMap);
            BEGenerator.putObjectToMap(foreign_key_table, "foreign_key_table", fieldMap);
            BEGenerator.putObjectToMap(masterTableName, "primary_key_table", fieldMap);
            BEGenerator.putObjectToMap(foreign_key_name, "foreign_key_name", fieldMap);
            HashMap collection = new HashMap();
            String elementType = packageName + "." + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1) + (CAFBusinessEntityInterface.isEntityAttribute((Attribute)property) ? "VO" : "");
            String embeddedElement = "false";
            BEGenerator.putObjectToMap(elementType, "element_type", collection);
            BEGenerator.putObjectToMap(embeddedElement, "embedded_element", collection);
            BEGenerator.putObjectToMap(collection, "collection", fieldMap);
            BEGenerator.putObjectToMap(fieldMap, BEGenerator.getFieldName(i++), multipleFields);
        }
        Table langTable = CAFBusinessEntityInterface.getLanguageTable(be);
        if (langTable != null) {
            String langTableName = langTable.getTableName();
            int j = 0;
            Iterator iFields = langTable.getFields().iterator();
            while (iFields.hasNext()) {
                Field currentField = (Field)iFields.next();
                HashMap fieldMap4 = new HashMap();
                String fieldName4 = "";
                String columnName = currentField.getFieldName();
                String persistence_modifier4 = "persistent";
                String embedded = "false";
                String default_fetch_group4 = "true";
                String primary_key = "false";
                switch (j) {
                    case 0: {
                        fieldName4 = "key";
                        primary_key = "true";
                        embedded = null;
                        break;
                    }
                    case 1: {
                        fieldName4 = "parentKey";
                        break;
                    }
                    case 2: {
                        fieldName4 = "language";
                        break;
                    }
                    default: {
                        fieldName4 = currentField.getProperty() == null ? "" : currentField.getProperty().getObjectName();
                    }
                }
                ++j;
                BEGenerator.putObjectToMap(fieldName4, "fieldName", fieldMap4);
                BEGenerator.putObjectToMap(columnName, "columnName", fieldMap4);
                BEGenerator.putObjectToMap(persistence_modifier4, "persistence_modifier", fieldMap4);
                BEGenerator.putObjectToMap(embedded, "embedded", fieldMap4);
                BEGenerator.putObjectToMap(default_fetch_group4, "default_fetch_group", fieldMap4);
                BEGenerator.putObjectToMap(primary_key, "primary_key", fieldMap4);
                BEGenerator.putObjectToMap(langTableName, "tableName", fieldMap4);
                BEGenerator.putObjectToMap(fieldMap4, BEGenerator.getFieldName(i++), ldFields);
                initContext.put("masterTableName", masterTableName);
                initContext.put("langDepTableName", langTableName);
            }
        }
        initContext.put("fields", fields);
        initContext.put("complexFields", complexFields);
        initContext.put("multipleFields", multipleFields);
        initContext.put("ldFields", ldFields);
        initContext.put("fieldsAssociationOne", fieldsAssociationOne);
        List keysList = be.getKeys();
        BEGenerator.handleAttribute(keysList, isLocal, keys, beName, locations, providerName, packageName, appName, beName, log, imports, relations, relationsTables, monitor, contentHolder);
        List beAttribs = be.getAttributes();
        boolean containsLD = BEGenerator.handleAttribute(beAttribs, isLocal, attributes, beName, locations, providerName, packageName, appName, beName, log, imports, relations, relationsTables, monitor, contentHolder);
        boolean isRemote = false;
        if (be.getBusinessEntityInterface().getBackend() == 1) {
            isRemote = true;
        }
        initContext.put("isRemote", new Boolean(isRemote));
        initContext.put("name", beName);
        initContext.put("objectGUID", be.getObjectId());
        initContext.put("package", packageName);
        initContext.put("appName", appName);
        initContext.put("providerName", providerName);
        initContext.put("attributes", attributes);
        initContext.put("imports", imports);
        initContext.put("relations", relations);
        initContext.put("keys", keys);
        initContext.put("mapProperties", mapProperties);
        initContext.put("relationsTables", relationsTables);
        initContext.put("containsLangDepAttr", new Boolean(containsLD));
        if (!isLocal) {
            initContext.put("persistance", Boolean.FALSE);
        } else {
            initContext.put("persistance", Boolean.TRUE);
        }
        initContext.put("ATTRIBUTE_IS_PROTECTED", "ATTRIBUTE_IS_PROTECTED");
        initContext.put("ATTRIBUTE_TYPE", "ATTRIBUTE_TYPE");
        initContext.put("ATTRIBUTE_GET_START", "ATTRIBUTE_GET_START");
        initContext.put("ATTRIBUTE_GET_END", "ATTRIBUTE_GET_END");
        initContext.put("ATTRIBUTE_SET_START", "ATTRIBUTE_SET_START");
        initContext.put("ATTRIBUTE_SET_END", "ATTRIBUTE_SET_END");
        initContext.put("ATTRIBUTE_KIND", "ATTRIBUTE_KIND");
        initContext.put("ATTRIBUTE_KIND_IS_MULTIPLE", "ATTRIBUTE_KIND_IS_MULTIPLE");
        initContext.put("ATTRIBUTE_MULTIPLE_NAME", "ATTRIBUTE_MULTIPLE_NAME");
        initContext.put("ATTRIBUTE_IS_LANG_DEP", "ATTRIBUTE_IS_LANG_DEP");
        initContext.put("ATTRIBUTE_IS_MANDATORY", "ATTRIBUTE_IS_MANDATORY");
        initContext.put("ATTRIBUTE_IS_OBJECT_TYPE", "ATTRIBUTE_IS_OBJECT_TYPE");
        return initContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean handleAttribute(List beAttribs, boolean isLocal, HashMap storageMap, String parentType, ProjectLocations locations, String providerName, String packageName, String appName, String beName, PrintWriter log, Vector imports, HashMap relations, HashMap relationsTables, GenerationMonitor monitor, DTRContentHolder contentHolder) throws CAFBaseException {
        boolean containsLD = false;
        if (beAttribs == null || beAttribs.size() <= 0) return containsLD;
        int i = 0;
        while (i < beAttribs.size()) {
            String fqAttribType;
            Attribute currAttrib = (Attribute)beAttribs.get(i);
            String currAttribName = currAttrib.getObjectName();
            HashMap<String, Object> currAttribProps = new HashMap<String, Object>();
            String getStart = null;
            String getEnd = null;
            String setStart = null;
            String setEnd = null;
            int attrKind = 0;
            Boolean isLangDep = null;
            boolean isObjectType = false;
            if (currAttrib instanceof Property) {
                isLangDep = ((Property)currAttrib).isLanguageDependent();
                if (isLangDep == null) {
                    isLangDep = new Boolean(false);
                } else if (isLangDep.booleanValue()) {
                    containsLD = true;
                }
            }
            if (currAttribName == null) {
                throw new CAFBaseException("Null name not allowed for Attribute object");
            }
            boolean checkImports = false;
            if (currAttrib.getReferencedObject() != null && currAttrib.getReferencedObject() instanceof DataObject) {
                DataObject refObj = (DataObject)currAttrib.getReferencedObject();
                if (currAttrib.getTypeJavaDdic() == null && refObj.getBusinessEntityInterface() != null) {
                    String refName = currAttrib.getObjectName();
                    if ((refName = refName.substring(0, 1).toUpperCase() + refName.substring(1)) == null) {
                        throw new CAFBaseException("Relation name should not be null");
                    }
                    HashMap<String, Object> relationProperties = new HashMap<String, Object>();
                    Boolean isMultiple = null;
                    isMultiple = currAttrib.getMaxOccurs() == -1 ? new Boolean(true) : new Boolean(false);
                    boolean isMandatory = false;
                    if (currAttrib.getMinOccurs() == 1) {
                        isMandatory = true;
                    }
                    boolean doubleLocal = false;
                    if (isLocal && refObj.getBusinessEntityInterface().getBackend() != null && refObj.getBusinessEntityInterface().getBackend() == 0) {
                        doubleLocal = true;
                    }
                    String relType = PackageGenerator.getBusinessServicePackage(refObj.getBusinessEntityInterface(), locations.getCoreName()) + "." + refObj.getObjectName();
                    relationProperties.put("ATTRIBUTE_KIND_IS_MULTIPLE", isMultiple);
                    relationProperties.put("ATTRIBUTE_IS_MANDATORY", new Boolean(isMandatory));
                    relationProperties.put("DOUBLE_LOCAL_RELATION", new Boolean(doubleLocal));
                    relationProperties.put("RELATION_TYPE", relType);
                    relations.put(refName, relationProperties);
                    attrKind = 4;
                    checkImports = true;
                } else {
                    if (!CAFBusinessEntityInterface.isComplexAttribute(currAttrib)) throw new CAFBaseException("Invalid set of parameters: JavaDdic: " + currAttrib.getTypeJavaDdic() + ", referenced onject: " + currAttrib.getReferencedObject());
                    if (currAttrib.getMaxOccurs() != -1) {
                        attrKind = 2;
                        BEComplexTypeGenerator.generateClass(refObj, isLocal, (Property)currAttrib, appName, providerName, parentType, locations, log, monitor, contentHolder);
                    } else {
                        attrKind = 5;
                        BEMultipleTypeGenerator.generateClass(currAttrib, isLocal, appName, providerName, parentType, locations, log, monitor, contentHolder);
                    }
                }
            } else if (currAttrib.getTypeJavaDdic() != null && currAttrib.getReferencedObject() == null && currAttrib.getMaxOccurs() == -1) {
                attrKind = 3;
                BEMultipleTypeGenerator.generateClass(currAttrib, isLocal, appName, providerName, parentType, locations, log, monitor, contentHolder);
            } else {
                attrKind = 1;
            }
            String attribType = fqAttribType = DDicConverter.getAttributeType(currAttrib, locations, packageName);
            if (fqAttribType.indexOf(46) == -1) {
                String wrapperType = DDicConverter.getJavaWrapper(fqAttribType);
                if (wrapperType == null) {
                    isObjectType = true;
                    getStart = "";
                    getEnd = "";
                    setStart = "(" + attribType + ") ";
                    setEnd = "";
                } else {
                    isObjectType = false;
                    getStart = "new " + wrapperType + "(";
                    getEnd = ")";
                    setStart = "((" + wrapperType + ") ";
                    if (wrapperType.equals("java.lang.Integer")) {
                        setEnd = ").intValue()";
                    } else if (wrapperType.equals("java.lang.Float")) {
                        setEnd = ").floatValue()";
                    } else if (wrapperType.equals("java.lang.Double")) {
                        setEnd = ").doubleValue()";
                    } else if (wrapperType.equals("java.lang.Short")) {
                        setEnd = ").shortValue()";
                    } else if (wrapperType.equals("java.lang.Long")) {
                        setEnd = ").longValue()";
                    } else if (wrapperType.equals("java.lang.Character")) {
                        setEnd = ").charValue()";
                    } else if (wrapperType.equals("java.lang.Byte")) {
                        setEnd = ").byteValue()";
                    } else {
                        if (!wrapperType.equals("java.lang.Boolean")) throw new CAFBaseException("Wrapper not supported: " + wrapperType);
                        setEnd = ").booleanValue()";
                    }
                }
            } else {
                isObjectType = true;
                getStart = "";
                getEnd = "";
                setStart = "(" + attribType + ") ";
                setEnd = "";
            }
            Boolean protectedStatus = BEGenerator.checkProtectedStatus(currAttribName);
            boolean isMandatory = false;
            if (currAttrib.getMinOccurs() == 1) {
                isMandatory = true;
            }
            currAttribProps.put("ATTRIBUTE_GET_START", getStart);
            currAttribProps.put("ATTRIBUTE_GET_END", getEnd);
            currAttribProps.put("ATTRIBUTE_SET_START", setStart);
            currAttribProps.put("ATTRIBUTE_SET_END", setEnd);
            currAttribProps.put("ATTRIBUTE_TYPE", attribType);
            currAttribProps.put("ATTRIBUTE_IS_PROTECTED", protectedStatus);
            currAttribProps.put("ATTRIBUTE_KIND", new Integer(attrKind));
            currAttribProps.put("ATTRIBUTE_IS_LANG_DEP", isLangDep);
            currAttribProps.put("ATTRIBUTE_IS_MANDATORY", new Boolean(isMandatory));
            currAttribProps.put("ATTRIBUTE_IS_OBJECT_TYPE", new Boolean(isObjectType));
            storageMap.put(currAttribName, currAttribProps);
            ++i;
        }
        return containsLD;
    }

    private static void putObjectToMap(Object object, String key, Map hMap) {
        if (object != null) {
            hMap.put(key, object);
        }
    }
}

