/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.Field;
import com.sap.caf.metamodel.Property;
import com.sap.caf.metamodel.Table;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.utils.Constants;
import com.sap.caf.tools.velocity.utils.DDicConverter;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.caf.tools.velocity.utils.PackageGenerator;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.caf.tools.velocity.utils.VelocityConverter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class BEComplexTypeGenerator {
    public static void generateClass(DataObject be, boolean isLocal, Property property, String appName, String providerName, String parentType, ProjectLocations locations, PrintWriter log, GenerationMonitor monitor, DTRContentHolder contentHolder) throws GeneratorException {
        String beName = null;
        if (be == null || (beName = be.getObjectName()) == null) {
            log.println("    Invalid complex type found: " + beName + ". Aborting generation.");
            return;
        }
        try {
            String packageName = PackageGenerator.getBusinessEntityPackage(parentType, appName, providerName, locations.getCoreName());
            HashMap initContext = BEComplexTypeGenerator.generateInitContext(be, property, packageName, beName, appName, providerName, parentType, locations, log);
            Table complexTable = ((Field)property.getField().iterator().next()).getTable();
            String complexTableName = complexTable.getTableName();
            initContext.put("tableName", complexTableName);
            String generatorPath = locations.getBusinessEntityPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + packageName.replace('.', '/');
            log.println("      Generating complex attribute: " + beName);
            String beFile = FileUtils.generateOutputFileName(generatorPath, beName);
            String beTemplateName = "BusinessEntity_Complex_Attr_Template.vm";
            VelocityConverter.processTemplete(beFile, beTemplateName, initContext, contentHolder, log);
            log.println("      Complex attribute generated successful");
            log.println("      Generating complex attribute PK: " + beName + "PK");
            String bePKFile = FileUtils.generateOutputFileName(generatorPath, beName + "PK");
            String bePKTemplateName = "BusinessEntity_Complex_Attr_PK_Template.vm";
            VelocityConverter.processTemplete(bePKFile, bePKTemplateName, initContext, contentHolder, log);
            log.println("      Complex attribute PK generated successful");
            if (isLocal) {
                log.println("      Generating " + beName + ".jdo");
                String relJdoFile = FileUtils.generateOutputFileName(generatorPath, beName, "jdo");
                String relJdoTemplateName = "BusinessEntity_Complex_Attr_JDO_Template.vm";
                VelocityConverter.processTemplete(relJdoFile, relJdoTemplateName, initContext, contentHolder, log);
                log.println("      " + beName + "VO.jdo generated successful");
                log.println("      Generating " + beName + ".map");
                String relMapFile = FileUtils.generateOutputFileName(generatorPath, beName, "map");
                String relMapTemplateName = "BusinessEntity_Complex_Attr_MAP_Template.vm";
                VelocityConverter.processTemplete(relMapFile, relMapTemplateName, initContext, contentHolder, log);
                log.println("      " + beName + "VO.map generated successful");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneratorException(e);
        }
    }

    private static String getFieldName(int position) {
        String sPosition = "" + position;
        StringBuffer result = new StringBuffer("field".length() + sPosition.length() + 1);
        result.append("field");
        int countUnd = 10 - sPosition.length();
        int i = 0;
        while (i < countUnd) {
            result.append("0");
            ++i;
        }
        result.append(sPosition);
        return result.toString();
    }

    private static void checkUpdateImports(Vector imports, String packageName, String attribType, PrintWriter log) {
        String restPackage = DDicConverter.replaceFirst(packageName + ".", "", attribType);
        if (restPackage.indexOf(46) != -1 && !imports.contains(attribType)) {
            log.println("      Adding import: " + attribType);
            imports.addElement(attribType);
        }
    }

    private static HashMap generateInitContext(DataObject be, Property attribute, String packageName, String beName, String appName, String providerName, String parentType, ProjectLocations locations, PrintWriter log) throws CAFBaseException {
        HashMap<String, Object> initContext = new HashMap<String, Object>();
        Vector imports = new Vector();
        HashMap attributes = new HashMap();
        if (attribute.getReferencedObject().getAttributes().iterator().next() != null) {
            String default_fetch_group;
            String embedded;
            String primary_key;
            String persistence_modifier;
            String fieldName;
            Table masterTable = ((Field)((Property)attribute.getReferencedObject().getAttributes().iterator().next()).getField().iterator().next()).getTable();
            String masterTableName = masterTable.getTableName();
            TreeMap fields = new TreeMap();
            TreeMap complexFields = new TreeMap();
            int i = 0;
            Iterator propsIterator = attribute.getReferencedObject().getAttributes().iterator();
            while (propsIterator.hasNext()) {
                Property prop = (Property)propsIterator.next();
                HashMap fieldMap = new HashMap();
                Field currentField = (Field)prop.getField().iterator().next();
                fieldName = "";
                persistence_modifier = "persistent";
                primary_key = "false";
                embedded = "true";
                default_fetch_group = "true";
                String columnName = currentField.getFieldName();
                fieldName = currentField.getProperty() != null ? currentField.getProperty().getObjectName() : "key";
                if ("OBJECTKEY".equalsIgnoreCase(columnName)) {
                    columnName = "OBJECTKEY";
                    embedded = null;
                    primary_key = "true";
                }
                BEComplexTypeGenerator.putObjectToMap(fieldName, "fieldName", fieldMap);
                BEComplexTypeGenerator.putObjectToMap(persistence_modifier, "persistence_modifier", fieldMap);
                BEComplexTypeGenerator.putObjectToMap(primary_key, "primary_key", fieldMap);
                BEComplexTypeGenerator.putObjectToMap(embedded, "embedded", fieldMap);
                BEComplexTypeGenerator.putObjectToMap(default_fetch_group, "default_fetch_group", fieldMap);
                BEComplexTypeGenerator.putObjectToMap(columnName, "columnName", fieldMap);
                BEComplexTypeGenerator.putObjectToMap(masterTableName, "tableName", fieldMap);
                BEComplexTypeGenerator.putObjectToMap(fieldMap, BEComplexTypeGenerator.getFieldName(i++), fields);
            }
            Field fkField = (Field)masterTable.getFields().toArray()[1];
            Table fkTable = fkField.getTable();
            HashMap fieldMap = new HashMap();
            fieldName = parentType.substring(0, 1).toLowerCase() + parentType.substring(1);
            persistence_modifier = "persistent";
            primary_key = "false";
            embedded = "true";
            default_fetch_group = "false";
            String multiplicity = "";
            multiplicity = fkField.getPkfield().getProperty().getMaxOccurs() > 0 ? "one" : "many";
            String update = "true";
            String primary_key_table = fkField.getPkfield().getTable().getTableName();
            String foreign_key_table = fkTable.getTableName();
            String foreign_key_name = fieldName + "_" + primary_key_table + "_" + "FK";
            BEComplexTypeGenerator.putObjectToMap(fieldName, "fieldName", fieldMap);
            BEComplexTypeGenerator.putObjectToMap(persistence_modifier, "persistence_modifier", fieldMap);
            BEComplexTypeGenerator.putObjectToMap(primary_key, "primary_key", fieldMap);
            BEComplexTypeGenerator.putObjectToMap(embedded, "embedded", fieldMap);
            BEComplexTypeGenerator.putObjectToMap(default_fetch_group, "default_fetch_group", fieldMap);
            BEComplexTypeGenerator.putObjectToMap(multiplicity, "multiplicity", fieldMap);
            BEComplexTypeGenerator.putObjectToMap(update, "update", fieldMap);
            BEComplexTypeGenerator.putObjectToMap(foreign_key_table, "foreign_key_table", fieldMap);
            BEComplexTypeGenerator.putObjectToMap(primary_key_table, "primary_key_table", fieldMap);
            BEComplexTypeGenerator.putObjectToMap(foreign_key_name, "foreign_key_name", fieldMap);
            BEComplexTypeGenerator.putObjectToMap(masterTableName, "tableName", fieldMap);
            BEComplexTypeGenerator.putObjectToMap(fieldMap, BEComplexTypeGenerator.getFieldName(i++), complexFields);
            initContext.put("masterTableName", masterTableName);
            initContext.put("fields", fields);
            initContext.put("complexFields", complexFields);
        }
        List attribs = be.getAttributes();
        BEComplexTypeGenerator.handleAttribute(attribs, attributes, locations, providerName, packageName, appName, beName, log, imports);
        initContext.put("name", beName);
        initContext.put("package", packageName);
        initContext.put("appName", appName);
        initContext.put("providerName", providerName);
        initContext.put("attributes", attributes);
        initContext.put("imports", imports);
        initContext.put("parentType", parentType);
        initContext.put("complexContext", "yes");
        initContext.put("ATTRIBUTE_IS_PROTECTED", "ATTRIBUTE_IS_PROTECTED");
        initContext.put("ATTRIBUTE_TYPE", "ATTRIBUTE_TYPE");
        initContext.put("ATTRIBUTE_GET_START", "ATTRIBUTE_GET_START");
        initContext.put("ATTRIBUTE_GET_END", "ATTRIBUTE_GET_END");
        initContext.put("ATTRIBUTE_SET_START", "ATTRIBUTE_SET_START");
        initContext.put("ATTRIBUTE_SET_END", "ATTRIBUTE_SET_END");
        return initContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleAttribute(List beAttribs, HashMap storageMap, ProjectLocations locations, String providerName, String packageName, String appName, String beName, PrintWriter log, Vector imports) throws CAFBaseException {
        if (beAttribs == null || beAttribs.size() <= 0) return;
        int i = 0;
        while (i < beAttribs.size()) {
            String fqAttribType;
            Attribute currAttrib = (Attribute)beAttribs.get(i);
            String currAttribName = currAttrib.getObjectName();
            HashMap<String, String> currAttribProps = new HashMap<String, String>();
            String getStart = null;
            String getEnd = null;
            String setStart = null;
            String setEnd = null;
            if (currAttribName == null) {
                throw new CAFBaseException("Null name not allowed for Attribute object");
            }
            if (currAttrib.getReferencedObject() != null && currAttrib.getReferencedObject() instanceof DataObject) {
                DataObject refObj = (DataObject)currAttrib.getReferencedObject();
                if (currAttrib.getTypeJavaDdic() == null || refObj.getBusinessEntityInterface() != null) {
                    throw new CAFBaseException("Invalid attribute for complex type " + refObj.getObjectName() + ": " + currAttribName);
                }
            }
            String attribType = fqAttribType = DDicConverter.getAttributeType(currAttrib, locations, packageName);
            if (fqAttribType.indexOf(46) == -1) {
                String wrapperType = DDicConverter.getJavaWrapper(fqAttribType);
                if (wrapperType == null) {
                    getStart = "";
                    getEnd = "";
                    setStart = "(" + attribType + ") ";
                    setEnd = "";
                } else {
                    getStart = "new " + wrapperType + "(";
                    getEnd = ")";
                    setStart = "((" + wrapperType + ") ";
                    if (wrapperType.equals("java.lang.Integer")) {
                        setEnd = ").intValue()";
                    } else if (wrapperType.equals("java.lang.Float")) {
                        setEnd = ").floatValue()";
                    } else if (wrapperType.equals("java.lang.Double")) {
                        setEnd = ").doubleValue()";
                    } else if (wrapperType.equals("java.lang.Short")) {
                        setEnd = ").shortValue()";
                    } else if (wrapperType.equals("java.lang.Long")) {
                        setEnd = ").longValue()";
                    } else if (wrapperType.equals("java.lang.Character")) {
                        setEnd = ").charValue()";
                    } else if (wrapperType.equals("java.lang.Byte")) {
                        setEnd = ").byteValue()";
                    } else {
                        if (!wrapperType.equals("java.lang.Boolean")) throw new CAFBaseException("Wrapper not supported: " + wrapperType);
                        setEnd = ").booleanValue()";
                    }
                }
            } else {
                getStart = "";
                getEnd = "";
                setStart = "(" + attribType + ") ";
                setEnd = "";
            }
            currAttribProps.put("ATTRIBUTE_GET_START", getStart);
            currAttribProps.put("ATTRIBUTE_GET_END", getEnd);
            currAttribProps.put("ATTRIBUTE_SET_START", setStart);
            currAttribProps.put("ATTRIBUTE_SET_END", setEnd);
            currAttribProps.put("ATTRIBUTE_TYPE", attribType);
            storageMap.put(currAttribName, currAttribProps);
            ++i;
        }
    }

    private static void putObjectToMap(Object object, String key, Map hMap) {
        if (object != null) {
            hMap.put(key, object);
        }
    }
}

