/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.utils.GeneratedFilesList;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.ExternalInterface;
import com.sap.caf.metamodel.FaultMessage;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.utils.Constants;
import com.sap.caf.tools.velocity.utils.DDicConverter;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.caf.tools.velocity.utils.NamingRestrictions;
import com.sap.caf.tools.velocity.utils.PackageGenerator;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.caf.tools.velocity.utils.VelocityConverter;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ApplicationServiceGenerator {
    public static HashMap initContext = null;

    public static File getGeneratedImplementation(ApplicationInterface as, String appName, String providerName, ProjectLocations locations) throws CAFBaseException {
        String appServName = null;
        if (as == null || (appServName = as.getObjectName()) == null) {
            throw new GeneratorException("Invalid ApplicationInterface object found: " + appServName + ". Aborting generation.");
        }
        String packageName = PackageGenerator.getApplicationServicePackage(as);
        String generatorPath = locations.getApplicationServicesPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + packageName.replace('.', '/');
        String beanFile = FileUtils.generateOutputFileName(generatorPath, appServName + "Bean");
        return new File(beanFile);
    }

    public static void clear(ApplicationInterface as, ProjectLocations locations, PrintWriter log, Map deleteQueue, GeneratedFilesList generatedFilesList) throws GeneratorException {
        try {
            String packageName = PackageGenerator.getApplicationServicePackage(as);
            String generatorPath = locations.getApplicationServicesPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + packageName.replace('.', '/');
            FileUtils.deleteDir(generatorPath, log, deleteQueue, generatedFilesList);
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
    }

    public static synchronized void generateClass(ApplicationInterface ai, String appName, String providerName, ProjectLocations locations, PrintWriter log, boolean clearBevoreGeneration, boolean hasFaults, GenerationMonitor monitor, DTRContentHolder contentHandler) throws GeneratorException {
        String appServName = null;
        if (ai == null || (appServName = ai.getObjectName()) == null) {
            throw new GeneratorException("Invalid ApplicationInterface object found: " + appServName + ". Aborting generation.");
        }
        log.println("    Starting ApplicationInterface generation: " + appServName);
        try {
            String packageName = PackageGenerator.getApplicationServicePackage(appServName, appName, providerName);
            String excGenPath = null;
            if (hasFaults) {
                String exceptionPackage = PackageGenerator.getExceptionsPackage(appName, providerName);
                String exceptionGenPath = locations.getApplicationServicesPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + exceptionPackage.replace('.', '/');
                FileUtils.generatePackageStructure(exceptionGenPath);
                excGenPath = exceptionPackage;
            }
            initContext = ApplicationServiceGenerator.generateInitContext(ai, packageName, appServName, appName, providerName, locations, log, excGenPath);
            String generatorPath = locations.getApplicationServicesPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + packageName.replace('.', '/');
            if (clearBevoreGeneration) {
                FileUtils.deleteDir(generatorPath, log, contentHandler.getDeleteQueue(), contentHandler.getFileList());
            }
            if (ai.isRemoteEnabled().booleanValue()) {
                log.println("      Generating remote interface");
                String remoteFile = FileUtils.generateOutputFileName(generatorPath, appServName);
                String remoteTemplateName = "ApplicationService_Template.vm";
                VelocityConverter.processTemplete(remoteFile, remoteTemplateName, initContext, contentHandler, log);
                log.println("      Remote interface generated successful");
                log.println("      Generating home interface ");
                String homeFile = FileUtils.generateOutputFileName(generatorPath, appServName + "Home");
                String homeTemplateName = "ApplicationServiceHome_Template.vm";
                VelocityConverter.processTemplete(homeFile, homeTemplateName, initContext, contentHandler, log);
                log.println("      Home interface generated successful");
            }
            log.println("      Generating bean");
            String beanFile = FileUtils.generateOutputFileName(generatorPath, appServName + "Bean");
            String beanTemplateName = "ApplicationServiceBean_Template.vm";
            VelocityConverter.processTemplete(beanFile, beanTemplateName, initContext, contentHandler, log);
            log.println("      Bean generated successful");
            log.println("      Generating local interface");
            String localFile = FileUtils.generateOutputFileName(generatorPath, appServName + "Local");
            String localTemplateName = "ApplicationServiceLocal_Template.vm";
            VelocityConverter.processTemplete(localFile, localTemplateName, initContext, contentHandler, log);
            log.println("      Local interface generated successful");
            log.println("      Generating local home interface");
            String localHomeFile = FileUtils.generateOutputFileName(generatorPath, appServName + "LocalHome");
            String localHomeTemplateName = "ApplicationServiceLocalHome_Template.vm";
            VelocityConverter.processTemplete(localHomeFile, localHomeTemplateName, initContext, contentHandler, log);
            log.println("      Local home interface generated successful");
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
        log.println("    ApplicationInterface generated successful: " + appServName);
    }

    private static HashMap generateInitContext(ApplicationInterface ai, String packageName, String className, String appName, String providerName, ProjectLocations locations, PrintWriter log, String exceptionPackage) throws CAFBaseException {
        String customCodeInt;
        String customCodeAttrib;
        HashMap<String, Object> initContext = new HashMap<String, Object>();
        Vector<String> imports = new Vector<String>();
        Vector methods = new Vector();
        HashMap dependencies = new HashMap();
        boolean isRemoteEnabled = ai.isRemoteEnabled();
        if (isRemoteEnabled) {
            imports.add(PackageGenerator.getUtilsPackage(appName, providerName) + ".ArraysUtils");
        }
        if (exceptionPackage != null) {
            imports.add(exceptionPackage + ".*");
        }
        List usedInterfaces = ai.getUsedInterfaces();
        int i = 0;
        while (i < usedInterfaces.size()) {
            MOFInterface depInt = (MOFInterface)usedInterfaces.get(i);
            Vector<String> temp = new Vector<String>();
            String depApplicationName = null;
            String depProviderName = null;
            Application depApp = depInt.getApplication();
            if (depApp != null) {
                depApplicationName = depApp.getObjectName();
                depProviderName = depApp.getProviderName();
            }
            if (depApplicationName != null && depProviderName != null) {
                temp.addElement(depApplicationName);
                temp.addElement(depProviderName);
                temp.addElement((String)depInt);
                if (depInt instanceof ExternalInterface) {
                    dependencies.put(NamingRestrictions.constructJavaIdentifier(depInt.getObjectName()), temp);
                } else {
                    dependencies.put(depInt.getObjectName(), temp);
                }
            } else {
                throw new CAFBaseException("Invalid dependency properties: app name: " + depApplicationName + ", provider name: " + depProviderName);
            }
            log.println("Adding dep: " + depInt.getObjectName());
            String servicePackage = null;
            String serviceClass = depInt.getObjectName();
            if (depInt instanceof BusinessEntityInterface) {
                servicePackage = PackageGenerator.getBusinessServicePackage((BusinessEntityInterface)depInt, locations.getCoreName());
            } else if (depInt instanceof ApplicationInterface) {
                servicePackage = PackageGenerator.getApplicationServicePackage((ApplicationInterface)depInt);
            } else if (depInt instanceof ExternalInterface) {
                servicePackage = PackageGenerator.getExternalServicePackage((ExternalInterface)depInt);
                serviceClass = NamingRestrictions.constructJavaIdentifier(depInt.getObjectName());
            } else {
                throw new CAFBaseException("Interface not supported: " + depInt.getClass().getName());
            }
            imports.addElement(servicePackage + "." + serviceClass + "Local");
            imports.addElement(servicePackage + "." + serviceClass + "LocalHome");
            if (i == 0) {
                imports.add(PackageGenerator.getUtilsPackage(appName, providerName) + ".HomeFactory");
            }
            ++i;
        }
        List operations = ai.getOperations();
        int i2 = 0;
        while (i2 < operations.size()) {
            String newWrapper;
            String[] attrW;
            HashMap<String, Object> method = new HashMap<String, Object>();
            Operation currOp = (Operation)operations.get(i2);
            Integer implCheck = currOp.getPermission().getImplicitCheck();
            String localRetValue = null;
            String remoteRetValue = null;
            String methodName = currOp.getObjectName();
            String methodUsage = methodName + "(";
            String methodDelegate = methodName + "(";
            String header = methodName + "(";
            String localHeaderFull = currOp.getObjectName() + "(";
            String remoteHeaderFull = currOp.getObjectName() + "_R(";
            String exceptions = null;
            String remoteExceptions = null;
            String paramWrappers = "{";
            String javaDoc = "/**\n";
            boolean isSimpleRetVal = false;
            boolean isMultipleRetVal = false;
            String opLongText = currOp.getLongText();
            javaDoc = opLongText == null ? javaDoc + "     * Operation.longText\n" : javaDoc + "     * " + opLongText + "\n";
            Message inputMsg = currOp.getInput();
            if (inputMsg != null) {
                List attributes = inputMsg.getMessageParts();
                int j = 0;
                while (j < attributes.size()) {
                    Attribute currAttrib = (Attribute)attributes.get(j);
                    String attribType = null;
                    String attribName = currAttrib.getObjectName();
                    int opType = currOp.getPatternType();
                    if (opType == 5) {
                        attribType = "com.sap.caf.rt.bol.util.QueryFilter";
                    } else if (opType == 8) {
                        attribType = "java.util.Map";
                        attribName = "attribs";
                    } else {
                        String defPackageName = null;
                        if (CAFBusinessEntityInterface.isComplexAttribute(currAttrib)) {
                            defPackageName = ApplicationServiceGenerator.getComplexAttributePackage(ai, currAttrib, locations);
                            if (defPackageName == null) {
                                throw new CAFBaseException("Package can not be constructed for complex attribute: " + attribName);
                            }
                        } else {
                            defPackageName = packageName;
                        }
                        attribType = DDicConverter.getAttributeType(currAttrib, locations, defPackageName);
                    }
                    String attrShortText = currAttrib.getShortText();
                    javaDoc = attrShortText == null ? javaDoc + "     * @param " + attribName + " Attribute.shortText\n" : javaDoc + "     * @param " + attribName + " " + attrShortText + "\n";
                    attrW = ApplicationServiceGenerator.getAttrubWrapper(attribType, attribName);
                    newWrapper = attrW[0];
                    String setStart = attrW[1];
                    String setEnd = attrW[2];
                    methodUsage = methodUsage + setStart + "parameters.get(" + j + ")" + setEnd;
                    methodDelegate = methodDelegate + ApplicationServiceGenerator.enhanceRemoteDelegate(attribName, attribType);
                    String localType = ApplicationServiceGenerator.getLocalAttributeType(attribType);
                    String remoteType = null;
                    remoteType = opType == 5 ? "com.sap.caf.rt.bol.util.QueryFilter" : (opType == 8 ? "java.util.Map" : ApplicationServiceGenerator.enhaceRemoteAttributeType(DDicConverter.getRemoteAttributeType(currAttrib, locations, packageName), currAttrib));
                    header = header + localType;
                    localHeaderFull = localHeaderFull + localType + " " + attribName;
                    remoteHeaderFull = remoteHeaderFull + remoteType + " " + attribName;
                    paramWrappers = paramWrappers + newWrapper;
                    if (j < attributes.size() - 1) {
                        methodUsage = methodUsage + ", ";
                        methodDelegate = methodDelegate + ", ";
                        header = header + ", ";
                        localHeaderFull = localHeaderFull + ", ";
                        remoteHeaderFull = remoteHeaderFull + ", ";
                        paramWrappers = paramWrappers + ", ";
                    }
                    ++j;
                }
            }
            methodUsage = methodUsage + ")";
            methodDelegate = methodDelegate + ")";
            header = header + ")";
            localHeaderFull = localHeaderFull + ")";
            remoteHeaderFull = remoteHeaderFull + ")";
            paramWrappers = paramWrappers + "}";
            Collection faultsMsg = currOp.getFault();
            if (faultsMsg != null && faultsMsg.size() > 0) {
                Object[] faultsColl = faultsMsg.toArray();
                int j = 0;
                while (j < faultsColl.length) {
                    String excShortText;
                    if (j == 0) {
                        exceptions = "throws ";
                        remoteExceptions = "throws ";
                        if (isRemoteEnabled) {
                            remoteExceptions = remoteExceptions + " java.rmi.RemoteException, ";
                        }
                    }
                    FaultMessage fm = (FaultMessage)faultsColl[j];
                    String excName = PackageGenerator.getFQExceptionName(fm, locations);
                    exceptions = exceptions + excName;
                    remoteExceptions = remoteExceptions + excName;
                    if (j < faultsColl.length - 1) {
                        exceptions = exceptions + ", ";
                        remoteExceptions = remoteExceptions + ", ";
                    }
                    javaDoc = (excShortText = fm.getShortText()) == null ? javaDoc + "     * @exception " + excName + " FaultMessage.shortText\n" : javaDoc + "     * @exception " + excName + " " + excShortText + "\n";
                    ++j;
                }
            }
            if (exceptions == null) {
                if (isRemoteEnabled) {
                    remoteExceptions = remoteExceptions == null ? "throws java.rmi.RemoteException" : remoteExceptions + ", java.rmi.RemoteException";
                }
                if (exceptions == null) {
                    exceptions = "";
                }
                if (remoteExceptions == null) {
                    remoteExceptions = "";
                }
            }
            Message outputMsg = currOp.getOutput();
            String retValue = null;
            String retStart = "";
            String retEnd = "";
            if (outputMsg != null) {
                List retList = outputMsg.getMessageParts();
                if (retList.size() > 1) {
                    throw new CAFBaseException("Wrong return values detected - there should be only one, " + retList.size() + " detected");
                }
                if (retList.size() == 1) {
                    Attribute retAttribute = (Attribute)retList.get(0);
                    retValue = DDicConverter.getAttributeType(retAttribute, locations, packageName);
                    localRetValue = ApplicationServiceGenerator.getLocalAttributeType(retValue);
                    remoteRetValue = DDicConverter.getRemoteAttributeType(retAttribute, locations, packageName);
                    attrW = ApplicationServiceGenerator.getAttrubWrapper(remoteRetValue, retAttribute.getObjectName());
                    newWrapper = attrW[0];
                    retStart = attrW[1];
                    retEnd = attrW[2];
                    String retShortText = retAttribute.getShortText();
                    javaDoc = retShortText == null ? javaDoc + "     * @return Attribute.shortText\n" : javaDoc + "     * @return " + retShortText + "\n";
                    if (retAttribute.getMaxOccurs() == -1) {
                        isMultipleRetVal = true;
                    } else {
                        isSimpleRetVal = true;
                    }
                    methodUsage = ApplicationServiceGenerator.enhanceMethodUsage(methodUsage, retValue);
                } else {
                    retValue = "void";
                    localRetValue = "void";
                    remoteRetValue = "void";
                }
            } else {
                retValue = "void";
                localRetValue = "void";
                remoteRetValue = "void";
            }
            javaDoc = javaDoc + "     */";
            String customCodeMet = currOp.getCoding();
            if (customCodeMet == null) {
                customCodeMet = "";
            }
            String transactionType = Constants.transactionTypes[currOp.getTransactionType()];
            method.put("METHOD_NAME", methodName);
            method.put("METHOD_USAGE", methodUsage);
            method.put("METHOD_DELEGATE", methodDelegate);
            method.put("METHOD_IMPL_CHECK", implCheck);
            method.put("METHOD_PARAM_WRAPPERS", paramWrappers);
            method.put("CUSTOM_CODE_METHOD", customCodeMet);
            method.put("METHOD_HEADER", header);
            method.put("METHOD_HEADER_FULL", localHeaderFull);
            method.put("METHOD_REMOTE_HEADER_FULL", remoteHeaderFull);
            method.put("METHOD_RET_VALUE", localRetValue);
            method.put("METHOD_REMOTE_RET_VALUE", remoteRetValue);
            method.put("METHOD_FAULT", exceptions);
            method.put("METHOD_REMOTE_FAULT", remoteExceptions);
            method.put("METHOD_JAVADOC", javaDoc);
            method.put("METHOD_TRANSACTION_TYPE", transactionType);
            method.put("METHOD_IS_SINGLE_RET_VAL", new Boolean(isSimpleRetVal));
            method.put("METHOD_IS_MULTIPLE_RET_VAL", new Boolean(isMultipleRetVal));
            method.put("METHOD_RET_VAL_WR_START", retStart);
            method.put("METHOD_RET_VAL_WR_END", retEnd);
            methods.addElement(method);
            ++i2;
        }
        String customCodeImp = ai.getImportsCoding();
        if (customCodeImp == null) {
            customCodeImp = "";
        }
        if ((customCodeAttrib = ai.getAttributesCoding()) == null) {
            customCodeAttrib = "";
        }
        if ((customCodeInt = ai.getInternalCoding()) == null) {
            customCodeInt = "";
        }
        initContext.put("dependencies", dependencies);
        initContext.put("objectGUID", ai.getObjectId());
        initContext.put("package", packageName);
        initContext.put("name", className);
        initContext.put("providerName", providerName);
        initContext.put("applicationName", appName);
        initContext.put("imports", imports);
        initContext.put("methods", methods);
        initContext.put("isRemoteEnabled", new Boolean(isRemoteEnabled));
        initContext.put("CUSTOM_CODE_ATTRIBUTES", ai.getAttributesCoding());
        initContext.put("CUSTOM_CODE_IMPORTS", ai.getImportsCoding());
        initContext.put("CUSTOM_CODE_INTERNAL_CODING", ai.getInternalCoding());
        initContext.put("METHOD_NAME", "METHOD_NAME");
        initContext.put("METHOD_USAGE", "METHOD_USAGE");
        initContext.put("METHOD_DELEGATE", "METHOD_DELEGATE");
        initContext.put("METHOD_JAVADOC", "METHOD_JAVADOC");
        initContext.put("METHOD_RET_VALUE", "METHOD_RET_VALUE");
        initContext.put("METHOD_REMOTE_RET_VALUE", "METHOD_REMOTE_RET_VALUE");
        initContext.put("METHOD_HEADER", "METHOD_HEADER");
        initContext.put("METHOD_HEADER_FULL", "METHOD_HEADER_FULL");
        initContext.put("METHOD_REMOTE_HEADER_FULL", "METHOD_REMOTE_HEADER_FULL");
        initContext.put("METHOD_FAULT", "METHOD_FAULT");
        initContext.put("METHOD_REMOTE_FAULT", "METHOD_REMOTE_FAULT");
        initContext.put("METHOD_PARAM_WRAPPERS", "METHOD_PARAM_WRAPPERS");
        initContext.put("METHOD_IMPL_CHECK", "METHOD_IMPL_CHECK");
        initContext.put("CUSTOM_CODE_METHOD", "CUSTOM_CODE_METHOD");
        initContext.put("METHOD_TRANSACTION_TYPE", "METHOD_TRANSACTION_TYPE");
        initContext.put("METHOD_IS_SINGLE_RET_VAL", "METHOD_IS_SINGLE_RET_VAL");
        initContext.put("METHOD_IS_MULTIPLE_RET_VAL", "METHOD_IS_MULTIPLE_RET_VAL");
        initContext.put("METHOD_RET_VAL_WR_START", "METHOD_RET_VAL_WR_START");
        initContext.put("METHOD_RET_VAL_WR_END", "METHOD_RET_VAL_WR_END");
        return initContext;
    }

    private static String enhanceRemoteDelegate(String attribName, String attribType) {
        String remoteDelegate = null;
        remoteDelegate = attribType.equals("java.util.ArrayList") ? "new java.util.ArrayList(ArraysUtils.transformToCollection(" + attribName + "))" : (attribType.equals("java.util.HashSet") ? "new java.util.HashSet(ArraysUtils.transformToCollection(" + attribName + "))" : attribName);
        return remoteDelegate;
    }

    private static String enhaceRemoteAttributeType(String remoteRetValue, Attribute attribute) {
        String retVal = remoteRetValue;
        if (attribute.getMaxOccurs() != null && attribute.getMaxOccurs() == -1) {
            retVal = retVal + "[]";
        }
        return retVal;
    }

    private static String getLocalAttributeType(String retValue) {
        String localRetValue = null;
        localRetValue = retValue.equals("java.util.ArrayList") ? "java.util.List" : (retValue.equals("java.util.HashSet") ? "java.util.Set" : retValue);
        return localRetValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] getAttrubWrapper(String attribType, String currAttribName) throws CAFBaseException {
        String[] retVal = new String[3];
        String newWrapper = null;
        String setStart = null;
        String setEnd = null;
        if (attribType.indexOf(46) == -1) {
            String wrappType = DDicConverter.getJavaWrapper(attribType);
            if (wrappType == null) {
                newWrapper = currAttribName;
                setStart = "(" + attribType + ") ";
                setEnd = "";
            } else {
                newWrapper = "new " + wrappType + "(" + currAttribName + ")";
                setStart = "((" + wrappType + ") ";
                if (wrappType.equals("java.lang.Integer")) {
                    setEnd = ").intValue()";
                } else if (wrappType.equals("java.lang.Float")) {
                    setEnd = ").floatValue()";
                } else if (wrappType.equals("java.lang.Double")) {
                    setEnd = ").doubleValue()";
                } else if (wrappType.equals("java.lang.Short")) {
                    setEnd = ").shortValue()";
                } else if (wrappType.equals("java.lang.Long")) {
                    setEnd = ").longValue()";
                } else if (wrappType.equals("java.lang.Character")) {
                    setEnd = ").charValue()";
                } else if (wrappType.equals("java.lang.Byte")) {
                    setEnd = ").byteValue()";
                } else {
                    if (!wrappType.equals("java.lang.Boolean")) throw new CAFBaseException("Wrapper not supported: " + wrappType);
                    setEnd = ").booleanValue()";
                }
            }
        } else {
            newWrapper = currAttribName;
            setStart = "(" + attribType + ") ";
            setEnd = "";
        }
        retVal[0] = newWrapper;
        retVal[1] = setStart;
        retVal[2] = setEnd;
        return retVal;
    }

    private static String enhanceMethodUsage(String methodUsage, String attribType) throws CAFBaseException {
        String wrappType;
        String newWrapper = null;
        newWrapper = attribType.indexOf(46) == -1 ? ((wrappType = DDicConverter.getJavaWrapper(attribType)) == null ? methodUsage : "new " + wrappType + "(" + methodUsage + ")") : methodUsage;
        return newWrapper;
    }

    private static String getComplexAttributePackage(ApplicationInterface ai, Attribute compAttr, ProjectLocations locations) throws CAFBaseException {
        String defPack = null;
        DataObject complexStructure = (DataObject)compAttr.getReferencedObject();
        Collection baseObjects = ai.getApplication().getBaseObjects();
        Iterator it = baseObjects.iterator();
        block0: while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof BusinessEntityInterface)) continue;
            BusinessEntityInterface bei = (BusinessEntityInterface)o;
            DataObject dObj = bei.getBusinessEntity();
            Iterator attribIt = dObj.getAttributes().iterator();
            while (attribIt.hasNext()) {
                DataObject attrObj;
                Attribute attr = (Attribute)attribIt.next();
                if (!CAFBusinessEntityInterface.isComplexAttribute(attr) || complexStructure != (attrObj = (DataObject)attr.getReferencedObject())) continue;
                defPack = PackageGenerator.getBusinessServicePackage(bei, locations.getCoreName());
                continue block0;
            }
        }
        return defPack;
    }
}

