/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.imports.mp2mmr;

import com.sap.caf.designer.exception.CAFBaseException;
import java.util.Properties;

public class RFCConnectSettings {
    public static final int REMOTE_MODE_SYSTEM_LANDSCAPE_DIR = 1;
    public static final int REMOTE_MODE_SELF_DEFINED = 2;
    public static final String RFC_MODE_REMOTE = "rfc.mode";
    public static final String RFC_FUNC_NAME = "rfc.functionname";
    public static final String JCO_CONNECTION_MODE = "jco.mode";
    public static final String JCO_CLIENT = "jco.client";
    public static final String JCO_MSG_SERVER = "jco.msgsrv";
    public static final String JCO_LOGONGROUP = "jco.logongroup";
    public static final String JCO_SYSTEMID = "jco.systemid";
    public static final String JCO_APPL_SERVER = "jco.applsrv";
    public static final String JCO_SYSTEM_NUMBER = "jco.sysnr";
    public static final String JCO_LANGUAGE = "jco.language";
    public static final String JCO_USERNAME = "jco.user";
    public static final String JCO_PASSWORD = "jco.password";
    public static final String JCO_SECURITY_MODE = "jco.client.snc_mode";
    public static final String SNC_PARTNERNAME = "jco.client.snc_partnername";
    public static final String SNC_QOP = "jco.client.snc_qop";
    private static final int CONNECTION_GROUP_LOGON = 1;
    private static final int CONNECTION_SERVER_LOGON = 2;
    private static final int SECURITY_MODE_OFF = Integer.parseInt("0");
    private static final int SECURITY_MODE_ON = Integer.parseInt("1");
    public int remoteMode = 2;
    public int connectionMode = 2;
    public int securityMode = SECURITY_MODE_OFF;
    public String functionName;
    public int clientNumber = -1;
    public String addressApplServer;
    public String addressMessageServer;
    public String group;
    public String systemID;
    public int systemNumber = -1;
    public String username;
    public String passwd;
    public String language;
    public String sncPartnername;
    public String sncQOP;

    public RFCConnectSettings(String messageServer, String group, String systemID, String functionName, int clientNumber, String username, String passwd, String language) {
        this.functionName = functionName;
        this.connectionMode = 1;
        this.addressApplServer = null;
        this.addressMessageServer = messageServer;
        this.group = group;
        this.systemID = systemID;
        this.systemNumber = -1;
        this.clientNumber = clientNumber;
        this.username = username;
        this.passwd = passwd;
        this.language = language;
        this.securityMode = SECURITY_MODE_OFF;
        this.sncPartnername = null;
        this.sncQOP = null;
    }

    public RFCConnectSettings(String messageServer, String group, String systemID, String functionName, int clientNumber, String username, String language, String sncPartnername, String sncQOP) {
        this.functionName = functionName;
        this.connectionMode = 1;
        this.addressApplServer = null;
        this.addressMessageServer = messageServer;
        this.group = group;
        this.systemID = systemID;
        this.systemNumber = -1;
        this.clientNumber = clientNumber;
        this.username = username;
        this.passwd = null;
        this.language = language;
        this.securityMode = SECURITY_MODE_ON;
        this.sncPartnername = sncPartnername;
        this.sncQOP = sncQOP;
    }

    public RFCConnectSettings(String addressApplServer, int systemNumber, String functionName, int clientNumber, String username, String passwd, String language) {
        this.functionName = functionName;
        this.connectionMode = 2;
        this.addressApplServer = addressApplServer;
        this.addressMessageServer = null;
        this.group = null;
        this.systemID = null;
        this.systemNumber = systemNumber;
        this.clientNumber = clientNumber;
        this.username = username;
        this.passwd = passwd;
        this.language = language;
        this.securityMode = SECURITY_MODE_OFF;
        this.sncPartnername = null;
        this.sncQOP = null;
    }

    public RFCConnectSettings(String addressApplServer, int systemNumber, String functionName, int clientNumber, String username, String language, String sncPartnername, String sncQOP) {
        this.functionName = functionName;
        this.connectionMode = 2;
        this.addressApplServer = addressApplServer;
        this.addressMessageServer = null;
        this.group = null;
        this.systemID = null;
        this.systemNumber = systemNumber;
        this.clientNumber = clientNumber;
        this.username = username;
        this.passwd = null;
        this.language = language;
        this.securityMode = SECURITY_MODE_ON;
        this.sncPartnername = sncPartnername;
        this.sncQOP = sncQOP;
    }

    public Properties getPropertyCollection() throws CAFBaseException {
        Properties props = new Properties();
        props.setProperty(RFC_MODE_REMOTE, Integer.toString(this.remoteMode));
        props.setProperty(JCO_CONNECTION_MODE, Integer.toString(this.connectionMode));
        if (this.functionName != null) {
            props.setProperty(RFC_FUNC_NAME, this.functionName);
        }
        if (this.addressApplServer != null) {
            props.setProperty(JCO_APPL_SERVER, this.addressApplServer);
        }
        if (this.addressMessageServer != null) {
            props.setProperty(JCO_MSG_SERVER, this.addressMessageServer);
        }
        if (this.group != null) {
            props.setProperty(JCO_LOGONGROUP, this.group);
        }
        if (this.systemID != null) {
            props.setProperty(JCO_SYSTEMID, this.systemID);
        }
        if (this.systemNumber != -1) {
            props.setProperty(JCO_SYSTEM_NUMBER, Integer.toString(this.systemNumber));
        }
        if (this.clientNumber == -1) {
            throw new CAFBaseException("Invalid Arguments. No Client Number Set.");
        }
        props.setProperty(JCO_CLIENT, Integer.toString(this.clientNumber));
        if (this.username == null) {
            throw new CAFBaseException("Invalid Arguments. No Username Set.");
        }
        props.setProperty(JCO_USERNAME, this.username);
        if (this.language != null) {
            props.setProperty(JCO_LANGUAGE, this.language);
        } else {
            props.setProperty(JCO_LANGUAGE, "DE");
        }
        if (this.passwd != null) {
            props.setProperty(JCO_PASSWORD, this.passwd);
        }
        props.setProperty(JCO_SECURITY_MODE, Integer.toString(this.securityMode));
        if (this.securityMode == SECURITY_MODE_ON) {
            if (this.sncPartnername == null) {
                throw new CAFBaseException("Invalid Arguments. No SNC-Partnername Set.");
            }
            props.setProperty(SNC_PARTNERNAME, this.sncPartnername);
            if (this.sncQOP != null) {
                props.setProperty(SNC_QOP, this.sncQOP);
            } else {
                throw new CAFBaseException("Invalid Arguments. No SNC-QOP Set.");
            }
        }
        return props;
    }
}

