/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.imports.mp2mmr;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.CAFRuntimeException;
import com.sap.caf.designer.utils.DateUtils;
import com.sap.caf.imports.mp2mmr.ConversionException;
import com.sap.caf.imports.mp2mmr.ConvertMP2DDicType;
import com.sap.caf.imports.mp2mmr.MP2MMRImport;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.Configuration;
import com.sap.caf.metamodel.Constraint;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.Entry;
import com.sap.caf.metamodel.ExternalInterface;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.MetamodelPackage;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.interfce.api.IOperationpart;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.service.registry.ServiceDefinition;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import java.util.AbstractList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import org.omg.cwm.objectmodel.core.VisibilityKind;
import org.omg.cwm.objectmodel.core.VisibilityKindEnum;

public class MP2MMRImportImpl
implements MP2MMRImport {
    public static final Integer BEAN_STATE_STATELESS = new Integer(0);
    public static final Integer BEAN_STATE_STATEFULL = new Integer(1);
    public static final Integer SRVC_TYPE_RFC_R3 = new Integer(0);
    public static final Integer SRVC_TYPE_WEBSERVICE = new Integer(1);
    public static final Integer SRVC_OPTYPE_NONE = new Integer(0);
    public static final Integer SRVC_OPTYPE_CREATE = new Integer(1);
    public static final Integer SRVC_OPTYPE_READ = new Integer(2);
    public static final Integer SRVC_OPTYPE_UPDATE = new Integer(3);
    public static final Integer SRVC_OPTYPE_DELETE = new Integer(4);
    public static final Integer SRVC_OPTYPE_FINDBY = new Integer(5);
    public static final Integer SRVC_OPTYPE_VALIDATE = new Integer(6);
    public static final Integer SRVC_OPTYPE_VALUEHELP = new Integer(7);
    public static final String WEBSERVICE_KEY_PROP = "address";
    public static final String RFC_R3_KEY_PROP = "jco.client";
    private String creatorName = "";
    private Date creationDate = new Date();
    private String creationTimeAsString = DateUtils.getTimeStampDateAsString(this.creationDate);
    private static Integer ATTR_LISTTYPE_ALLUNSORT = new Integer(0);
    private static Integer ATTR_LISTTYPE_SEQUENCE = new Integer(1);
    private static Integer ATTR_LISTTYPE_CHOICE = new Integer(2);
    private static Integer ATTR_RELTYPE_NONE = new Integer(0);
    private static Integer ATTR_RELTYPE_ASSOCIATION = new Integer(1);
    private static Integer ATTR_RELTYPE_AGGREGATION = new Integer(2);

    public void setCreator(String username) {
        this.creatorName = username;
    }

    public void setCreationDate(Date datetime) {
        this.creationDate = datetime;
        this.creationTimeAsString = DateUtils.getTimeStampDateAsString(this.creationDate);
    }

    public ExternalInterface storeService(ServiceDefinition srvDef, MetamodelPackage metamodel, String serviceName) throws CAFBaseException {
        try {
            CachedEqualInstances cachedMaps = new CachedEqualInstances();
            IPorttype port = srvDef.getPortType();
            Properties connectProps = srvDef.getPortTypeProperties();
            ExternalInterface extSrvDescr = metamodel.getExternalInterface().createExternalInterface();
            this.updateBaseObjectCreationParams((BaseObject)extSrvDescr);
            extSrvDescr.setObjectName(serviceName);
            extSrvDescr.setName(serviceName);
            extSrvDescr.setBeanState(BEAN_STATE_STATELESS);
            boolean isR3 = false;
            if (connectProps.getProperty(RFC_R3_KEY_PROP) != null) {
                isR3 = true;
            } else if (connectProps.getProperty(WEBSERVICE_KEY_PROP) != null) {
                isR3 = false;
            } else {
                throw new CAFRuntimeException("Cannot Determine the External Service Type. Properties are not understandable.");
            }
            extSrvDescr.setType(isR3 ? SRVC_TYPE_RFC_R3 : SRVC_TYPE_WEBSERVICE);
            extSrvDescr.setConfiguration(MP2MMRImportImpl.importConfiguration(metamodel, connectProps));
            this.importOperations(cachedMaps, metamodel, extSrvDescr, port, srvDef);
            return extSrvDescr;
        }
        catch (Exception ex) {
            throw new CAFBaseException(ex);
        }
    }

    private static Configuration importConfiguration(MetamodelPackage metamodel, Properties props) {
        Configuration config = metamodel.getConfiguration().createConfiguration();
        com.sap.caf.metamodel.Properties extIntProperties = metamodel.getProperties().createProperties();
        if (props != null) {
            Enumeration it = ((Hashtable)props).keys();
            while (it.hasMoreElements()) {
                String key = (String)it.nextElement();
                String value = (String)((Hashtable)props).get(key);
                if (key.equals(RFC_R3_KEY_PROP) || key.equals("jco.user") || key.equals("jco.password") || value == null) continue;
                Entry keyPropEntry = metamodel.getEntry().createEntry();
                keyPropEntry.setKey(key);
                keyPropEntry.setValue(value);
                extIntProperties.getEntries().add(keyPropEntry);
            }
        }
        config.setProperties(extIntProperties);
        return config;
    }

    private void importOperations(CachedEqualInstances cachedMaps, MetamodelPackage metamodel, ExternalInterface extSrvDescr, IPorttype port, ServiceDefinition srvDef) throws EngineException, ConversionException {
        if (port == null || srvDef == null) {
            return;
        }
        List serviceOperations = extSrvDescr.getOperations();
        if (serviceOperations == null) {
            return;
        }
        int nOpCount = port.getOperationCount();
        int i = 0;
        while (i < nOpCount) {
            IOperationpart outputParams;
            IOperation mpIOperation = port.getOperation(i);
            Operation mmrOperation = metamodel.getOperation().createOperation();
            this.updateBaseObjectCreationParams((BaseObject)mmrOperation);
            mmrOperation.setObjectName(mpIOperation.getName());
            mmrOperation.setName(mpIOperation.getName());
            mmrOperation.setPatternType(SRVC_OPTYPE_NONE);
            mmrOperation.setTransactionType(new Integer(0));
            mmrOperation.setCoding("");
            mmrOperation.setConfiguration(MP2MMRImportImpl.importConfiguration(metamodel, srvDef.getOperationProperties(mpIOperation.getName())));
            IOperationpart inputParams = mpIOperation.getInputOperationpart();
            if (inputParams != null) {
                mmrOperation.setInput(this.createMMRMessage(cachedMaps, metamodel, inputParams, false));
            }
            if ((outputParams = mpIOperation.getOutputOperationpart()) != null) {
                mmrOperation.setOutput(this.createMMRMessage(cachedMaps, metamodel, outputParams, false));
            }
            int nFaultOpCount = mpIOperation.getFaultOperationpartCount();
            int j = 0;
            while (j < nFaultOpCount) {
                IOperationpart faultOp = mpIOperation.getFaultOperationpart(i);
                if (faultOp != null) {
                    mmrOperation.getFault().add(this.createMMRMessage(cachedMaps, metamodel, faultOp, true));
                }
                ++j;
            }
            mmrOperation.setPermission(metamodel.getPermission().createPermission());
            serviceOperations.add(mmrOperation);
            ++i;
        }
    }

    private Message createMMRMessage(CachedEqualInstances cachedMaps, MetamodelPackage metamodel, IOperationpart oppart, boolean isFaultMsg) throws ConversionException {
        if (oppart == null) {
            return null;
        }
        Object mmrMessage = null;
        mmrMessage = isFaultMsg ? metamodel.getFaultMessage().createFaultMessage() : metamodel.getMessage().createMessage();
        this.updateBaseObjectCreationParams((BaseObject)mmrMessage);
        IMessage mpIMessage = oppart.getMessage();
        mmrMessage.setObjectName(mpIMessage.getName());
        mmrMessage.setName(mpIMessage.getName());
        int nLen = mpIMessage.getMessagepartCount();
        if (nLen > 0) {
            if (nLen > 1) {
                throw new CAFRuntimeException("Program Error: The MP \"IMessage\" instance of the parameter \"IOperationpart\" contains unexpected number of \"Messagepart\" members.");
            }
            this.importAttributeList(cachedMaps, mmrMessage.getMessageParts(), metamodel, mpIMessage);
            return mmrMessage;
        }
        return null;
    }

    private static int maxoccursMP2MMRNormalize(int nMaxOccurs) {
        return nMaxOccurs > 0 ? nMaxOccurs : -1;
    }

    private void importAttributeList(CachedEqualInstances cachedMaps, List attrList, MetamodelPackage metamodel, IMessage mpIMessage) throws ConversionException {
        int nLen = mpIMessage.getMessagepartCount();
        int i = 0;
        while (i < nLen) {
            IMessagepart msgPart = mpIMessage.getMessagepart(i);
            Attribute mmrAttr = this.createMMRAttribute(cachedMaps, metamodel, msgPart);
            attrList.add(mmrAttr);
            ++i;
        }
    }

    private Attribute createMMRAttribute(CachedEqualInstances cachedMaps, MetamodelPackage metamodel, IMessagepart msgPart) throws ConversionException {
        Attribute mmrAttribute = metamodel.getAttribute().createAttribute();
        this.updateBaseObjectCreationParams((BaseObject)mmrAttribute);
        mmrAttribute.setObjectName(msgPart.getName());
        mmrAttribute.setName(msgPart.getName());
        mmrAttribute.setMinOccurs(new Integer(1));
        mmrAttribute.setMaxOccurs(new Integer(1));
        mmrAttribute.setAbstract(false);
        mmrAttribute.setListType(ATTR_LISTTYPE_ALLUNSORT);
        mmrAttribute.setRelationType(ATTR_RELTYPE_ASSOCIATION);
        DataStructure dataStruct = metamodel.getDataStructure().createDataStructure();
        this.updateBaseObjectCreationParams((BaseObject)dataStruct);
        dataStruct.setName(msgPart.getName());
        dataStruct.setObjectName(msgPart.getName());
        IStructure struct = msgPart.getStructure();
        if (!(struct instanceof IElement)) {
            throw new CAFRuntimeException("Program Error: Unexpected MP data. IStructure struct instance have to be of type IElement.");
        }
        IElement opElement = (IElement)struct;
        Attribute fieldAttribute = this.createMMRAttribute(cachedMaps, metamodel, opElement);
        dataStruct.getAttributes().add(fieldAttribute);
        mmrAttribute.setReferencedObject(dataStruct);
        return mmrAttribute;
    }

    private Attribute createMMRAttribute(CachedEqualInstances cachedMaps, MetamodelPackage metamodel, IElement elArg) throws ConversionException {
        Attribute mmrAttribute = metamodel.getAttribute().createAttribute();
        this.updateBaseObjectCreationParams((BaseObject)mmrAttribute);
        mmrAttribute.setObjectName(elArg.getName());
        mmrAttribute.setName(elArg.getName());
        mmrAttribute.setMinOccurs(new Integer(elArg.getMinOccurs()));
        mmrAttribute.setMaxOccurs(new Integer(MP2MMRImportImpl.maxoccursMP2MMRNormalize(elArg.getMaxOccurs())));
        mmrAttribute.setAbstract(false);
        mmrAttribute.setListType(ATTR_LISTTYPE_ALLUNSORT);
        mmrAttribute.setRelationType(ATTR_RELTYPE_NONE);
        IType attrType = elArg.getType();
        if (attrType instanceof ISimpleType) {
            ISimpleType simpleAttr = (ISimpleType)attrType;
            mmrAttribute.setTypeJavaDdic(ConvertMP2DDicType.getDDicType(simpleAttr));
            Constraint attrConstr = metamodel.getConstraint().createConstraint();
            attrConstr.setFractionDigits(new Integer(simpleAttr.getFractionDigits()));
            attrConstr.setMaxLength(new Integer(simpleAttr.getMaxLength()));
            attrConstr.setMinLength(new Integer(simpleAttr.getMinLength()));
            attrConstr.setTotalDigits(new Integer(simpleAttr.getTotalDigits()));
            int n = simpleAttr.getPatternCount();
            int i = 0;
            while (i < n) {
                String val = simpleAttr.getPattern(i);
                attrConstr.getPattern().add(val);
                ++i;
            }
            n = simpleAttr.getConstantCount();
            int i2 = 0;
            while (i2 < n) {
                String val = simpleAttr.getConstant(i2).getValue();
                attrConstr.getEnumeration().add(val);
                ++i2;
            }
            mmrAttribute.setAttributeConstraint(attrConstr);
        } else if (attrType instanceof IComplexType) {
            mmrAttribute.setRelationType(ATTR_RELTYPE_ASSOCIATION);
            DataStructure complexStruct = this.createComplexAttributeType(cachedMaps, metamodel, (IComplexType)attrType);
            if (complexStruct.getName().equals("")) {
                complexStruct.setName(elArg.getName());
                complexStruct.setObjectName(complexStruct.getName());
            }
            mmrAttribute.setReferencedObject(complexStruct);
        } else {
            throw new CAFRuntimeException("5. Unexpected MP data. Attribute not known type.");
        }
        return mmrAttribute;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataStructure createComplexAttributeType(CachedEqualInstances cachedMaps, MetamodelPackage metamodel, IComplexType mpComplexType) throws ConversionException {
        DataStructure dataStructure;
        if (cachedMaps.containsType(mpComplexType)) {
            throw new ConversionException(0);
        }
        cachedMaps.pushType(mpComplexType);
        try {
            DataStructure dataStruct = cachedMaps.getDataStructure(mpComplexType);
            if (dataStruct != null) {
                DataStructure dataStructure2 = dataStruct;
                Object var10_7 = null;
                cachedMaps.popType();
                return dataStructure2;
            }
            dataStruct = metamodel.getDataStructure().createDataStructure();
            this.updateBaseObjectCreationParams((BaseObject)dataStruct);
            cachedMaps.putDataStructure(mpComplexType, dataStruct);
            dataStruct.setName("");
            dataStruct.setObjectName("");
            int nMemberCount = mpComplexType.getElementCount();
            if (nMemberCount == 1) {
                IElement singleField = mpComplexType.getElement(0);
                if (singleField.getMaxOccurs() == 0) {
                    dataStruct.setName(singleField.getName() + "Array");
                    dataStruct.setObjectName(dataStruct.getName());
                } else if (singleField.getMaxOccurs() > 1) {
                    dataStruct.setName(singleField.getName() + "LimitedArray");
                    dataStruct.setObjectName(dataStruct.getName());
                }
            }
            int i = 0;
            while (true) {
                if (i >= nMemberCount) {
                    dataStructure = dataStruct;
                    break;
                }
                IElement field = mpComplexType.getElement(i);
                Attribute fieldAttribute = this.createMMRAttribute(cachedMaps, metamodel, field);
                dataStruct.getAttributes().add(fieldAttribute);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            cachedMaps.popType();
            throw throwable;
        }
        Object var10_8 = null;
        cachedMaps.popType();
        return dataStructure;
    }

    private void updateBaseObjectCreationParams(BaseObject baseObject) {
        baseObject.setObjectId(baseObject.refMofId());
        baseObject.setCreatedAt(this.creationTimeAsString);
        baseObject.setCreatedBy(this.creatorName);
        baseObject.setLastChangedAt(this.creationTimeAsString);
        baseObject.setLastChangedBy(this.creatorName);
        baseObject.setVisibility((VisibilityKind)VisibilityKindEnum.VK_NOTAPPLICABLE);
        baseObject.setName("CAF");
    }

    private static class CachedEqualInstances {
        private Stack forwardEdges = new Stack();
        private HashMap equalComplexTypes = new HashMap();

        private CachedEqualInstances() {
        }

        public DataStructure getDataStructure(IComplexType mpComplexType) {
            return (DataStructure)this.equalComplexTypes.get(mpComplexType);
        }

        public void putDataStructure(IComplexType mpComplexType, DataStructure value) {
            this.equalComplexTypes.put(mpComplexType, value);
        }

        public void pushType(IComplexType mpComplexType) {
            this.forwardEdges.push(mpComplexType);
        }

        public IComplexType popType() {
            return (IComplexType)this.forwardEdges.pop();
        }

        public boolean containsType(IComplexType mpComplexType) {
            Iterator it = ((AbstractList)this.forwardEdges).iterator();
            while (it.hasNext()) {
                Object current = it.next();
                if (!current.equals(mpComplexType)) continue;
                return true;
            }
            return false;
        }
    }
}

