/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class TreeSelectionDialog
extends TitleAreaDialog {
    protected Tree tree;
    protected TreeViewer treeViewer;

    public TreeSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getDialogCaption());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.tree = new Tree(composite, 2820);
        this.tree.addSelectionListener((SelectionListener)new TreeListener());
        this.treeViewer = new TreeViewer(this.tree);
        GridData data = new GridData(1040);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.expandToLevel(3);
        this.treeViewer.setSelection(null);
        this.setTitle(this.getCaption());
        this.setMessage(this.getDescription());
        this.initDialog();
        return composite;
    }

    protected void okPressed() {
        TreeItem[] items = this.tree.getSelection();
        if (items.length > 0) {
            TreeItem selected = items[0];
            this.setResult(selected);
        }
        super.okPressed();
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.y += 100;
        return size;
    }

    protected abstract String getDialogCaption();

    protected abstract void initDialog();

    protected abstract Object getResult();

    protected abstract void setResult(TreeItem var1);

    protected abstract void refreshButtonState(TreeItem var1);

    protected abstract String getCaption();

    protected abstract String getDescription();

    class TreeListener
    implements SelectionListener {
        TreeListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            TreeItem[] items = TreeSelectionDialog.this.tree.getSelection();
            if (items.length > 0) {
                TreeItem selected = items[0];
                TreeSelectionDialog.this.refreshButtonState(selected);
            }
        }
    }
}

