/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.wizards.IconUtils;
import com.sap.caf.designer.wizards.TreeSelectionDialog;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.DataStructure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class TreeSelectionDSDialog
extends TreeSelectionDialog {
    private BOMSystem bomSystem;
    private DataStructure result;

    public TreeSelectionDSDialog(Shell parentShell, BOMSystem bomSystem) {
        super(parentShell);
        this.bomSystem = bomSystem;
    }

    protected String getDialogCaption() {
        return "Select DataStructure";
    }

    protected void initDialog() {
        TreeItem rootTreeItem = new TreeItem(this.tree, 0);
        rootTreeItem.setText("DataStructures");
        rootTreeItem.setImage(IconUtils.getStaticIcon("DataStructures"));
        ArrayList dataStructures = new ArrayList();
        dataStructures.addAll(this.bomSystem.getCoreDataStructures().keySet());
        Iterator iter = dataStructures.iterator();
        while (iter.hasNext()) {
            DataStructure dataStructure = (DataStructure)this.bomSystem.getCoreDataStructures().get(iter.next());
            TreeItem treeItem = new TreeItem(rootTreeItem, 0);
            treeItem.setData((Object)dataStructure);
            treeItem.setText(dataStructure.getObjectName());
            treeItem.setImage(IconUtils.getStaticIcon("DataStructure"));
            if (!this.checkFlat(dataStructure)) continue;
            List attrs = dataStructure.getAttributes();
            Iterator iterAttrs = attrs.iterator();
            while (iterAttrs.hasNext()) {
                BaseObject baseObject = (BaseObject)iterAttrs.next();
                if (!(baseObject instanceof Attribute)) continue;
                Attribute attr = (Attribute)baseObject;
                TreeItem treeItemAttr = new TreeItem(treeItem, 0);
                treeItemAttr.setData((Object)attr);
                treeItemAttr.setText(attr.getObjectName());
                treeItemAttr.setImage(IconUtils.getStaticIcon("Attribute"));
            }
        }
        rootTreeItem.setExpanded(true);
    }

    public boolean checkFlat(DataStructure dataStructure) {
        List attrs = dataStructure.getAttributes();
        Iterator iterAttrs = attrs.iterator();
        while (iterAttrs.hasNext()) {
            BaseObject baseObject = (BaseObject)iterAttrs.next();
            if (baseObject instanceof Attribute) {
                Attribute attr = (Attribute)baseObject;
                if (attr.getReferencedObject() == null) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public Object getResult() {
        return this.result;
    }

    protected void setResult(TreeItem selected) {
        DataStructure dataStructure;
        this.result = dataStructure = (DataStructure)selected.getData();
    }

    protected void refreshButtonState(TreeItem selected) {
        this.getButton(0).setEnabled(selected.getData() != null && selected.getData() instanceof DataStructure);
    }

    protected String getCaption() {
        return "Select Data Structure";
    }

    protected String getDescription() {
        return "Data Structures presented in this dialog are flat structures";
    }
}

