/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.generation.utils.GenerationUtilsDt;
import com.sap.caf.designer.wizards.ProjectWizardPage2;
import com.sap.caf.tools.velocity.utils.NamingRestrictions;
import com.sap.tc.logging.Location;
import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ProjectWizardPage
extends WizardPage {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$wizards$ProjectWizardPage == null ? (class$com$sap$caf$designer$wizards$ProjectWizardPage = ProjectWizardPage.class$("com.sap.caf.designer.wizards.ProjectWizardPage")) : class$com$sap$caf$designer$wizards$ProjectWizardPage);
    private static final int SIZING_TEXT_FIELD_WIDTH = 170;
    private Text projectName;
    private Text packageText;
    private Text applicationName;
    private ISelection selection;
    private String initProjName;
    private boolean useDefaults = true;
    private String initialProjectFieldValue;
    private String initialLocationFieldValue;
    private String customLocationFieldValue = "";
    private Text locationPathField;
    private Label locationLabel;
    private Button browseButton;
    boolean isDCProject = false;
    String vendorName = null;
    String appName = null;
    String prjName = null;
    String locationName = null;
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            ProjectWizardPage.this.dialogChanged(true);
        }
    };
    static /* synthetic */ Class class$com$sap$caf$designer$wizards$ProjectWizardPage;

    public ProjectWizardPage(ISelection selection, String initProjName) {
        super("wizardPage");
        this.setTitle(mTextPool.getText("BOM_PROJECTWZRD_0008"));
        this.setDescription(mTextPool.getText("BOM_PROJECTWZRD_0007"));
        this.selection = selection;
        this.initProjName = initProjName;
    }

    public String getApplication() {
        return this.applicationName.getText();
    }

    public void setApplicationName(String appName) {
        this.appName = appName;
    }

    public void setDCProject(boolean b) {
        this.isDCProject = b;
    }

    public boolean isDCProject() {
        return this.isDCProject;
    }

    public void setLocation(String location) {
        this.locationName = location;
    }

    public String getPackage() {
        if (!this.isDCProject()) {
            return this.packageText.getText();
        }
        return this.vendorName;
    }

    public boolean isPageComplete() {
        return this.dialogChanged(false) && this.getNextPage().isPageComplete();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectLocationFieldValue() {
        if (this.locationPathField == null) {
            return "";
        }
        return this.locationPathField.getText().trim();
    }

    public void setProjectName(String name) {
        this.prjName = name;
    }

    public String getProjectName() {
        return this.projectName.getText();
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public boolean canFlipToNextPage() {
        return this.dialogChanged(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(mTextPool.getText("BOM_PROJECTWZRD_0019"));
        this.applicationName = new Text(container, 2052);
        if (this.isDCProject() && this.appName != null) {
            this.applicationName.setText(this.appName);
            this.applicationName.setEnabled(false);
        }
        GridData gd = new GridData(768);
        this.applicationName.setLayoutData((Object)gd);
        this.applicationName.setTextLimit(38);
        this.applicationName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectWizardPage.this.dialogChanged(true);
            }
        });
        label = new Label(container, 0);
        label.setText(mTextPool.getText("BOM_PROJECTWZRD_0003", true));
        this.projectName = new Text(container, 2052);
        if (this.isDCProject() && this.prjName != null) {
            this.projectName.setText(this.prjName);
            this.projectName.setEnabled(false);
        }
        gd = new GridData(768);
        this.projectName.setLayoutData((Object)gd);
        this.projectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectWizardPage2 nextPage = (ProjectWizardPage2)ProjectWizardPage.this.getNextPage();
                if (nextPage != null) {
                    nextPage.setDictionaryNameField(ProjectWizardPage.this.projectName.getText() + "Dict");
                    nextPage.setObjectEjbNameField(ProjectWizardPage.this.projectName.getText() + "EjbModule");
                    nextPage.setEnterpriseApplicationNameField(ProjectWizardPage.this.projectName.getText() + "EnterpriseApplication");
                    nextPage.setMetadataNameField(ProjectWizardPage.this.projectName.getText() + "Metadata");
                    nextPage.setWebDynproNameField(ProjectWizardPage.this.projectName.getText() + "WebDynpro");
                    nextPage.setUMENameField(ProjectWizardPage.this.projectName.getText() + "Permissions");
                }
                ProjectWizardPage.this.dialogChanged(true);
            }
        });
        if (!this.isDCProject()) {
            label = new Label(container, 0);
            label.setText(mTextPool.getText("BOM_PROJECTWZRD_0005"));
            this.packageText = new Text(container, 2052);
            gd = new GridData(768);
            this.packageText.setLayoutData((Object)gd);
            this.packageText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ProjectWizardPage.this.dialogChanged(true);
                }
            });
        }
        this.createProjectLocationGroup(container);
        this.initialize();
        this.dialogChanged(true);
        this.setControl((Control)container);
        this.projectName.setFocus();
    }

    private final void createProjectLocationGroup(Composite parent) {
        Font font = parent.getFont();
        Label projectGroupEmpty = new Label(parent, 256);
        Label projectGroupEmpty2 = new Label(parent, 256);
        Label projectGroup = new Label(parent, 0);
        projectGroup.setLayoutData((Object)new GridData(9));
        projectGroup.setFont(font);
        projectGroup.setText(mTextPool.getText("BOM_PROJECTWZRD_0012"));
        final Button useDefaultsButton = new Button(parent, 16416);
        useDefaultsButton.setText(mTextPool.getText("BOM_PROJECTWZRD_0013"));
        useDefaultsButton.setSelection(this.useDefaults);
        useDefaultsButton.setFont(font);
        if (this.isDCProject()) {
            useDefaultsButton.setEnabled(false);
        }
        GridData buttonData = new GridData(8);
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedProjectLocationGroup(parent, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectWizardPage.this.useDefaults = useDefaultsButton.getSelection();
                ProjectWizardPage.this.browseButton.setEnabled(!ProjectWizardPage.this.useDefaults);
                ProjectWizardPage.this.locationPathField.setEnabled(!ProjectWizardPage.this.useDefaults);
                ProjectWizardPage.this.locationLabel.setEnabled(!ProjectWizardPage.this.useDefaults);
                if (ProjectWizardPage.this.useDefaults) {
                    ProjectWizardPage.this.customLocationFieldValue = ProjectWizardPage.this.locationPathField.getText();
                    ProjectWizardPage.this.setLocationForSelection();
                } else {
                    ProjectWizardPage.this.locationPathField.setText(ProjectWizardPage.this.customLocationFieldValue);
                }
                ProjectWizardPage.this.dialogChanged(true);
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private String getDefaultLocationForName(String nameValue) {
        IPath defaultPath = Platform.getLocation().append(nameValue);
        return defaultPath.toOSString();
    }

    private boolean isJavaKeyWord(String applicationName) {
        return !NamingRestrictions.isValidMemberName(applicationName);
    }

    private void setLocationForSelection() {
        if (this.useDefaults) {
            this.locationPathField.setText(this.getDefaultLocationForName(this.getProjectName()));
        }
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup, boolean enabled) {
        Font font = projectGroup.getFont();
        this.locationLabel = new Label(projectGroup, 128);
        this.locationLabel.setText(mTextPool.getText("BOM_PROJECTWZRD_0014"));
        this.locationLabel.setEnabled(enabled);
        this.locationLabel.setFont(font);
        Composite projectPathGroup = new Composite(projectGroup, 128);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.numColumns = 2;
        projectPathGroup.setLayout((Layout)layout);
        projectPathGroup.setLayoutData((Object)new GridData(768));
        this.locationPathField = new Text(projectPathGroup, 2048);
        GridData data = new GridData(800);
        data.widthHint = 170;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setEnabled(enabled);
        this.locationPathField.setFont(font);
        this.locationPathField.setText("");
        this.browseButton = new Button(projectPathGroup, 131208);
        this.browseButton.setText(mTextPool.getText("BOM_PROJECTWZRD_0015"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProjectWizardPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        this.browseButton.setFont(font);
        if (this.initialLocationFieldValue == null) {
            this.locationPathField.setText(Platform.getLocation().toOSString());
        } else {
            this.locationPathField.setText(this.initialLocationFieldValue);
        }
        if (this.locationName != null) {
            this.initialLocationFieldValue = this.locationName;
            this.locationPathField.setText(this.locationName);
        }
        this.locationPathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectWizardPage.this.dialogChanged(true);
            }
        });
    }

    private boolean dialogChanged(boolean isNeedUpdatePage) {
        String projectName = this.getProjectName();
        String packageName = this.getPackage();
        String applicationName = this.getApplication();
        String locationFieldContents = this.getProjectLocationFieldValue();
        if (applicationName.length() == 0) {
            if (isNeedUpdatePage) {
                this.updateStatus(mTextPool.getText("BOM_PROJECTWZRD_0020"));
            }
            return false;
        }
        if (this.isJavaKeyWord(applicationName)) {
            if (isNeedUpdatePage) {
                this.updateStatus(mTextPool.getText("BOM_PROJECTWZRD_0042"));
            }
            return false;
        }
        if (!GenerationUtilsDt.isValidApplicationNameIdentifier(applicationName)) {
            if (isNeedUpdatePage) {
                this.updateStatus(mTextPool.getText("BOM_PROJECTWZRD_0030"));
            }
            return false;
        }
        if (projectName.length() == 0) {
            if (isNeedUpdatePage) {
                this.updateStatus(mTextPool.getText("BOM_PROJECTWZRD_0004"));
            }
            return false;
        }
        if (this.getProjectHandle().exists()) {
            if (isNeedUpdatePage) {
                this.updateStatus(mTextPool.getText("BOM_PROJECTWZRD_0023"));
            }
            return false;
        }
        if (!GenerationUtilsDt.isValidProjectNameIdentifier(projectName)) {
            if (isNeedUpdatePage) {
                this.updateStatus(mTextPool.getText("BOM_PROJECTWZRD_0031"));
            }
            return false;
        }
        if (packageName.length() == 0) {
            if (isNeedUpdatePage) {
                this.updateStatus(mTextPool.getText("BOM_PROJECTWZRD_0006"));
            }
            return false;
        }
        if (!GenerationUtilsDt.isValidPackageNameIdentifier(packageName)) {
            if (isNeedUpdatePage) {
                this.updateStatus(mTextPool.getText("BOM_PROJECTWZRD_0032"));
            }
            return false;
        }
        if (locationFieldContents.length() == 0) {
            if (isNeedUpdatePage) {
                this.updateStatus(mTextPool.getText("BOM_PROJECTWZRD_0021"));
            }
            return false;
        }
        Path path = new Path("");
        if (!path.isValidPath(locationFieldContents)) {
            if (isNeedUpdatePage) {
                this.updateStatus(mTextPool.getText("BOM_PROJECTWZRD_0021"));
            }
            return false;
        }
        if (isNeedUpdatePage) {
            this.updateStatus(null);
        }
        return true;
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(mTextPool.getText("BOM_PROJECTWZRD_0024"));
        String dirName = this.getProjectLocationFieldValue();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.customLocationFieldValue = selectedDirectory;
            this.locationPathField.setText(this.customLocationFieldValue);
        }
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                if (obj instanceof IContainer) {
                    IContainer container = (IContainer)obj;
                } else {
                    IContainer iContainer = ((IResource)obj).getParent();
                }
            }
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(false);
    }

    public boolean isUseDefaults() {
        return this.useDefaults;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

