/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.AppDesignerPerspective;
import com.sap.caf.designer.BomPlugin;
import com.sap.caf.designer.IProjectTypes;
import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.dtr.DtrService;
import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.CAFEclipseCoreException;
import com.sap.caf.designer.exception.CAFInvocationTargetException;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.preferences.XMLMapStore;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.views.ModelTreeViewer;
import com.sap.caf.designer.wizards.CafComponentTypesReader;
import com.sap.caf.designer.wizards.ProjectWizardPage;
import com.sap.caf.designer.wizards.ProjectWizardPage2;
import com.sap.caf.tools.velocity.utils.StringUtils;
import com.sap.ide.eclipse.component.core.ComponentTypeTreeViewer;
import com.sap.ide.eclipse.component.core.DCController;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.wizard.DCDefinitionPage;
import com.sap.ide.eclipse.component.wizard.DCWizardUtil;
import com.sap.ide.eclipse.component.wizard.IWizardValidator;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.login.UserValidator;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.webdynpro.project.LibraryReference;
import com.sap.ide.metamodel.webdynpro.project.ProjectProperties;
import com.sap.ide.webdynpro.service.core.projectproperties.ProjectPropertiesService;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.Component;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.complib.provider.FileOutputProvider;
import com.sap.tc.complib.provider.PPOutputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.logging.Location;
import com.tssap.dii.component.IConnectedWizard;
import com.tssap.dii.component.IStartCreateProjectWizard;
import com.tssap.dtr.client.eclipse.workspaceMonitor.WorkspaceMonitor;
import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.IRepresentArchive;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ear.dd.IDisplayName;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.IDescriptorFactory;
import com.tssap.j2ee.ui.util.CompUtil;
import com.tssap.j2ee.util.core.CompConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ProjectWizard
extends Wizard
implements INewWizard,
IProjectTypes,
IConnectedWizard,
IWizardValidator {
    public static final String METADATA_PROJECT_TYPE = "Composite Application Services";
    public static final String J2EE_PROJECT_TYPE = "J2EE";
    public static final String EJB_PROJECT_SUBTYPE = "EJBModule";
    public static final String DICTIONARY_PROJECT_TYPE = "Dictionary";
    public static final String VENDOR_NAME = "sap.com";
    public static final String PROJECT_TYPE_NAME_END = " Object";
    public static final String ENTERPRISE_APPLICATION_SUBTYPE = "Enterprise Application";
    public static final String WEBDYNPRO_APPLICATION_SUBTYPE = "Source";
    public static final String EMPTY_EJB_PROJECT_SUFFIX = "EjbModule";
    public static final String EMPTY_DICT_PROJECT_SUFFIX = "Dict";
    public static final String EMPTY_EAR_PROJECT_SUFFIX = "EnterpriseApplication";
    public static final String EMPTY_METADATA_PROJECT_SUFFIX = "Metadata";
    public static final String EMPTY_WEBDYNPRO_PROJECT_SUFFIX = "WebDynpro";
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String JAVANATURE_ID = "org.eclipse.jdt.core.javanature";
    public static final String DDICNATURE_ID = "com.sap.dictionary.tools.archivebuilder.DictionaryNature";
    private static final String EJBNATURE_ID = "com.tssap.j2ee.core.ejb.ejbNature";
    private static final String PATTERNNATURE_ID = "com.tssap.selena.cmf.PatternNature";
    private static final String TEMPLATENATURE_ID = "com.tssap.selena.cmf.TemplateNature";
    public static final String CAFNATURE_ID = "com.sap.caf.designer.CAFNature";
    private static final String EJBJARNATURE_ID = "com.tssap.j2ee.core.ejbjar.ejbJarNature";
    private static final String EARNATURE_ID = "com.tssap.j2ee.core.ear.earNature";
    public static final String SOURCE_PATH_ENTRY = "ejbModule";
    public static final String WDPNATURE = "com.sap.ide.webdynpro.archivebuilder.WebDynproNature";
    public static final String WDP_PROJECT_TYPE = "Web Dynpro";
    public static final String WDP_PROJECT_SUFFIX = "WDP";
    public static final String UMENATURE = "com.sap.ide.eclipse.component.provider.dcnature";
    public static final String UME_PROJECT_TYPE = "Content";
    public static final String UME_PROJECT_SUBTYPE = "UME Permissions";
    public static final String UME_PROJECT_SUFFIX = "UME";
    public static final String EMPTY_UME_PROJECT_SUFFIX = "Permissions";
    private static final String CORE_OBJECTS_JAR_PATH = "/plugins/com.sap.tc.ap/comp/CAF/DCs/sap.com/caf/core/services/_comp/gen/default/public/ejbjar/lib/java/sap.com~caf~core~services.jar";
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$wizards$ProjectWizard == null ? (class$com$sap$caf$designer$wizards$ProjectWizard = ProjectWizard.class$("com.sap.caf.designer.wizards.ProjectWizard")) : class$com$sap$caf$designer$wizards$ProjectWizard);
    private ProjectWizardPage page;
    private ProjectWizardPage2 page2;
    private ISelection selection;
    private IWorkbench workbench;
    private String projName = "";
    private BOMSystem bos;
    private PublicPart publicPart2 = null;
    private DevelopmentComponent dictionaryDC = null;
    private IStartCreateProjectWizard startWizard;
    private boolean isUseDefaultDCName = false;
    private Map generatedFiles = new HashMap();
    private List fullPathOfCreatedFiles = new ArrayList();
    static /* synthetic */ Class class$com$sap$caf$designer$wizards$ProjectWizard;

    public ProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public ProjectWizard(String projName) {
        this();
        this.projName = projName;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (AppDesignerPerspective.getLicense().isValid()) {
            return super.getNextPage(page);
        }
        return null;
    }

    public String getPackage() {
        return this.page.getPackage();
    }

    public String getProjectName() {
        return this.page.getProjectName();
    }

    public void addPages() {
        if (!AppDesignerPerspective.getLicense().isValid()) {
            return;
        }
        if (this.page == null) {
            this.page = new ProjectWizardPage(this.selection, this.projName);
        }
        this.addPage((IWizardPage)this.page);
        if (this.page2 == null) {
            this.page2 = new ProjectWizardPage2(this.selection, this.projName);
        }
        this.addPage((IWizardPage)this.page2);
    }

    public boolean canFinish() {
        if (AppDesignerPerspective.getLicense().isValid()) {
            return super.canFinish();
        }
        return false;
    }

    public boolean completeProject(IProject newProj, Properties properties) {
        try {
            IProjectDescription desc = newProj.getDescription();
            String[] prevNatures = desc.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = CAFNATURE_ID;
            desc.setNatureIds(newNatures);
            newProj.setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void finalProject() {
    }

    public void init(IStartCreateProjectWizard wizard) {
        DCDefinitionPage dcdefpage;
        this.startWizard = wizard;
        if (!AppDesignerPerspective.getLicense().isValid()) {
            return;
        }
        DCController dCController = ((com.sap.ide.eclipse.component.wizard.ProjectWizard)this.startWizard).getDCController();
        ((com.sap.ide.eclipse.component.wizard.ProjectWizard)this.startWizard).addValidator((IWizardValidator)this);
        if (!dCController.getDevConfiguration().isLocalConfiguration() && !UserValidator.isDefaultServerOnline() && this.startWizard != null && this.startWizard instanceof com.sap.ide.eclipse.component.wizard.ProjectWizard && (dcdefpage = (DCDefinitionPage)((com.sap.ide.eclipse.component.wizard.ProjectWizard)this.startWizard).getPage("devComponentWizardPage")) != null && !dcdefpage.getControl().isDisposed()) {
            dcdefpage.setMessage(mTextPool.getText("DC_PREFIX_LACK_WARNING"), 2);
        }
        if (this.page == null) {
            this.page = new ProjectWizardPage(this.selection, this.projName);
        }
        if (this.page2 == null) {
            this.page2 = new ProjectWizardPage2(this.selection, this.projName);
        }
        this.page.setDCProject(true);
        this.page2.setDCProject(true);
        this.page.setLocation(this.startWizard.getProjectDescription().getLocation().toOSString());
        this.page.setVendorName(this.startWizard.getVendor());
        ComponentType compType = new ComponentType();
        compType.setType(METADATA_PROJECT_TYPE);
        this.page.setProjectName(this.getProjectName(compType));
        this.page2.setProjectName(this.getDCName(compType, true));
        if (this.startWizard != null) {
            compType.setType("Dictionary Object");
            this.page2.setDictionaryNameField(this.getProjectName(compType));
            compType.setType(null);
            compType.setSubType("EJBModule Object");
            this.page2.setObjectEjbNameField(this.getProjectName(compType));
            compType.setType(null);
            compType.setSubType(ENTERPRISE_APPLICATION_SUBTYPE);
            this.page2.setEnterpriseApplicationNameField(this.getProjectName(compType));
            compType.setType(null);
            compType.setSubType(METADATA_PROJECT_TYPE);
            this.page2.setMetadataNameField(this.getProjectName(compType));
            compType.setType(null);
            compType.setSubType(WDP_PROJECT_TYPE);
            this.page2.setWebDynproNameField(this.getProjectName(compType));
            compType.setType(UME_PROJECT_TYPE);
            compType.setSubType(UME_PROJECT_SUBTYPE);
            this.page2.setUMENameField(this.getProjectName(compType));
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(mTextPool.getText("BOM_PROJECTWZRD_0043"));
        this.workbench = workbench;
    }

    public boolean performFinish() {
        if (this.startWizard != null && this.startWizard instanceof com.sap.ide.eclipse.component.wizard.ProjectWizard) {
            ((com.sap.ide.eclipse.component.wizard.ProjectWizard)this.startWizard).reset();
        }
        if (!AppDesignerPerspective.getLicense().isValid()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)mTextPool.getText("CAFDESIGNER.NO_LICENSE_TITLE"), (String)mTextPool.getText("CAFDESIGNER.CREATEPROJECT.NO_LICENSE_MSG"));
            return true;
        }
        final String projectName = this.page.getProjectName();
        final String packageName = this.page.getPackage();
        final String appName = this.page.getApplication();
        final String projectLocationPath = this.page.getProjectLocationFieldValue();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws CAFInvocationTargetException {
                try {
                    try {
                        ProjectWizard.this.doFinish(appName, packageName, projectName, monitor, projectLocationPath);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                    catch (Exception e) {
                        throw new CAFInvocationTargetException(e);
                    }
                    Object var5_2 = null;
                }
                catch (Throwable throwable) {
                    Object var5_3 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, op);
            this.changetoAppDesignerPerspective();
            ModelTreeViewer.deepRefreshInstances();
            ModelTreeViewer.refreshInstances();
            Runnable runnable = new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)ProjectWizard.this.getShell(), (String)"Info", (String)"Project was created successfully");
                }
            };
            this.getContainer().getShell().getDisplay().asyncExec(runnable);
            while (this.getContainer().getShell().getDisplay().readAndDispatch()) {
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            if (e.getMessage() != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)mTextPool.getText("BOM_ALL_0020"), (String)e.getMessage());
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)mTextPool.getText("BOM_ALL_0020"), (String)mTextPool.getText("BOM_PROJECTWZRD_0034"));
            }
            return false;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            if (e.getMessage() != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)mTextPool.getText("BOM_ALL_0020"), (String)e.getMessage());
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)mTextPool.getText("BOM_ALL_0020"), (String)mTextPool.getText("BOM_PROJECTWZRD_0034"));
            }
            return false;
        }
        return true;
    }

    public IStatus validate() {
        ComponentType compType;
        this.isUseDefaultDCName = false;
        DCController controller = ((com.sap.ide.eclipse.component.wizard.ProjectWizard)this.startWizard).createDCController();
        ComponentType compType1 = new ComponentType();
        compType1.setType(METADATA_PROJECT_TYPE);
        ComponentType compType2 = new ComponentType();
        compType2.setSubType("EJBModule Object");
        ComponentType compType4 = new ComponentType();
        compType4.setType("Dictionary Object");
        ComponentType compType6 = new ComponentType();
        compType6.setSubType(ENTERPRISE_APPLICATION_SUBTYPE);
        this.getDCName(compType1, true);
        this.getDCName(compType2, true);
        this.getDCName(compType4, true);
        this.getDCName(compType6, true);
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>();
        ht.put(this.getDCName(compType1, false), new Integer(1));
        ht.put(this.getDCName(compType2, false), new Integer(1));
        ht.put(this.getDCName(compType4, false), new Integer(1));
        ht.put(this.getDCName(compType6, false), new Integer(1));
        if (ht.size() < 4) {
            this.isUseDefaultDCName = true;
        }
        if (this.page != null) {
            compType = new ComponentType();
            compType.setType(METADATA_PROJECT_TYPE);
            this.page.setProjectName(this.getProjectName(compType));
            if (this.startWizard.getName() != null) {
                String s = this.startWizard.getName().trim().replace('.', '~').replace('/', '.');
                if (s.length() > 0) {
                    StringBuffer buf = new StringBuffer(s);
                    StringBuffer buf2 = new StringBuffer();
                    if (buf.charAt(0) != '.') {
                        buf2.append(buf.charAt(0));
                    }
                    int i = 1;
                    while (i < buf.length()) {
                        if (buf.charAt(i) != '.') {
                            buf2.append(buf.charAt(i));
                        } else if (buf.charAt(i) == '.' && buf.charAt(i - 1) != '.') {
                            buf2.append(buf.charAt(i));
                        }
                        ++i;
                    }
                    if (buf2.length() - 1 >= 0 && buf2.charAt(buf2.length() - 1) == '.') {
                        buf2.deleteCharAt(buf2.length() - 1);
                    }
                    this.page.setApplicationName(buf2.toString());
                } else {
                    this.page.setApplicationName(s);
                }
            }
        }
        if (this.page2 != null) {
            compType = new ComponentType();
            compType.setType(METADATA_PROJECT_TYPE);
            this.page2.setProjectName(this.getDCName(compType, true));
            if (this.startWizard != null) {
                compType.setType("Dictionary Object");
                this.page2.setDictionaryNameField(this.getProjectName(compType));
                compType.setType(null);
                compType.setSubType("EJBModule Object");
                this.page2.setObjectEjbNameField(this.getProjectName(compType));
                compType.setType(null);
                compType.setSubType(ENTERPRISE_APPLICATION_SUBTYPE);
                this.page2.setEnterpriseApplicationNameField(this.getProjectName(compType));
                compType.setType(null);
                compType.setSubType(METADATA_PROJECT_TYPE);
                this.page2.setMetadataNameField(this.getProjectName(compType));
                compType.setType(null);
                compType.setSubType(WDP_PROJECT_TYPE);
                this.page2.setWebDynproNameField(this.getProjectName(compType));
                compType.setType(UME_PROJECT_TYPE);
                compType.setSubType(UME_PROJECT_SUBTYPE);
                this.page2.setUMENameField(this.getProjectName(compType));
            }
        }
        controller.setDefaultName(this.getDCName(compType1, false));
        IStatus status = controller.validateDCName();
        if (4 == status.getSeverity()) {
            return status;
        }
        status = controller.validate();
        if (4 == status.getSeverity()) {
            return status;
        }
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName(compType1));
        if (proj.exists()) {
            return new Status(0, "com.sap.caf.designer", 0, mTextPool.getText("BOM_PROJECTWZRD_0037", new Object[]{proj.getName()}), null);
        }
        controller.setDefaultName(this.getDCName(compType2, false));
        status = controller.validateDCName();
        if (4 == status.getSeverity()) {
            return status;
        }
        status = controller.validate();
        if (4 == status.getSeverity()) {
            return status;
        }
        proj = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName(compType2));
        if (proj.exists()) {
            return new Status(0, "com.sap.caf.designer", 0, mTextPool.getText("BOM_PROJECTWZRD_0037", new Object[]{proj.getName()}), null);
        }
        controller.setDefaultName(this.getDCName(compType4, false));
        status = controller.validateDCName();
        if (4 == status.getSeverity()) {
            return status;
        }
        status = controller.validate();
        if (4 == status.getSeverity()) {
            return status;
        }
        proj = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName(compType4));
        if (proj.exists()) {
            return new Status(0, "com.sap.caf.designer", 0, mTextPool.getText("BOM_PROJECTWZRD_0037", new Object[]{proj.getName()}), null);
        }
        controller.setDefaultName(this.getDCName(compType6, true));
        status = controller.validateDCName();
        if (4 == status.getSeverity()) {
            return status;
        }
        status = controller.validate();
        if (4 == status.getSeverity()) {
            return status;
        }
        proj = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName(compType6));
        if (proj.exists()) {
            return new Status(0, "com.sap.caf.designer", 0, mTextPool.getText("BOM_PROJECTWZRD_0037", new Object[]{proj.getName()}), null);
        }
        return new Status(0, "com.sap.caf.designer", 0, "", null);
    }

    protected void setArchiveInfo(IRepresentArchive project, String extension, String location, String dcname) {
        if (this.startWizard != null) {
            CompUtil.setArchiveInfo((IRepresentArchive)project, (String)dcname, (String)this.startWizard.getVendor(), (String)extension, (String)location);
        }
    }

    protected void changetoAppDesignerPerspective() {
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor persp = reg.findPerspectiveWithId("com.sap.caf.designer.perspective");
        if (persp == null) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            page.setPerspective(persp);
            try {
                page.showView("com.sap.caf.designer.views.ModelTreeViewer");
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    protected void storeCfgProp(IProject project) {
        if (project == null) {
            return;
        }
        IPath dir_path = project.getLocation().append("cfg");
        File dir = dir_path.toFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, "caf_prop.xml");
        XMLMapStore store = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            store = new XMLMapStore("root", file.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            store = null;
        }
        if (store != null) {
            if (!this.page2.isCoreProject()) {
                store.setValue("MMR_CORE", this.page2.getCoreNameField());
                if (this.page2.getCoreNameField() == null || "".equals(this.page2.getCoreNameField().trim())) {
                    store.setValue("IS_CORE", true);
                } else {
                    store.setValue("IS_CORE", false);
                }
            }
            if (this.page.isDCProject()) {
                ComponentType compType = new ComponentType();
                compType.setType("Dictionary Object");
                store.setValue("DICT", this.getDCName(compType, false) + ":" + this.startWizard.getVendor());
                compType.setType(null);
                compType.setSubType("EJBModule Object");
                store.setValue("EJB", this.getDCName(compType, false) + ":" + this.startWizard.getVendor());
                compType.setSubType(null);
                compType.setType(WDP_PROJECT_TYPE);
                store.setValue("WDP_PROJECT", this.getDCName(compType, false) + ":" + this.startWizard.getVendor());
                compType.setSubType(UME_PROJECT_SUBTYPE);
                compType.setType(UME_PROJECT_TYPE);
                store.setValue("UME_PROJECT", this.getDCName(compType, false) + ":" + this.startWizard.getVendor());
                compType.setType(null);
                compType.setSubType(ENTERPRISE_APPLICATION_SUBTYPE);
                store.setValue("ENTERPRISE_APPLICATION", this.getDCName(compType, false) + ":" + this.startWizard.getVendor());
            } else {
                store.setValue("DICT", project.getName() + EMPTY_DICT_PROJECT_SUFFIX);
                store.setValue("EJB", project.getName() + EMPTY_EJB_PROJECT_SUFFIX);
                store.setValue("WDP_PROJECT", project.getName() + EMPTY_WEBDYNPRO_PROJECT_SUFFIX);
                store.setValue("UME_PROJECT", project.getName() + "permissions");
                store.setValue("ENTERPRISE_APPLICATION", project.getName() + EMPTY_EAR_PROJECT_SUFFIX);
            }
            store.store();
        }
    }

    private static boolean getBooleanValue(Object object) {
        Boolean value = new Boolean(false);
        if (object instanceof String) {
            return Boolean.getBoolean((String)object);
        }
        if (object instanceof Boolean) {
            value = (Boolean)object;
        }
        return value;
    }

    private static boolean getBooleanValue(Element element, String attrName) {
        String value = element.getAttribute(attrName);
        if (value == null) {
            return false;
        }
        return "true".equals(value.toLowerCase());
    }

    private static String getRevertedProvider(String providerName) {
        StringBuffer result = new StringBuffer(providerName.length());
        StringBuffer providerSB = new StringBuffer(providerName);
        int lastIndex = providerSB.toString().lastIndexOf(46);
        int prevLastindex = providerSB.length();
        while (lastIndex > 0) {
            result.append(providerSB.substring(lastIndex + 1, prevLastindex));
            result.append(".");
            providerSB.replace(lastIndex, lastIndex + 1, "~");
            prevLastindex = lastIndex;
            lastIndex = providerSB.toString().lastIndexOf(46);
        }
        result.append(providerSB.substring(0, prevLastindex));
        return result.toString();
    }

    private void getAllFiles(File dir, String projectType, String rootPath) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null && children.length > 0) {
            int i = 0;
            while (i < children.length) {
                this.getAllFiles(new File(dir, children[i]), projectType, rootPath);
                ++i;
            }
        }
        if (dir.isFile()) {
            String path = dir.getAbsolutePath();
            if (!".project".equals(dir.getName()) && !".classpath".equals(dir.getName())) {
                this.fullPathOfCreatedFiles.add(path);
                String value = this.filePathReplacer(path, rootPath);
                if (this.generatedFiles.containsKey(projectType)) {
                    List valuesCollection = (List)this.generatedFiles.get(projectType);
                    valuesCollection.add(value);
                } else {
                    ArrayList<String> valuesCollection = new ArrayList<String>();
                    valuesCollection.add(value);
                    this.generatedFiles.put(projectType, valuesCollection);
                }
            }
        }
    }

    private String getDCName(ComponentType compType, boolean haveToValidate) {
        if (!this.isUseDefaultDCName) {
            String pattern = null;
            try {
                pattern = this.getPattern(compType);
                pattern = MessageFormat.format(pattern, this.startWizard.getName());
                if (pattern == null || "".equals(pattern)) {
                    this.isUseDefaultDCName = true;
                    haveToValidate = false;
                }
            }
            catch (CAFBaseException e) {
                this.isUseDefaultDCName = true;
            }
            if (haveToValidate) {
                DCController controller = ((com.sap.ide.eclipse.component.wizard.ProjectWizard)this.startWizard).createDCController();
                controller.setDefaultName(pattern);
                IStatus status = controller.validateDCName();
                if (4 == status.getSeverity()) {
                    this.isUseDefaultDCName = true;
                }
            }
            return pattern;
        }
        if (this.isUseDefaultDCName) {
            if (METADATA_PROJECT_TYPE.equals(compType.getType())) {
                return this.startWizard.getName() + "/metadata";
            }
            if ("EJBModule Object".equals(compType.getSubType())) {
                return this.startWizard.getName() + "/ejbmodule";
            }
            if ("Dictionary Object".equals(compType.getType())) {
                return this.startWizard.getName() + "/dictionary";
            }
            if (ENTERPRISE_APPLICATION_SUBTYPE.equals(compType.getSubType())) {
                return this.startWizard.getName();
            }
            if (WDP_PROJECT_TYPE.equals(compType.getType())) {
                return this.startWizard.getName() + "/webdynpro";
            }
            if (UME_PROJECT_TYPE.equals(compType.getType())) {
                return this.startWizard.getName() + "/permissions";
            }
        }
        return null;
    }

    private String getPattern(ComponentType compType) throws CAFBaseException {
        try {
            Element el = CafComponentTypesReader.getPatternElement(compType);
            return el.getAttribute("value");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CAFBaseException(e);
        }
    }

    private String getProjectName(ComponentType compType) {
        String dcName = this.getDCName(compType, false);
        if (dcName == null) {
            dcName = "";
        }
        return this.startWizard.getConfigurationName() + "~" + dcName.replace('/', '~') + "~" + this.startWizard.getVendor();
    }

    private String getRoot(String enterpriseProjectPath) {
        enterpriseProjectPath = enterpriseProjectPath.replace('\\', '/');
        String rootPath = enterpriseProjectPath.substring(0, enterpriseProjectPath.lastIndexOf("/"));
        return rootPath;
    }

    private void configureAdvancedDependences(DevelopmentComponent dc, ComponentType compType) {
        try {
            List dependencies = CafComponentTypesReader.getDependencies(compType);
            if (dependencies != null) {
                Iterator it = dependencies.iterator();
                while (it.hasNext()) {
                    Element element = (Element)it.next();
                    Dependency dependency = ComponentFactory.createDependency();
                    dependency.setComponent(new DCReference());
                    if (element.getAttribute("name") != null && !"".equals(element.getAttribute("name"))) {
                        dependency.getComponent().setName(element.getAttribute("name"));
                    }
                    if (element.getAttribute("vendor") != null && !"".equals(element.getAttribute("vendor"))) {
                        dependency.getComponent().setVendor(element.getAttribute("vendor"));
                    }
                    if (element.getAttribute("scalias") != null && !"".equals(element.getAttribute("scalias"))) {
                        dependency.getComponent().setSCAlias(element.getAttribute("scalias"));
                    }
                    if (element.getAttribute("ppref") != null && !"".equals(element.getAttribute("ppref"))) {
                        dependency.setPublicPart(element.getAttribute("ppref"));
                    }
                    dependency.setForChildrenOnly(ProjectWizard.getBooleanValue(element, "for-children"));
                    dependency.setAtBuildTime(ProjectWizard.getBooleanValue(element, "at-build-time"));
                    dependency.setAtDeployTime(ProjectWizard.getBooleanValue(element, "at-deploy-time"));
                    dependency.setAtDesignTime(ProjectWizard.getBooleanValue(element, "at-design-time"));
                    dependency.setAtRunTime(ProjectWizard.getBooleanValue(element, "at-runtime"));
                    dc.getDependencies().add(dependency);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configureAdvancedDependencesForWebDynpro(DevelopmentComponent webdynproDC, PublicPart ppart) {
        if (this.dictionaryDC != null && this.publicPart2 != null) {
            Dependency dependency = ComponentFactory.createDependency();
            dependency.setComponent(new DCReference());
            dependency.getComponent().setName(this.dictionaryDC.getName());
            dependency.getComponent().setVendor(this.dictionaryDC.getVendor());
            dependency.getComponent().setSCAlias("");
            dependency.setPublicPart(ppart.getName());
            dependency.setAtBuildTime(true);
            webdynproDC.getDependencies().add(dependency);
        }
    }

    private void configureDependencesAndBuildPlugin(DevelopmentComponent dc, ComponentType compType) {
        List dependencies;
        Element buildPlugin = ComponentTypeTreeViewer.getBuildPlugin((ComponentType)compType);
        if (buildPlugin != null) {
            PPReference ppReference = new PPReference();
            ppReference.setName(buildPlugin.getAttribute("ppref"));
            DCReference dcReference = new DCReference();
            dcReference.setName(buildPlugin.getAttribute("name"));
            dcReference.setVendor(buildPlugin.getAttribute("vendor"));
            dcReference.setSCAlias(buildPlugin.getAttribute("scalias"));
            ppReference.setComponent(dcReference);
            dc.setBuildPlugin(ppReference);
        }
        if ((dependencies = ComponentTypeTreeViewer.getDependencies((ComponentType)compType)) != null) {
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                Dependency dependency = ComponentFactory.createDependency();
                dependency.setComponent(new DCReference());
                dependency.getComponent().setName(element.getAttribute("name"));
                dependency.getComponent().setVendor(element.getAttribute("vendor"));
                dependency.getComponent().setSCAlias(element.getAttribute("scalias"));
                dependency.setPublicPart(element.getAttribute("ppref"));
                dependency.setForChildrenOnly(ProjectWizard.getBooleanValue(element, "for-children"));
                dependency.setAtBuildTime(ProjectWizard.getBooleanValue(element, "at-build-time"));
                dependency.setAtDeployTime(ProjectWizard.getBooleanValue(element, "at-deploy-time"));
                dependency.setAtDesignTime(ProjectWizard.getBooleanValue(element, "at-design-time"));
                dependency.setAtRunTime(ProjectWizard.getBooleanValue(element, "at-runtime"));
                dc.getDependencies().add(dependency);
            }
        }
    }

    private void copyFile(String srcFile, String targFile) {
        try {
            File source = new File(srcFile);
            File target = new File(targFile);
            FileReader fr = new FileReader(source);
            BufferedReader in = new BufferedReader(fr);
            FileWriter fw = new FileWriter(target);
            BufferedWriter out = new BufferedWriter(fw);
            boolean eof = false;
            while (!eof) {
                String line = in.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                out.write(line + '\n');
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createDC(IProject newProject, String name, IProgressMonitor monitor) throws CAFBaseException {
        ComponentType compType;
        DCController controller = ((com.sap.ide.eclipse.component.wizard.ProjectWizard)this.startWizard).createDCController();
        if ("/metadata".equals(name)) {
            compType = new ComponentType();
            compType.setType(METADATA_PROJECT_TYPE);
            compType.setVendor(VENDOR_NAME);
            String pattern = this.getPattern(compType);
            String namePattern = MessageFormat.format(pattern, this.startWizard.getName());
            controller.setDefaultName(namePattern);
            controller.setDefaultDCType(compType);
        } else if ("/ejb".equals(name)) {
            compType = new ComponentType();
            compType.setSubType("EJBModule Object");
            controller.setDefaultName(this.getDCName(compType, false));
        } else if ("/dictionary".equals(name)) {
            compType = new ComponentType();
            compType.setType("Dictionary Object");
            controller.setDefaultName(this.getDCName(compType, false));
        } else if ("/ear".equals(name)) {
            compType = new ComponentType();
            compType.setSubType(ENTERPRISE_APPLICATION_SUBTYPE);
            controller.setDefaultName(this.getDCName(compType, false));
        } else if ("/webdynpro".equals(name)) {
            compType = new ComponentType();
            compType.setType(WDP_PROJECT_TYPE);
            controller.setDefaultName(this.getDCName(compType, false));
        } else if ("/permissions".equals(name)) {
            compType = new ComponentType();
            compType.setType(UME_PROJECT_TYPE);
            compType.setSubType(UME_PROJECT_SUBTYPE);
            controller.setDefaultName(this.getDCName(compType, false));
        }
        controller.fillProject(newProject, null, this.startWizard.getActivity(), monitor);
        try {
            controller.getProject().refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new CAFBaseException(e);
        }
        try {
            Entity entity;
            PublicPart publicPart;
            ComponentType compType2;
            IDCExtendedProject dcPrj = (IDCExtendedProject)newProject.getNature(UMENATURE);
            DevelopmentComponent dc = dcPrj.getDCNode().getConfiguration().getDCProxyLocally(controller.getCompartment().getName(), controller.getVendor(), controller.getName()).getComponent();
            if ("/metadata".equals(name)) {
                compType2 = new ComponentType();
                compType2.setType(METADATA_PROJECT_TYPE);
                compType2.setVendor(VENDOR_NAME);
                dc.setComponentType(compType2);
                this.configureDependencesAndBuildPlugin(dc, compType2);
                compType2 = new ComponentType();
                compType2.setType(METADATA_PROJECT_TYPE);
                this.configureAdvancedDependences(dc, compType2);
            } else if ("/ejb".equals(name)) {
                FileOutputProvider outpuProvider;
                compType2 = new ComponentType();
                compType2.setType(J2EE_PROJECT_TYPE);
                compType2.setSubType(EJB_PROJECT_SUBTYPE);
                compType2.setVendor(VENDOR_NAME);
                dc.setComponentType(compType2);
                this.configureDependencesAndBuildPlugin(dc, compType2);
                compType2 = new ComponentType();
                compType2.setSubType("EJBModule Object");
                this.configureAdvancedDependences(dc, compType2);
                publicPart = ComponentFactory.createPublicPart((String)"client", (DevelopmentComponent)dc);
                publicPart.setPurpose(PublicPart.Purpose.valueOf((String)"compilation"));
                entity = ComponentFactory.createEntity((String)(this.startWizard.getVendor() + "~" + this.getDCName(compType2, false).replace('/', '~') + "_client"), (String)"EJB-Client-JAR", (PublicPart)publicPart);
                try {
                    outpuProvider = new FileOutputProvider(dcPrj.getDCNode().getConfiguration().getConfigurationRootFolder().replace('\\', '/'), (Component)dc);
                    entity.setType("Java Package Tree");
                    entity.setSubType("Class");
                    entity.setPackageName("");
                    outpuProvider.selectPublicPart(publicPart.getName());
                    publicPart.serialize((PPOutputProvider)outpuProvider);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ProviderException e) {
                    e.printStackTrace();
                }
                publicPart = ComponentFactory.createPublicPart((String)"ejbjar", (DevelopmentComponent)dc);
                publicPart.setPurpose(PublicPart.Purpose.valueOf((String)"assembly"));
                entity = ComponentFactory.createEntity((String)(this.startWizard.getVendor() + "~" + this.getDCName(compType2, false).replace('/', '~')), (String)"EJB-JAR", (PublicPart)publicPart);
                try {
                    outpuProvider = new FileOutputProvider(dcPrj.getDCNode().getConfiguration().getConfigurationRootFolder().replace('\\', '/'), (Component)dc);
                    outpuProvider.selectPublicPart(publicPart.getName());
                    publicPart.serialize((PPOutputProvider)outpuProvider);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ProviderException e) {
                    e.printStackTrace();
                }
                dc.emptySourceFolders().add("META-INF");
                dc.emptyPackageFolders().add(SOURCE_PATH_ENTRY);
            } else if ("/dictionary".equals(name)) {
                FileOutputProvider outpuProvider;
                compType2 = new ComponentType();
                compType2.setType(DICTIONARY_PROJECT_TYPE);
                compType2.setVendor(VENDOR_NAME);
                dc.setComponentType(compType2);
                this.configureDependencesAndBuildPlugin(dc, compType2);
                compType2 = new ComponentType();
                compType2.setType("Dictionary Object");
                this.configureAdvancedDependences(dc, compType2);
                this.dictionaryDC = dc;
                publicPart = ComponentFactory.createPublicPart((String)"types_assembly", (DevelopmentComponent)dc);
                publicPart.setPurpose(PublicPart.Purpose.ASSEMBLY);
                try {
                    outpuProvider = new FileOutputProvider(dcPrj.getDCNode().getConfiguration().getConfigurationRootFolder().replace('\\', '/'), (Component)dc);
                    outpuProvider.selectPublicPart(publicPart.getName());
                    publicPart.serialize((PPOutputProvider)outpuProvider);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ProviderException e) {
                    e.printStackTrace();
                }
                this.publicPart2 = ComponentFactory.createPublicPart((String)"types_compilation", (DevelopmentComponent)dc);
                this.publicPart2.setPurpose(PublicPart.Purpose.COMPILATION);
                try {
                    outpuProvider = new FileOutputProvider(dcPrj.getDCNode().getConfiguration().getConfigurationRootFolder().replace('\\', '/'), (Component)dc);
                    outpuProvider.selectPublicPart(this.publicPart2.getName());
                    this.publicPart2.serialize((PPOutputProvider)outpuProvider);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ProviderException e) {
                    e.printStackTrace();
                }
                dc.emptyPackageFolders().add("src/packages");
            } else if ("/ear".equals(name)) {
                compType2 = new ComponentType();
                compType2.setType(J2EE_PROJECT_TYPE);
                compType2.setSubType(ENTERPRISE_APPLICATION_SUBTYPE);
                compType2.setVendor(VENDOR_NAME);
                dc.setComponentType(compType2);
                this.configureDependencesAndBuildPlugin(dc, compType2);
                compType2 = new ComponentType();
                compType2.setType(ENTERPRISE_APPLICATION_SUBTYPE);
                this.configureAdvancedDependences(dc, compType2);
                dc.emptySourceFolders().add("META-INF");
                ComponentType compType3 = new ComponentType();
                compType3.setSubType("EJBModule Object");
                Dependency dependency = ComponentFactory.createDependency();
                dependency.setComponent(new DCReference());
                dependency.getComponent().setName(this.getDCName(compType3, false));
                dependency.getComponent().setVendor(this.startWizard.getVendor());
                dependency.setPublicPart("ejbjar");
                dependency.setAtBuildTime(true);
                dc.getDependencies().add(dependency);
                ComponentType compType4 = new ComponentType();
                compType4.setType("Dictionary Object");
                Dependency dependency4 = ComponentFactory.createDependency();
                dependency4.setComponent(new DCReference());
                dependency4.getComponent().setName(this.getDCName(compType4, false));
                dependency4.getComponent().setVendor(this.startWizard.getVendor());
                dependency4.setPublicPart("types_assembly");
                dependency4.setAtBuildTime(true);
                dc.getDependencies().add(dependency4);
            } else if ("/webdynpro".equals(name)) {
                compType2 = new ComponentType();
                compType2.setType(WDP_PROJECT_TYPE);
                compType2.setVendor(VENDOR_NAME);
                dc.setComponentType(compType2);
                this.configureDependencesAndBuildPlugin(dc, compType2);
                this.configureAdvancedDependences(dc, compType2);
                publicPart = ComponentFactory.createPublicPart((String)"client", (DevelopmentComponent)dc);
                publicPart.setPurpose(PublicPart.Purpose.valueOf((String)"compilation"));
                entity = ComponentFactory.createEntity((String)(this.startWizard.getVendor() + "~" + this.getDCName(compType2, false).replace('/', '~') + "_client"), (String)"Common Model", (PublicPart)publicPart);
                entity.setSubType(WEBDYNPRO_APPLICATION_SUBTYPE);
                entity.setName(this.page.getApplication());
                entity.setCaption(this.page.getApplication());
                entity.setDescription(this.page.getApplication());
                String packageName = ProjectWizard.getRevertedProvider(this.page.getPackage()) + "/" + this.page.getApplication() + "/services/" + this.page.getApplication();
                entity.setPackageName(packageName.replace('.', '/'));
                try {
                    FileOutputProvider outpuProvider = new FileOutputProvider(dcPrj.getDCNode().getConfiguration().getConfigurationRootFolder().replace('\\', '/'), (Component)dc);
                    outpuProvider.selectPublicPart(publicPart.getName());
                    publicPart.serialize((PPOutputProvider)outpuProvider);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ProviderException e) {
                    e.printStackTrace();
                }
                PublicPart publicPartJPT = ComponentFactory.createPublicPart((String)"package_tree", (DevelopmentComponent)dc);
                publicPartJPT.setPurpose(PublicPart.Purpose.COMPILATION);
                Entity entity2 = ComponentFactory.createEntity((String)(this.startWizard.getVendor() + "~" + this.getDCName(compType2, false).replace('/', '~') + "_package_tree"), (String)"Java Package Tree", (PublicPart)publicPartJPT);
                entity2.setSubType("Class");
                entity2.setName(this.page.getApplication());
                entity2.setCaption(this.page.getApplication());
                entity2.setDescription(this.page.getApplication());
                String packageName2 = ProjectWizard.getRevertedProvider(this.page.getPackage()) + "/" + this.page.getApplication() + "/services/" + this.page.getApplication();
                entity2.setPackageName(packageName2.replace('.', '/'));
                try {
                    FileOutputProvider outputProvider = new FileOutputProvider(dcPrj.getDCNode().getConfiguration().getConfigurationRootFolder().replace('\\', '/'), (Component)dc);
                    outputProvider.selectPublicPart(publicPartJPT.getName());
                    publicPartJPT.serialize((PPOutputProvider)outputProvider);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ProviderException e) {
                    e.printStackTrace();
                }
                this.configureAdvancedDependencesForWebDynpro(dc, this.publicPart2);
                List folders = dc.getSourceFolders();
                if (folders == null) {
                    folders = dc.emptySourceFolders();
                }
                folders.add("META-INF");
                folders.add("src/mimes");
                folders.add("src/configuration");
                dc.emptyPackageFolders().add("src/packages");
            } else if ("/permissions".equals(name)) {
                compType2 = new ComponentType();
                compType2.setType(UME_PROJECT_TYPE);
                compType2.setSubType(UME_PROJECT_SUBTYPE);
                compType2.setVendor(VENDOR_NAME);
                dc.setComponentType(compType2);
                this.configureDependencesAndBuildPlugin(dc, compType2);
                this.configureAdvancedDependences(dc, compType2);
            }
            IDevelopmentComponentNode dcNode = dcPrj.getDCNode();
            if (dcNode != null) {
                List folders;
                IDCProxy dcProxy = dcNode.getDCProxy();
                if (!controller.isForLocalDevelopment() && controller.hasToSyncUsedDC()) {
                    try {
                        long systemtime = System.currentTimeMillis();
                        logger.infoT("dcProxy.syncUsedComponents before:" + dcNode.getName());
                        monitor.subTask(mTextPool.getText("DTR_PROJECT_WZR_SYNCH_MONITOR_TASK_NAME", new String[]{dcPrj.getDCName()}));
                        monitor.beginTask(mTextPool.getText("DTR_PROJECT_WZR_SYNCH_MONITOR_TASK_NAME", new String[]{dcPrj.getDCName()}) + dcNode.getName(), 100);
                        monitor.worked(10);
                        dcProxy.syncUsedComponents(DCWizardUtil.getBuildVariant((IDevelopmentConfiguration)dcNode.getConfiguration(), (Compartment)dcNode.getCompartment()), false);
                        monitor.done();
                        logger.infoT("dcProxy.syncUsedComponents after: worked " + (systemtime - System.currentTimeMillis()) + " ms.");
                    }
                    catch (Throwable th) {
                        MessageDialog.openWarning((Shell)this.getShell(), (String)mTextPool.getText("BOM_ALL_0021"), (String)mTextPool.getText("DTR_PROJECT_WZR_SYNCH_WARNING", new String[]{dcPrj.getDCName()}));
                    }
                }
                if ((folders = dc.getSourceFolders()) == null) {
                    folders = dc.emptySourceFolders();
                }
                folders.add("src");
                dc.addProperty("file-type", null, ".ump");
                dc.addProperty("container-type", null, "com.sap.security.ume");
                dcProxy.serializeDefinition();
            }
            DCProjectUtil.updateProject((IDevelopmentConfiguration)dcPrj.getDCNode().getConfiguration(), (DevelopmentComponent)dc);
            this.updateClasspath(newProject);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CAFBaseException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createDir(String newDir) {
        try {
            boolean b = new File(newDir).mkdirs();
            if (!b) return;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private void createSharingReferenceObjectForWebdynproProject(IProject webdynproProject, IProgressMonitor monitor) {
        ProjectProperties properties = ProjectPropertiesService.getProjectProperties((IProject)webdynproProject);
        LibraryReference reference = null;
        try {
            if (webdynproProject != null && webdynproProject.hasNature(WDPNATURE)) {
                reference = properties.createSharingReference("1");
                reference.setLibraryName("sap.com/caf~UI~ptn~common");
                MetamodelManager.saveAllMetaData((Metamodel)MetamodelManager.getMetamodel((String)webdynproProject.getName()));
            }
        }
        catch (Exception co) {
            logger.errorT("Could not create a sharing reference object for project with name : " + webdynproProject.getName());
            co.printStackTrace();
        }
    }

    private void doFinish(String appName, String packageName, String projectName, IProgressMonitor monitor, String path) throws CAFEclipseCoreException, CAFInvocationTargetException, CAFBaseException {
        block148: {
            try {
                IProject newEnterpriseProject;
                IProject newUMEProject;
                IProject newWDProject;
                IProject newMetadataProject;
                IClasspathEntry jreSrcEntryDict;
                IClasspathEntry classpathEntry2;
                IClasspathEntry classpathEntry1;
                IClasspathEntry classpathEntry0;
                IProject newDDICProject;
                IClasspathEntry jreSrcEntry;
                IClasspathEntry coreJarEntry;
                IProject newEJBProject;
                WorkspaceMonitor dtrMonitor = WorkspaceMonitor.getInstance();
                try {
                    ComponentType compType = new ComponentType();
                    compType.setType(METADATA_PROJECT_TYPE);
                    compType.setVendor(VENDOR_NAME);
                    List dependencies = CafComponentTypesReader.getDependencies(compType);
                    compType = new ComponentType();
                    compType.setType(J2EE_PROJECT_TYPE);
                    compType.setSubType(EJB_PROJECT_SUBTYPE);
                    compType.setVendor(VENDOR_NAME);
                    compType.setSubType(compType.getSubType() + PROJECT_TYPE_NAME_END);
                    dependencies = CafComponentTypesReader.getDependencies(compType);
                    compType = new ComponentType();
                    compType.setType(DICTIONARY_PROJECT_TYPE);
                    compType.setVendor(VENDOR_NAME);
                    compType.setType(compType.getType() + PROJECT_TYPE_NAME_END);
                    dependencies = CafComponentTypesReader.getDependencies(compType);
                    compType = new ComponentType();
                    compType.setType(J2EE_PROJECT_TYPE);
                    compType.setSubType(ENTERPRISE_APPLICATION_SUBTYPE);
                    compType.setVendor(VENDOR_NAME);
                    dependencies = CafComponentTypesReader.getDependencies(compType);
                    compType = new ComponentType();
                    compType.setType(WDP_PROJECT_TYPE);
                    compType.setVendor(VENDOR_NAME);
                    dependencies = CafComponentTypesReader.getDependencies(compType);
                    compType = new ComponentType();
                    compType.setType(UME_PROJECT_TYPE);
                    compType.setSubType(UME_PROJECT_SUBTYPE);
                    compType.setVendor(VENDOR_NAME);
                    dependencies = CafComponentTypesReader.getDependencies(compType);
                }
                catch (FileNotFoundException fnfex) {
                    MessageDialog.openError((Shell)this.getShell(), (String)mTextPool.getText("BOM_ALL_0020"), (String)mTextPool.getText("BOM_PROJECTWZRD_0035", new Object[]{"cafComponentTypes.xml"}));
                }
                catch (SAXException saxex) {
                    MessageDialog.openError((Shell)this.getShell(), (String)mTextPool.getText("BOM_ALL_0020"), (String)mTextPool.getText("BOM_PROJECTWZRD_0036", new Object[]{"cafComponentTypes.xml"}));
                }
                catch (ParserConfigurationException parsex) {
                    MessageDialog.openError((Shell)this.getShell(), (String)mTextPool.getText("BOM_ALL_0020"), (String)mTextPool.getText("BOM_PROJECTWZRD_0036", new Object[]{"cafComponentTypes.xml"}));
                }
                catch (IOException ioex) {
                    MessageDialog.openError((Shell)this.getShell(), (String)mTextPool.getText("BOM_ALL_0020"), (String)mTextPool.getText("BOM_PROJECTWZRD_0036", new Object[]{"cafComponentTypes.xml"}));
                }
                monitor.beginTask(mTextPool.getText("BOM_ALL_0005") + projectName, 6);
                monitor.setTaskName(mTextPool.getText("BOM_PROJECTWZRD_0001") + " " + projectName + "...");
                monitor.worked(10);
                IPath dcPath = null;
                if (this.page.isDCProject()) {
                    int count = new Path("").append(this.startWizard.getName()).segmentCount() + 1;
                    dcPath = this.startWizard.getProjectDescription().getLocation().removeLastSegments(count);
                }
                IWorkspace wsp = ResourcesPlugin.getWorkspace();
                ComponentType compType = new ComponentType();
                monitor.setTaskName(mTextPool.getText("BOM_PROJECTWZRD_0001") + " " + projectName + " EJB Module ...");
                if (this.page.isDCProject()) {
                    compType.setType(null);
                    compType.setSubType("EJBModule Object");
                    this.createDir(dcPath.append(this.getDCName(compType, false)).append("_comp").toOSString());
                    newEJBProject = wsp.getRoot().getProject(this.getProjectName(compType));
                } else {
                    newEJBProject = wsp.getRoot().getProject(projectName + EMPTY_EJB_PROJECT_SUFFIX);
                }
                IProjectDescription desc = wsp.newProjectDescription(newEJBProject.getName());
                Path projectEJBRootPath = null;
                if (this.page.isDCProject()) {
                    desc.setLocation(dcPath.append(this.getDCName(compType, false)).append("_comp"));
                    projectEJBRootPath = dcPath.append(this.getDCName(compType, false)).append("_comp");
                } else {
                    projectEJBRootPath = new Path(path);
                    projectEJBRootPath = projectEJBRootPath.append(newEJBProject.getName());
                    this.createDir(projectEJBRootPath.toString());
                    if (!this.page.isUseDefaults()) {
                        desc.setLocation((IPath)projectEJBRootPath);
                    }
                }
                newEJBProject.create(desc, monitor);
                if (!newEJBProject.isOpen()) {
                    try {
                        newEJBProject.open(monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                }
                dtrMonitor.setMonitorResource((IResource)newEJBProject, false, -1);
                Path ejbWrkSpc = projectEJBRootPath;
                this.createDir(ejbWrkSpc.append("bin").toString());
                this.createDir(ejbWrkSpc.append(SOURCE_PATH_ENTRY).toString());
                this.createDir(ejbWrkSpc.append("Model Folder").toString());
                desc = newEJBProject.getDescription();
                String[] prevNatures = desc.getNatureIds();
                String[] newNatures = new String[prevNatures.length + 5];
                System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
                newNatures[0] = EJBNATURE_ID;
                newNatures[1] = EJBJARNATURE_ID;
                newNatures[2] = JAVANATURE_ID;
                newNatures[3] = PATTERNNATURE_ID;
                newNatures[4] = TEMPLATENATURE_ID;
                desc.setNatureIds(newNatures);
                newEJBProject.setDescription(desc, monitor);
                if (!newEJBProject.isOpen()) {
                    try {
                        newEJBProject.open(monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                }
                monitor.worked(30);
                IJavaProject javaProject = JavaCore.create((IProject)newEJBProject);
                if (javaProject.exists() && !javaProject.isOpen()) {
                    javaProject.open(null);
                }
                IPath binPath = newEJBProject.getLocation().append(SOURCE_PATH_ENTRY);
                IContainer binContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(binPath);
                if (binContainer instanceof IFolder) {
                    try {
                        if (!binContainer.exists()) {
                            ((IFolder)binContainer).create(true, true, monitor);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                IClasspathEntry classpathEntry = JavaCore.newSourceEntry((IPath)binContainer.getFullPath());
                IClasspathEntry[] classpathEntryArray = javaProject.getRawClasspath();
                IClasspathEntry[] classpathEntryArray2 = new IClasspathEntry[classpathEntryArray.length + 2];
                int i = 0;
                while (i < classpathEntryArray.length) {
                    classpathEntryArray2[i] = classpathEntryArray[i].getEntryKind() == 3 ? classpathEntry : classpathEntryArray[i];
                    ++i;
                }
                classpathEntryArray2[classpathEntryArray.length] = coreJarEntry = JavaCore.newVariableEntry((IPath)new Path("ECLIPSE_HOME/plugins/com.sap.tc.ap/comp/CAF/DCs/sap.com/caf/core/services/_comp/gen/default/public/ejbjar/lib/java/sap.com~caf~core~services.jar"), null, null);
                classpathEntryArray2[classpathEntryArray.length + 1] = jreSrcEntry = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), null);
                javaProject.setRawClasspath(classpathEntryArray2, monitor);
                if (this.page.isDCProject()) {
                    this.createDC(newEJBProject, "/ejb", monitor);
                }
                this.createDir(newEJBProject.getLocation().append("META-INF").toString());
                monitor.worked(40);
                IEjbModule ejbModule = J2eeProjectManager.getEjbModule((String)newEJBProject.getName());
                if (ejbModule != null) {
                    IFolder metaFolder = newEJBProject.getFolder("META-INF");
                    metaFolder.create(true, true, monitor);
                    ejbModule.createDescriptor();
                    if (this.startWizard != null) {
                        ComponentType tempCompType = new ComponentType();
                        tempCompType.setSubType("EJBModule Object");
                        this.setArchiveInfo((IRepresentArchive)ejbModule, "jar", CompConstants.getDcLocationEjbJar((String)this.startWizard.getBuildVariant()), this.getDCName(tempCompType, false));
                    }
                }
                try {
                    newEJBProject.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                monitor.setTaskName(mTextPool.getText("BOM_PROJECTWZRD_0001") + " " + projectName + " Dict ...");
                if (this.page.isDCProject()) {
                    compType.setType("Dictionary Object");
                    compType.setSubType(null);
                    newDDICProject = wsp.getRoot().getProject(this.getProjectName(compType));
                } else {
                    newDDICProject = wsp.getRoot().getProject(projectName + EMPTY_DICT_PROJECT_SUFFIX);
                }
                desc = wsp.newProjectDescription(newDDICProject.getName());
                Path projectDictRootPath = null;
                if (this.page.isDCProject()) {
                    desc.setLocation(dcPath.append(this.getDCName(compType, false)).append("_comp"));
                    projectDictRootPath = dcPath.append(this.getDCName(compType, false)).append("_comp");
                } else {
                    projectDictRootPath = new Path(path);
                    projectDictRootPath = projectDictRootPath.append(newDDICProject.getName());
                    this.createDir(projectDictRootPath.toString());
                    if (!this.page.isUseDefaults()) {
                        desc.setLocation((IPath)projectDictRootPath);
                    }
                }
                prevNatures = desc.getNatureIds();
                newNatures = new String[prevNatures.length + 3];
                System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
                newNatures[0] = DDICNATURE_ID;
                newNatures[1] = JAVANATURE_ID;
                newNatures[2] = PATTERNNATURE_ID;
                desc.setNatureIds(newNatures);
                ICommand[] buildSpec = new ICommand[4];
                buildSpec[0] = desc.newCommand();
                buildSpec[0].setBuilderName("com.sap.dictionary.tools.generation.GenerationBuilder");
                buildSpec[1] = desc.newCommand();
                buildSpec[1].setBuilderName("org.eclipse.jdt.core.javabuilder");
                buildSpec[2] = desc.newCommand();
                buildSpec[2].setBuilderName("com.sap.ide.ws.wsbuilder");
                buildSpec[3] = desc.newCommand();
                buildSpec[3].setBuilderName("com.tssap.selena.cmf.PatternBuilder");
                desc.setBuildSpec(buildSpec);
                newDDICProject.create(desc, monitor);
                if (!newDDICProject.isOpen()) {
                    try {
                        newDDICProject.open(monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                }
                dtrMonitor.setMonitorResource((IResource)newDDICProject, false, -1);
                this.createDir(projectDictRootPath.append("bin").toString());
                this.createDir(projectDictRootPath.append("gen_ddic").append("datatypes").toString());
                this.createDir(projectDictRootPath.append("gen_ddic").append("dbtables").toString());
                this.createDir(projectDictRootPath.append("Model Folder").toString());
                this.createDir(projectDictRootPath.append("src").append("packages").toString());
                IJavaProject javaProject2 = JavaCore.create((IProject)newDDICProject);
                if (javaProject2.exists() && !javaProject2.isOpen()) {
                    javaProject2.open(null);
                }
                IClasspathEntry[] classpathEntryArray3 = new IClasspathEntry[4];
                binPath = newDDICProject.getLocation().append("src");
                IContainer binContainer5 = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(binPath);
                if (binContainer5 instanceof IFolder) {
                    try {
                        if (!binContainer5.exists()) {
                            ((IFolder)binContainer5).create(true, true, monitor);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                binPath = newDDICProject.getLocation().append("src").append("packages");
                IContainer binContainer2 = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(binPath);
                if (binContainer2 instanceof IFolder) {
                    try {
                        if (!binContainer2.exists()) {
                            ((IFolder)binContainer2).create(true, true, monitor);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                classpathEntryArray3[0] = classpathEntry0 = JavaCore.newSourceEntry((IPath)binContainer2.getFullPath());
                binPath = newDDICProject.getLocation().append("gen_ddic");
                IContainer binContainer6 = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(binPath);
                if (binContainer6 instanceof IFolder) {
                    try {
                        if (!binContainer6.exists()) {
                            ((IFolder)binContainer6).create(true, true, monitor);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                binPath = newDDICProject.getLocation().append("gen_ddic").append("datatypes");
                binContainer2 = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(binPath);
                if (binContainer2 instanceof IFolder) {
                    try {
                        if (!binContainer2.exists()) {
                            ((IFolder)binContainer2).create(true, true, monitor);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                classpathEntryArray3[1] = classpathEntry1 = JavaCore.newSourceEntry((IPath)binContainer2.getFullPath());
                binPath = newDDICProject.getLocation().append("gen_ddic").append("dbtables");
                binContainer2 = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(binPath);
                if (binContainer2 instanceof IFolder) {
                    try {
                        if (!binContainer2.exists()) {
                            ((IFolder)binContainer2).create(true, true, monitor);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                classpathEntryArray3[2] = classpathEntry2 = JavaCore.newSourceEntry((IPath)binContainer2.getFullPath());
                classpathEntryArray3[3] = jreSrcEntryDict = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
                javaProject2.setRawClasspath(classpathEntryArray3, monitor);
                if (this.page.isDCProject()) {
                    compType.setType("Dictionary Object");
                    compType.setSubType(null);
                    newDDICProject = wsp.getRoot().getProject(this.getProjectName(compType));
                    desc = newDDICProject.getDescription();
                    prevNatures = desc.getNatureIds();
                    newNatures = new String[prevNatures.length + 1];
                    System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
                    newNatures[prevNatures.length] = UMENATURE;
                    desc.setNatureIds(newNatures);
                    newDDICProject.setDescription(desc, monitor);
                    this.createDC(newDDICProject, "/dictionary", monitor);
                }
                try {
                    newDDICProject.refreshLocal(2, monitor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                monitor.worked(50);
                compType.setType(METADATA_PROJECT_TYPE);
                if (this.page.isDCProject()) {
                    this.createDir(dcPath.append(this.getDCName(compType, false)).append("_comp").toOSString());
                    newMetadataProject = wsp.getRoot().getProject(this.getProjectName(compType));
                } else {
                    newMetadataProject = wsp.getRoot().getProject(projectName);
                }
                desc = wsp.newProjectDescription(newMetadataProject.getName());
                if (!this.page.isUseDefaults()) {
                    Path projectRootPath = new Path(path);
                    projectRootPath = projectRootPath.append(newMetadataProject.getName());
                    this.createDir(projectRootPath.toString());
                    desc.setLocation((IPath)projectRootPath);
                }
                if (this.page.isDCProject()) {
                    desc.setLocation(dcPath.append(this.getDCName(compType, false)).append("_comp"));
                }
                String[] prevNatures1 = desc.getNatureIds();
                String[] newNatures1 = new String[prevNatures1.length + 1];
                System.arraycopy(prevNatures1, 0, newNatures1, 0, prevNatures1.length);
                newNatures1[prevNatures1.length] = CAFNATURE_ID;
                desc.setNatureIds(newNatures1);
                if (this.page.isDCProject()) {
                    prevNatures1 = desc.getNatureIds();
                    newNatures1 = new String[prevNatures1.length + 1];
                    System.arraycopy(prevNatures1, 0, newNatures1, 0, prevNatures1.length);
                    newNatures1[prevNatures1.length] = UMENATURE;
                    desc.setNatureIds(newNatures1);
                }
                newMetadataProject.create(desc, monitor);
                this.storeCfgProp(newMetadataProject);
                try {
                    newMetadataProject.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (!newMetadataProject.isOpen()) {
                    try {
                        newMetadataProject.open(monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                }
                dtrMonitor.setMonitorResource((IResource)newMetadataProject, false, -1);
                monitor.worked(55);
                if (this.page.isDCProject()) {
                    this.createDC(newMetadataProject, "/metadata", monitor);
                }
                try {
                    newMetadataProject.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                monitor.setTaskName(mTextPool.getText("BOM_PROJECTWZRD_START_MONITOR_TASK", new String[]{projectName}));
                if (this.page.isDCProject()) {
                    compType.setType(WDP_PROJECT_TYPE);
                    this.createDir(dcPath.append(this.getDCName(compType, false)).append("_comp").toOSString());
                    newWDProject = wsp.getRoot().getProject(this.getProjectName(compType));
                } else {
                    newWDProject = wsp.getRoot().getProject(projectName + WDP_PROJECT_SUFFIX);
                }
                desc = wsp.newProjectDescription(newWDProject.getName());
                Path projectWDPRootPath = null;
                if (this.page.isDCProject()) {
                    desc.setLocation(dcPath.append(this.getDCName(compType, false)).append("_comp"));
                    projectWDPRootPath = dcPath.append(this.getDCName(compType, false)).append("_comp");
                } else {
                    projectWDPRootPath = new Path(path);
                    projectWDPRootPath = projectWDPRootPath.append(newWDProject.getName());
                    this.createDir(projectWDPRootPath.toString());
                    if (!this.page.isUseDefaults()) {
                        desc.setLocation((IPath)projectWDPRootPath);
                    }
                }
                newWDProject.create(desc, monitor);
                if (!newWDProject.isOpen()) {
                    try {
                        newWDProject.open(monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                }
                dtrMonitor.setMonitorResource((IResource)newWDProject, false, -1);
                Path wdpWrkSpc = projectWDPRootPath;
                this.createDir(wdpWrkSpc.append("bin").toString());
                this.createDir(wdpWrkSpc.append("gen_ddic").append("datatypes").toString());
                this.createDir(wdpWrkSpc.append("gen_wdp").append("configuration").toString());
                this.createDir(wdpWrkSpc.append("gen_wdp").append("packages").toString());
                this.createDir(wdpWrkSpc.append("lib").toString());
                this.createDir(wdpWrkSpc.append("META-INF").toString());
                this.createDir(wdpWrkSpc.append("Model Folder").toString());
                this.createDir(wdpWrkSpc.append("src").append("configuration").append("Applications").toString());
                this.createDir(wdpWrkSpc.append("src").append("configuration").append("ComponentInterfaces").toString());
                this.createDir(wdpWrkSpc.append("src").append("configuration").append("Components").toString());
                this.createDir(wdpWrkSpc.append("src").append("mimes").append("Applications").toString());
                this.createDir(wdpWrkSpc.append("src").append("mimes").append("ComponentInterfaces").toString());
                this.createDir(wdpWrkSpc.append("src").append("mimes").append("Components").toString());
                this.createDir(wdpWrkSpc.append("src").append("packages").toString());
                desc = newWDProject.getDescription();
                prevNatures = desc.getNatureIds();
                newNatures = new String[prevNatures.length + 4];
                System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
                newNatures[0] = WDPNATURE;
                newNatures[1] = DDICNATURE_ID;
                newNatures[2] = JAVANATURE_ID;
                newNatures[3] = PATTERNNATURE_ID;
                desc.setNatureIds(newNatures);
                if (this.page.isDCProject()) {
                    prevNatures = desc.getNatureIds();
                    newNatures = new String[prevNatures.length + 1];
                    System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
                    newNatures[prevNatures.length] = UMENATURE;
                    desc.setNatureIds(newNatures);
                }
                newWDProject.setDescription(desc, monitor);
                this.storeCfgProp(newWDProject);
                try {
                    newWDProject.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (this.page.isDCProject()) {
                    this.createDC(newWDProject, "/webdynpro", monitor);
                }
                if (!newWDProject.isOpen()) {
                    try {
                        newWDProject.open(monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                }
                monitor.worked(30);
                IJavaProject javaProject3 = JavaCore.create((IProject)newWDProject);
                if (javaProject3.exists() && !javaProject3.isOpen()) {
                    javaProject3.open(null);
                }
                IPath wdpBinPath = newWDProject.getLocation().append("src").append("packages");
                IContainer wdpBinContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(wdpBinPath);
                if (wdpBinContainer instanceof IFolder) {
                    try {
                        if (!wdpBinContainer.exists()) {
                            ((IFolder)wdpBinContainer).create(true, true, monitor);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                IClasspathEntry wdpClasspathEntry = JavaCore.newSourceEntry((IPath)wdpBinContainer.getFullPath());
                IClasspathEntry[] wdpClasspathEntryArray = javaProject3.getRawClasspath();
                IClasspathEntry[] wdpClasspathEntryArray2 = new IClasspathEntry[wdpClasspathEntryArray.length + 3];
                int i2 = 0;
                while (i2 < wdpClasspathEntryArray.length) {
                    wdpClasspathEntryArray2[i2] = wdpClasspathEntryArray[i2].getEntryKind() == 3 ? wdpClasspathEntry : wdpClasspathEntryArray[i2];
                    ++i2;
                }
                wdpBinPath = newWDProject.getLocation().append("gen_ddic").append("datatypes");
                wdpBinContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(wdpBinPath);
                if (wdpBinContainer instanceof IFolder) {
                    try {
                        if (!wdpBinContainer.exists()) {
                            ((IFolder)wdpBinContainer).create(true, true, monitor);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                wdpClasspathEntryArray2[wdpClasspathEntryArray.length] = wdpClasspathEntry = JavaCore.newSourceEntry((IPath)wdpBinContainer.getFullPath());
                wdpBinPath = newWDProject.getLocation().append("gen_wdp").append("packages");
                wdpBinContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(wdpBinPath);
                if (wdpBinContainer instanceof IFolder) {
                    try {
                        if (!wdpBinContainer.exists()) {
                            ((IFolder)wdpBinContainer).create(true, true, monitor);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                wdpClasspathEntryArray2[wdpClasspathEntryArray.length + 1] = wdpClasspathEntry = JavaCore.newSourceEntry((IPath)wdpBinContainer.getFullPath());
                wdpClasspathEntryArray2[wdpClasspathEntryArray.length + 2] = jreSrcEntry;
                javaProject3.setRawClasspath(wdpClasspathEntryArray2, monitor);
                this.createSharingReferenceObjectForWebdynproProject(newWDProject, monitor);
                monitor.worked(30);
                monitor.setTaskName(mTextPool.getText("BOM_PROJECTWZRD_START_MONITOR_TASK", new String[]{projectName}));
                if (this.page.isDCProject()) {
                    compType.setType(UME_PROJECT_TYPE);
                    compType.setSubType(UME_PROJECT_SUBTYPE);
                    this.createDir(dcPath.append(this.getDCName(compType, false)).append("_comp").toOSString());
                    newUMEProject = wsp.getRoot().getProject(this.getProjectName(compType));
                } else {
                    newUMEProject = wsp.getRoot().getProject(projectName + UME_PROJECT_SUFFIX);
                }
                desc = wsp.newProjectDescription(newUMEProject.getName());
                Path projectUMERootPath = null;
                if (this.page.isDCProject()) {
                    desc.setLocation(dcPath.append(this.getDCName(compType, false)).append("_comp"));
                    projectUMERootPath = dcPath.append(this.getDCName(compType, false)).append("_comp");
                } else {
                    projectUMERootPath = new Path(path);
                    projectUMERootPath = projectUMERootPath.append(newUMEProject.getName());
                    this.createDir(projectUMERootPath.toString());
                    if (!this.page.isUseDefaults()) {
                        desc.setLocation((IPath)projectUMERootPath);
                    }
                }
                newUMEProject.create(desc, monitor);
                if (!newUMEProject.isOpen()) {
                    try {
                        newUMEProject.open(monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                }
                dtrMonitor.setMonitorResource((IResource)newUMEProject, false, -1);
                Path umeWrkSpc = projectUMERootPath;
                this.createDir(umeWrkSpc.append("src").toString());
                desc = newUMEProject.getDescription();
                if (this.page.isDCProject()) {
                    prevNatures = desc.getNatureIds();
                    newNatures = new String[prevNatures.length + 1];
                    System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
                    newNatures[prevNatures.length] = UMENATURE;
                    desc.setNatureIds(newNatures);
                }
                newUMEProject.setDescription(desc, monitor);
                this.storeCfgProp(newUMEProject);
                try {
                    newUMEProject.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (this.page.isDCProject()) {
                    this.createDC(newUMEProject, "/permissions", monitor);
                }
                if (!newUMEProject.isOpen()) {
                    try {
                        newUMEProject.open(monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                }
                monitor.worked(30);
                monitor.setTaskName(mTextPool.getText("BOM_PROJECTWZRD_0001") + " " + projectName + " Enterprise Application ...");
                if (this.page.isDCProject()) {
                    compType.setType(null);
                    compType.setSubType(ENTERPRISE_APPLICATION_SUBTYPE);
                    this.createDir(dcPath.append(this.getDCName(compType, false)).append("_comp").toOSString());
                    newEnterpriseProject = wsp.getRoot().getProject(this.getProjectName(compType));
                    desc = wsp.newProjectDescription(newEnterpriseProject.getName());
                    desc.setLocation(dcPath.append(this.getDCName(compType, false)).append("_comp"));
                } else {
                    newEnterpriseProject = wsp.getRoot().getProject(projectName + EMPTY_EAR_PROJECT_SUFFIX);
                    desc = wsp.newProjectDescription(newEnterpriseProject.getName());
                    if (!this.page.isUseDefaults()) {
                        Path projectRootPath = new Path(path);
                        projectRootPath = projectRootPath.append(newEnterpriseProject.getName());
                        this.createDir(projectRootPath.toString());
                        desc.setLocation((IPath)projectRootPath);
                    }
                }
                prevNatures1 = desc.getNatureIds();
                newNatures1 = new String[prevNatures1.length + 1];
                System.arraycopy(prevNatures1, 0, newNatures1, 0, prevNatures1.length);
                newNatures1[prevNatures1.length] = EARNATURE_ID;
                desc.setNatureIds(newNatures1);
                if (this.page.isDCProject()) {
                    ComponentType compType3 = new ComponentType();
                    compType3.setSubType("EJBModule Object");
                    desc.setReferencedProjects(new IProject[]{wsp.getRoot().getProject(this.getProjectName(compType3))});
                } else {
                    desc.setReferencedProjects(new IProject[]{wsp.getRoot().getProject(projectName + EMPTY_EJB_PROJECT_SUFFIX)});
                }
                newEnterpriseProject.create(desc, monitor);
                try {
                    newEnterpriseProject.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (!newEnterpriseProject.isOpen()) {
                    try {
                        newEnterpriseProject.open(monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                }
                dtrMonitor.setMonitorResource((IResource)newEnterpriseProject, false, -1);
                monitor.worked(55);
                IFolder metaFolder = newEnterpriseProject.getFolder("META-INF");
                metaFolder.create(true, true, monitor);
                IEarProject earProject = J2eeProjectManager.getEarProject((String)newEnterpriseProject.getName());
                if (earProject != null) {
                    earProject.createDescriptor();
                    String name = "";
                    if (this.page.isDCProject()) {
                        ComponentType tempCompType = new ComponentType();
                        tempCompType.setSubType(ENTERPRISE_APPLICATION_SUBTYPE);
                        name = this.getDCName(tempCompType, false);
                    } else {
                        name = newEnterpriseProject.getName();
                    }
                    IDisplayName displayName = earProject.getDescriptor().getDisplayName();
                    if (displayName == null) {
                        displayName = earProject.getDescriptor().createDisplayName(null);
                    }
                    displayName.setValue(name);
                }
                earProject = J2eeProjectManager.getEarProject((String)newEnterpriseProject.getName());
                IJ2eeProject ejbProject1 = null;
                if (this.page.isDCProject()) {
                    ComponentType compType7 = new ComponentType();
                    compType7.setSubType("EJBModule Object");
                    ejbProject1 = J2eeProjectManager.getJ2eeProject((String)this.getProjectName(compType7));
                } else {
                    ejbProject1 = J2eeProjectManager.getJ2eeProject((String)(projectName + EMPTY_EJB_PROJECT_SUFFIX));
                }
                earProject.setModule(ejbProject1);
                IDescriptorFactory[] allFactories = UIPlugin.getExternalDescriptors();
                int i3 = 0;
                while (i3 < allFactories.length) {
                    allFactories[i3].createDescriptor((IJ2eeProject)earProject);
                    ++i3;
                }
                if (this.page.isDCProject()) {
                    this.createDC(newEnterpriseProject, "/ear", monitor);
                }
                String SRC = JavaCore.getClasspathVariable((String)"ECLIPSE_HOME") + "/plugins/" + BomPlugin.getDefault().getDescriptor().getUniqueIdentifier() + "/templates/application-j2ee-engine.xml.initial";
                String PROJECT_SRC = metaFolder.getLocation().toOSString() + "/application-j2ee-engine.xml";
                this.copyFile(SRC, PROJECT_SRC);
                try {
                    newEnterpriseProject.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (packageName != null) {
                    packageName = packageName.toLowerCase();
                }
                this.bos = BOMSystem.createBOMSystem(projectName, appName, packageName);
                this.bos.reloadRelatedProjects();
                try {
                    wsp.getRoot().getProject(projectName).refreshLocal(2, monitor);
                    MetamodelProvider.setDirty(projectName, false);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                monitor.worked(60);
                monitor.done();
                try {
                    String ddPath = newDDICProject.getLocation().toOSString();
                    String ejbPath = newEJBProject.getLocation().toOSString();
                    String entPath = newEnterpriseProject.getLocation().toOSString();
                    String metPath = newMetadataProject.getLocation().toOSString();
                    String umePath = newUMEProject.getLocation().toOSString();
                    String wdPath = newWDProject.getLocation().toOSString();
                    String rootPath = this.getRoot(entPath);
                    this.getAllFiles(new File(ddPath), "DICT", rootPath);
                    this.getAllFiles(new File(ejbPath), "EJB", rootPath);
                    this.getAllFiles(new File(entPath), "ENTERPRISE_APPLICATION", rootPath);
                    this.getAllFiles(new File(metPath), "MMR", rootPath);
                    this.getAllFiles(new File(umePath), "UME_PROJECT", rootPath);
                    this.getAllFiles(new File(wdPath), "WDP_PROJECT", rootPath);
                }
                catch (Exception e) {
                    logger.errorT("An error occured while creating local project with name:" + appName + ".The error is: " + e.getMessage());
                    e.printStackTrace();
                }
                try {
                    DCController dCController = ((com.sap.ide.eclipse.component.wizard.ProjectWizard)this.startWizard).getDCController();
                    if (!dCController.isForLocalDevelopment()) {
                        this.bos.getResourceChangeListener().setHasPopUp(false);
                        this.bos.getResourceChangeListener().notifyResourceModifications(this.generatedFiles, null, null);
                        this.bos.getResourceChangeListener().finalizeModifications();
                        break block148;
                    }
                    if (!DtrService.isLocalConfiguration(newEJBProject)) {
                        this.bos.getDTRReplicatorList().addToList(this.fullPathOfCreatedFiles);
                    }
                    this.bos.getResourceChangeListener().setHasPopUp(true);
                }
                catch (Exception e) {
                    logger.errorT("An error occured while creating remote project with name:" + appName + ".The error is: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            catch (Exception ex) {
                throw new CAFBaseException(ex);
            }
        }
    }

    private String filePathReplacer(String filePath, String rootPath) {
        filePath = filePath.replace('\\', '/');
        if ((filePath = StringUtils.replaceAll(filePath, rootPath, "")).indexOf("_comp") != -1) {
            filePath = filePath.substring(filePath.indexOf("_comp") + 5);
        }
        return filePath;
    }

    private void updateClasspath(IProject newProject) throws CAFBaseException {
        try {
            IDCExtendedProject dcPrj = (IDCExtendedProject)newProject.getNature(UMENATURE);
            DCWizardUtil.updateModel((IProject)newProject, (IDevelopmentConfiguration)dcPrj.getConfiguration());
        }
        catch (Exception ex) {
            throw new CAFBaseException(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

