/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.BomPlugin;
import com.sap.caf.designer.Logger;
import com.sap.caf.designer.StatusLineMessage;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.dtr.DtrService;
import com.sap.caf.designer.exception.CAFEclipseCoreException;
import com.sap.caf.designer.exception.CAFInvocationTargetException;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.views.ModelTreeViewer;
import com.sap.caf.designer.wizards.ProjectDeleteWizardPage1;
import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ProjectDeleteWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$wizards$ProjectDeleteWizard == null ? (class$com$sap$caf$designer$wizards$ProjectDeleteWizard = ProjectDeleteWizard.class$("com.sap.caf.designer.wizards.ProjectDeleteWizard")) : class$com$sap$caf$designer$wizards$ProjectDeleteWizard);
    private ProjectDeleteWizardPage1 page;
    private ISelection selection;
    private String projectName;
    static /* synthetic */ Class class$com$sap$caf$designer$wizards$ProjectDeleteWizard;

    public ProjectDeleteWizard(Element element, String projectName) {
        this.projectName = projectName;
        this.setDefaultPageImageDescriptor(SapIdeUtilImages.getImageDescriptorFromIconsDirectory((IPluginDescriptor)BomPlugin.getDefault().getDescriptor(), (String)"wzBannerCompApplication.gif"));
        this.setWindowTitle(mTextPool.getText("BOM_BONAVIGATOR_0002"));
        this.setNeedsProgressMonitor(true);
    }

    public String[] getSelProjects() {
        return this.page.getSelProjects();
    }

    public void addPages() {
        this.page = new ProjectDeleteWizardPage1(this.selection, this.projectName);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setForcePreviousAndNextButtons(false);
    }

    public boolean performFinish() {
        final String[] projectName = this.getSelProjects();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws CAFInvocationTargetException {
                try {
                    try {
                        ProjectDeleteWizard.this.doFinish(projectName, monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                    Object var5_2 = null;
                }
                catch (Throwable throwable) {
                    Object var5_3 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)TextPool.getInstance().getText("BOM_ALL_0020"), (String)e.getMessage());
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)TextPool.getInstance().getText("BOM_ALL_0020"), (String)realException.getMessage());
            return false;
        }
        ModelTreeViewer.deepRefreshInstances();
        ModelTreeViewer.refreshInstances();
        return true;
    }

    private static boolean deleteDirectory(File directory) {
        boolean result = false;
        try {
            if (directory != null && directory.isDirectory()) {
                File[] files = directory.listFiles();
                int i = 0;
                while (i < files.length) {
                    File currentFile = files[i];
                    result = currentFile.isFile() ? currentFile.delete() : ProjectDeleteWizard.deleteDirectory(currentFile);
                    if (!result) {
                        return result;
                    }
                    ++i;
                }
            }
            if (directory != null) {
                result = directory.delete();
            }
        }
        catch (SecurityException se) {
            logger.errorT("Error: " + se.getMessage());
            se.printStackTrace();
        }
        catch (Exception e) {
            logger.errorT("Error: " + e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    private void doFinish(String[] projectName, IProgressMonitor monitor) throws CAFEclipseCoreException, InvocationTargetException {
        int numberOfProjects = projectName.length;
        try {
            int i = 0;
            while (i < numberOfProjects) {
                String appDir;
                String ejbModuleDir;
                String metadataDir;
                File f;
                int workCounter = 0;
                String projectNameApp = projectName[i];
                String projectPostfix = projectNameApp.substring(projectNameApp.lastIndexOf(126) + 1);
                String projectPrefix = projectNameApp.substring(0, projectNameApp.lastIndexOf(126));
                monitor.beginTask(mTextPool.getText("BOM_ALL_0005") + projectName[i], 4);
                String projectNameMetaData = projectPrefix + "~" + "metadata" + "~" + projectPostfix;
                String projectNameEjbModule = projectPrefix + "~" + "ejbmodule" + "~" + projectPostfix;
                String projectNameDictionary = projectPrefix + "~" + "dictionary" + "~" + projectPostfix;
                String projectNameWebdynpro = projectPrefix + "~" + "webdynpro" + "~" + projectPostfix;
                String projectNamePermissions = projectPrefix + "~" + "permissions" + "~" + projectPostfix;
                String projectNameApplication = projectNameApp;
                MetamodelProvider.unRegisterMetamodelProvider(projectNameMetaData);
                BOMSystem.deleteProject(projectNameApplication);
                BOMSystem bs = BOMSystem.getBOMSystem(projectNameMetaData);
                if (projectName[i] != null && bs != null) {
                    bs.notifyCAFObjectChanged(null, 40);
                }
                monitor.setTaskName(mTextPool.getText("BOM_PROJECTWZRD_0002") + " " + projectNameWebdynpro + "...");
                monitor.worked(workCounter++);
                IWorkspace wsp = ResourcesPlugin.getWorkspace();
                IProject wdpProject = wsp.getRoot().getProject(projectNameWebdynpro);
                IDevelopmentComponentNode dcWdpNode = ComponentUtil.getDCNode((IProject)wdpProject);
                monitor.setTaskName(mTextPool.getText("BOM_PROJECTWZRD_0002") + " " + projectNamePermissions + "...");
                monitor.worked(workCounter++);
                wsp = ResourcesPlugin.getWorkspace();
                IProject permProject = wsp.getRoot().getProject(projectNamePermissions);
                IDevelopmentComponentNode dcPermNode = ComponentUtil.getDCNode((IProject)permProject);
                monitor.worked(workCounter++);
                monitor.setTaskName(mTextPool.getText("BOM_PROJECTWZRD_0002") + " " + projectNameEjbModule + "EJB...");
                IProject ejbProject = wsp.getRoot().getProject(projectNameEjbModule);
                IDevelopmentComponentNode dcEjbNode = ComponentUtil.getDCNode((IProject)ejbProject);
                monitor.worked(workCounter++);
                monitor.setTaskName(mTextPool.getText("BOM_PROJECTWZRD_0002") + " " + projectNameDictionary + "Dict...");
                IProject dictProject = wsp.getRoot().getProject(projectNameDictionary);
                IDevelopmentComponentNode dcDictNode = ComponentUtil.getDCNode((IProject)dictProject);
                monitor.worked(workCounter++);
                monitor.setTaskName(mTextPool.getText("BOM_PROJECTWZRD_0002") + " " + projectNameApplication + "Assembly...");
                IProject appProject = wsp.getRoot().getProject(projectNameApplication);
                IDevelopmentComponentNode dcAppNode = ComponentUtil.getDCNode((IProject)appProject);
                monitor.setTaskName(mTextPool.getText("BOM_PROJECTWZRD_0002") + " " + projectNameMetaData + "...");
                monitor.worked(workCounter++);
                wsp = ResourcesPlugin.getWorkspace();
                IProject metaProject = wsp.getRoot().getProject(projectNameMetaData);
                IDevelopmentComponentNode dcMetaNode = ComponentUtil.getDCNode((IProject)metaProject);
                if (!DtrService.isLocalConfiguration(metaProject)) {
                    if (dcMetaNode != null && dcMetaNode.getDCProxy().isAnythingCheckedOut() || dcAppNode != null && dcAppNode.getDCProxy().isAnythingCheckedOut() || dcDictNode != null && dcDictNode.getDCProxy().isAnythingCheckedOut() || dcEjbNode != null && dcEjbNode.getDCProxy().isAnythingCheckedOut() || dcPermNode != null && dcPermNode.getDCProxy().isAnythingCheckedOut() || dcWdpNode != null && dcWdpNode.getDCProxy().isAnythingCheckedOut()) {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        MessageDialog.openInformation((Shell)window.getShell(), (String)mTextPool.getText("DTR_INFO_DELETE_PROJECT_TITLE"), (String)mTextPool.getText("DTR_INFO_DELETE_PROJECT"));
                        return;
                    }
                } else {
                    if (dcMetaNode != null && dcMetaNode.getDCProxy() != null) {
                        dcMetaNode.getDCProxy().removeLocalDC(true);
                    }
                    if (dcAppNode != null && dcAppNode.getDCProxy() != null) {
                        dcAppNode.getDCProxy().removeLocalDC(true);
                    }
                    if (dcDictNode != null && dcDictNode.getDCProxy() != null) {
                        dcDictNode.getDCProxy().removeLocalDC(true);
                    }
                    if (dcEjbNode != null && dcEjbNode.getDCProxy() != null) {
                        dcEjbNode.getDCProxy().removeLocalDC(true);
                    }
                    if (dcPermNode != null && dcPermNode.getDCProxy() != null) {
                        dcPermNode.getDCProxy().removeLocalDC(true);
                    }
                    if (dcWdpNode != null && dcWdpNode.getDCProxy() != null) {
                        dcWdpNode.getDCProxy().removeLocalDC(true);
                    }
                }
                if (metaProject.exists()) {
                    metaProject.delete(true, true, monitor);
                }
                if (wdpProject.exists()) {
                    wdpProject.delete(true, true, monitor);
                }
                if (permProject.exists()) {
                    permProject.delete(true, true, monitor);
                }
                if ((f = new File(metadataDir = dcPermNode.getDefinitionPath().substring(0, dcPermNode.getDefinitionPath().indexOf("_comp") - 1))).exists()) {
                    ProjectDeleteWizard.deleteDirectory(f);
                }
                bs.deleteSystem();
                if (ejbProject.exists()) {
                    ejbProject.delete(true, true, monitor);
                }
                if ((f = new File(ejbModuleDir = dcEjbNode.getDefinitionPath().substring(0, dcEjbNode.getDefinitionPath().indexOf("_comp") - 1))).exists()) {
                    ProjectDeleteWizard.deleteDirectory(f);
                }
                if (dictProject.exists()) {
                    dictProject.delete(true, true, monitor);
                }
                String dictDir = dcDictNode.getDefinitionPath().substring(0, dcDictNode.getDefinitionPath().indexOf("_comp") - 1);
                ProjectDeleteWizard.deleteDirectory(new File(dictDir));
                if (appProject.exists()) {
                    appProject.delete(true, true, monitor);
                }
                if ((f = new File(appDir = dcAppNode.getDefinitionPath().substring(0, dcAppNode.getDefinitionPath().indexOf("_comp") - 1))).exists()) {
                    ProjectDeleteWizard.deleteDirectory(f);
                }
                StatusLineMessage slm = new StatusLineMessage();
                slm.printMessage(mTextPool.getText("BOM_PROJECT_0001") + " " + projectName[i] + " " + mTextPool.getText("BOM_ALL_0010") + ".");
                monitor.worked(workCounter++);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        monitor.done();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

