/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.BomPlugin;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.ApplicationInterfaceEditor;
import com.sap.caf.designer.exception.CAFEclipseCoreException;
import com.sap.caf.designer.exception.CAFInvocationTargetException;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFApplicationInterface;
import com.sap.caf.designer.structure.util.DefaultValues;
import com.sap.caf.designer.utils.EntityNamesStringUtil;
import com.sap.caf.designer.wizards.OperationWizardPage01;
import com.sap.caf.designer.wizards.OperationWizardPage02;
import com.sap.caf.designer.wizards.OperationWizardPage03;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.FaultMessage;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.metamodel.Permission;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class OperationWizard
extends Wizard
implements INewWizard {
    public static int PATTERN_TYPE_CUSTOM = 0;
    public static int PATTERN_TYPE_CREATE = 1;
    public static int PATTERN_TYPE_READ = 2;
    public static int PATTERN_TYPE_UPDATE = 3;
    public static int PATTERN_TYPE_DELETE = 4;
    public static int PATTERN_TYPE_FINDBY = 5;
    public static int PATTERN_TYPE_BWEXTRACTOR = 8;
    public static String PERMISSION_EXCEPRION_NAME = "sap.com/caf.core/CAFPermissionException";
    public static final String BW_EXTRACTOR_PARAMETER_NAME = "RECORDTYPE";
    public static final String BW_EXTRACTOR_PARAMETER_TYPE = "com.sap.caf.base.integer";
    private static final TextPool mTextPool = TextPool.getInstance();
    private OperationWizardPage01 operationsWizardPage01;
    private OperationWizardPage02 operationsWizardPage02;
    private OperationWizardPage03 operationsWizardPage03;
    private String projName;
    private String objName;
    private Operation m_operation;
    private CAFApplicationInterface mCAFApInf;
    private BOMSystem mbomsystem;
    private ApplicationInterfaceEditor editor;

    public OperationWizard() {
        this.setDefaultPageImageDescriptor(SapIdeUtilImages.getImageDescriptorFromIconsDirectory((IPluginDescriptor)BomPlugin.getDefault().getDescriptor(), (String)"wzBannerCompApplication.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public OperationWizard(ApplicationInterfaceEditor editor, CAFApplicationInterface cafApplInt, Operation operation) {
        this();
        this.projName = cafApplInt.getBomSystem().getProjectName();
        this.objName = cafApplInt.getApplicationInterface().getObjectName();
        this.m_operation = operation;
        this.mCAFApInf = cafApplInt;
        this.mbomsystem = cafApplInt.getBomSystem();
        this.editor = editor;
        if (this.m_operation == null) {
            this.setWindowTitle(TextPool.getInstance().getText("ASI_OPERWZRD_00000"));
        } else {
            this.setWindowTitle(TextPool.getInstance().getText("ASI_OPERWZRD_00001"));
        }
        OperationWizard.checkAndRepareOperation(operation, this.mbomsystem);
    }

    public static void checkAndRepareOperation(Operation operation, BOMSystem bomsystem) {
        if (operation != null && operation.getPatternType() != null && operation.getPatternType() == PATTERN_TYPE_FINDBY) {
            List attributesList;
            boolean mustRepairOperation = false;
            ArrayList<Attribute> oldAttributesList = new ArrayList<Attribute>();
            Message message = operation.getInput();
            if (message != null && (attributesList = message.getMessageParts()) != null) {
                Iterator iAttributes = attributesList.iterator();
                while (iAttributes.hasNext()) {
                    Attribute currentAttribute = (Attribute)iAttributes.next();
                    if (currentAttribute == null || currentAttribute.getReferencedObject() != null) continue;
                    oldAttributesList.add(currentAttribute);
                    if (currentAttribute.getReferencedObject() == null) continue;
                    mustRepairOperation = true;
                }
            }
            if (mustRepairOperation) {
                OperationWizard.setFiltersForDataFields(message, oldAttributesList, bomsystem);
                MetamodelProvider.setDirtyOn(bomsystem.getProjectName());
            }
        }
    }

    public List getAllASOperations() {
        return this.mCAFApInf.getApplicationInterface().getOperations();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage result = null;
        String pageName = page.getName();
        if (pageName.equals("OperationWizardPage01")) {
            result = this.getPage("OperationWizardPage02");
        }
        if (pageName.equals("OperationWizardPage02") && this.operationsWizardPage01 != null && this.operationsWizardPage01.needPage3()) {
            result = this.getPage("OperationWizardPage03");
        }
        return result;
    }

    public void addPages() {
        if (this.operationsWizardPage01 == null) {
            this.operationsWizardPage01 = new OperationWizardPage01(this.mCAFApInf, this.m_operation);
        }
        this.addPage((IWizardPage)this.operationsWizardPage01);
        if (this.operationsWizardPage02 == null) {
            this.operationsWizardPage02 = new OperationWizardPage02(this.mCAFApInf, this.m_operation);
        }
        this.addPage((IWizardPage)this.operationsWizardPage02);
        if (this.operationsWizardPage03 == null) {
            this.operationsWizardPage03 = new OperationWizardPage03(this.mCAFApInf, this.m_operation);
        }
        this.addPage((IWizardPage)this.operationsWizardPage03);
    }

    public boolean canFinish() {
        return this.operationsWizardPage01.isPageComplete() && this.operationsWizardPage02.isPageComplete() && (this.operationsWizardPage03 != null && this.operationsWizardPage03.isPageComplete() || this.operationsWizardPage03 == null);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws CAFInvocationTargetException {
                try {
                    try {
                        OperationWizard.this.doFinish(monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)TextPool.getInstance().getText("BOM_ALL_0020"), (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void setDataFields(Message message) {
        message.getMessageParts().clear();
        Iterator iteratorSelectedFields = this.operationsWizardPage03.getSelectAttributes().iterator();
        while (iteratorSelectedFields.hasNext()) {
            Attribute selectedAttribute = (Attribute)iteratorSelectedFields.next();
            Attribute a = this.mCAFApInf.getBomSystem().getMetamodelPackage().getAttribute().createAttribute();
            a.setObjectId(a.refMofId());
            a.setObjectName(selectedAttribute.getObjectName());
            a.setReferencedObject(selectedAttribute.getReferencedObject());
            a.setMinOccurs(selectedAttribute.getMinOccurs());
            a.setMaxOccurs(selectedAttribute.getMaxOccurs());
            a.setTypeJavaDdic(selectedAttribute.getTypeJavaDdic());
            a.setListType(selectedAttribute.getListType());
            message.getMessageParts().add(a);
        }
    }

    private static void setFiltersForDataFields(Message message, List selectedFieldsCollection, BOMSystem bomsystem) {
        if (message != null && message.getMessageParts() != null) {
            message.getMessageParts().clear();
            Iterator iteratorSelectedFields = selectedFieldsCollection.iterator();
            while (iteratorSelectedFields.hasNext()) {
                Attribute selectedAttribute = (Attribute)iteratorSelectedFields.next();
                Attribute a = OperationWizard.createAttribute(selectedAttribute.getObjectName(), bomsystem);
                a.setObjectId(a.refMofId());
                DataStructure ds = bomsystem.getMetamodelPackage().getDataStructure().createDataStructure();
                DefaultValues.setDefaults(ds, DefaultValues.ENTITY_INTERFACE_OPERATION_INPUT_DATA_STRUCTURE);
                a.setReferencedObject(ds);
                Attribute attrOperation = OperationWizard.createAttribute("option", bomsystem);
                attrOperation.setTypeJavaDdic("com.sap.caf.base.string");
                Attribute attrMinValue = OperationWizard.createAttribute("minValue", bomsystem);
                attrMinValue.setTypeJavaDdic("com.sap.caf.base.string");
                Attribute attrMaxValue = OperationWizard.createAttribute("maxValue", bomsystem);
                attrMaxValue.setTypeJavaDdic("com.sap.caf.base.string");
                ds.getAttributes().add(attrOperation);
                ds.getAttributes().add(attrMinValue);
                ds.getAttributes().add(attrMaxValue);
                message.getMessageParts().add(a);
            }
        }
    }

    public static Attribute createAttribute(String name, BOMSystem bomSystem) {
        Attribute attr = bomSystem.getMetamodelPackage().getAttribute().createAttribute();
        DefaultValues.setDefaults(attr, DefaultValues.DEFAULT_ATTRIBUTE);
        attr.setObjectName(name);
        attr.setShortText(name);
        attr.setListType(new Integer(1));
        return attr;
    }

    private void setDataStructure(Message message, boolean isOutput) {
        String name = "dS0";
        if (isOutput) {
            name = "Result";
        }
        DataStructure dataObject = this.operationsWizardPage02.getDataStructureSelected();
        if (!this.hasNamedAttribute(message.getMessageParts(), name)) {
            Attribute targetAttribute = this.mCAFApInf.getBomSystem().getMetamodelPackage().getAttribute().createAttribute();
            targetAttribute.setObjectId(targetAttribute.refMofId());
            targetAttribute.setObjectName(name);
            targetAttribute.setReferencedObject(dataObject);
            targetAttribute.setMinOccurs(new Integer(0));
            targetAttribute.setMaxOccurs(new Integer(1));
            targetAttribute.setListType(new Integer(2));
            message.getMessageParts().add(targetAttribute);
        } else {
            Iterator attIterator = message.getMessageParts().iterator();
            while (attIterator.hasNext()) {
                Attribute attribute = (Attribute)attIterator.next();
                if (!attribute.getObjectName().equalsIgnoreCase(name)) continue;
                attribute.setReferencedObject(dataObject);
                attribute.setMinOccurs(new Integer(0));
                attribute.setMaxOccurs(new Integer(1));
                attribute.setListType(new Integer(2));
            }
        }
    }

    private void setFault(Operation operation, String faultName) {
        boolean exist = false;
        FaultMessage fault = null;
        fault = faultName.indexOf("caf.core") < 0 ? (FaultMessage)this.mCAFApInf.getBomSystem().getApplicationFaultMessages().get(EntityNamesStringUtil.restoreCoreFaultPackages2(faultName)) : (FaultMessage)this.mCAFApInf.getBomSystem().getCoreFaults().get(EntityNamesStringUtil.restoreCoreFaultPackages2(faultName));
        Iterator faultsIterator = operation.getFault().iterator();
        while (faultsIterator.hasNext()) {
            FaultMessage currMessage = (FaultMessage)faultsIterator.next();
            if (!currMessage.getObjectName().equals(fault.getObjectName())) continue;
            exist = true;
        }
        if (!exist) {
            operation.getFault().add(fault);
        }
    }

    private FaultMessage containsFault(Operation currentOperation, String faultName) {
        if (currentOperation.getFault() != null && !currentOperation.getFault().isEmpty()) {
            Iterator iter = currentOperation.getFault().iterator();
            while (iter.hasNext()) {
                FaultMessage fm = (FaultMessage)iter.next();
                if (!fm.getObjectName().equals(faultName)) continue;
                return fm;
            }
        }
        return null;
    }

    private Operation createOneOperation(boolean hasInput, boolean hasOutput) {
        Operation newOperation = this.mCAFApInf.getBomSystem().getMetamodelPackage().getOperation().createOperation();
        newOperation.setObjectId(newOperation.refMofId());
        Permission newPermition = this.mCAFApInf.getBomSystem().getMetamodelPackage().getPermission().createPermission();
        newOperation.setPermission(newPermition);
        if (hasInput) {
            Message inmesg = this.mCAFApInf.getBomSystem().getMetamodelPackage().getMessage().createMessage();
            inmesg.setObjectId(inmesg.refMofId());
            newOperation.setInput(inmesg);
        }
        if (hasOutput) {
            Message outmesg = this.mCAFApInf.getBomSystem().getMetamodelPackage().getMessage().createMessage();
            outmesg.setObjectId(outmesg.refMofId());
            newOperation.setOutput(outmesg);
        }
        return newOperation;
    }

    private void doFinish(IProgressMonitor monitor) throws CAFEclipseCoreException {
        monitor.beginTask(mTextPool.getText("BOM_ALL_0005") + "...", 4);
        monitor.worked(1);
        try {
            boolean custom = this.operationsWizardPage01.getCustom();
            boolean extractor = this.operationsWizardPage01.getExtractor();
            boolean access = this.operationsWizardPage01.getAccess();
            boolean read = this.operationsWizardPage01.getAccessRead();
            boolean create = this.operationsWizardPage01.getAccessCreate();
            boolean update = this.operationsWizardPage01.getAccessUpdate();
            boolean delete = this.operationsWizardPage01.getAccessDelete();
            boolean findby = this.operationsWizardPage01.getFindBy();
            boolean isNewOperation = false;
            DataStructure dataObject = this.operationsWizardPage02.getDataStructureSelected();
            if (custom) {
                if (this.m_operation == null) {
                    this.m_operation = this.createOneOperation(false, false);
                    isNewOperation = true;
                }
                this.m_operation.setObjectName(this.operationsWizardPage02.getOperationName());
                this.m_operation.setLongText(this.operationsWizardPage02.getOperationDescription());
                this.m_operation.setTransactionType(this.operationsWizardPage02.getOperationTransactionType());
                this.m_operation.setPatternType(new Integer(PATTERN_TYPE_CUSTOM));
                this.m_operation.getPermission().setImplicitCheck(this.operationsWizardPage02.getOperationPermissionCheck());
                this.updatePermissionFaultmessage();
                if (isNewOperation) {
                    this.mCAFApInf.getApplicationInterface().getOperations().add(this.m_operation);
                }
                this.editor.refreshOperations(this.m_operation);
                this.editor.getOperationPage().refreshParameterTree();
                this.editor.setDirty(true);
            } else if (extractor) {
                if (this.m_operation == null) {
                    this.m_operation = this.createOneOperation(true, true);
                    isNewOperation = true;
                }
                this.m_operation.setObjectName(this.operationsWizardPage02.getOperationName());
                this.m_operation.setLongText(this.operationsWizardPage02.getOperationDescription());
                this.m_operation.setTransactionType(new Integer(4));
                this.m_operation.getPermission().setImplicitCheck(this.operationsWizardPage02.getOperationPermissionCheck());
                this.m_operation.setPatternType(new Integer(PATTERN_TYPE_BWEXTRACTOR));
                this.updatePermissionFaultmessage();
                Attribute atr = OperationWizard.createAttribute("*", this.mbomsystem);
                atr.setTypeJavaDdic("*");
                this.m_operation.getInput().getMessageParts().clear();
                this.m_operation.getInput().getMessageParts().add(atr);
                Attribute output = null;
                if (isNewOperation) {
                    output = this.mCAFApInf.getBomSystem().getMetamodelPackage().getAttribute().createAttribute();
                    output.setObjectId(output.refMofId());
                    output.setObjectName("Result");
                    output.setMinOccurs(new Integer(0));
                    output.setListType(new Integer(1));
                    output.setMaxOccurs(new Integer(-1));
                    this.m_operation.getOutput().getMessageParts().add(output);
                } else {
                    output = (Attribute)this.m_operation.getOutput().getMessageParts().get(0);
                }
                output.setReferencedObject(dataObject);
                this.setFault(this.m_operation, "CAFFindException(caf.core)");
                this.setFault(this.m_operation, "ServiceException(caf.core)");
                if (isNewOperation) {
                    this.mCAFApInf.getApplicationInterface().getOperations().add(this.m_operation);
                }
                this.editor.refreshOperations(this.m_operation);
                this.editor.getOperationPage().refreshParameterTree();
                this.editor.setDirty(true);
            } else if (findby) {
                if (this.m_operation == null) {
                    this.m_operation = this.createOneOperation(true, true);
                    isNewOperation = true;
                }
                this.m_operation.setObjectName(this.operationsWizardPage02.getOperationName());
                this.m_operation.setLongText(this.operationsWizardPage02.getOperationDescription());
                this.m_operation.setTransactionType(new Integer(4));
                this.m_operation.getPermission().setImplicitCheck(this.operationsWizardPage02.getOperationPermissionCheck());
                this.m_operation.setPatternType(new Integer(PATTERN_TYPE_FINDBY));
                this.updatePermissionFaultmessage();
                OperationWizard.setFiltersForDataFields(this.m_operation.getInput(), this.operationsWizardPage03.getSelectAttributes(), this.mbomsystem);
                Attribute output = null;
                if (isNewOperation) {
                    output = this.mCAFApInf.getBomSystem().getMetamodelPackage().getAttribute().createAttribute();
                    output.setObjectId(output.refMofId());
                    output.setObjectName("Result");
                    output.setMinOccurs(new Integer(0));
                    output.setListType(new Integer(1));
                    output.setMaxOccurs(new Integer(-1));
                    this.m_operation.getOutput().getMessageParts().add(output);
                } else {
                    output = (Attribute)this.m_operation.getOutput().getMessageParts().get(0);
                }
                output.setReferencedObject(dataObject);
                this.setFault(this.m_operation, "CAFFindException(caf.core)");
                if (isNewOperation) {
                    this.mCAFApInf.getApplicationInterface().getOperations().add(this.m_operation);
                }
                this.editor.refreshOperations(this.m_operation);
                this.editor.getOperationPage().refreshParameterTree();
                this.editor.setDirty(true);
            } else if (access) {
                String dataStructureName = "";
                if (dataObject != null) {
                    dataStructureName = dataObject.getObjectName();
                }
                String generalDescription = "";
                if (this.m_operation == null) {
                    generalDescription = mTextPool.getText("ASI_OPERATION_WIZARD_GENERAL_DESCRIPTION") + ":";
                }
                if (create) {
                    if (this.m_operation == null) {
                        this.m_operation = this.createOneOperation(true, true);
                        isNewOperation = true;
                    }
                    this.m_operation.setObjectName("create" + dataStructureName);
                    this.m_operation.setLongText((!generalDescription.equals("") ? "create:" : "") + generalDescription + this.operationsWizardPage02.getOperationDescription());
                    this.m_operation.setTransactionType(new Integer(0));
                    this.m_operation.getPermission().setImplicitCheck(this.operationsWizardPage02.getOperationPermissionCheck());
                    this.m_operation.setPatternType(new Integer(PATTERN_TYPE_CREATE));
                    this.updatePermissionFaultmessage();
                    this.setDataStructure(this.m_operation.getInput(), false);
                    this.setDataFields(this.m_operation.getInput());
                    this.setDataStructure(this.m_operation.getOutput(), true);
                    this.setFault(this.m_operation, "CAFCreateException(caf.core)");
                    if (isNewOperation) {
                        this.mCAFApInf.getApplicationInterface().getOperations().add(this.m_operation);
                    }
                    this.editor.refreshOperations(this.m_operation);
                    this.editor.getOperationPage().refreshParameterTree();
                    this.editor.setDirty(true);
                    if (isNewOperation) {
                        this.m_operation = null;
                    }
                }
                if (read) {
                    if (this.m_operation == null) {
                        this.m_operation = this.createOneOperation(true, true);
                        isNewOperation = true;
                    }
                    this.m_operation.setObjectName("read" + dataStructureName);
                    this.m_operation.setLongText((!generalDescription.equals("") ? "read:" : "") + generalDescription + this.operationsWizardPage02.getOperationDescription());
                    this.m_operation.setTransactionType(new Integer(4));
                    this.m_operation.getPermission().setImplicitCheck(this.operationsWizardPage02.getOperationPermissionCheck());
                    this.m_operation.setPatternType(new Integer(PATTERN_TYPE_READ));
                    if (isNewOperation) {
                        Attribute input = this.mCAFApInf.getBomSystem().getMetamodelPackage().getAttribute().createAttribute();
                        input.setObjectId(input.refMofId());
                        input.setObjectName("key");
                        input.setMinOccurs(new Integer(0));
                        input.setListType(new Integer(2));
                        input.setMaxOccurs(new Integer(1));
                        input.setTypeJavaDdic("com.sap.caf.core.id");
                        this.m_operation.getInput().getMessageParts().add(input);
                    }
                    this.setDataStructure(this.m_operation.getOutput(), true);
                    this.setFault(this.m_operation, "CAFRetrieveException(caf.core)");
                    this.updatePermissionFaultmessage();
                    if (isNewOperation) {
                        this.mCAFApInf.getApplicationInterface().getOperations().add(this.m_operation);
                    }
                    this.editor.refreshOperations(this.m_operation);
                    this.editor.getOperationPage().refreshParameterTree();
                    this.editor.setDirty(true);
                    if (isNewOperation) {
                        this.m_operation = null;
                    }
                }
                if (update) {
                    if (this.m_operation == null) {
                        this.m_operation = this.createOneOperation(true, false);
                        isNewOperation = true;
                    }
                    this.m_operation.setObjectName("update" + dataStructureName);
                    this.m_operation.setLongText((!generalDescription.equals("") ? "update:" : "") + generalDescription + this.operationsWizardPage02.getOperationDescription());
                    this.m_operation.setTransactionType(new Integer(0));
                    this.m_operation.getPermission().setImplicitCheck(this.operationsWizardPage02.getOperationPermissionCheck());
                    this.m_operation.setPatternType(new Integer(PATTERN_TYPE_UPDATE));
                    this.updatePermissionFaultmessage();
                    this.setDataStructure(this.m_operation.getInput(), false);
                    this.setFault(this.m_operation, "CAFUpdateException(caf.core)");
                    if (isNewOperation) {
                        this.mCAFApInf.getApplicationInterface().getOperations().add(this.m_operation);
                    }
                    this.editor.refreshOperations(this.m_operation);
                    this.editor.getOperationPage().refreshParameterTree();
                    this.editor.setDirty(true);
                    if (isNewOperation) {
                        this.m_operation = null;
                    }
                }
                if (delete) {
                    if (this.m_operation == null) {
                        this.m_operation = this.createOneOperation(true, false);
                        isNewOperation = true;
                    }
                    this.m_operation.setObjectName("delete" + dataStructureName);
                    this.m_operation.setLongText((!generalDescription.equals("") ? "delete:" : "") + generalDescription + this.operationsWizardPage02.getOperationDescription());
                    this.m_operation.setTransactionType(new Integer(0));
                    this.m_operation.getPermission().setImplicitCheck(this.operationsWizardPage02.getOperationPermissionCheck());
                    this.m_operation.setPatternType(new Integer(PATTERN_TYPE_DELETE));
                    this.updatePermissionFaultmessage();
                    this.setDataStructure(this.m_operation.getInput(), false);
                    this.setFault(this.m_operation, "CAFDeleteException(caf.core)");
                    if (isNewOperation) {
                        this.mCAFApInf.getApplicationInterface().getOperations().add(this.m_operation);
                    }
                    this.editor.refreshOperations(this.m_operation);
                    this.editor.getOperationPage().refreshParameterTree();
                    this.editor.setDirty(true);
                    if (isNewOperation) {
                        this.m_operation = null;
                    }
                }
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    private boolean hasNamedAttribute(List messageParts, String attributeName) {
        boolean result = false;
        Iterator iteratorParts = messageParts.iterator();
        while (iteratorParts.hasNext()) {
            Attribute attribute = (Attribute)iteratorParts.next();
            if (attribute.getObjectName() == null || !attribute.getObjectName().equalsIgnoreCase(attributeName)) continue;
            result = true;
        }
        return result;
    }

    private void updatePermissionFaultmessage() {
        if (this.m_operation.getPermission().getImplicitCheck() == 1) {
            if (this.containsFault(this.m_operation, PERMISSION_EXCEPRION_NAME) == null) {
                this.m_operation.getFault().add(this.mCAFApInf.getBomSystem().getCoreFaults().get(PERMISSION_EXCEPRION_NAME));
            }
        } else {
            FaultMessage pfm = null;
            pfm = this.containsFault(this.m_operation, PERMISSION_EXCEPRION_NAME);
            if (pfm != null) {
                this.m_operation.getFault().remove(pfm);
            }
        }
    }
}

