/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditor;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.tc.logging.Location;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import com.tssap.util.ui.viewer.table.SapTableViewer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MethodWizardPage3
extends WizardPage {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Object[] tabColumnNames = new Object[]{mTextPool.getText("BOM_METHODWZRD_0014"), mTextPool.getText("BOM_METHODWZRD_0005")};
    private static final int ATTRIBUTE_IS_PARAMETR_COLUMN = 0;
    private static final int ATTRIBUTE_NAME_COLUMN = 1;
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$designer$wizards$MethodWizardPage3 == null ? (class$com$sap$caf$designer$wizards$MethodWizardPage3 = MethodWizardPage3.class$("com.sap.caf.designer.wizards.MethodWizardPage3")) : class$com$sap$caf$designer$wizards$MethodWizardPage3));
    private DefaultTableModel tableData;
    private ISapTableViewer attributeList;
    private List attributes;
    private int mappingCount;
    private Operation method = null;
    private BusinessEntityInterfaceEditor editor;
    static /* synthetic */ Class class$com$sap$caf$designer$wizards$MethodWizardPage3;

    public MethodWizardPage3(BusinessEntityInterfaceEditor be, String methodName) {
        super("wizardPage");
        this.editor = be;
        this.setTitle(mTextPool.getText("BOM_METHODWZRD_0044"));
        this.setDescription(mTextPool.getText("BOM_METHODWZRD_0040"));
        this.method = be.getCAFBusinessEntityInterface().getOperationByName(methodName);
        this.attributes = be.getCAFBusinessEntityInterface().readCurrentAttributes();
        this.mappingCount = 0;
        this.setPageComplete(false);
    }

    public MethodWizardPage3(List attributes) {
        super("wizardPage");
        this.setTitle(mTextPool.getText("BOM_METHODWZRD_0044"));
        this.setDescription(mTextPool.getText("BOM_METHODWZRD_0040"));
        this.attributes = attributes;
        this.mappingCount = 0;
        this.setPageComplete(false);
    }

    public MethodWizardPage3(String methodName, List attributes) {
        super("wizardPage");
        this.setTitle(mTextPool.getText("BOM_METHODWZRD_0044"));
        this.setDescription(mTextPool.getText("BOM_METHODWZRD_0040"));
        this.attributes = attributes;
        this.mappingCount = 0;
        this.setPageComplete(false);
    }

    public List getSelectAttributes() {
        ArrayList<String> selectedAttributes = new ArrayList<String>(this.attributes.size());
        int rowCount = this.tableData.getRowCount();
        int i = 0;
        while (i < rowCount) {
            Boolean check = (Boolean)this.tableData.getValueAt(i, 0);
            if (check.booleanValue()) {
                selectedAttributes.add((String)this.tableData.getValueAt(i, 1));
            }
            ++i;
        }
        return selectedAttributes;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        this.tableData = new DefaultTableModel(new Object[0][0], tabColumnNames){

            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }
        };
        this.tableData.addTableModelListener(new AttributeTableModelListener());
        this.attributeList = SapTableViewer.createTableViewer((Composite)container, (TableModel)this.tableData);
        this.attributeList.setBooleanColumnHandler(0);
        this.attributeList.getTable().getColumn(0).setWidth(50);
        this.attributeList.getTable().getColumn(0).setAlignment(0x1000000);
        this.attributeList.getTable().getColumn(1).setWidth(250);
        Label label = new Label(container, 0);
        label.setText("");
        this.initialize();
        this.setControl((Control)container);
    }

    private void setMappingCount(Boolean value) {
        this.mappingCount = value.booleanValue() ? ++this.mappingCount : --this.mappingCount;
        this.setPageComplete(this.mappingCount > 0);
    }

    private void initialize() {
        if (this.attributes != null) {
            Iterator i = this.attributes.iterator();
            while (i.hasNext()) {
                Attribute attr = (Attribute)i.next();
                if (!CAFBusinessEntityInterface.isSimpleAttribute(attr) && !this.editor.getCAFBusinessEntityInterface().isKeyAttribute(attr) || attr.getObjectName().equals("key")) continue;
                Object[] newRow = new Object[]{Boolean.FALSE, attr.getObjectName()};
                this.tableData.addRow(newRow);
            }
        }
        if (this.method != null) {
            int rowCount = this.tableData.getRowCount();
            Message msg = this.method.getInput();
            ArrayList parameters = null;
            parameters = msg != null ? msg.getMessageParts() : new ArrayList();
            int i = 0;
            while (i < rowCount) {
                String attributeName = (String)this.tableData.getValueAt(i, 1);
                Iterator j = parameters.iterator();
                while (j.hasNext()) {
                    Attribute param = (Attribute)j.next();
                    if (!param.getObjectName().equals(attributeName)) continue;
                    this.tableData.setValueAt(Boolean.TRUE, i, 0);
                    break;
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AttributeTableModelListener
    implements TableModelListener {
        private AttributeTableModelListener() {
        }

        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0) {
                if (MethodWizardPage3.this.getSelectAttributes().size() > 0) {
                    MethodWizardPage3.this.setPageComplete(true);
                } else {
                    MethodWizardPage3.this.setPageComplete(false);
                }
            }
        }
    }
}

