/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditor;
import com.sap.caf.designer.generation.utils.GenerationUtilsDt;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.metamodel.Operation;
import com.sap.dictionary.tools.tableeditor.service.SimpletypeSelection;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.tc.logging.Location;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class MethodWizardPage2
extends WizardPage {
    private Text methodNameText;
    private Text parameterNameText;
    private Text returnType;
    private Button arrayCheckBox;
    private Button button;
    private Button addParameterButton;
    private Button removeParameterButton;
    private List parameterList;
    private BOMSystem bos;
    private Operation method;
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$designer$wizards$MethodWizardPage2 == null ? (class$com$sap$caf$designer$wizards$MethodWizardPage2 = MethodWizardPage2.class$("com.sap.caf.designer.wizards.MethodWizardPage2")) : class$com$sap$caf$designer$wizards$MethodWizardPage2));
    static /* synthetic */ Class class$com$sap$caf$designer$wizards$MethodWizardPage2;

    public MethodWizardPage2(BOMSystem bos) {
        super("wizardPage");
        this.setTitle(mTextPool.getText("BOM_METHODWZRD_0043"));
        this.setDescription(mTextPool.getText("BOM_METHODWZRD_0039"));
        this.bos = bos;
    }

    public MethodWizardPage2(BusinessEntityInterfaceEditor be, String methodName) {
        super("wizardPage");
        this.setTitle(mTextPool.getText("BOM_METHODWZRD_0043"));
        this.setDescription(mTextPool.getText("BOM_METHODWZRD_0039"));
        this.bos = be.getBOMSystem();
    }

    public String[] getParameterList() {
        return this.parameterList.getItems();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(mTextPool.getText("BOM_METHODWZRD_0023"));
        this.parameterNameText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.parameterNameText.setLayoutData((Object)gd);
        this.parameterNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MethodWizardPage2.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText(mTextPool.getText("BOM_METHODWZRD_0008"));
        this.returnType = new Text(container, 2060);
        gd = new GridData(768);
        this.returnType.setLayoutData((Object)gd);
        this.returnType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MethodWizardPage2.this.dialogChanged();
            }
        });
        this.button = new Button(container, 8);
        this.button.setText(mTextPool.getText("BOM_ALL_0002"));
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodWizardPage2.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("");
        gd = new GridData(768);
        this.arrayCheckBox = new Button(container, 32);
        this.arrayCheckBox.setLayoutData((Object)gd);
        this.arrayCheckBox.setText(mTextPool.getText("BOM_METHODWZRD_0006"));
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText(mTextPool.getText("BOM_METHODWZRD_0024"));
        this.parameterList = new List(container, 2050);
        gd = new GridData(1808);
        this.parameterList.setLayoutData((Object)gd);
        Composite buttonContainer = new Composite(container, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonContainer.setLayout((Layout)buttonLayout);
        buttonLayout.numColumns = 1;
        buttonLayout.verticalSpacing = 2;
        this.addParameterButton = new Button(buttonContainer, 8);
        this.addParameterButton.setText(mTextPool.getText("BOM_ALL_0001"));
        this.addParameterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodWizardPage2.this.addParameter();
            }
        });
        this.addParameterButton.setEnabled(false);
        this.removeParameterButton = new Button(buttonContainer, 8);
        this.removeParameterButton.setText(mTextPool.getText("BOM_ALL_0006"));
        this.removeParameterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodWizardPage2.this.deleteParameter();
            }
        });
        this.removeParameterButton.setEnabled(false);
        this.removeParameterButton.setVisible(false);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.method != null) {
            this.makeParameterList();
        }
    }

    private void handleBrowse() {
        DtDictionaryRoot mDtDictionaryRoot = this.bos.getAppDdicRoot();
        SimpletypeSelection selection = mDtDictionaryRoot != null ? new SimpletypeSelection(mDtDictionaryRoot, Display.getDefault().getActiveShell()) : new SimpletypeSelection(new DtDictionaryRoot[0], Display.getDefault().getActiveShell());
        if (selection.open()) {
            String pack = selection.getSimpleType().getPackage();
            String st = selection.getSimpleType().getName();
            this.returnType.setText(pack + "." + st);
        }
    }

    private void addParameter() {
        String paramText = this.parameterNameText.getText();
        String returnText = this.returnType.getText();
        if (this.arrayCheckBox.getSelection()) {
            paramText = paramText + "[]";
        }
        this.parameterList.add(paramText + " (" + returnText + ")");
        this.setDefaultParameterNameText();
        this.setReturnTypeText2Default();
        this.arrayCheckBox.setSelection(false);
    }

    private void deleteParameter() {
    }

    private void setDefaultParameterNameText() {
        this.parameterNameText.setText("");
    }

    private void setReturnTypeText2Default() {
        this.returnType.setText("");
    }

    private void dialogChanged() {
        String paramText = this.parameterNameText.getText();
        String returnText = this.returnType.getText();
        if (paramText.length() == 0) {
            this.updateStatus(mTextPool.getText("BOM_METHODWZRD_0026"));
            this.addParameterButton.setEnabled(false);
            return;
        }
        if (!GenerationUtilsDt.isValidIdentifier(paramText)) {
            this.updateStatus(mTextPool.getText("BOM_METHODWZRD_0025"));
            return;
        }
        if (returnText.length() == 0 || returnText.equals("void")) {
            this.updateStatus(mTextPool.getText("BOM_METHODWZRD_0009"));
            this.addParameterButton.setEnabled(false);
            return;
        }
        if (paramText.length() != 0 && returnText.length() != 0) {
            this.addParameterButton.setEnabled(true);
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
    }

    public IWizardPage getNextPage() {
        return null;
    }

    private void makeParameterList() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

