/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditor;
import com.sap.caf.designer.generation.utils.GenerationUtilsDt;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.wizards.MethodWizard;
import com.sap.caf.designer.wizards.MethodWizardPage2;
import com.sap.caf.designer.wizards.MethodWizardPage3;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.tools.velocity.utils.NamingRestrictions;
import com.sap.dictionary.tools.tableeditor.service.SimpletypeSelection;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.tc.logging.Location;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class MethodWizardPage1
extends WizardPage {
    private static final String COLLECTION_NAME = "collection";
    private static final String FIND_BEGIN_NAME = "findBy";
    private Text methodNameText;
    private Text methodDescriptionText;
    private Text permissionNameText;
    private Combo methodTypeCombo;
    private Combo accessModifierCombo;
    private Combo transactionTypeCombo;
    private Text returnType;
    private Button button;
    private Button arrayCheckBox;
    private String objectType;
    private boolean fieldSelected = false;
    private BOMSystem bos;
    private Operation method = null;
    private BusinessEntityInterfaceEditor beie;
    private String methodName;
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$designer$wizards$MethodWizardPage1 == null ? (class$com$sap$caf$designer$wizards$MethodWizardPage1 = MethodWizardPage1.class$("com.sap.caf.designer.wizards.MethodWizardPage1")) : class$com$sap$caf$designer$wizards$MethodWizardPage1));
    private static final Object[] tabColumnNames = new Object[]{mTextPool.getText("BOM_METHODWZRD_0014"), mTextPool.getText("BOM_METHODWZRD_0005")};
    private static final int ATTRIBUTE_IS_PARAMETR_COLUMN = 0;
    private static final int ATTRIBUTE_NAME_COLUMN = 1;
    private DefaultTableModel tableData;
    private ISapTableViewer attributeList;
    private List attributes;
    private int mappingCount;
    private Operation operation = null;
    static /* synthetic */ Class class$com$sap$caf$designer$wizards$MethodWizardPage1;

    public MethodWizardPage1(BOMSystem bos) {
        super("wizardPage");
        this.setTitle(mTextPool.getText("BOM_METHODWZRD_0052"));
        this.bos = bos;
        this.objectType = "BO";
    }

    public MethodWizardPage1(BusinessEntityInterfaceEditor be, String methodName) {
        super("wizardPage");
        this.setTitle(mTextPool.getText("BOM_METHODWZRD_0052"));
        this.beie = be;
        this.methodName = methodName;
        this.bos = be.getBOMSystem();
        this.method = be.getCAFBusinessEntityInterface().getOperationByName(methodName);
        this.objectType = "BO";
        this.operation = this.beie.getCAFBusinessEntityInterface().getOperationByName(methodName);
        this.attributes = this.beie.getCAFBusinessEntityInterface().readCurrentAttributes();
    }

    public void createControl(Composite parent) {
        ISashPane mainSashPane = PaneFactory.createVerticalSashPane((Composite)parent);
        IGridLayoutPane topPane = mainSashPane.addGridLayoutPane(5, false);
        Label label = null;
        label = topPane.addTextLabel(mTextPool.getText("BOM_METHODWZRD_0018", true), topPane.createGridLayoutData(4, 4, 1, 1));
        this.methodNameText = topPane.addTextField("", topPane.createGridLayoutData(4, 4, 3, 1));
        this.methodNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MethodWizardPage1.this.dialogChanged(MethodWizardPage1.this.objectType);
            }
        });
        topPane.addPlaceholder();
        label = topPane.addTextLabel(mTextPool.getText("BOM_METHODWZRD_0011", true), topPane.createGridLayoutData(4, 4, 1, 1));
        this.methodDescriptionText = topPane.addTextField("", topPane.createGridLayoutData(4, 4, 3, 1));
        this.methodDescriptionText.setTextLimit(60);
        this.methodDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MethodWizardPage1.this.dialogChanged(MethodWizardPage1.this.objectType);
            }
        });
        this.methodDescriptionText.setEnabled(true);
        topPane.addPlaceholder();
        IGridLayoutPane tablePane = mainSashPane.addGridLayoutPane(5, false);
        this.createOperationDetailsControl(tablePane);
        IGridLayoutPane hiddenPane = topPane;
        if (this.objectType.equals("BO")) {
            this.methodTypeCombo = hiddenPane.addComboBox(MethodWizard.method_names);
            this.methodTypeCombo.select(0);
        } else if (this.objectType.equals("SO")) {
            this.methodTypeCombo = hiddenPane.addComboBox(new String[]{mTextPool.getText("BOM_METHODWZRD_0035")});
            this.methodTypeCombo.setEnabled(false);
            this.methodTypeCombo.select(0);
        }
        this.methodTypeCombo.setVisible(false);
        this.accessModifierCombo = hiddenPane.addComboBox(new String[]{mTextPool.getText("BOM_METHODWZRD_0028"), mTextPool.getText("BOM_METHODWZRD_0030")});
        this.accessModifierCombo.setText("");
        this.accessModifierCombo.setVisible(false);
        this.returnType = hiddenPane.addTextField("void");
        this.returnType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MethodWizardPage1.this.dialogChanged(MethodWizardPage1.this.objectType);
            }
        });
        this.button = hiddenPane.addPushButton(mTextPool.getText("BOM_ALL_0002"));
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodWizardPage1.this.handleBrowse();
            }
        });
        if (this.objectType.equals("SO")) {
            this.transactionTypeCombo = hiddenPane.addComboBox(new String[]{mTextPool.getText("BOM_METHODWZRD_0048"), mTextPool.getText("BOM_METHODWZRD_0049"), mTextPool.getText("BOM_METHODWZRD_0051"), mTextPool.getText("BOM_METHODWZRD_0050"), mTextPool.getText("BOM_METHODWZRD_0046"), mTextPool.getText("BOM_METHODWZRD_0047")});
            this.transactionTypeCombo.setEnabled(false);
            this.permissionNameText = hiddenPane.addTextField("");
            this.permissionNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MethodWizardPage1.this.dialogChanged(MethodWizardPage1.this.objectType);
                }
            });
        }
        this.arrayCheckBox = hiddenPane.addCheckBox(mTextPool.getText("BOM_METHODWZRD_0006"));
        this.arrayCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MethodWizardPage1.this.arrayCheckBox.getSelection()) {
                    MethodWizardPage1.this.button.setEnabled(false);
                    MethodWizardPage1.this.returnType.setText(MethodWizardPage1.COLLECTION_NAME);
                } else {
                    MethodWizardPage1.this.button.setEnabled(true);
                    MethodWizardPage1.this.returnType.setText("void");
                }
            }
        });
        this.initialize();
        this.initializeOperationDetailsControl();
        this.dialogChanged(this.objectType);
        this.setControl((Control)parent);
    }

    private void initialize() {
        if (null == this.method) {
            this.setDescription(mTextPool.getText("BOM_METHODWZRD_0037"));
            this.accessModifierCombo.select(1);
            this.accessModifierCombo.setVisible(false);
        } else {
            this.setTitle(mTextPool.getText("BOM_METHODWZRD_0042"));
            this.setDescription(mTextPool.getText("BOM_METHODWZRD_0038"));
            this.methodNameText.setText(this.method.getObjectName());
            this.methodDescriptionText.setText(this.method.getShortText() == null ? "" : this.method.getShortText());
            this.methodTypeCombo.setEnabled(false);
            this.methodTypeCombo.setVisible(false);
            this.methodNameText.setEnabled(false);
        }
        this.methodNameText.setEnabled(true);
        this.methodDescriptionText.setEnabled(true);
        this.accessModifierCombo.select(1);
        this.accessModifierCombo.setEnabled(false);
        this.accessModifierCombo.setVisible(false);
        this.returnType.setText(COLLECTION_NAME);
        this.returnType.setEnabled(false);
        this.returnType.setVisible(false);
        this.button.setEnabled(false);
        this.button.setVisible(false);
        this.arrayCheckBox.setSelection(true);
        this.arrayCheckBox.setEnabled(false);
        this.arrayCheckBox.setVisible(false);
    }

    private void handleBrowse() {
        DtDictionaryRoot mDtDictionaryRoot = this.bos.getAppDdicRoot();
        SimpletypeSelection selection = mDtDictionaryRoot != null ? new SimpletypeSelection(mDtDictionaryRoot, Display.getDefault().getActiveShell()) : new SimpletypeSelection(new DtDictionaryRoot[0], Display.getDefault().getActiveShell());
        if (selection.open()) {
            String pack = selection.getSimpleType().getPackage();
            String st = selection.getSimpleType().getName();
            this.returnType.setText(pack + "." + st);
        }
    }

    private void dialogChanged(String objectType) {
        String methodNameText = this.getMethodNameText();
        String methodDescriptionText = this.getMethodDescriptionText();
        int methodType = this.getMethodType();
        Operation oper = this.beie.getCAFBusinessEntityInterface().getOperationByName(methodNameText);
        if (oper != null && !methodNameText.equals(this.methodName)) {
            this.updateStatus("Duplicate operation name...");
            return;
        }
        if (methodNameText.length() == 0) {
            this.updateStatus(mTextPool.getText("BOM_METHODWZRD_0022"));
            return;
        }
        if (!(methodType != 1 && methodType != 0 || GenerationUtilsDt.isValidIdentifier(methodNameText) && NamingRestrictions.isValidMemberName(methodNameText.trim()))) {
            this.updateStatus(mTextPool.getText("BOM_METHODWZRD_0021"));
            return;
        }
        if (methodDescriptionText.length() == 0) {
            this.updateStatus(mTextPool.getText("BOM_METHODWZRD_0012"));
            return;
        }
        if (this.returnType.getText().length() == 0) {
            this.updateStatus(mTextPool.getText("BOM_METHODWZRD_0034"));
            return;
        }
        if (objectType.equals("VO") && this.permissionNameText.getText().length() == 0) {
            this.updateStatus(mTextPool.getText("BOM_METHODWZRD_0027"));
            return;
        }
        if (!MethodWizard.knowMethodType(methodType)) {
            this.updateStatus(mTextPool.getText("BOM_METHODWZRD_0020"));
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        if (this.methodNameText.getText().equals("")) {
            this.setMessage(mTextPool.getText("BOM_METHODWZRD_0053"));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getMethodNameText() {
        if (this.methodNameText != null) {
            return this.methodNameText.getText();
        }
        return "";
    }

    public String getMethodDescriptionText() {
        return this.methodDescriptionText.getText();
    }

    public String getMethodReturnType() {
        return this.returnType.getText();
    }

    public int getMethodType() {
        return MethodWizard.method_types[this.methodTypeCombo.getSelectionIndex()];
    }

    public int getMethodSelectedIndex() {
        return this.methodTypeCombo.getSelectionIndex();
    }

    public int getVisibility() {
        return this.accessModifierCombo.getSelectionIndex();
    }

    public boolean isArray() {
        return this.arrayCheckBox.getSelection();
    }

    private boolean isValidMethodType() {
        return MethodWizard.knowMethodType(MethodWizard.method_types[this.methodTypeCombo.getSelectionIndex()]);
    }

    public IWizardPage getNextPage() {
        int methodType = this.getMethodType();
        if (methodType == 1) {
            MethodWizardPage2 page = ((MethodWizard)this.getWizard()).methodWizardPage2;
            return page;
        }
        if (methodType == 0) {
            MethodWizardPage3 page = ((MethodWizard)this.getWizard()).methodWizardPage3;
            return page;
        }
        if (methodType == 3) {
            return null;
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        String methodNameText = this.getMethodNameText();
        String methodDescriptionText = this.getMethodDescriptionText();
        if (this.getErrorMessage() != null) {
            return false;
        }
        if (methodNameText.length() != 0 & methodDescriptionText.length() != 0 & this.isValidMethodType()) {
            return !methodNameText.equals("findByIndex") && !methodNameText.equals("findByMultipleParameters");
        }
        return false;
    }

    public void createOperationDetailsControl(IGridLayoutPane parent) {
        ISashPane tableViewer = parent.addVerticalSashPane(parent.createGridLayoutData(4, 4, true, true));
        this.tableData = new DefaultTableModel(new Object[0][0], tabColumnNames){

            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }
        };
        this.tableData.addTableModelListener(new AttributeTableModelListener());
        this.attributeList = tableViewer.addSapTableViewer((TableModel)this.tableData, true);
        this.attributeList.setBooleanColumnHandler(0);
        this.attributeList.getTable().getColumn(0).setWidth(50);
        this.attributeList.getTable().getColumn(0).setAlignment(0x1000000);
        this.attributeList.getTable().getColumn(1).setWidth(250);
    }

    private void initializeOperationDetailsControl() {
        if (this.attributes != null) {
            Iterator i = this.attributes.iterator();
            while (i.hasNext()) {
                Object[] newRow;
                Attribute attr = (Attribute)i.next();
                if (attr.getObjectName().equals("key")) continue;
                DataObject businesEntity = this.beie.getCAFBusinessEntityInterface().getBusinesEntityInterface().getBusinessEntity();
                if (CAFBusinessEntityInterface.isEntityAttribute(attr)) {
                    if (attr.getReferencedObject() == businesEntity) continue;
                    newRow = new Object[]{Boolean.FALSE, attr.getObjectName()};
                    this.tableData.addRow(newRow);
                    if (this.beie.getBusinessEntityInterface().getBackend() != 0 || ((DataObject)attr.getReferencedObject()).getBusinessEntityInterface().getBackend() != 0 || attr.getMaxOccurs() <= 0) continue;
                    List attrs = attr.getReferencedObject().getAttributes();
                    Iterator j = attrs.iterator();
                    while (j.hasNext()) {
                        Attribute subAttr = (Attribute)j.next();
                        if (!"com.sap.caf.base.string".equals(subAttr.getTypeJavaDdic()) && !CAFBusinessEntityInterface.isComplexAttribute(subAttr)) {
                            Object[] newRow1 = new Object[]{Boolean.FALSE, attr.getObjectName() + "." + subAttr.getObjectName()};
                            this.tableData.addRow(newRow1);
                        }
                        if (!CAFBusinessEntityInterface.isComplexAttribute(subAttr)) continue;
                        List attrs1 = subAttr.getReferencedObject().getAttributes();
                        Iterator j1 = attrs1.iterator();
                        while (j1.hasNext()) {
                            Attribute subComplAttr = (Attribute)j1.next();
                            if ("com.sap.caf.base.string".equals(subComplAttr.getTypeJavaDdic())) continue;
                            Object[] newRow2 = new Object[]{Boolean.FALSE, attr.getObjectName() + "." + subAttr.getObjectName() + "." + subComplAttr.getObjectName()};
                            this.tableData.addRow(newRow2);
                        }
                    }
                    continue;
                }
                if (CAFBusinessEntityInterface.isComplexAttribute(attr)) {
                    List attrs = attr.getReferencedObject().getAttributes();
                    Iterator j = attrs.iterator();
                    while (j.hasNext()) {
                        Attribute subAttr = (Attribute)j.next();
                        if ("com.sap.caf.base.string".equals(subAttr.getTypeJavaDdic())) continue;
                        Object[] newRow2 = new Object[]{Boolean.FALSE, attr.getObjectName() + "." + subAttr.getObjectName()};
                        this.tableData.addRow(newRow2);
                    }
                    continue;
                }
                if ("com.sap.caf.base.string".equals(attr.getTypeJavaDdic())) continue;
                newRow = new Object[]{Boolean.FALSE, attr.getObjectName()};
                this.tableData.addRow(newRow);
            }
        }
        if (this.operation != null) {
            int rowCount = this.tableData.getRowCount();
            Message msg = this.operation.getInput();
            ArrayList parameters = null;
            parameters = msg != null ? msg.getMessageParts() : new ArrayList();
            int i = 0;
            while (i < rowCount) {
                String attributeName = (String)this.tableData.getValueAt(i, 1);
                Iterator j = parameters.iterator();
                while (j.hasNext()) {
                    Attribute param = (Attribute)j.next();
                    if (!param.getObjectName().equals(attributeName)) continue;
                    this.tableData.setValueAt(Boolean.TRUE, i, 0);
                    break;
                }
                ++i;
            }
        }
    }

    private void setMappingCount(Boolean value) {
        this.mappingCount = value.booleanValue() ? ++this.mappingCount : --this.mappingCount;
        this.setPageComplete(this.mappingCount > 0);
    }

    public List getSelectAttributes() {
        ArrayList<String> selectedAttributes = new ArrayList<String>(this.attributes.size());
        int rowCount = this.tableData.getRowCount();
        int i = 0;
        while (i < rowCount) {
            Boolean check = (Boolean)this.tableData.getValueAt(i, 0);
            if (check.booleanValue()) {
                selectedAttributes.add((String)this.tableData.getValueAt(i, 1));
            }
            ++i;
        }
        return selectedAttributes;
    }

    public void setPageComplete(boolean complete) {
        boolean allComplete = !this.methodNameText.getText().equals("") && !this.methodDescriptionText.getText().equals("") && this.fieldSelected;
        super.setPageComplete(allComplete && complete);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AttributeTableModelListener
    implements TableModelListener {
        private AttributeTableModelListener() {
        }

        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0) {
                // empty if block
            }
            MethodWizardPage1.this.fieldSelected = true;
            MethodWizardPage1.this.dialogChanged("");
        }
    }
}

