/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.BomPlugin;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditor;
import com.sap.caf.designer.exception.CAFEclipseCoreException;
import com.sap.caf.designer.exception.CAFInvocationTargetException;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFMessage;
import com.sap.caf.designer.structure.util.DefaultValues;
import com.sap.caf.designer.wizards.MethodWizardPage1;
import com.sap.caf.designer.wizards.MethodWizardPage2;
import com.sap.caf.designer.wizards.MethodWizardPage3;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.Operation;
import com.sap.tc.logging.Location;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class MethodWizard
extends Wizard
implements INewWizard {
    public static final int METHOD_CUSTOM_TYPE = 1;
    public static final int METHOD_FIND_BY_TYPE = 0;
    public static final int METHOD_FIND_BY_MULTY_TYPE = 3;
    static int[] method_types = new int[]{0};
    static String[] method_names = new String[]{TextPool.getInstance().getText("BOM_METHODWZRD_0015")};
    public static final String ARRAY_MARKER = "[]";
    MethodWizardPage1 methodWizardPage1;
    MethodWizardPage2 methodWizardPage2;
    MethodWizardPage3 methodWizardPage3;
    private ISelection selection;
    private String attributeName;
    private String methodName;
    private List boAttributes;
    private static DefaultTableModel defTableModel;
    private static final TextPool mTextPool;
    private BOMSystem bos;
    private BusinessEntityInterfaceEditor boe;
    private Operation method = null;
    private static final Location logger;
    static /* synthetic */ Class class$com$sap$caf$designer$wizards$MethodWizard;

    public MethodWizard() {
        this.setDefaultPageImageDescriptor(SapIdeUtilImages.getImageDescriptorFromIconsDirectory((IPluginDescriptor)BomPlugin.getDefault().getDescriptor(), (String)"wzBannerCompApplication.gif"));
        this.setWindowTitle(TextPool.getInstance().getText("BOM_METHODWZRD_0041"));
        this.setNeedsProgressMonitor(true);
    }

    public MethodWizard(String methodName, BusinessEntityInterfaceEditor be) {
        this();
        this.methodName = methodName;
        if (be == null) {
            // empty if block
        }
        this.boe = be;
        this.method = this.boe.getCAFBusinessEntityInterface().getOperationByName(methodName);
        this.bos = this.boe.getBOMSystem();
    }

    public void addPages() {
        this.methodWizardPage1 = new MethodWizardPage1(this.boe, this.methodName);
        this.addPage((IWizardPage)this.methodWizardPage1);
    }

    public boolean performFinish() {
        final String methodNameText = this.getMethodNameText();
        final String methodDescriptionText = this.getMethodDescriptionText();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws CAFInvocationTargetException {
                try {
                    try {
                        MethodWizard.this.doFinish(methodNameText, methodDescriptionText, monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Error\n" + e.getMessage()));
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Error\n" + realException.getMessage()));
            return false;
        }
        return true;
    }

    public int getMethodType() {
        return this.methodWizardPage1.getMethodType();
    }

    public String getMethodNameText() {
        return this.methodWizardPage1.getMethodNameText();
    }

    public String getMethodDescriptionText() {
        return this.methodWizardPage1.getMethodDescriptionText();
    }

    public int getVisibility() {
        int visibility = this.methodWizardPage1.getVisibility();
        if (visibility > -1) {
            visibility += 2;
        }
        return visibility;
    }

    public String getMethodReturnType() {
        String methodReturnType = this.methodWizardPage1.getMethodReturnType();
        if (methodReturnType.length() == 0) {
            methodReturnType = "void";
        }
        return methodReturnType;
    }

    public boolean isArray() {
        return this.methodWizardPage1.isArray();
    }

    private void doFinish(String methodNameText, String methodDescriptionText, IProgressMonitor monitor) throws CAFEclipseCoreException {
        try {
            boolean isNewMethod = false;
            monitor.beginTask(mTextPool.getText("BOM_ALL_0005") + "...", 4);
            monitor.worked(1);
            this.method = this.boe.getCAFBusinessEntityInterface().getOperationByName(this.methodName);
            boolean hadFyndByOperation = this.boe.getCAFBusinessEntityInterface().hasFyndByOperation();
            int methodType = this.methodWizardPage1.getMethodType();
            if ("".equals(this.methodName)) {
                isNewMethod = true;
                CAFBusinessEntityInterface cbei = this.boe.getCAFBusinessEntityInterface();
                this.method = cbei.createOperation();
                DefaultValues.setDefaults(this.method, DefaultValues.OPERATION_FINDBY);
                this.method.getFault().add(cbei.createFaultMessage("CAFFindException"));
                cbei.setFindByOutputAttributes(this.method);
                if (null == this.method) {
                    return;
                }
            }
            this.method.setObjectName(methodNameText);
            this.method.setShortText(methodDescriptionText);
            if (this.isArray()) {
                // empty if block
            }
            monitor.worked(3);
            switch (methodType) {
                case 0: {
                    this.makeParametersFromPage3();
                }
            }
            if (this.method.getInput() != null && this.method.getInput().getMessageParts().size() == 0) {
                new CAFMessage(this.bos, this.method.getInput()).remove();
            }
            this.boe.getMethodsPage().fillTableMethods();
            monitor.worked(4);
            this.boe.setDirty(true);
            if (isNewMethod) {
                if (!hadFyndByOperation && DefaultValues.OPERATION_FINDBY[2][2].equals(this.method.getPatternType())) {
                    this.boe.getCAFBusinessEntityInterface().createMultyParamMethods();
                }
                this.bos.notifyCAFObjectChanged(this.method, 25);
            } else {
                this.bos.notifyCAFObjectChanged(this.method, 27);
            }
        }
        catch (Exception t) {
            logger.errorT("Could not create method with name :" + methodNameText);
            t.printStackTrace();
        }
    }

    private void throwCoreException(String message) throws CAFEclipseCoreException {
        Status status = new Status(4, "com.sap.caf.designer", 0, message, null);
        throw new CAFEclipseCoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (logger.beInfo()) {
            logger.infoT("Incorrect method type" + selection);
        }
    }

    public boolean canFinish() {
        return this.methodWizardPage1.isPageComplete();
    }

    private void makeParametersFromPage2() {
        String[] parameters = this.methodWizardPage2.getParameterList();
        int numParams = parameters.length;
        int index = 0;
        int i = 0;
        while (i < numParams) {
            int cardinality;
            index = parameters[i].indexOf(32);
            if (parameters[i].indexOf(ARRAY_MARKER) != -1) {
                index -= 2;
                cardinality = 2;
            } else {
                cardinality = 0;
            }
            String paramName = parameters[i].substring(0, index);
            ++i;
        }
    }

    private void makeParametersFromPage3() {
        List selectedAttributes = this.methodWizardPage1.getSelectAttributes();
        CAFBusinessEntityInterface cbei = this.boe.getCAFBusinessEntityInterface();
        cbei.removeUnusedFinByAttributes(this.method, selectedAttributes);
        Iterator i = selectedAttributes.iterator();
        while (i.hasNext()) {
            Attribute parameter = cbei.addFindByInputAttribute(this.method, (String)i.next());
            if (null == parameter) continue;
        }
    }

    private void makeParametersForMultiple() {
    }

    static boolean knowMethodType(int methodType) {
        int i = 0;
        while (i < method_types.length) {
            if (methodType == method_types[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mTextPool = TextPool.getInstance();
        logger = Location.getLocation((Class)(class$com$sap$caf$designer$wizards$MethodWizard == null ? (class$com$sap$caf$designer$wizards$MethodWizard = MethodWizard.class$("com.sap.caf.designer.wizards.MethodWizard")) : class$com$sap$caf$designer$wizards$MethodWizard));
    }
}

