/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.utils.EntityNamesStringUtil;
import com.sap.tc.logging.Location;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FaultMessageWizardPage1
extends WizardPage {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$wizards$FaultMessageWizardPage1 == null ? (class$com$sap$caf$designer$wizards$FaultMessageWizardPage1 = FaultMessageWizardPage1.class$("com.sap.caf.designer.wizards.FaultMessageWizardPage1")) : class$com$sap$caf$designer$wizards$FaultMessageWizardPage1);
    private Text objectText;
    private Text applicationText;
    private ISelection selection;
    private String initProjName;
    private BOMSystem mBomsystem;
    static /* synthetic */ Class class$com$sap$caf$designer$wizards$FaultMessageWizardPage1;

    public FaultMessageWizardPage1(ISelection selection, String initProjName) {
        super("FM wizardPage");
        logger.infoT("FaultMessageWizardPage1 constructor" + initProjName);
        this.setTitle(mTextPool.getText("FMWP1.Fault_Message_2"));
        this.setDescription(mTextPool.getText("ASI_TITLE_0016"));
        this.selection = selection;
        this.initProjName = initProjName;
        this.mBomsystem = BOMSystem.getBOMSystem(initProjName);
    }

    public String getObjectTextName() {
        return this.objectText.getText();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText(mTextPool.getText("FMWP1.Fault_Message_Name_4", true));
        this.objectText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.objectText.setLayoutData((Object)gd);
        this.objectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FaultMessageWizardPage1.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText(mTextPool.getText("BOM_GENERAL_0002", true));
        this.applicationText = new Text(container, 2052);
        gd = new GridData(768);
        this.applicationText.setLayoutData((Object)gd);
        this.applicationText.setEditable(false);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
        this.objectText.setFocus();
    }

    private void dialogChanged() {
        String error = null;
        String faultMsgName = this.getObjectTextName();
        Set faultMsgNames = null;
        faultMsgNames = this.mBomsystem.getApplicationFaultMessages().keySet();
        error = EntityNamesStringUtil.isClassNameValid(mTextPool.getText("FMWP1.Fault_Message_2"), faultMsgName, faultMsgNames);
        if (error != null) {
            this.updateStatus(error);
            return;
        }
        if (this.faultMessageNameExists(faultMsgNames, faultMsgName)) {
            error = mTextPool.getText("FMWP1.Fault_Message_Name_Exists");
            this.updateStatus(error);
            return;
        }
        this.updateStatus(null);
    }

    private boolean faultMessageNameExists(Collection faultMsgNames, String faultMsgName) {
        boolean nameExists = false;
        Iterator it = faultMsgNames.iterator();
        String newFaultResolvedName = this.mBomsystem.getApplication().getProviderName() + "/" + this.mBomsystem.getApplicationName() + "/" + faultMsgName;
        while (it.hasNext()) {
            String tempName = (String)it.next();
            if (!tempName.equals(newFaultResolvedName)) continue;
            nameExists = true;
        }
        return nameExists;
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                if (obj instanceof IContainer) {
                    IContainer container = (IContainer)obj;
                } else {
                    IContainer iContainer = ((IResource)obj).getParent();
                }
            }
        }
        this.applicationText.setText(this.mBomsystem.getApplicationName());
    }

    private void updateStatus(String message) {
        if (this.objectText.getText().equals("")) {
            this.setMessage(mTextPool.getText("FMWP1.Fault_Message_3"));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

