/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.BomPlugin;
import com.sap.caf.designer.Logger;
import com.sap.caf.designer.StatusLineMessage;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.ApplicationInterfaceEditor;
import com.sap.caf.designer.exception.CAFEclipseCoreException;
import com.sap.caf.designer.exception.CAFInvocationTargetException;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.wizards.FaultMessageWizardPage1;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.FaultMessage;
import com.sap.caf.metamodel.MetamodelPackage;
import com.sap.tc.logging.Location;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class FaultMessageWizard
extends Wizard
implements INewWizard {
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$wizards$FaultMessageWizard == null ? (class$com$sap$caf$designer$wizards$FaultMessageWizard = FaultMessageWizard.class$("com.sap.caf.designer.wizards.FaultMessageWizard")) : class$com$sap$caf$designer$wizards$FaultMessageWizard);
    private static final TextPool mTextPool = TextPool.getInstance();
    private FaultMessageWizardPage1 page;
    private ISelection selection;
    private String projName;
    static /* synthetic */ Class class$com$sap$caf$designer$wizards$FaultMessageWizard;

    public FaultMessageWizard() {
        this.setDefaultPageImageDescriptor(SapIdeUtilImages.getImageDescriptorFromIconsDirectory((IPluginDescriptor)BomPlugin.getDefault().getDescriptor(), (String)"wzBannerCompApplication.gif"));
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(mTextPool.getText("FWM.FWMCreateText"));
    }

    public FaultMessageWizard(String projName) {
        this();
        this.projName = projName;
    }

    public String getObjName() {
        return this.page.getObjectTextName();
    }

    public void addPages() {
        this.page = new FaultMessageWizardPage1(this.selection, this.projName);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setForcePreviousAndNextButtons(false);
    }

    public boolean performFinish() {
        final String objName = this.getObjName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws CAFInvocationTargetException {
                try {
                    try {
                        FaultMessageWizard.this.doFinish(objName, monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String objName, IProgressMonitor monitor) throws CAFEclipseCoreException {
        Object editPart = null;
        monitor.beginTask(mTextPool.getText("BOM_ALL_0005") + "...", 4);
        monitor.worked(1);
        try {
            BOMSystem bomsystem = BOMSystem.getBOMSystem(this.projName);
            MetamodelPackage mpackage = bomsystem.getMetamodelPackage();
            FaultMessage faultmsg = mpackage.getFaultMessage().createFaultMessage();
            String faultName = bomsystem.getApplication().getProviderName() + "/" + bomsystem.getApplicationName() + "/" + objName;
            faultmsg.setObjectName(faultName);
            faultmsg.setObjectId(faultmsg.refMofId());
            bomsystem.getApplicationFaultMessages().put(faultName, faultmsg);
            bomsystem.getApplication().getBaseObjects().add(faultmsg);
            ApplicationInterfaceEditor.refreshInstances();
            IWorkbenchPage workbenchActivePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            monitor.setTaskName(mTextPool.getText("BOM_TEXTWZRD_0005"));
            monitor.worked(2);
            bomsystem.getModifiedServicesList().objectModified((BaseObject)faultmsg);
            MetamodelProvider.setDirtyOn(this.projName);
            StatusLineMessage slm = new StatusLineMessage();
            slm.printMessage(mTextPool.getText("FM_STATUSLINE_0002") + " " + objName + " " + mTextPool.getText("BOM_STATUSLINE_0003"));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)mTextPool.getText("FMW.FMnotCreated"), (String)e.getMessage());
        }
        monitor.worked(3);
    }

    private void throwCoreException(String message) throws CAFEclipseCoreException {
        Status status = new Status(4, "com.sap.caf.designer", 0, message, null);
        throw new CAFEclipseCoreException((IStatus)status);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

