/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.BomPlugin;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.ApplicationInterfaceEditor;
import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.CAFEclipseCoreException;
import com.sap.caf.designer.exception.CAFInvocationTargetException;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFExternalInterface;
import com.sap.caf.designer.utils.ProxyConfig;
import com.sap.caf.designer.views.ModelTreeViewer;
import com.sap.caf.designer.wizards.ExternalServicesWizardPage1;
import com.sap.caf.designer.wizards.StandaloneProxyDefinitionPage;
import com.sap.caf.imports.mp2mmr.ConversionException;
import com.sap.caf.imports.mp2mmr.RFCConnectSettings;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.MetamodelPackage;
import com.sap.caf.mp.core.data.service.manager.saprfc.SAPRFCServiceManager;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinition;
import com.sap.ide.jcb.core.service.IR3Service;
import com.sap.ide.jcb.core.service.internal.R3Service;
import com.sap.ide.jcb.core.service.workingset.internal.WorkingSetObject;
import com.sap.ide.jcb.core.wizardpages.RFCSelectionPage;
import com.sap.ide.jcb.core.wizardpages.SAPLogonPage;
import com.sap.ide.wsproxy.wizards.prx.pages.DeployableProxyDefinitionPage;
import com.sap.ide.wsproxy.wizards.prx.pages.WsdlLocalFileClientPage;
import com.sap.ide.wsproxy.wizards.prx.pages.WsdlLocalServerClientPage;
import com.sap.ide.wsproxy.wizards.prx.pages.WsdlPageI;
import com.sap.ide.wsproxy.wizards.prx.pages.WsdlUddiClientPage;
import com.sap.tc.logging.Location;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ExternalInterfaceWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static IMemento memento = null;
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$designer$wizards$ExternalInterfaceWizard == null ? (class$com$sap$caf$designer$wizards$ExternalInterfaceWizard = ExternalInterfaceWizard.class$("com.sap.caf.designer.wizards.ExternalInterfaceWizard")) : class$com$sap$caf$designer$wizards$ExternalInterfaceWizard));
    private static final String ROOT_MEMENTO_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><r3info></r3info>";
    private IWorkbench mWorkbench = PlatformUI.getWorkbench();
    private StandaloneProxyDefinitionPage projectPage;
    private WsdlLocalServerClientPage localServerWsdlPage;
    private WsdlUddiClientPage uddiServerWsdlPage;
    private WsdlLocalFileClientPage fileSystemWsdlPage;
    private IR3Service mR3Service;
    private SAPLogonPage mSAPLogonPage;
    private RFCSelectionPage mRFCSelectionPage;
    private IWizardPage lastPage = null;
    private ExternalServicesWizardPage1 externalServicesPage1;
    private String projName;
    private BOMSystem bos;
    private int servType;
    private boolean m_bAnythingEntered = false;
    static /* synthetic */ Class class$com$sap$caf$designer$wizards$ExternalInterfaceWizard;

    public ExternalInterfaceWizard() {
        this.setDefaultPageImageDescriptor(SapIdeUtilImages.getImageDescriptorFromIconsDirectory((IPluginDescriptor)BomPlugin.getDefault().getDescriptor(), (String)"wzBannerCompApplication.gif"));
        this.setNeedsProgressMonitor(true);
        this.mSAPLogonPage = new SAPLogonPage();
        this.mRFCSelectionPage = new RFCSelectionPage();
        this.mSAPLogonPage.init(memento);
        this.mR3Service = R3Service.getInstance();
        this.mSAPLogonPage.setConnectionManager(this.mR3Service.getConnectionManager());
        this.mRFCSelectionPage.setR3Service(this.mR3Service);
        this.setWindowTitle(mTextPool.getText("ESW_TITLE"));
    }

    public ExternalInterfaceWizard(String projName) {
        this();
        this.projName = projName;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        logger.infoT("getNextPage after current -->" + page.getClass().getName());
        this.lastPage = page;
        Object result = null;
        if (page instanceof ExternalServicesWizardPage1) {
            this.setType();
            result = this.servType == 0 ? this.mSAPLogonPage : this.projectPage;
        } else if (page instanceof SAPLogonPage) {
            result = this.mRFCSelectionPage;
        } else if (page instanceof DeployableProxyDefinitionPage) {
            if (((DeployableProxyDefinitionPage)page).getWsdlSourceSelection() == 0) {
                result = this.localServerWsdlPage;
            } else if (((DeployableProxyDefinitionPage)page).getWsdlSourceSelection() == 2) {
                result = this.fileSystemWsdlPage;
            } else if (((DeployableProxyDefinitionPage)page).getWsdlSourceSelection() == 1) {
                result = this.uddiServerWsdlPage;
            }
        }
        return result;
    }

    public void setType() {
        this.servType = this.externalServicesPage1.getType();
        logger.infoT("ExternalServicesWizard servType, type  = " + this.servType);
    }

    public void addPages() {
        this.externalServicesPage1 = new ExternalServicesWizardPage1();
        this.addPage((IWizardPage)this.externalServicesPage1);
        this.projectPage = new StandaloneProxyDefinitionPage();
        this.addPage((IWizardPage)this.projectPage);
        this.localServerWsdlPage = new WsdlLocalServerClientPage();
        this.addPage((IWizardPage)this.localServerWsdlPage);
        this.uddiServerWsdlPage = new WsdlUddiClientPage();
        this.addPage((IWizardPage)this.uddiServerWsdlPage);
        this.fileSystemWsdlPage = new WsdlLocalFileClientPage();
        this.addPage((IWizardPage)this.fileSystemWsdlPage);
        this.addPage((IWizardPage)this.mSAPLogonPage);
        this.addPage((IWizardPage)this.mRFCSelectionPage);
        logger.infoT(" ExternalInterfaceWizard addPages executed successfully." + this.projName);
    }

    public boolean canFinish() {
        return this.lastPage == this.mRFCSelectionPage || this.lastPage == this.localServerWsdlPage || this.lastPage == this.fileSystemWsdlPage || this.lastPage == this.uddiServerWsdlPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setForcePreviousAndNextButtons(false);
    }

    public boolean performFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws CAFInvocationTargetException {
                try {
                    try {
                        ExternalInterfaceWizard.this.doFinish(monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                    Object var5_2 = null;
                }
                catch (Throwable throwable) {
                    Object var5_3 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, op);
            return true;
        }
        catch (InterruptedException e) {
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            if (realException instanceof ExtWizardException) {
                ExtWizardException custom = (ExtWizardException)((Object)realException);
                if (custom.code == 1) {
                    if (custom.bRFC) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)mTextPool.getText("ESW_DLG_TITLE_NO_RFCFUNC_SELECTED"), (String)mTextPool.getText("ESW_DLG_MSG_NO_RFCFUNC_SELECTED"));
                    } else {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)mTextPool.getText("ESW_DLG_TITLE_NO_WS_SELECTED"), (String)mTextPool.getText("ESW_DLG_MSG_NO_WS_SELECTED"));
                    }
                }
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)mTextPool.getText("ESW_DLG_TITLE_CANNOTIMPORT_SELECTED"), (String)realException.getMessage());
            }
            return false;
        }
    }

    private String getEnteredWSDLURL() {
        String strURL = "";
        try {
            strURL = ((WsdlPageI)this.lastPage).getWSDLUrl();
            if (strURL != null && (strURL = strURL.trim()).length() == 0) {
                return null;
            }
            return strURL;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    private RFCConnectSettings convertRFCProperties(boolean bSingleServer, Properties rfcConnectPluginProp) {
        String language = rfcConnectPluginProp.getProperty("jco.client.lang");
        String password = rfcConnectPluginProp.getProperty("jco.client.passwd");
        String user = rfcConnectPluginProp.getProperty("jco.client.user");
        String clientNumber = rfcConnectPluginProp.getProperty("jco.client.client");
        String sncMode = rfcConnectPluginProp.getProperty("jco.client.snc_mode");
        boolean bSecurityMode = false;
        if (sncMode != null) {
            bSecurityMode = sncMode.trim().equals("1");
        }
        if (bSingleServer) {
            String systemNumber = rfcConnectPluginProp.getProperty("jco.client.sysnr");
            String host = rfcConnectPluginProp.getProperty("jco.client.ashost");
            if (bSecurityMode) {
                String sncPartnerName = rfcConnectPluginProp.getProperty("jco.client.snc_partnername");
                String sncSecurityLevel = rfcConnectPluginProp.getProperty("jco.client.snc_qop");
                return new RFCConnectSettings(host, Integer.parseInt(systemNumber), "", Integer.parseInt(clientNumber), user, language, sncPartnerName, sncSecurityLevel);
            }
            return new RFCConnectSettings(host, Integer.parseInt(systemNumber), "", Integer.parseInt(clientNumber), user, password, language);
        }
        String messageServer = rfcConnectPluginProp.getProperty("jco.client.mshost");
        String systemID = rfcConnectPluginProp.getProperty("jco.client.r3name");
        String group = rfcConnectPluginProp.getProperty("jco.client.group");
        if (bSecurityMode) {
            String sncPartnerName = rfcConnectPluginProp.getProperty("jco.client.snc_partnername");
            String sncSecurityLevel = rfcConnectPluginProp.getProperty("jco.client.snc_qop");
            return new RFCConnectSettings(messageServer, group, systemID, "", Integer.parseInt(clientNumber), user, language, sncPartnerName, sncSecurityLevel);
        }
        return new RFCConnectSettings(messageServer, group, systemID, "", Integer.parseInt(clientNumber), user, password, language);
    }

    private void doFinish(IProgressMonitor monitor) throws CAFEclipseCoreException, CAFInvocationTargetException {
        block9: {
            this.m_bAnythingEntered = false;
            BOMSystem bomsystem = null;
            MetamodelPackage metamodel = null;
            try {
                try {
                    bomsystem = BOMSystem.getBOMSystem(this.projName);
                    metamodel = bomsystem.getMetamodelPackage();
                }
                catch (Exception ex) {
                    throw new CAFInvocationTargetException(ex, mTextPool.getText("ESW_ERROR_CANNOTGET_MMR", new String[]{this.projName}));
                }
                if (this.servType == 0) {
                    this.importR3RFCSystem(monitor, bomsystem, metamodel);
                } else {
                    this.importWebService(monitor, bomsystem, metamodel);
                }
                monitor.setTaskName(mTextPool.getText("ESW_IMPORT_FINISHED_SUCC"));
                monitor.worked(1);
                Object var6_5 = null;
                if (!this.m_bAnythingEntered) break block9;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (this.m_bAnythingEntered) {
                    MetamodelProvider.setDirtyOn(this.projName);
                    ModelTreeViewer.refreshInstances();
                    ApplicationInterfaceEditor.refreshInstances();
                    if (bomsystem != null) {
                        bomsystem.notifyCAFObjectChanged(null, 13);
                    }
                }
                throw throwable;
            }
            MetamodelProvider.setDirtyOn(this.projName);
            ModelTreeViewer.refreshInstances();
            ApplicationInterfaceEditor.refreshInstances();
            if (bomsystem != null) {
                bomsystem.notifyCAFObjectChanged(null, 13);
            }
        }
    }

    private void importMP2MMR(IProgressMonitor monitor, BOMSystem bomsystem, IServiceDefinition[] res, String[] names) throws CAFInvocationTargetException {
        if (res == null || res.length == 0) {
            return;
        }
        if (names.length != res.length) {
            throw new RuntimeException("Program Error in ExternalInterfaceWizard.importMP2MMR, res and names arrays differ in size.");
        }
        monitor.setTaskName(mTextPool.getText("ESW_TASK_IMPORT_MMR"));
        int i = 0;
        while (i < res.length) {
            block9: {
                try {
                    try {
                        CAFExternalInterface cafextern = CAFExternalInterface.createFromMPServiceDef(bomsystem, res[i], names[i]);
                        bomsystem.getModifiedServicesList().objectModified((BaseObject)cafextern.getExternalInterface());
                        this.m_bAnythingEntered = true;
                    }
                    catch (ConversionException ex) {
                        if (ex.reason == 0) {
                            MessageDialog.openInformation((Shell)this.getShell(), (String)mTextPool.getText("ESW_CANNOT_MP_MMR_TITLE"), (String)mTextPool.getText("ESW_CANNOT_USE_CYCLIC_STRUCTURES"));
                            break block9;
                        }
                        if (ex.reason == 1) {
                            MessageDialog.openInformation((Shell)this.getShell(), (String)mTextPool.getText("ESW_CANNOT_MP_MMR_TITLE"), (String)mTextPool.getText("ESW_EXTERNAL_NAME_ALREADY_EXIST", new String[]{names[i]}));
                            break block9;
                        }
                        throw ex;
                    }
                }
                catch (Exception ex) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)mTextPool.getText("ESW_CANNOT_MP_MMR_TITLE"), (String)mTextPool.getText("ESW_CANNOT_MP_MMR_MSG", new String[]{names[i], ex.getMessage()}));
                }
            }
            ++i;
        }
    }

    private void importR3RFCSystem(IProgressMonitor monitor, BOMSystem bomsystem, MetamodelPackage metamodel) throws CAFInvocationTargetException {
        int nSelectedRFCSize = this.mRFCSelectionPage.getR3Service().getWorkingSet().getSize();
        if (nSelectedRFCSize <= 0) {
            throw new CAFInvocationTargetException((Throwable)((Object)new ExtWizardException("RFC - Nothing is selected.", 1, true)));
        }
        monitor.beginTask(mTextPool.getText("ESW_TASKNAME_IMPORT_RFC"), nSelectedRFCSize);
        monitor.setTaskName(mTextPool.getText("ESW_TASK_IMPORT_RFC"));
        try {
            SAPRFCServiceManager rfcImportManager = new SAPRFCServiceManager();
            Properties rfcConnectPluginProp = this.mR3Service.getConnectionManager().getJCOClient().getProperties();
            boolean bSingleServer = this.mSAPLogonPage.getConnectionType().equals("SingleServer");
            RFCConnectSettings rfcConnectProps = this.convertRFCProperties(bSingleServer, rfcConnectPluginProp);
            Iterator itRFCWorkingSet = this.mRFCSelectionPage.getR3Service().getWorkingSet().getIterator();
            while (itRFCWorkingSet.hasNext()) {
                String rfcName;
                monitor.setTaskName(mTextPool.getText("ESW_TASK_IMPORT_RFC"));
                WorkingSetObject selRFC = (WorkingSetObject)itRFCWorkingSet.next();
                rfcConnectProps.functionName = rfcName = selRFC.getName();
                Vector resrfc = null;
                Vector<String> vectorNames = new Vector<String>();
                try {
                    resrfc = rfcImportManager.importServiceDefinition("R/3 RFC", rfcConnectProps.getPropertyCollection(), null);
                    int i = 0;
                    while (i < resrfc.size()) {
                        vectorNames.add(rfcName);
                        ++i;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    logger.catching((Throwable)ex);
                    MessageDialog.openInformation((Shell)this.getShell(), (String)mTextPool.getText("ESW_RFC_METHOD_IMPORT_FAILED_TITLE"), (String)mTextPool.getText("ESW_RFC_METHOD_IMPORT_FAILED_MSG", new String[]{rfcName, ex.getMessage()}));
                }
                if (resrfc.size() != vectorNames.size()) {
                    throw new RuntimeException("Program Error in ExternalInterfaceWizard.importR3RFCSystem, 'resrfc' and 'vectorNames' arrays differ in size.");
                }
                int nLen = resrfc.size();
                IServiceDefinition[] arrSD = new IServiceDefinition[nLen];
                String[] names = new String[nLen];
                int i = 0;
                while (i < nLen) {
                    arrSD[i] = (IServiceDefinition)resrfc.get(i);
                    names[i] = (String)vectorNames.get(i);
                    ++i;
                }
                this.importMP2MMR(monitor, bomsystem, arrSD, names);
                monitor.worked(1);
            }
        }
        catch (CAFInvocationTargetException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CAFInvocationTargetException(ex, mTextPool.getText("ESW_CANNOT_LOAD_GENERAL_RFC"));
        }
    }

    private void importWebService(IProgressMonitor monitor, BOMSystem bomsystem, MetamodelPackage metamodel) throws CAFInvocationTargetException {
        monitor.beginTask(mTextPool.getText("ESW_TASKNAME_IMPORT_WS"), 2);
        this.m_bAnythingEntered = false;
        monitor.setTaskName(mTextPool.getText("ESW_TASK_IMPORT_WS"));
        String urlWSDL = this.getEnteredWSDLURL();
        if (urlWSDL == null || urlWSDL.length() == 0) {
            throw new CAFInvocationTargetException((Throwable)((Object)new ExtWizardException("WS - Nothing is selected.", 1, false)));
        }
        IServiceDefinition[] res = null;
        String[] names = null;
        try {
            URL url = null;
            ProxyConfig proxy = null;
            try {
                url = new URL(urlWSDL);
                proxy = ProxyConfig.loadFromPrefereces();
            }
            catch (Exception ex) {
                File wsdlContent = new File(urlWSDL);
                url = wsdlContent.toURL();
            }
            res = CAFExternalInterface.importWebServicesMP(url, proxy);
            names = new String[res.length];
            int i = 0;
            while (i < res.length) {
                names[i] = res[i].getPortType().getName();
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.catching((Throwable)ex);
            throw new CAFInvocationTargetException(ex, mTextPool.getText("ESW_CANNOT_LOAD_WSDL", new String[]{urlWSDL, ex.getLocalizedMessage()}));
        }
        monitor.worked(1);
        this.importMP2MMR(monitor, bomsystem, res, names);
        monitor.worked(1);
    }

    private void throwCoreException(String message) throws CAFEclipseCoreException {
        Status status = new Status(4, "com.sap.caf.designer", 0, message, null);
        throw new CAFEclipseCoreException((IStatus)status);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ExtWizardException
    extends CAFBaseException {
        public static final int NOTHING_IS_SELECTED = 1;
        public int code = 0;
        public boolean bRFC = true;

        public ExtWizardException(String reason, int code, boolean bRFC) {
            super(reason);
            this.bRFC = bRFC;
            this.code = code;
        }
    }
}

