/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.BomPlugin;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.dnd.ModelDragSourceListener;
import com.sap.caf.designer.dnd.ModelDropTargetListener;
import com.sap.caf.designer.dnd.ModelElementSource;
import com.sap.caf.designer.dnd.ModelElementSourceTransfer;
import com.sap.caf.designer.editors.ApplicationServiceOperationsPage;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.utils.EntityNamesStringUtil;
import com.sap.caf.designer.views.BOMTreeUtil;
import com.sap.caf.designer.wizards.ComboBoxStringCellEditor;
import com.sap.caf.designer.wizards.DSAttributeTO;
import com.sap.caf.designer.wizards.DataStructureTableModel;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.AttributeObjectAssociation;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.MetamodelPackage;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.YesManFilter;
import com.tssap.selena.model.extension.ui.treeviewer.GenericDataModelFilteredTreeViewer;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import com.tssap.util.ui.viewer.table.SapTableRow;
import com.tssap.util.ui.viewer.tree.ISapTreeViewer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.table.TableModel;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DTOWizardPage1
extends WizardPage {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Object[] tableColumnNames = new Object[]{mTextPool.getText("DTOWP1.Name_1"), mTextPool.getText("DTOWP1.Type_2"), mTextPool.getText("DTOWP1.Collection_3"), ""};
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$designer$wizards$DTOWizardPage1 == null ? (class$com$sap$caf$designer$wizards$DTOWizardPage1 = DTOWizardPage1.class$("com.sap.caf.designer.wizards.DTOWizardPage1")) : class$com$sap$caf$designer$wizards$DTOWizardPage1));
    private Text objectText;
    private GenericDataModelFilteredTreeViewer serviceCatalogGenericTreeViewer;
    private ISapTableViewer dsTableviewer;
    private DataStructureTableModel defTableModel;
    private List refObjects = new ArrayList();
    private ISapTreeViewer treeViewer;
    private BOMSystem bomsystem;
    private Text dsNameText;
    private String datastructureName;
    private String projectName;
    private ArrayList m_defaultDsAttr;
    static /* synthetic */ Class class$com$sap$caf$designer$wizards$DTOWizardPage1;

    public DTOWizardPage1(String projectName, String dsuniqName, ArrayList defaultDSAttr) {
        super("wizardPage");
        logger.infoT("DTOWizardPage1" + projectName);
        this.bomsystem = BOMSystem.getBOMSystem(projectName);
        this.projectName = projectName;
        this.datastructureName = dsuniqName;
        this.m_defaultDsAttr = defaultDSAttr;
    }

    public DataStructureTableModel getAttributeTable() {
        return this.defTableModel;
    }

    public String getDataStructureName() {
        return this.dsNameText.getText();
    }

    public List getReferencedObject() {
        return this.refObjects;
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    public void createControl(Composite parent) {
        Composite composite;
        ISashPane outerSashPane1 = PaneFactory.createHorizontalSashPane((Composite)parent);
        IGridLayoutPane leftgridPane = outerSashPane1.addGridLayoutPane(1, false);
        leftgridPane.addTextLabel(mTextPool.getText("DTOWP1.Data_Structure_Name_5", true), leftgridPane.createGridLayoutData(4, 4, 1, 1));
        leftgridPane.addPlaceholder();
        leftgridPane.addTextLabel(mTextPool.getText("DTOWP1.Data_Objects_6"), leftgridPane.createGridLayoutData(4, 4, 21, 1));
        IGridLayoutPane middlegridPane = outerSashPane1.addGridLayoutPane(1, false);
        int i = 1;
        while (i <= 6) {
            middlegridPane.addPlaceholder(1, 1);
            ++i;
        }
        Image arrow = SapIdeUtilImages.getImageFromIconsDirectory((IPluginDescriptor)BomPlugin.getDefault().getDescriptor(), (String)"arrow_right.gif");
        Button addButton = middlegridPane.addPushButton(arrow, mTextPool.getText("BOM_ALL_0001"), middlegridPane.createGridLayoutData(2, 2, 1, 1));
        addButton.addSelectionListener((SelectionListener)new AddButtonListener());
        arrow = SapIdeUtilImages.getImageFromIconsDirectory((IPluginDescriptor)BomPlugin.getDefault().getDescriptor(), (String)"arrow_left.gif");
        Button removeButton = middlegridPane.addPushButton(arrow, mTextPool.getText("BOM_ALL_0006"), middlegridPane.createGridLayoutData(2, 2, 1, 1));
        removeButton.addSelectionListener((SelectionListener)new RemoveButtonListener());
        IGridLayoutPane rightgridPane = outerSashPane1.addGridLayoutPane(1, false);
        this.dsNameText = rightgridPane.addTextField("", rightgridPane.createGridLayoutData(4, 4, 21, 1));
        this.dsNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DTOWizardPage1.this.dialogChanged();
            }
        });
        rightgridPane.addPlaceholder();
        rightgridPane.addTextLabel(mTextPool.getText("DTOWP1.Data_Structure_Attributes_10"), rightgridPane.createGridLayoutData(1, 2, 1, 1));
        outerSashPane1.setWeights(new int[]{10, 1, 10});
        ISashPane tableViewer = leftgridPane.addVerticalSashPane(leftgridPane.createGridLayoutData(4, 4, true, true));
        this.serviceCatalogGenericTreeViewer = (GenericDataModelFilteredTreeViewer)BOMTreeUtil.createTreeViewer(tableViewer.getComposite(), new PropertyMap[0], true, true);
        this.serviceCatalogGenericTreeViewer.setFilter((IFilter)new YesManFilter(){

            public boolean isAvailable(PropertyMap propertyMap) {
                boolean ret = false;
                if (propertyMap instanceof Element) {
                    Element element = (Element)propertyMap;
                    UniqueName uniqueName = element.getUniqueName();
                    if (!uniqueName.getDomain().equals("CAF")) {
                        ret = false;
                    } else {
                        String sd = uniqueName.getSubDomain();
                        if ("Create Data Structure".equals(sd) || "Attributes Type Catalog".equals(sd) || "Data Object".equals(sd) || "Data Structure".equals(sd) || "Core Data Structure".equals(sd) || "Core Data Structures".equals(sd) || "Current Data Structures".equals(sd) || "Data Structures".equals(sd) || "Java Type".equals(sd) || "Java Type Package".equals(sd) || "Java Types".equals(sd)) {
                            ret = true;
                        }
                    }
                }
                return ret;
            }
        });
        String paramDSname = this.datastructureName == null ? "" : this.datastructureName;
        UniqueName serviceCatalog = com.sap.caf.designer.model.ModelAccess.createUniqueName("CAF", "Create Data Structure", null, "Data Objects Catalog", new String[]{this.projectName, "", paramDSname});
        Model model = ModelAccess.createModel((UniqueName)serviceCatalog);
        this.serviceCatalogGenericTreeViewer.addRoot((PropertyMap)model);
        this.serviceCatalogGenericTreeViewer.getTreeViewer().expandToLevel(2);
        tableViewer = rightgridPane.addVerticalSashPane(leftgridPane.createGridLayoutData(4, 4, true, true));
        this.dsTableviewer = tableViewer.addSapTableViewer((TableModel)this.initializeTableModel());
        CellEditor[] celleditors = new CellEditor[]{new TextCellEditor((Composite)this.dsTableviewer.getTable()), new TextCellEditor((Composite)this.dsTableviewer.getTable()), new ComboBoxStringCellEditor((Composite)this.dsTableviewer.getTable(), ApplicationServiceOperationsPage.atrListType), new TextCellEditor((Composite)this.dsTableviewer.getTable())};
        this.dsTableviewer.getTableViewer().setCellEditors(celleditors);
        this.dsTableviewer.getTable().getColumn(3).setWidth(0);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)parent);
        if (this.serviceCatalogGenericTreeViewer != null) {
            DragSource source = new DragSource((Control)this.serviceCatalogGenericTreeViewer.getTree(), 20);
            source.setTransfer(new Transfer[]{ModelElementSourceTransfer.getInstance()});
            source.addDragListener((DragSourceListener)new CatalogModelDragSourceListener());
            DropTarget catalogTarget = new DropTarget((Control)this.serviceCatalogGenericTreeViewer.getTree(), 2);
            catalogTarget.setTransfer(new Transfer[]{ModelElementSourceTransfer.getInstance()});
            catalogTarget.addDropListener((DropTargetListener)new CatalogModelDropTargetListener());
        }
        if (rightgridPane != null && (composite = rightgridPane.getComposite()).getChildren().length >= 4) {
            DropTarget depTatget = new DropTarget(composite.getChildren()[3], 20);
            depTatget.setTransfer(new Transfer[]{ModelElementSourceTransfer.getInstance()});
            depTatget.addDropListener((DropTargetListener)new DataStuctureModelDropTargetListener());
        }
        if (this.dsTableviewer != null) {
            this.dsTableviewer.getTableViewer().addDragSupport(2, new Transfer[]{ModelElementSourceTransfer.getInstance()}, (DragSourceListener)new DataStuctureModelDragSourceListener());
        }
    }

    public boolean dialogChanged() {
        String error;
        String datastrName = this.getDataStructureName();
        Set dsnames = null;
        if (this.datastructureName == null) {
            dsnames = this.bomsystem.getApplicationDataStructures().keySet();
        }
        if ((error = EntityNamesStringUtil.isClassNameValid(mTextPool.getText("DTOWP1.Data_Structure_17"), datastrName, dsnames)) != null) {
            this.updateStatus(error);
            return false;
        }
        if (this.defTableModel.getRowCount() < 1) {
            this.updateStatus(mTextPool.getText("DTOWP1.At_least_one"));
            return false;
        }
        this.updateStatus(null);
        return true;
    }

    protected void justUpdateStatus(String message) {
        this.setErrorMessage(message);
    }

    protected void updateStatus(String message) {
        if (this.dsNameText.getText().equals("")) {
            this.setMessage(mTextPool.getText("DS_STATUSLINE_0004"));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private Collection getExistingNames() {
        ArrayList<Object> names = new ArrayList<Object>();
        int i = 0;
        while (i < this.defTableModel.getRowCount()) {
            names.add(this.defTableModel.getValueAt(i, 0));
            ++i;
        }
        return names;
    }

    private boolean isDefaultAttribute(String name) {
        if (name == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_defaultDsAttr.size()) {
            if (name.equals(((DSAttributeTO)this.m_defaultDsAttr.get(i)).getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void addItemToDS(String name, String subdomain, String[] unParams) {
        DataStructure addedDS;
        String subDomain = subdomain;
        if (!(subDomain.equals("Java Type") || subDomain.equals("Data Object") || subDomain.equals("Data Structure") || subDomain.equals("Core Data Structure"))) {
            return;
        }
        String atrType = name;
        String atrName = "";
        if (subDomain.equals("Data Object")) {
            CAFBusinessEntityInterface cafbei = (CAFBusinessEntityInterface)this.bomsystem.getBusinessEntityInterfaces().get(name);
            DataObject do_ = cafbei.getBusinesEntityInterface().getBusinessEntity();
            atrName = EntityNamesStringUtil.getAttributeDSName(name, this.getExistingNames());
            this.refObjects.add(do_);
        } else if (subDomain.equals("Data Structure")) {
            addedDS = (DataStructure)this.bomsystem.getApplicationDataStructures().get(name);
            if (!this.dsNameText.getEditable() && this.datastructureName != null) {
                DataStructure thisDS = (DataStructure)this.bomsystem.getApplicationDataStructures().get(this.datastructureName);
                MetamodelPackage mpackage = this.bomsystem.getMetamodelPackage();
                AttributeObjectAssociation attributeObjectAssociation = mpackage.getAttributeObjectAssociation();
                if (attributeObjectAssociation.getObject(thisDS) != null) {
                    ArrayList referencingDss = new ArrayList();
                    this.checkCyclicReference(thisDS, addedDS, referencingDss);
                    String refDsnames = "";
                    Iterator ireferencingDss = ((AbstractList)referencingDss).iterator();
                    while (ireferencingDss.hasNext()) {
                        String element = (String)ireferencingDss.next();
                        refDsnames = refDsnames + element + ", ";
                    }
                    if (!"".equals(refDsnames)) {
                        this.updateStatus("Action can not be  performed! Creating that attribute will cause cyclic reference," + refDsnames.substring(0, refDsnames.length() - 2) + ", has reference to " + thisDS.getObjectName());
                        return;
                    }
                }
            }
            atrName = EntityNamesStringUtil.getAttributeDSName(name, this.getExistingNames());
            this.refObjects.add(addedDS);
        } else if (subDomain.equals("Core Data Structure")) {
            addedDS = (DataStructure)this.bomsystem.getCoreDataStructures().get(name);
            atrName = EntityNamesStringUtil.getAttributeDSName(name, this.getExistingNames());
            this.refObjects.add(addedDS);
        } else {
            atrName = EntityNamesStringUtil.getAttributeSimpleTypeName(this.getExistingNames());
            atrType = unParams[unParams.length - 1] + "." + name;
            this.refObjects.add(atrType);
        }
        Object[] newRow = new Object[]{atrName, atrType, ApplicationServiceOperationsPage.atrListType[2]};
        this.defTableModel.addRow(newRow);
        this.dialogChanged();
    }

    private void checkCyclicReference(DataStructure thisDs, DataStructure addedDS, ArrayList referedDss) {
        MetamodelPackage mpackage = this.bomsystem.getMetamodelPackage();
        Iterator attrCollection = addedDS.getAttributes().iterator();
        while (attrCollection.hasNext()) {
            Attribute attr = (Attribute)attrCollection.next();
            if (attr.getReferencedObject() == null || !(attr.getReferencedObject() instanceof DataStructure)) continue;
            DataStructure attrDS = attr.getReferencedObject();
            if (attrDS.equals((Object)thisDs)) {
                referedDss.add(addedDS.getObjectName());
                continue;
            }
            this.checkCyclicReference(thisDs, attrDS, referedDss);
        }
    }

    private void initialize() {
        if (this.datastructureName != null) {
            this.dsNameText.setText(this.datastructureName);
            this.setTitle(mTextPool.getText("DS_OPERWZRD_0004"));
            this.setDescription(mTextPool.getText("ASI_OPERWZRD_0005"));
            this.dsNameText.setEditable(false);
        } else {
            this.setTitle(mTextPool.getText("DS_OPERWZRD_0000"));
            this.setDescription(mTextPool.getText("DS_OPERWZRD_0001"));
        }
    }

    private DataStructureTableModel initializeTableModel() {
        Object[][] atrData = null;
        if (this.datastructureName != null) {
            DataStructure ds = (DataStructure)this.bomsystem.getApplicationDataStructures().get(this.datastructureName);
            List attributes = ds.getAttributes();
            int numMethods = attributes.size();
            atrData = new Object[numMethods][4];
            int i = 0;
            while (i < numMethods) {
                Attribute attribute = (Attribute)attributes.get(i);
                atrData[i][0] = attribute.getObjectName();
                atrData[i][2] = ApplicationServiceOperationsPage.atrListType[attribute.getListType()];
                if (attribute.getReferencedObject() == null) {
                    atrData[i][1] = attribute.getTypeJavaDdic();
                    this.refObjects.add(attribute.getTypeJavaDdic());
                } else {
                    atrData[i][1] = attribute.getReferencedObject().getObjectName();
                    this.refObjects.add(attribute.getReferencedObject());
                }
                atrData[i][3] = attribute.getObjectId();
                ++i;
            }
        } else {
            atrData = new Object[this.m_defaultDsAttr.size()][4];
            int i = 0;
            while (i < this.m_defaultDsAttr.size()) {
                DSAttributeTO defAttrib = (DSAttributeTO)this.m_defaultDsAttr.get(i);
                atrData[i][0] = defAttrib.getName();
                atrData[i][1] = defAttrib.getSimpleJavatype();
                this.refObjects.add(defAttrib.getSimpleJavatype());
                atrData[i][2] = ApplicationServiceOperationsPage.atrListType[defAttrib.getCollectionType()];
                atrData[i][3] = "";
                ++i;
            }
        }
        this.defTableModel = new DataStructureTableModel(this, atrData, tableColumnNames);
        return this.defTableModel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DataStuctureModelDropTargetListener
    extends ModelDropTargetListener {
        DataStuctureModelDropTargetListener() {
            super(new String[]{"Java Type", "Data Structure", "Core Data Structure"});
        }

        protected void dropTypedSource(ModelElementSource elementSource) {
            String[] params = new String[elementSource.getParamsCount()];
            int i = 0;
            while (i < elementSource.getParamsCount()) {
                params[i] = elementSource.getParam(i);
                ++i;
            }
            DTOWizardPage1.this.addItemToDS(elementSource.name, elementSource.subDomain, params);
        }
    }

    private class DataStuctureModelDragSourceListener
    extends ModelDragSourceListener {
        DataStuctureModelDragSourceListener() {
            super(new String[]{ModelDragSourceListener.TABLE_ROW_SUBDOMAIN});
        }
    }

    private class CatalogModelDropTargetListener
    extends ModelDropTargetListener {
        private int[] dropCounts = new int[0];

        CatalogModelDropTargetListener() {
            super(new String[]{ModelDragSourceListener.TABLE_ROW_SUBDOMAIN});
        }

        public void dragOver(DropTargetEvent event) {
            event.feedback = 0;
            this.dropCounts = new int[DTOWizardPage1.this.refObjects.size()];
        }

        protected void dropTypedSource(ModelElementSource elementSource) {
            if (elementSource.getParamsCount() > 0) {
                boolean isupdated = false;
                int affectingdrops = 0;
                int rownumber = -1;
                try {
                    rownumber = new Integer(elementSource.getParam(0));
                }
                catch (NumberFormatException nfe) {
                    rownumber = -1;
                }
                if (rownumber >= 0) {
                    int i = 0;
                    while (i < rownumber) {
                        affectingdrops += this.dropCounts[i];
                        ++i;
                    }
                    if (DTOWizardPage1.this.defTableModel.getRowCount() >= rownumber - affectingdrops) {
                        DTOWizardPage1.this.defTableModel.removeRow(rownumber - affectingdrops);
                        DTOWizardPage1.this.refObjects.remove(rownumber - affectingdrops);
                        isupdated = true;
                    }
                }
                if (isupdated) {
                    this.dropCounts[rownumber] = 1;
                    DTOWizardPage1.this.dsTableviewer.getTableViewer().refresh();
                }
            }
        }
    }

    private class CatalogModelDragSourceListener
    extends ModelDragSourceListener {
        CatalogModelDragSourceListener() {
            super(new String[]{"Java Type", "Data Structure", "Core Data Structure"});
        }
    }

    protected class AddButtonListener
    extends SelectionAdapter {
        protected AddButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ISelection selection = DTOWizardPage1.this.serviceCatalogGenericTreeViewer.getTreeViewer().getSelection();
            if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
                DTOWizardPage1.this.updateStatus(mTextPool.getText("DTOWP1.Select_Attribute_Type"));
                return;
            }
            Object rightObj = ((IStructuredSelection)selection).getFirstElement();
            if (rightObj instanceof Entity) {
                Entity rightEntity = (Entity)rightObj;
                UniqueName un = rightEntity.getUniqueName();
                String[] unParameters = new String[un.getParametersCount()];
                int i = 0;
                while (i < un.getParametersCount()) {
                    unParameters[i] = un.getParameter(i);
                    ++i;
                }
                DTOWizardPage1.this.addItemToDS(un.getName(), un.getSubDomain(), unParameters);
            }
        }
    }

    protected class RemoveButtonListener
    extends SelectionAdapter {
        protected RemoveButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ISelection selection = DTOWizardPage1.this.dsTableviewer.getTableViewer().getSelection();
            if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
                return;
            }
            Object rightObj = ((IStructuredSelection)selection).getFirstElement();
            if (rightObj instanceof SapTableRow) {
                SapTableRow selectedRow = (SapTableRow)rightObj;
                if (DTOWizardPage1.this.defTableModel.getRowCount() >= selectedRow.getRowNum()) {
                    if (DTOWizardPage1.this.isDefaultAttribute((String)DTOWizardPage1.this.defTableModel.getValueAt(selectedRow.getRowNum(), 0))) {
                        DTOWizardPage1.this.updateStatus("This is a default attribute! It can not be deleted!");
                        return;
                    }
                    DTOWizardPage1.this.refObjects.remove(selectedRow.getRowNum());
                    DTOWizardPage1.this.defTableModel.removeRow(selectedRow.getRowNum());
                    DTOWizardPage1.this.dialogChanged();
                }
            }
        }
    }
}

