/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.BomPlugin;
import com.sap.caf.designer.StatusLineMessage;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.ApplicationInterfaceEditor;
import com.sap.caf.designer.editors.ApplicationServiceOperationsPage;
import com.sap.caf.designer.exception.CAFEclipseCoreException;
import com.sap.caf.designer.exception.CAFInvocationTargetException;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.util.DefaultValues;
import com.sap.caf.designer.wizards.DTOWizardPage1;
import com.sap.caf.designer.wizards.DataStructureTableModel;
import com.sap.caf.designer.wizards.OperationWizardPage02;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.AttributeObjectAssociation;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.MetamodelPackage;
import com.sap.caf.metamodel.ObjectAttributeAssociation;
import com.sap.tc.logging.Location;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class DTOWizard
extends Wizard
implements INewWizard {
    private static DefaultTableModel defTableModel;
    private static final TextPool mTextPool;
    private static final Location logger;
    private DTOWizardPage1 dTOWizardPage1;
    private ISelection selection;
    private String projName;
    private BOMSystem bomsystem;
    private IWizardPage previousPage;
    private String m_dsName;
    private ArrayList m_defaultDsAttr;
    static /* synthetic */ Class class$com$sap$caf$designer$wizards$DTOWizard;

    public DTOWizard() {
        this.setDefaultPageImageDescriptor(SapIdeUtilImages.getImageDescriptorFromIconsDirectory((IPluginDescriptor)BomPlugin.getDefault().getDescriptor(), (String)"wzBannerCompApplication.gif"));
        this.setWindowTitle(mTextPool.getText("DS_STATUSLINE_0003"));
    }

    public DTOWizard(String projectName, String aDsName, ArrayList defaultDSAttr) {
        this();
        this.projName = projectName;
        this.bomsystem = BOMSystem.getBOMSystem(projectName);
        this.m_dsName = aDsName;
        this.m_defaultDsAttr = defaultDSAttr;
    }

    public boolean isEditDD() {
        return this.m_dsName != null;
    }

    public void addPages() {
        logger.infoT("addPages " + this.projName);
        this.dTOWizardPage1 = new DTOWizardPage1(this.projName, this.m_dsName, this.m_defaultDsAttr);
        this.addPage((IWizardPage)this.dTOWizardPage1);
    }

    public boolean canFinish() {
        return this.dTOWizardPage1.isPageComplete();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (logger.beInfo()) {
            logger.infoT("Incorrect method type" + this.projName);
        }
    }

    public boolean performFinish() {
        logger.infoT("performFinish " + this.projName);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws CAFInvocationTargetException {
                try {
                    try {
                        DTOWizard.this.doFinish(monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private Attribute getAtrByObjectId(String objectId, List existingAttrList) {
        Iterator iExistingAttr = existingAttrList.iterator();
        while (iExistingAttr.hasNext()) {
            Attribute attr = (Attribute)iExistingAttr.next();
            if (!attr.getObjectId().equals(objectId)) continue;
            iExistingAttr.remove();
            return attr;
        }
        return null;
    }

    private void doFinish(IProgressMonitor monitor) throws CAFEclipseCoreException {
        DataStructure ds = null;
        try {
            String dsname = this.dTOWizardPage1.getDataStructureName();
            DataStructureTableModel atrTable = this.dTOWizardPage1.getAttributeTable();
            MetamodelPackage mpackage = this.bomsystem.getMetamodelPackage();
            LinkedList existingAttrList = new LinkedList();
            if (this.m_dsName != null) {
                ds = (DataStructure)this.bomsystem.getApplicationDataStructures().get(dsname);
                AttributeObjectAssociation attributeObjectAssociation = mpackage.getAttributeObjectAssociation();
                ObjectAttributeAssociation objectAttributeAssociation = mpackage.getObjectAttributeAssociation();
                existingAttrList.addAll(ds.getAttributes());
            } else {
                ds = mpackage.getDataStructure().createDataStructure();
                DefaultValues.setDefaults(ds, null);
                ds.setObjectName(dsname);
                ds.setObjectId(ds.refMofId());
            }
            DataStructureTableModel atrtable = this.dTOWizardPage1.getAttributeTable();
            List refObjects = this.dTOWizardPage1.getReferencedObject();
            int i = 0;
            while (i < refObjects.size()) {
                Attribute atr = null;
                if (atrtable.getValueAt(i, 3) == null || "".equals((String)atrtable.getValueAt(i, 3))) {
                    atr = mpackage.getAttribute().createAttribute();
                    DefaultValues.setDefaults(atr, DefaultValues.DEFAULT_ATTRIBUTE);
                    atr.setObjectId(atr.refMofId());
                    ds.getAttributes().add(atr);
                } else {
                    atr = this.getAtrByObjectId((String)atrtable.getValueAt(i, 3), existingAttrList);
                }
                if (atr != null) {
                    atr.setObjectName((String)atrtable.getValueAt(i, 0));
                    atr.setListType(new Integer(this.resolveListType((String)atrtable.getValueAt(i, 2))));
                    if (atr.getListType() != 2) {
                        atr.setMaxOccurs(new Integer(-1));
                    } else {
                        atr.setMaxOccurs(new Integer(1));
                    }
                    if (refObjects.get(i) instanceof DataStructure) {
                        atr.setReferencedObject((DataStructure)refObjects.get(i));
                    } else {
                        atr.setTypeJavaDdic((String)atrtable.getValueAt(i, 1));
                    }
                }
                ++i;
            }
            Iterator iAttrForDetete = existingAttrList.iterator();
            while (iAttrForDetete.hasNext()) {
                Attribute attrForDelete = (Attribute)iAttrForDetete.next();
                ds.getAttributes().remove(attrForDelete);
                attrForDelete.refDelete();
            }
            if (this.m_dsName == null) {
                this.bomsystem.getApplicationDataStructures().put(dsname, ds);
                this.bomsystem.getApplication().getBaseObjects().add(ds);
            }
            this.bomsystem.getModifiedServicesList().objectModified((BaseObject)ds);
            MetamodelProvider.setDirtyOn(this.projName);
            ApplicationInterfaceEditor.refreshInstances();
            OperationWizardPage02.refreshDialogTree();
            monitor.beginTask(mTextPool.getText("BOM_ALL_0005") + "...", 4);
            monitor.worked(1);
            StatusLineMessage slm = new StatusLineMessage();
            slm.printMessage(mTextPool.getText("DS_STATUSLINE_0002") + " " + ds.getObjectName() + " " + mTextPool.getText("BOM_STATUSLINE_0003"));
        }
        catch (Throwable th) {
            th.printStackTrace();
            this.throwCoreException(th.getMessage());
        }
    }

    private int resolveListType(String listtype) {
        int i = 0;
        while (i < ApplicationServiceOperationsPage.atrListType.length) {
            if (ApplicationServiceOperationsPage.atrListType[i].equals(listtype)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private void throwCoreException(String message) throws CAFEclipseCoreException {
        logger.infoT("THROWcORE EXCEPTION " + message);
        Status status = new Status(4, "com.sap.caf.designer", 0, message, null);
        throw new CAFEclipseCoreException((IStatus)status);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mTextPool = TextPool.getInstance();
        logger = Location.getLocation((Class)(class$com$sap$caf$designer$wizards$DTOWizard == null ? (class$com$sap$caf$designer$wizards$DTOWizard = DTOWizard.class$("com.sap.caf.designer.wizards.DTOWizard")) : class$com$sap$caf$designer$wizards$DTOWizard));
    }
}

