/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.BomPlugin;
import com.sap.caf.designer.exception.CAFFileNotFoundException;
import com.sap.caf.designer.exception.CAFIOException;
import com.sap.caf.designer.exception.CAFParserConfigurationException;
import com.sap.caf.designer.exception.CAFSAXException;
import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.tc.complib.ComponentType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CafComponentTypesReader {
    private static String VENDOR = "typevendor";
    private static String TYPE = "type";
    private static Element root;
    public static final String TYPE_CONFIG_FILE = "cafComponentTypes.xml";

    public static Element getComponentTypeElement(ComponentType type) throws CAFFileNotFoundException, CAFParserConfigurationException, CAFSAXException, CAFIOException {
        try {
            if (type == null) {
                return null;
            }
            Element typeElement = CafComponentTypesReader.getTypeElement(TYPE, type.getType(), null);
            return typeElement;
        }
        catch (FileNotFoundException fnfe) {
            throw new CAFFileNotFoundException(fnfe);
        }
        catch (ParserConfigurationException pce) {
            throw new CAFParserConfigurationException(pce);
        }
        catch (SAXException se) {
            throw new CAFSAXException(se);
        }
        catch (IOException se) {
            throw new CAFIOException(se);
        }
    }

    public static InputStream getComponentTypeXMLDefinition() throws CAFIOException, CAFFileNotFoundException {
        try {
            InputStream input = null;
            BomPlugin myPlugin = BomPlugin.getDefault();
            URL base = myPlugin.getDescriptor().find(new Path("").append(TYPE_CONFIG_FILE));
            if (base == null) {
                throw new CAFFileNotFoundException();
            }
            input = new URL(base, TYPE_CONFIG_FILE).openStream();
            return input;
        }
        catch (IOException se) {
            throw new CAFIOException(se);
        }
    }

    public static List getDependencies(ComponentType type) throws CAFFileNotFoundException, CAFParserConfigurationException, CAFSAXException, CAFIOException {
        try {
            if (type == null) {
                return null;
            }
            Element typeElement = type.getSubType() != null ? CafComponentTypesReader.getTypeElement(TYPE, type.getSubType(), null) : CafComponentTypesReader.getTypeElement(TYPE, type.getType(), null);
            return CafComponentTypesReader.getDependencies(typeElement);
        }
        catch (ParserConfigurationException pce) {
            throw new CAFParserConfigurationException(pce);
        }
        catch (SAXException se) {
            throw new CAFSAXException(se);
        }
        catch (IOException se) {
            throw new CAFIOException(se);
        }
    }

    public static Element getPatternElement(ComponentType type) throws CAFFileNotFoundException, CAFParserConfigurationException, CAFSAXException, CAFIOException {
        try {
            if (type == null) {
                return null;
            }
            Element typeElement = type.getSubType() != null ? CafComponentTypesReader.getTypeElement(TYPE, type.getSubType(), null) : CafComponentTypesReader.getTypeElement(TYPE, type.getType(), null);
            NodeList nodes = typeElement.getElementsByTagName("pattern");
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node instanceof Element) {
                    return (Element)node;
                }
                ++i;
            }
            return null;
        }
        catch (ParserConfigurationException pce) {
            throw new CAFParserConfigurationException(pce);
        }
        catch (SAXException se) {
            throw new CAFSAXException(se);
        }
        catch (IOException se) {
            throw new CAFIOException(se);
        }
    }

    public static DocumentBuilder createNewDocumentBuilder() throws CAFParserConfigurationException {
        try {
            return new DocumentBuilderFactoryImpl().newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new CAFParserConfigurationException(pce);
        }
    }

    protected static String getNameAttribute(Object element) {
        if (element != null && element instanceof Element) {
            Element node = (Element)element;
            return node.getAttribute("name");
        }
        return "";
    }

    private static List getDependencies(Element dependencies) {
        ArrayList<Node> list = new ArrayList<Node>();
        if (dependencies != null) {
            NodeList nodes = dependencies.getElementsByTagName("dependency");
            int i = 0;
            while (i < nodes.getLength()) {
                list.add(nodes.item(i));
                ++i;
            }
        }
        return list;
    }

    private static Element getElement(String name, Element obj) {
        if (obj != null) {
            NodeList children = obj.getChildNodes();
            int i = 0;
            while (children != null && i < children.getLength()) {
                if (children.item(i) instanceof Element && name.equals(children.item(i).getNodeName().toLowerCase())) {
                    return (Element)children.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    private static Element getElementRoot() throws CAFFileNotFoundException, CAFParserConfigurationException, CAFIOException, CAFSAXException {
        if (root == null) {
            Document mainDocument = null;
            InputStream input = null;
            try {
                input = CafComponentTypesReader.getComponentTypeXMLDefinition();
                mainDocument = CafComponentTypesReader.createNewDocumentBuilder().parse(input);
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                throw new CAFFileNotFoundException(ex);
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
                throw new CAFIOException(ioex);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                throw new CAFParserConfigurationException(e);
            }
            catch (SAXException se) {
                se.printStackTrace();
                throw new CAFSAXException(se);
            }
            root = (Element)mainDocument.getElementsByTagName("types").item(0);
        }
        return root;
    }

    private static Element getTypeElement(String type, String name, Element root) throws CAFFileNotFoundException, CAFParserConfigurationException, CAFSAXException, CAFIOException {
        if (name == null) {
            return null;
        }
        if (root == null) {
            root = CafComponentTypesReader.getElementRoot();
        }
        NodeList nodes = root.getElementsByTagName(type);
        int i = 0;
        while (i < nodes.getLength()) {
            Element element;
            Node node = nodes.item(i);
            if (node instanceof Element && name.equals((element = (Element)node).getAttribute("name"))) {
                return element;
            }
            ++i;
        }
        return null;
    }
}

