/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.BomPlugin;
import com.sap.caf.designer.StatusLineMessage;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.ApplicationInterfaceEditor;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditorInput;
import com.sap.caf.designer.exception.CAFEclipseCoreException;
import com.sap.caf.designer.exception.CAFInvocationTargetException;
import com.sap.caf.designer.exception.CAFResourceException;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.views.ModelTreeViewer;
import com.sap.caf.designer.wizards.BusinessEntityInterfaceWizardPage1;
import com.sap.caf.designer.wizards.BusinessEntityInterfaceWizardPage2;
import com.sap.caf.designer.wizards.BusinessEntityInterfaceWizardPage3;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class BusinessEntityInterfaceWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private BusinessEntityInterfaceWizardPage1 page;
    private BusinessEntityInterfaceWizardPage2 page2;
    private BusinessEntityInterfaceWizardPage3 page3;
    private ISelection selection;
    private String projName;

    public BusinessEntityInterfaceWizard() {
        this.setDefaultPageImageDescriptor(SapIdeUtilImages.getImageDescriptorFromIconsDirectory((IPluginDescriptor)BomPlugin.getDefault().getDescriptor(), (String)"wzBannerCompApplication.gif"));
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(mTextPool.getText("BOM_TITLE_0021"));
    }

    public BusinessEntityInterfaceWizard(String projName) {
        this();
        this.projName = projName;
    }

    public String getObjName() {
        return this.page.getObjectTextName();
    }

    public void addPages() {
        this.page = new BusinessEntityInterfaceWizardPage1(this.selection, this.projName);
        this.addPage((IWizardPage)this.page);
        this.page2 = new BusinessEntityInterfaceWizardPage2(this.selection, this.projName);
        this.page3 = new BusinessEntityInterfaceWizardPage3(this.selection, this.projName);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setForcePreviousAndNextButtons(false);
    }

    public boolean performFinish() {
        final String objName = this.getObjName();
        boolean localPersistency = false;
        boolean indexSearch = false;
        final String[][] selAttributes = null;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws CAFInvocationTargetException {
                try {
                    try {
                        BusinessEntityInterfaceWizard.this.doFinish(objName, "", "", false, false, selAttributes, monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)TextPool.getInstance().getText("BOM_ALL_0020"), (String)e.getMessage());
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)TextPool.getInstance().getText("BOM_ALL_0020"), (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String objName, String baseObjName, String ownerName, boolean localPersistency, boolean indexSearch, String[][] selAttributes, IProgressMonitor monitor) throws CAFEclipseCoreException {
        IEditorPart editPart = null;
        monitor.beginTask(mTextPool.getText("BOM_ALL_0005") + "...", 4);
        monitor.worked(1);
        try {
            BOMSystem bomsystem = BOMSystem.getBOMSystem(this.projName);
            CAFBusinessEntityInterface cbei = null;
            try {
                cbei = CAFBusinessEntityInterface.createBusinessEntityInterface(bomsystem, objName);
            }
            catch (CAFResourceException ex) {
                this.throwCoreException(((Throwable)((Object)ex)).getMessage());
            }
            BusinessEntityInterface bei = cbei.getBusinesEntityInterface();
            ModelTreeViewer.refreshInstances();
            ApplicationInterfaceEditor.refreshInstances();
            BusinessEntityInterfaceEditorInput eInput = new BusinessEntityInterfaceEditorInput(cbei);
            IWorkbenchPage workbenchActivePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            monitor.setTaskName(mTextPool.getText("BOM_TEXTWZRD_0005"));
            monitor.worked(2);
            if (workbenchActivePage != null) {
                editPart = workbenchActivePage.openEditor((IEditorInput)eInput, "com.sap.caf.designer.editors.BusinessEntityInterfaceEditor");
            }
            bomsystem.getModifiedServicesList().objectModified((BaseObject)bei);
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Editor could not be opened", (String)e.getMessage());
        }
        StatusLineMessage slm = new StatusLineMessage();
        slm.printMessage(mTextPool.getText("BOM_STATUSLINE_0002") + " " + objName + " " + mTextPool.getText("BOM_STATUSLINE_0003"));
        monitor.worked(3);
    }

    private void throwCoreException(String message) throws CAFEclipseCoreException {
        Status status = new Status(4, "com.sap.caf.designer", 0, message, null);
        throw new CAFEclipseCoreException((IStatus)status);
    }
}

