/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.generation.utils.GenerationUtilsDt;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.wizards.AttributeWizard;
import com.sap.caf.designer.wizards.TreeSelectionDSDialog;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.tools.velocity.utils.NamingRestrictions;
import com.sap.dictionary.tools.tableeditor.service.SimpletypeSelection;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.tc.logging.Location;
import java.util.Iterator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AttributeWizardPage
extends WizardPage {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$wizards$AttributeWizardPage == null ? (class$com$sap$caf$designer$wizards$AttributeWizardPage = AttributeWizardPage.class$("com.sap.caf.designer.wizards.AttributeWizardPage")) : class$com$sap$caf$designer$wizards$AttributeWizardPage);
    private Text attributeText;
    private Text attributeDescription;
    private Text dataTypeText;
    private Combo keyTypeCombo;
    private Button button;
    private AttributeWizard parentWiz;
    private BOMSystem bos;
    private Button isKeyCheckBox;
    private Button isComplexTypeCheckBox;
    private boolean isComplexTypeCheckBoxSelected = false;
    private DataStructure dataStructure = null;
    boolean descriptionFocus = false;
    boolean descriptionChanged = false;
    static /* synthetic */ Class class$com$sap$caf$designer$wizards$AttributeWizardPage;

    public AttributeWizardPage(AttributeWizard parent) {
        super("wizardPage");
        this.setTitle(mTextPool.getText("BOM_ATTRBTWZRD_0023"));
        this.setDescription(mTextPool.getText("BOM_ATTRBTWZRD_0013"));
        this.parentWiz = parent;
    }

    public String getAttributeDescription() {
        return this.attributeDescription.getText();
    }

    public String getAttributeName() {
        return this.attributeText.getText();
    }

    public String getDataType() {
        return this.dataTypeText.getText();
    }

    public boolean getIsComplexAttribute() {
        return this.isComplexTypeCheckBox.getSelection();
    }

    public boolean getIsKey() {
        return this.isKeyCheckBox.getSelection();
    }

    public int getKeyType() {
        if (this.keyTypeCombo == null) {
            return 2;
        }
        return this.keyTypeCombo.getSelectionIndex();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(mTextPool.getText("BOM_ATTRBTWZRD_0009", true));
        this.attributeText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.attributeText.setLayoutData((Object)gd);
        this.attributeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeWizardPage.this.dialogChanged();
                if (!AttributeWizardPage.this.descriptionChanged) {
                    AttributeWizardPage.this.attributeDescription.setText(AttributeWizardPage.this.attributeText.getText().trim());
                }
            }
        });
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText(mTextPool.getText("BOM_ATTRBTWZRD_0021", true));
        this.attributeDescription = new Text(container, 2052);
        this.attributeDescription.setText("");
        gd = new GridData(768);
        this.attributeDescription.setLayoutData((Object)gd);
        this.attributeDescription.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AttributeWizardPage.this.descriptionFocus = true;
            }

            public void focusLost(FocusEvent e) {
                AttributeWizardPage.this.descriptionFocus = false;
            }
        });
        this.attributeDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AttributeWizardPage.this.descriptionFocus) {
                    AttributeWizardPage.this.descriptionChanged = true;
                }
                if ("".equals(AttributeWizardPage.this.attributeDescription.getText())) {
                    AttributeWizardPage.this.descriptionChanged = false;
                }
                AttributeWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText("");
        this.isKeyCheckBox = new Button(container, 32);
        gd = new GridData(768);
        this.isKeyCheckBox.setLayoutData((Object)gd);
        this.isKeyCheckBox.setText(mTextPool.getText("BOM_ATTRBTWZRD_0004"));
        label = new Label(container, 0);
        label.setText("");
        this.isKeyCheckBox.setEnabled(this.parentWiz.isKeyAllowed);
        this.isKeyCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeWizardPage.this.isComplexTypeCheckBox.setEnabled(!AttributeWizardPage.this.isKeyCheckBox.getSelection() && !((AttributeWizardPage)AttributeWizardPage.this).parentWiz.isSubAttribute && ((AttributeWizardPage)AttributeWizardPage.this).parentWiz.isComplexAllowed);
            }
        });
        label = new Label(container, 0);
        label.setText("");
        this.isComplexTypeCheckBox = new Button(container, 32);
        gd = new GridData(768);
        this.isComplexTypeCheckBox.setLayoutData((Object)gd);
        this.isComplexTypeCheckBox.setText(mTextPool.getText("BOM_ATTRBT_0003"));
        this.isComplexTypeCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeWizardPage.this.isKeyCheckBox.setEnabled(!AttributeWizardPage.this.isComplexTypeCheckBox.getSelection() && ((AttributeWizardPage)AttributeWizardPage.this).parentWiz.isKeyAllowed);
                AttributeWizardPage.this.isComplexTypeCheckBoxSelected = AttributeWizardPage.this.isComplexTypeCheckBox.getSelection();
                AttributeWizardPage.this.dialogChanged();
            }
        });
        if (this.parentWiz.isSubAttribute) {
            this.isComplexTypeCheckBox.setEnabled(false);
        } else {
            this.isComplexTypeCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AttributeWizardPage.this.isComplexTypeCheckBoxSelected = AttributeWizardPage.this.isComplexTypeCheckBox.getSelection();
                    AttributeWizardPage.this.dataTypeText.setText("");
                    AttributeWizardPage.this.dialogChanged();
                }
            });
        }
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText(mTextPool.getText("BOM_ATTRBTWZRD_0002", true));
        gd = new GridData(768);
        this.dataTypeText = new Text(container, 2052);
        this.dataTypeText.setLayoutData((Object)gd);
        this.dataTypeText.setEnabled(false);
        this.button = new Button(container, 8);
        this.button.setText(mTextPool.getText("BOM_ALL_0002"));
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeWizardPage.this.handleBrowse();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
        this.attributeText.setFocus();
    }

    private void dialogChanged() {
        String dataType;
        String attributeText = this.getAttributeName();
        if (attributeText.trim().length() == 0) {
            this.updateStatus(mTextPool.getText("BOM_ATTRBTWZRD_0010"));
            return;
        }
        if (this.attributeDescription.getText().trim().length() == 0) {
            this.updateStatus(mTextPool.getText("BOM_ATTRBTWZRD_0010A"));
            return;
        }
        if (!GenerationUtilsDt.isValidAttributeIdentifier(attributeText)) {
            this.updateStatus(mTextPool.getText("BOM_ATTRBTWZRD_0017"));
            return;
        }
        if (attributeText != null && !NamingRestrictions.isValidAttributeName(attributeText)) {
            this.updateStatus(mTextPool.getText("BOM_ATTRBTWZRD_0018"));
            return;
        }
        String wrongName = this.parentWiz.boName;
        if (attributeText != null && this.isComplexTypeCheckBoxSelected && attributeText.equalsIgnoreCase(wrongName)) {
            this.updateStatus(mTextPool.getText("BOM_ATTRBTWZRD_0019"));
            return;
        }
        if (attributeText != null && this.isComplexTypeCheckBoxSelected && this.hasComplexAttributeWithThisName(attributeText)) {
            this.updateStatus(mTextPool.getText("BOM_ATTRBTWZRD_0020"));
            return;
        }
        if (!this.isComplexTypeCheckBoxSelected && (dataType = this.getDataType()).length() == 0) {
            this.updateStatus(mTextPool.getText("BOM_ATTRBTWZRD_0003"));
            return;
        }
        this.updateStatus(null);
    }

    private void handleBrowse() {
        if (!this.isComplexTypeCheckBox.getSelection()) {
            DtDictionaryRoot[] dicts = new DtDictionaryRoot[]{this.bos.getAppDdicRoot(), this.bos.getCoreDdicRoot()};
            logger.infoT("mDtDictionaryRoots: " + dicts[0] + "..." + dicts[1]);
            SimpletypeSelection selection = null;
            selection = dicts[0] == null && dicts[1] == null ? new SimpletypeSelection(new DtDictionaryRoot[0], Display.getDefault().getActiveShell()) : (dicts[1] == null ? new SimpletypeSelection(dicts[0], Display.getDefault().getActiveShell()) : new SimpletypeSelection(dicts, Display.getDefault().getActiveShell()));
            if (selection.open()) {
                String pack = selection.getSimpleType().getPackage();
                String st = selection.getSimpleType().getName();
                this.dataTypeText.setText(pack + "." + st);
                this.dialogChanged();
            }
        } else {
            TreeSelectionDSDialog dialog = new TreeSelectionDSDialog(this.getShell(), this.bos);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                this.dataStructure = (DataStructure)dialog.getResult();
                this.dataTypeText.setText(this.dataStructure.getObjectName());
            }
        }
    }

    private boolean hasComplexAttributeWithThisName(String attributeName) {
        boolean result = false;
        Iterator complexAtrributesNamesIter = this.parentWiz.getComplexAttributesNames().iterator();
        while (complexAtrributesNamesIter.hasNext()) {
            String cxAttribName = (String)complexAtrributesNamesIter.next();
            if (!attributeName.equalsIgnoreCase(cxAttribName)) continue;
            result = true;
        }
        return result;
    }

    private void initialize() {
        this.dataTypeText.setText("");
        this.bos = BOMSystem.getBOMSystem(this.parentWiz.projName);
        if (this.parentWiz.attrType.equals("AttributeAttribute")) {
            this.isKeyCheckBox.setEnabled(false);
        }
    }

    private void updateStatus(String message) {
        if (this.attributeText.getText().equals("")) {
            this.setMessage(mTextPool.getText("BOM_ATTRBTWZRD_0022"));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public DataStructure getDataStructure() {
        return this.dataStructure;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

