/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.BomPlugin;
import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditor;
import com.sap.caf.designer.exception.CAFEclipseCoreException;
import com.sap.caf.designer.exception.CAFInvocationTargetException;
import com.sap.caf.designer.exception.CAFResourceException;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.wizards.AttributeWizardPage;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.Property;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AttributeWizard
extends Wizard
implements INewWizard {
    private AttributeWizardPage page;
    private static final TextPool mTextPool = TextPool.getInstance();
    static final String FIELDATTR = "FieldAttribute";
    static final String ATTRATTR = "AttributeAttribute";
    String projName;
    String appName;
    String objName;
    String attrType;
    String boName;
    private BOMSystem bos;
    private Element element;
    boolean isSubAttribute = false;
    boolean isKeyAllowed = true;
    boolean isComplexAllowed = true;
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$wizards$AttributeWizard == null ? (class$com$sap$caf$designer$wizards$AttributeWizard = AttributeWizard.class$("com.sap.caf.designer.wizards.AttributeWizard")) : class$com$sap$caf$designer$wizards$AttributeWizard);
    private BusinessEntityInterfaceEditor editor;
    static /* synthetic */ Class class$com$sap$caf$designer$wizards$AttributeWizard;

    public AttributeWizard(Element element, String attrType, String objName) {
        if (attrType.equals(FIELDATTR)) {
            this.editor = BusinessEntityInterfaceEditor.getBusinessEntityInterfaceEditor(element.getUniqueName().getParameter(0), objName);
            this.boName = objName;
            this.objName = null;
        } else {
            this.boName = element.getUniqueName().getParameter(1);
            this.objName = objName;
            this.editor = BusinessEntityInterfaceEditor.getBusinessEntityInterfaceEditor(element.getUniqueName().getParameter(0), element.getUniqueName().getParameter(1));
        }
        if (this.editor != null) {
            // empty if block
        }
        this.setDefaultPageImageDescriptor(SapIdeUtilImages.getImageDescriptorFromIconsDirectory((IPluginDescriptor)BomPlugin.getDefault().getDescriptor(), (String)"wzBannerCompApplication.gif"));
        this.setNeedsProgressMonitor(true);
        this.attrType = attrType;
        this.element = element;
        this.appName = element.getUniqueName().getParameter(0);
        this.projName = BOMSystem.getProjectNameFromAppName(this.appName);
        if (ATTRATTR.equals(attrType)) {
            this.isSubAttribute = true;
            this.isComplexAllowed = false;
        }
        this.setWindowTitle(TextPool.getInstance().getText("BOM_ATTRBTWZRD_0014"));
    }

    public void addPages() {
        this.page = new AttributeWizardPage(this);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final Element element = this.element;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws CAFInvocationTargetException {
                try {
                    try {
                        AttributeWizard.this.doFinish(AttributeWizard.this.attrType, element, monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException e) {
            String message = e.getMessage();
            if (message == null || "".equals(message)) {
                message = mTextPool.getText("BOM_ATTRBTWZRD_0016");
            }
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            String message = realException.getMessage();
            if (message == null || "".equals(message)) {
                message = mTextPool.getText("BOM_ATTRBTWZRD_0016");
            }
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
            return false;
        }
        return true;
    }

    public void doFinish(String attrType, Element element, IProgressMonitor monitor) throws CAFEclipseCoreException {
        logger.infoT("projName: " + this.projName);
        logger.infoT("boName: " + this.boName);
        logger.infoT("objName: " + this.objName);
        monitor.beginTask(mTextPool.getText("BOM_ATTRBTWZRD_0001") + " " + this.objName, 5);
        monitor.worked(1);
        monitor.setTaskName(mTextPool.getText("BOM_ATTRBTWZRD_0012"));
        Property cafAttribute = null;
        Property cafAttributeAttribute = null;
        BusinessEntityInterface bei = this.editor.getBusinessEntityInterface();
        BOMSystem bos = this.editor.getBOMSystem();
        CAFBusinessEntityInterface cbei = this.editor.getCAFBusinessEntityInterface();
        if (cbei == null) {
            // empty if block
        }
        if (attrType.equals(FIELDATTR)) {
            if (cbei.getAttributeByName(this.getAttributeName()) != null) {
                this.throwCoreException(mTextPool.getText("BOM_ATTRBT_0002", new Object[]{this.getAttributeName()}));
            }
            if (this.getIsKey()) {
                cafAttribute = cbei.addKeyAttribute(this.getAttributeName());
                if (this.getKeyType() == 2) {
                    cafAttribute.setMinOccurs(new Integer(1));
                } else {
                    cafAttribute.setMinOccurs(new Integer(0));
                }
                cafAttribute.setTypeJavaDdic(this.getDataType());
            } else if (this.getIsComplexAttribute()) {
                try {
                    cafAttribute = cbei.addComplexAttribute(this.getAttributeName());
                    if (!"".equals(this.page.getDataType()) && this.page.getDataStructure() != null) {
                        Iterator itAttr = this.page.getDataStructure().getAttributes().iterator();
                        cafAttribute.setHollow(new Boolean(true));
                        while (itAttr.hasNext()) {
                            Attribute dsAttr = (Attribute)itAttr.next();
                            Property subAttribute = cbei.addSubAttribute((Attribute)cafAttribute, dsAttr.getObjectName(), false);
                            subAttribute.setTypeJavaDdic(dsAttr.getTypeJavaDdic());
                            subAttribute.setHollow(new Boolean(true));
                            subAttribute.setShortText(dsAttr.getObjectName());
                        }
                    }
                }
                catch (CAFResourceException ex) {
                    logger.errorT("Could not create attribute with type:" + attrType + ".Error is:" + ((Throwable)((Object)ex)).getMessage());
                    ((Throwable)((Object)ex)).printStackTrace();
                }
            } else {
                cafAttribute = cbei.addSimpleAttribute(this.getAttributeName());
                cafAttribute.setTypeJavaDdic(this.getDataType());
            }
            cafAttribute.setObjectName(this.getAttributeName());
        } else if (attrType.equals(ATTRATTR)) {
            Attribute complex = cbei.getAttributeByName(this.objName);
            if (cbei.getSubAttributeByName(complex, this.getAttributeName()) != null) {
                this.throwCoreException(mTextPool.getText("BOM_ATTRBT_0002", new Object[]{this.getAttributeName()}));
            }
            if (this.getIsKey()) {
                cafAttributeAttribute = cbei.addSubAttribute(complex, this.getAttributeName(), this.getIsKey());
                cafAttributeAttribute.setTypeJavaDdic(this.getDataType());
            } else {
                cafAttributeAttribute = cbei.addSubAttribute(complex, this.getAttributeName(), this.getIsKey());
                if (cafAttributeAttribute == null) {
                    this.throwCoreException(mTextPool.getText("BOM_ATTRBT_0002", new Object[]{this.getAttributeName()}));
                }
                cafAttributeAttribute.setTypeJavaDdic(this.getDataType());
            }
        }
        if (cafAttribute != null) {
            cafAttribute.setShortText(this.page.getAttributeDescription());
        }
        if (cafAttributeAttribute != null) {
            cafAttributeAttribute.setShortText(this.page.getAttributeDescription());
        }
        monitor.worked(2);
        monitor.setTaskName(mTextPool.getText("BOM_ATTRBTWZRD_0011"));
        Object editPart = null;
        this.editor.setDirty(true);
        this.editor.getAttributesPage().setStatusLine(this.getAttributeName());
        this.editor.getAttributesPage().refresh();
        if (cafAttribute != null) {
            bos.notifyCAFObjectChanged(cafAttribute, 35);
        }
        if (cafAttributeAttribute != null) {
            bos.notifyCAFObjectChanged(cafAttributeAttribute, 35);
        }
        monitor.worked(3);
        if (attrType.equals(FIELDATTR)) {
            // empty if block
        }
        monitor.worked(4);
    }

    public Collection getComplexAttributesNames() {
        ArrayList<String> result = new ArrayList<String>();
        CAFBusinessEntityInterface cbei = this.editor.getCAFBusinessEntityInterface();
        List attributesList = cbei.getBusinesEntityInterface().getBusinessEntity().getAttributes();
        if (attributesList != null) {
            Iterator attrIterator = attributesList.iterator();
            while (attrIterator.hasNext()) {
                Attribute currentAttribute = (Attribute)attrIterator.next();
                if (currentAttribute.getTypeJavaDdic() != null && (currentAttribute.getTypeJavaDdic() == null || !currentAttribute.getTypeJavaDdic().equals("")) || currentAttribute.getMinOccurs() == null || currentAttribute.getMinOccurs() != 0) continue;
                result.add(currentAttribute.getObjectName());
            }
        }
        return result;
    }

    private void throwCoreException(String message) throws CAFEclipseCoreException {
        Status status = new Status(4, "com.sap.caf.designer", 0, message, null);
        throw new CAFEclipseCoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public String getAttributeName() {
        return this.page.getAttributeName();
    }

    public String getDataType() {
        return this.page.getDataType();
    }

    public boolean getIsKey() {
        return this.page.getIsKey();
    }

    public int getKeyType() {
        return this.page.getKeyType();
    }

    public boolean getIsComplexAttribute() {
        return this.page.getIsComplexAttribute();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

