/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.utils.EntityNamesStringUtil;
import com.sap.tc.logging.Location;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ApplicationServiceWizardPage1
extends WizardPage {
    private static String RESERVED_WORD = "ApplicationService";
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$wizards$ApplicationServiceWizardPage1 == null ? (class$com$sap$caf$designer$wizards$ApplicationServiceWizardPage1 = ApplicationServiceWizardPage1.class$("com.sap.caf.designer.wizards.ApplicationServiceWizardPage1")) : class$com$sap$caf$designer$wizards$ApplicationServiceWizardPage1);
    private Text objectText;
    private Text applicationText;
    private ISelection selection;
    private String initProjName;
    private BOMSystem mBomsystem;
    static /* synthetic */ Class class$com$sap$caf$designer$wizards$ApplicationServiceWizardPage1;

    public ApplicationServiceWizardPage1(ISelection selection, String initProjName) {
        super("AS wizardPage");
        this.setTitle(mTextPool.getText("ASI_TITLE_0017"));
        this.setDescription(mTextPool.getText("ASI_TITLE_0015"));
        this.selection = selection;
        this.initProjName = initProjName;
        this.mBomsystem = BOMSystem.getBOMSystem(initProjName);
    }

    public String getApplicationName() {
        return this.applicationText.getText();
    }

    public String getObjectTextName() {
        return this.objectText.getText();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText(mTextPool.getText("ASI_TITLE_0018", true));
        this.objectText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.objectText.setLayoutData((Object)gd);
        this.objectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ApplicationServiceWizardPage1.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText(mTextPool.getText("BOM_GENERAL_0002", true));
        this.applicationText = new Text(container, 2052);
        gd = new GridData(768);
        this.applicationText.setLayoutData((Object)gd);
        this.applicationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ApplicationServiceWizardPage1.this.dialogChanged();
            }
        });
        logger.infoT("ASwizard projectname=" + this.initProjName);
        this.applicationText.setText(this.mBomsystem.getApplicationName());
        if (this.applicationText.getText().length() == 0) {
            Integer length = new Integer(this.applicationText.getText().length());
            this.applicationText.setEnabled(true);
            Button appButton = new Button(container, 8);
            appButton.setText(mTextPool.getText("BOM_ALL_0002"));
            appButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                }
            });
        } else {
            this.applicationText.setEnabled(false);
            label = new Label(container, 0);
            label.setText("");
        }
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
        this.objectText.setFocus();
    }

    private void dialogChanged() {
        String objectText = this.getObjectTextName();
        String applicationName = this.getApplicationName();
        Set asnames = this.mBomsystem.getApplicationInterfaces().keySet();
        Set bsnames = this.mBomsystem.getBusinessEntityInterfaces().keySet();
        Set coreapp = this.mBomsystem.getCoreApplicationInterfaces().keySet();
        Set corebs = this.mBomsystem.getCoreBusinessEntities().keySet();
        String error = EntityNamesStringUtil.isClassNameValid(TextPool.getInstance().getText("ASI_STATUSLINE_0002"), objectText, asnames, bsnames, coreapp, corebs, applicationName, true);
        if (error == null && RESERVED_WORD.equals(objectText)) {
            error = TextPool.getInstance().getText("ASI.RESERVED.NAME");
        }
        this.updateStatus(error);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                if (obj instanceof IContainer) {
                    IContainer container = (IContainer)obj;
                } else {
                    IContainer iContainer = ((IResource)obj).getParent();
                }
            }
        }
        this.applicationText.setText(this.mBomsystem.getApplicationName());
    }

    private void updateStatus(String message) {
        if (this.objectText.getText().equals("")) {
            this.setMessage(mTextPool.getText("ASI_TITLE_0022"));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

