/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.wizards;

import com.sap.caf.designer.BomPlugin;
import com.sap.caf.designer.Logger;
import com.sap.caf.designer.StatusLineMessage;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.ApplicationInterfaceEditorInput;
import com.sap.caf.designer.exception.CAFEclipseCoreException;
import com.sap.caf.designer.exception.CAFInvocationTargetException;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFApplicationInterface;
import com.sap.caf.designer.views.ModelTreeViewer;
import com.sap.caf.designer.wizards.ApplicationServiceWizardPage1;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.MetamodelPackage;
import com.sap.tc.logging.Location;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ApplicationServiceWizard
extends Wizard
implements INewWizard {
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$wizards$ApplicationServiceWizard == null ? (class$com$sap$caf$designer$wizards$ApplicationServiceWizard = ApplicationServiceWizard.class$("com.sap.caf.designer.wizards.ApplicationServiceWizard")) : class$com$sap$caf$designer$wizards$ApplicationServiceWizard);
    private static final TextPool mTextPool = TextPool.getInstance();
    private ApplicationServiceWizardPage1 page;
    private ISelection selection;
    private String projName;
    static /* synthetic */ Class class$com$sap$caf$designer$wizards$ApplicationServiceWizard;

    public ApplicationServiceWizard() {
        this.setDefaultPageImageDescriptor(SapIdeUtilImages.getImageDescriptorFromIconsDirectory((IPluginDescriptor)BomPlugin.getDefault().getDescriptor(), (String)"wzBannerCompApplication.gif"));
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(TextPool.getInstance().getText("ASI_TITLE_0021"));
    }

    public ApplicationServiceWizard(String projName) {
        this();
        this.projName = projName;
    }

    public String getObjName() {
        return this.page.getObjectTextName();
    }

    public void addPages() {
        this.page = new ApplicationServiceWizardPage1(this.selection, this.projName);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setForcePreviousAndNextButtons(false);
    }

    public boolean performFinish() {
        final String objName = this.getObjName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws CAFInvocationTargetException {
                try {
                    try {
                        ApplicationServiceWizard.this.doFinish(objName, monitor);
                    }
                    catch (CoreException e) {
                        throw new CAFInvocationTargetException(e);
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)mTextPool.getText("BOM_ALL_0020"), (String)e.getMessage());
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            String message = realException.getMessage();
            if (message == null || "".equals(message)) {
                message = mTextPool.getText("ASI_ATTRBTWZRD_0016");
            }
            MessageDialog.openError((Shell)this.getShell(), (String)mTextPool.getText("BOM_ALL_0020"), (String)message);
            return false;
        }
        return true;
    }

    private void doFinish(String objName, IProgressMonitor monitor) throws CAFEclipseCoreException {
        IEditorPart editPart = null;
        monitor.beginTask(mTextPool.getText("BOM_ALL_0005") + "...", 4);
        monitor.worked(1);
        CAFApplicationInterface cafAppSinterface = null;
        try {
            BOMSystem bomsystem = BOMSystem.getBOMSystem(this.projName);
            MetamodelPackage mpackage = bomsystem.getMetamodelPackage();
            ApplicationInterface appInterface = mpackage.getApplicationInterface().createApplicationInterface();
            appInterface.setObjectName(objName);
            appInterface.setObjectId(appInterface.refMofId());
            cafAppSinterface = new CAFApplicationInterface(bomsystem, appInterface);
            bomsystem.notifyCreateApplicationServiceBefore(cafAppSinterface);
            bomsystem.getApplication().getBaseObjects().add(appInterface);
            bomsystem.getApplicationInterfaces().put(objName, cafAppSinterface);
            bomsystem.notifyCreateApplicationServiceAfter(cafAppSinterface);
            ModelTreeViewer.refreshInstances();
            ApplicationInterfaceEditorInput eInput = new ApplicationInterfaceEditorInput(cafAppSinterface);
            IWorkbenchPage workbenchActivePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            monitor.setTaskName(mTextPool.getText("BOM_TEXTWZRD_0005"));
            monitor.worked(2);
            if (workbenchActivePage != null) {
                editPart = workbenchActivePage.openEditor((IEditorInput)eInput, "com.sap.caf.designer.editors.ApplicationInterfaceEditor");
            }
            bomsystem.getModifiedServicesList().objectModified((BaseObject)appInterface);
        }
        catch (Exception e) {
            logger.errorT("Could not create the Application Service:" + objName);
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)TextPool.getInstance().getText("ASI.Editor_could_not_be_opened_1"), (String)e.getMessage());
        }
        StatusLineMessage slm = new StatusLineMessage();
        slm.printMessage(mTextPool.getText("ASI_STATUSLINE_0002") + " " + objName + " " + mTextPool.getText("BOM_STATUSLINE_0003"));
        monitor.worked(3);
    }

    private void throwCoreException(String message) throws CAFEclipseCoreException {
        Status status = new Status(4, "com.sap.caf.designer", 0, message, null);
        throw new CAFEclipseCoreException((IStatus)status);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

