/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.webdynpro.mmrexport;

import com.sap.caf.designer.webdynpro.mmrexport.MMRRelation;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MMRNode {
    private String m_entityType = null;
    private String m_nameAttr = "objectName";
    private String m_idAttr = "objectID";
    MMRNode m_parent = null;
    MMRNode m_root = null;
    private Map m_attrs = new HashMap();
    private Collection m_children = new ArrayList();
    private Collection m_allNodes = new ArrayList();
    private Map m_relations = new HashMap();

    protected MMRNode() {
    }

    public MMRNode(String entityType) {
        this.m_entityType = entityType;
    }

    public final Collection getAllChildren() {
        return new ArrayList(this.m_children);
    }

    public final Collection getAllRelations() {
        return new ArrayList(this.m_relations.values());
    }

    public void setAttribute(String attrName, String value) {
        this.m_attrs.put(attrName, value);
    }

    public String getAttribute(String attrName) {
        return (String)this.m_attrs.get(attrName);
    }

    public final MMRNode getChild(String entityType, String name) {
        Iterator it = this.m_children.iterator();
        while (it.hasNext()) {
            MMRNode child = (MMRNode)it.next();
            if (!entityType.equals(child.getEntityType()) || !name.equals(child.getNodeName())) continue;
            return child;
        }
        return null;
    }

    public final Collection getChildrenOfType(String entityType) {
        ArrayList<MMRNode> result = new ArrayList<MMRNode>();
        Iterator it = this.m_children.iterator();
        while (it.hasNext()) {
            MMRNode child = (MMRNode)it.next();
            if (!entityType.equals(child.getEntityType())) continue;
            result.add(child);
        }
        return result;
    }

    public String getEntityType() {
        return this.m_entityType;
    }

    public void setIdAttribute(String attr) {
        this.m_idAttr = attr;
    }

    public String getIdAttribute() {
        return this.m_idAttr;
    }

    public void setNamingAttribute(String attr) {
        this.m_nameAttr = attr;
    }

    public String getNamingAttribute() {
        return this.m_nameAttr;
    }

    public final void setNodeId(String id) {
        this.setAttribute(this.getIdAttribute(), id);
    }

    public final String getNodeId() {
        return this.getAttribute(this.getIdAttribute());
    }

    public final void setNodeName(String name) {
        this.setAttribute(this.getNamingAttribute(), name);
    }

    public final String getNodeName() {
        return this.getAttribute(this.getNamingAttribute());
    }

    public final MMRRelation getRelation(String relationName) {
        return (MMRRelation)this.m_relations.get(relationName);
    }

    public final MMRRelation addRelation(String name, MMRNode target, int minOccurs, int maxOccurs) {
        MMRRelation result = new MMRRelation(this, target, name, minOccurs, maxOccurs);
        this.m_relations.put(name, result);
        return result;
    }

    public final MMRNode appendChild(String entityType, String name) {
        MMRNode result = this.createChild(entityType);
        result.setNodeName(name);
        result.m_parent = this;
        result.m_root = this.m_root == null ? this : this.m_root;
        this.m_children.add(result);
        this.m_allNodes.add(result);
        return result;
    }

    public final boolean removeChild(MMRNode node) {
        return this.m_children.remove(node);
    }

    public final boolean removeChild(String entityType, String name) {
        boolean result;
        MMRNode child = this.getChild(entityType, name);
        boolean bl = result = child != null;
        if (result) {
            this.removeChild(child);
        }
        return result;
    }

    public MMRNode getParentNode() {
        return this.m_parent;
    }

    public MMRNode getParentOfType(String entityType) {
        MMRNode parent = this.getParentNode();
        while (parent != null && !parent.getEntityType().equals(entityType)) {
            parent = parent.getParentNode();
        }
        return parent;
    }

    public MMRNode getRootNode() {
        return this.m_root;
    }

    public final boolean removeRelation(String relationName) {
        return this.m_relations.remove(relationName) != null;
    }

    public String getStringOfSpaces(int spacesCount) {
        if (spacesCount <= 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(spacesCount);
        int i = 0;
        while (i < spacesCount) {
            result.append(" ");
            ++i;
        }
        return result.toString();
    }

    public void writeToPrintStream(PrintStream out) {
        this.__writeToPrintStream(out, 0);
    }

    protected void __writeToPrintStream(PrintStream out, int level) {
        StringBuffer line = new StringBuffer();
        line.append(this.getStringOfSpaces(level * 2));
        line.append("EntityType: ");
        line.append(this.getEntityType());
        line.append("  NAME:");
        line.append(this.getNodeName());
        line.append("  MOFID:");
        line.append(this.getNodeId());
        out.println(line);
        out.println(this.getStringOfSpaces(level * 2) + " Attributes:" + this.m_attrs.toString());
        out.println(this.getStringOfSpaces(level * 2) + " Childs:");
        Iterator it = this.m_children.iterator();
        while (it.hasNext()) {
            MMRNode child = (MMRNode)it.next();
            child.__writeToPrintStream(out, level + 1);
        }
        out.println(this.getStringOfSpaces(level * 2) + " Relations:");
        Set relationsSet = this.m_relations.entrySet();
        Iterator it2 = relationsSet.iterator();
        while (it2.hasNext()) {
            Map.Entry entry = it2.next();
            MMRRelation relation = (MMRRelation)entry.getValue();
            String relationName = (String)entry.getKey();
            out.println(this.getStringOfSpaces((level + 1) * 2) + relationName + " MIN_OCCURS:" + relation.getMinOccurs() + " MAX_OCCURS:" + relation.getMaxOccurs());
            out.println(this.getStringOfSpaces((level + 1) * 2) + " TARGET:" + relation.getTarget().getNodeName());
        }
    }

    protected MMRNode createChild(String entityType) {
        return new MMRNode(entityType);
    }
}

