/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.webdynpro.mmrexport;

import com.sap.caf.designer.exception.CAFRuntimeException;
import com.sap.caf.designer.webdynpro.mmrexport.MMRApplication;
import com.sap.caf.designer.webdynpro.mmrexport.MMRDataStructure;
import com.sap.caf.designer.webdynpro.mmrexport.MMRNode;
import com.sap.caf.designer.webdynpro.mmrexport.MMROperation;
import java.util.Collection;
import java.util.Iterator;

public class MMRInterface
extends MMRNode {
    private MMRDataStructure m_do = null;

    MMRInterface(String entityName) {
        super(entityName);
        if (!"ApplicationInterface".equals(entityName) && !"BusinessEntityInterface".equals(entityName)) {
            throw new CAFRuntimeException("Incorrect entity name: " + entityName);
        }
    }

    public Collection getAllOperations() {
        Collection result = this.getChildrenOfType("Operation");
        if ("DataObject".equals(this.getEntityType())) {
            Iterator it = result.iterator();
            while (it.hasNext()) {
                MMROperation ope = (MMROperation)it.next();
                if (ope.getOutput() == this.m_do) continue;
                it.remove();
            }
        }
        return result;
    }

    public MMRApplication getApplication() {
        return (MMRApplication)this.getParentNode();
    }

    public MMROperation getOperation(String operationName) {
        MMROperation result = (MMROperation)this.getChild("Operation", operationName);
        if ("DataObject".equals(this.getEntityType()) && result.getOutput() != this.m_do) {
            result = null;
        }
        return result;
    }

    public MMRDataStructure getUnderlyingDO() {
        return (MMRDataStructure)this.getChildrenOfType("DataObject").iterator().next();
    }

    public MMROperation createOperation(String operationName) {
        MMROperation result = (MMROperation)this.appendChild("Operation", operationName);
        if ("DataObject".equals(this.getEntityType())) {
            result.setOutput(this.m_do);
        }
        return result;
    }

    public void createUnderlyingDO(String doName) {
        Iterator it = this.getChildrenOfType("DataObject").iterator();
        while (it.hasNext()) {
            this.removeChild((MMRNode)it.next());
        }
        if (!"BusinessEntityInterface".equals(this.getEntityType())) {
            throw new CAFRuntimeException("Underlying bo can be set for business entity interface only, while found " + this.getEntityType());
        }
        this.appendChild("DataObject", doName);
    }

    public boolean removeQuery(String operationName) {
        return this.removeChild("Operation", operationName);
    }

    protected MMRNode createChild(String entityType) {
        if ("Operation".equals(entityType)) {
            return new MMROperation();
        }
        if ("DataStructure".equals(entityType) || "DataObject".equals(entityType)) {
            return new MMRDataStructure(entityType);
        }
        return super.createChild(entityType);
    }
}

