/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.webdynpro.mmrexport;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.CAFRuntimeException;
import com.sap.caf.designer.webdynpro.mmrexport.MMRApplication;
import com.sap.caf.designer.webdynpro.mmrexport.MMRAttribute;
import com.sap.caf.designer.webdynpro.mmrexport.MMRDataStructure;
import com.sap.caf.designer.webdynpro.mmrexport.MMRInterface;
import com.sap.caf.designer.webdynpro.mmrexport.MMRNode;
import com.sap.caf.designer.webdynpro.mmrexport.MMROperation;
import com.sap.caf.designer.webdynpro.mmrexport.MMRRelation;
import com.sap.caf.designer.webdynpro.mmrexport.VelocityTools;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.repository.IMMRepositoryObjectProvider;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.framework.ModelType;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MMRExporter {
    private static final String MODEL_CLASS = "WD_className";
    private static final String MODEL_PACKAGE = "WD_packageName";
    private static final String MODEL_NAME = "WD_modelName";
    private MMRNode m_hostApp;
    private Map m_exportedNodes = new HashMap();
    private Collection m_exportedRelations = new ArrayList();
    private Collection m_changedMDOs = new ArrayList();
    private Collection m_addedMDOs = new ArrayList();
    private DtDictionaryRoot dtDictRoot = null;
    private WebDynproRoot wdRoot = null;
    private Model wdModel = null;
    private Map m_usedModels = new HashMap();
    private boolean m_modelDefinitionChanged;
    private boolean m_preparing;

    public String getClassName(MMRNode node) {
        String entityName = node.getEntityType();
        if (node instanceof MMROperation) {
            return (((MMROperation)node).getOutput() == null ? "C" : "Q") + this.toTitleCase(((MMROperation)node).getInterface().getNodeName()) + this.toTitleCase(node.getNodeName());
        }
        if (node instanceof MMRDataStructure) {
            if ("InputStructure".equals(entityName)) {
                MMROperation ope = (MMROperation)node.getParentNode();
                return "P" + this.toTitleCase(ope.getInterface().getNodeName()) + this.toTitleCase(ope.getNodeName());
            }
            if ("DataStructure".equals(entityName) || "DataObject".equals(entityName)) {
                return "A" + this.toTitleCase(node.getNodeName());
            }
        }
        throw new CAFRuntimeException("Entity type " + node.getEntityType() + " does not correspond to any WD model class");
    }

    public String getClassPackage(MMRNode node) {
        String entityName = node.getEntityType();
        if (node instanceof MMRInterface) {
            return this.getClassPackage(((MMRInterface)node).getApplication()) + "." + node.getNodeName().toLowerCase();
        }
        if (node instanceof MMRApplication) {
            String modelName = node.getAttribute(MODEL_NAME);
            String pckg = this.revertPackage(node.getAttribute("providerName")) + "." + node.getNodeName().toLowerCase() + ".services";
            if (modelName != null && !"".equals(modelName)) {
                pckg = pckg + "." + modelName.toLowerCase();
            }
            return pckg;
        }
        if (node instanceof MMROperation) {
            return this.getClassPackage(((MMROperation)node).getInterface());
        }
        if (node instanceof MMRDataStructure) {
            if ("DataObject".equals(entityName)) {
                return this.getClassPackage(((MMRDataStructure)node).getInterface());
            }
            if ("DataStructure".equals(entityName)) {
                return this.getClassPackage(((MMRDataStructure)node).getApplication()) + ".datatypes";
            }
            if ("InputStructure".equals(entityName)) {
                return this.getClassPackage((MMROperation)node.getParentNode());
            }
        }
        throw new CAFRuntimeException("Entity type " + node.getEntityType() + " does not correspond to any WD model package");
    }

    public void setDtDictRoot(DtDictionaryRoot dtDictRoot) {
        this.dtDictRoot = dtDictRoot;
    }

    public DtDictionaryRoot getDtDictRoot() {
        return this.dtDictRoot;
    }

    public Model getUsedModel(String appName) {
        return (Model)this.m_usedModels.get(appName);
    }

    public void setWdRoot(WebDynproRoot wdModel) {
        this.wdRoot = wdModel;
    }

    public WebDynproRoot getWdRoot() {
        return this.wdRoot;
    }

    public void addUsedModel(String appName, Model model) {
        this.m_usedModels.put(appName, model);
    }

    public void clearUsedModels() {
        this.m_usedModels.clear();
    }

    public Model exportToWDModel(MMRNode node, String modelName) throws LoadException, MetamodelException {
        this.m_preparing = true;
        this.m_modelDefinitionChanged = false;
        this.m_exportedNodes.clear();
        MMRApplication hostApp = (MMRApplication)(node instanceof MMRApplication ? node : node.getParentOfType("Application"));
        this.m_hostApp = hostApp;
        hostApp.setAttribute(MODEL_NAME, modelName);
        String modelPackage = this.getClassPackage(hostApp);
        this.wdModel = this.wdRoot.getModel(modelPackage, modelName);
        if (this.wdModel == null) {
            this.wdModel = this.wdRoot.createModel(modelPackage, modelName);
        }
        if (this.wdModel.getModelType() == null) {
            ModelType mt = this.wdRoot.getModelType("com.sap.ide.webdynpro.modeltypes", "ReverseEngineered");
            if (mt == null) {
                mt = this.wdRoot.createModelType("com.sap.ide.webdynpro.modeltypes", "ReverseEngineered");
            }
            this.wdModel.setModelType(mt);
        }
        ArrayList<ModelClass> originalMCs = new ArrayList<ModelClass>();
        originalMCs.addAll(Arrays.asList(this.wdModel.getModelClasses()));
        ArrayList<ModelRelation> originalRelations = new ArrayList<ModelRelation>();
        originalRelations.addAll(Arrays.asList(this.wdModel.getModelRelations()));
        this.processNode(node);
        if (this.modelDefinitionChanged()) {
            this.m_changedMDOs.add(this.wdModel);
        }
        if (!RepositoryServices.checkWriteability((MainDevelopmentObject[])this.m_changedMDOs.toArray(new MainDevelopmentObject[0]), (IMMRepositoryObjectProvider)this.findRepositoryObjectProvider())) {
            return null;
        }
        this.m_preparing = false;
        this.processNode(node);
        originalMCs.removeAll(this.m_exportedNodes.values());
        originalRelations.removeAll(this.m_exportedRelations);
        Iterator it = originalRelations.iterator();
        while (it.hasNext()) {
            this.m_modelDefinitionChanged = true;
            ((ModelRelation)it.next()).delete();
        }
        Iterator it2 = originalMCs.iterator();
        while (it2.hasNext()) {
            this.m_modelDefinitionChanged = true;
            ((ModelClass)it2.next()).delete();
        }
        return this.wdModel;
    }

    public Map generateMCInterfaces(String destPath, boolean preparing) throws CAFBaseException {
        HashMap<String, ModelClass> res = new HashMap<String, ModelClass>();
        Iterator it = this.m_exportedNodes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ModelClass exportedMC = (ModelClass)entry.getValue();
            if (!this.m_changedMDOs.contains(exportedMC) && (preparing || !this.m_addedMDOs.contains(exportedMC))) continue;
            MMRNode node = (MMRNode)entry.getKey();
            String pckg = node.getAttribute(MODEL_PACKAGE);
            String cls = node.getAttribute(MODEL_CLASS);
            if (!destPath.endsWith("/") && !destPath.endsWith("\\")) {
                destPath = destPath + "/";
            }
            String destFile = destPath + pckg.replace('.', '/') + "/" + cls + ".java";
            HashMap ctx = this.buildContextForMC(exportedMC);
            ctx.put("class", cls);
            ctx.put("package", pckg);
            ctx.put("extends", this.getBaseInterfaceName(node));
            boolean validAspect = this.isValidAspect(node);
            ctx.put("node", node);
            ctx.put("validAspect", new Boolean(validAspect));
            File dest = new File(destFile);
            if (!preparing || dest.exists() && !dest.canWrite()) {
                if (preparing || !dest.exists()) {
                    res.put(pckg + '.' + cls, exportedMC);
                }
                if (!preparing) {
                    VelocityTools.defaultVT.runTemplate(destFile, (Map)ctx, "ModelClass.vm");
                }
            }
            if (!validAspect) continue;
            String entityType = node.getEntityType();
            ctx.put("modelName", this.wdModel.getName());
            ctx.put("modelPackage", this.wdModel.getPackage());
            MMRInterface hostInterface = "DataObject".equals(entityType) ? (MMRInterface)node.getParentNode() : this.findInterface((MMRDataStructure)node);
            ctx.put("interfaceName", hostInterface != null ? hostInterface.getNodeName() : "");
            destFile = destPath + pckg.replace('.', '/') + "/" + node.getNodeName() + "Utils.java";
            dest = new File(destFile);
            if (preparing && (!dest.exists() || dest.canWrite())) continue;
            if (preparing || !dest.exists()) {
                res.put(pckg + '.' + node.getNodeName() + "Utils", exportedMC);
            }
            if (preparing) continue;
            VelocityTools.defaultVT.runTemplate(destFile, (Map)ctx, "AspectUtils.vm");
        }
        return res;
    }

    public boolean modelDefinitionChanged() {
        return this.m_modelDefinitionChanged;
    }

    public Model removeUsedModel(String appName) {
        return (Model)this.m_usedModels.remove(appName);
    }

    protected void exportDataStructure(MMRDataStructure dsNode, ModelClass dsMC) throws MetamodelException, LoadException {
        ArrayList<Property> currProps = new ArrayList<Property>(Arrays.asList(dsMC.getProperties()));
        Iterator it = dsNode.getAllAttributes().iterator();
        while (it.hasNext()) {
            MMRAttribute attr = (MMRAttribute)it.next();
            String attrName = attr.getNodeName();
            ModelClassProperty mcProperty = (ModelClassProperty)dsMC.getProperty(attrName);
            if (mcProperty == null) {
                if (this.m_preparing) {
                    this.addChangedClass(dsMC);
                    break;
                }
                mcProperty = dsMC.createProperty(attrName);
            } else {
                currProps.remove(mcProperty);
            }
            String propType = attr.getDDicType();
            if (propType == null) continue;
            int idx = propType.lastIndexOf(".");
            String tPackage = idx < 0 ? "" : propType.substring(0, idx);
            String tName = propType.substring(idx + 1);
            DtSimpleType type = this.dtDictRoot.getSimpleType(tPackage, tName);
            if (mcProperty.getType() == type) continue;
            if (this.m_preparing) {
                this.addChangedClass(dsMC);
                break;
            }
            mcProperty.setType((DevelopmentObject)type);
        }
        Iterator it2 = currProps.iterator();
        while (it2.hasNext()) {
            Property prop = (Property)it2.next();
            if (!(prop instanceof ModelClassProperty)) continue;
            if (this.m_preparing) {
                this.addChangedClass(dsMC);
                break;
            }
            prop.delete();
        }
        Iterator it3 = dsNode.getChildrenOfType("DataStructure").iterator();
        while (it3.hasNext()) {
            MMRDataStructure complexAttr = (MMRDataStructure)it3.next();
            ModelClass complexAttrMC = this.exportNode(complexAttr);
            this.createRelation(dsMC, complexAttr.getNodeName(), complexAttrMC, CardinalityEnum._0_N);
        }
        Iterator it4 = dsNode.getAllRelations().iterator();
        while (it4.hasNext()) {
            MMRRelation rel = (MMRRelation)it4.next();
            MMRNode target = rel.getTarget();
            ModelClass targetMC = this.exportNode(target);
            this.createRelation(dsMC, rel.getName(), targetMC, this.getCardinalityEnum(rel.getMinOccurs(), rel.getMaxOccurs()));
        }
    }

    protected void exportInterface(MMRInterface interfaceNode) throws CreateException, LoadException, MetamodelException {
        Iterator it = interfaceNode.getAllChildren().iterator();
        while (it.hasNext()) {
            this.exportNode((MMRNode)it.next());
        }
    }

    protected void exportOperation(MMROperation operation, ModelClass opeMC) throws MetamodelException, LoadException {
        ModelClass ipMC = this.exportNode(operation.getInput());
        this.createRelation(opeMC, "InputParameterStructure", ipMC, CardinalityEnum._1_1);
        MMRDataStructure outputDS = operation.getOutput();
        if (outputDS != null) {
            ModelClass outputMC = this.exportNode(outputDS);
            this.createRelation(opeMC, "Result", outputMC, CardinalityEnum._0_N);
        }
    }

    private String getBaseInterfaceName(MMRNode node) {
        String result = null;
        String entityType = node.getEntityType();
        if ("DataObject".equals(entityType) || "DataStructure".equals(entityType)) {
            result = "com.sap.tc.col.client.generic.api.IAspectRow";
        } else if ("Operation".equals(entityType)) {
            result = ((MMROperation)node).getOutput() != null ? "com.sap.tc.col.client.generic.api.IQuery" : "com.sap.tc.col.client.generic.api.IAction";
        } else if ("InputStructure".equals(entityType)) {
            result = "com.sap.tc.col.client.generic.api.IStructure";
        }
        return result;
    }

    private CardinalityEnum getCardinalityEnum(int minOccurs, int maxOccurs) {
        if (minOccurs == 0) {
            return maxOccurs < 0 ? CardinalityEnum._0_N : CardinalityEnum._0_1;
        }
        return maxOccurs < 0 ? CardinalityEnum._1_N : CardinalityEnum._1_1;
    }

    private String getJavaType(String baseType, Collection imports) {
        String importClass = null;
        String javaClass = baseType;
        if ("string".equals(baseType)) {
            javaClass = "String";
        } else if ("decimal".equals(baseType)) {
            javaClass = "BigDecimal";
            importClass = "java.math.BigDecimal";
        } else if ("integer".equals(baseType)) {
            javaClass = "int";
        } else if ("binary".equals(baseType)) {
            javaClass = "byte[]";
        } else if ("timestamp".equals(baseType)) {
            javaClass = "Timestamp";
            importClass = "java.sql.Timestamp";
        } else if ("time".equals(baseType)) {
            javaClass = "Time";
            importClass = "java.sql.Time";
        } else if ("date".equals(baseType)) {
            javaClass = "Date";
            importClass = "java.sql.Date";
        }
        if (importClass != null && !imports.contains(importClass)) {
            imports.add(importClass);
        }
        return javaClass;
    }

    private ModelClass getOrCreateModelClass(String packageName, String className) throws CreateException {
        ModelClass result = this.wdModel.getModelClass(packageName, className);
        if (result == null && !this.m_preparing) {
            result = this.wdModel.createModelClass(packageName, className);
            this.m_addedMDOs.add(result);
        }
        return result;
    }

    private boolean isValidAspect(MMRNode node) {
        String entityType = node.getEntityType();
        String parentEntityType = node.getParentNode().getEntityType();
        return "DataObject".equals(entityType) && "BusinessEntityInterface".equals(parentEntityType);
    }

    private void addChangedClass(ModelClass mc) {
        if (!this.m_changedMDOs.contains(mc) && !this.m_addedMDOs.contains(mc)) {
            this.m_changedMDOs.add(mc);
        }
    }

    private HashMap buildContextForMC(ModelClass mc) {
        HashMap<String, Cloneable> ctx = new HashMap<String, Cloneable>();
        ArrayList imports = new ArrayList();
        ctx.put("imports", imports);
        HashMap<String, String> props = new HashMap<String, String>();
        ctx.put("props", props);
        Property[] mcps = mc.getProperties();
        int i = 0;
        while (i < mcps.length) {
            DtSimpleType dttype = (DtSimpleType)mcps[i].getType();
            props.put(mcps[i].getName(), this.getJavaType(dttype == null ? "" : dttype.getBuiltInType(), imports));
            ++i;
        }
        return ctx;
    }

    private ModelRelation createRelation(ModelClass sourceMC, String targetRoleName, ModelClass targetMC, CardinalityEnum cardinality) throws CreateException, MetamodelException {
        ModelRelationRole sourceRole;
        ModelRelationRole targetRole;
        if (this.m_preparing) {
            return null;
        }
        String relationName = sourceMC.getName() + ":" + targetRoleName;
        ModelRelation relation = this.wdModel.getModelRelation(relationName);
        if (relation == null) {
            relation = this.wdModel.createModelRelation(relationName);
            this.m_modelDefinitionChanged = true;
        }
        if ((targetRole = relation.getModelRelationRole(targetRoleName)) == null) {
            targetRole = relation.createModelRelationRole(targetRoleName);
            this.m_modelDefinitionChanged = true;
        }
        if (!this.m_preparing) {
            targetRole.setModelClass(targetMC);
            targetRole.setCardinality(cardinality);
            targetRole.setNavigable(true);
        }
        if ((sourceRole = relation.getModelRelationRole("Source")) == null) {
            sourceRole = relation.createModelRelationRole("Source");
            this.m_modelDefinitionChanged = true;
        }
        if (!this.m_preparing) {
            sourceRole.setModelClass(sourceMC);
            sourceRole.setAggregate(false);
            sourceRole.setCardinality(CardinalityEnum._0_1);
            sourceRole.setNavigable(false);
        }
        if (!this.m_exportedRelations.contains(relation)) {
            this.m_exportedRelations.add(relation);
        }
        return relation;
    }

    private ModelClass exportNode(MMRNode node) throws MetamodelException, CreateException {
        String className;
        String packageName;
        ModelClass mc = null;
        MMRApplication app = (MMRApplication)node.getParentOfType("Application");
        if (app != this.m_hostApp) {
            String className2;
            String packageName2;
            Model externalModel = this.getUsedModel(app.getNodeName());
            if (externalModel != null && (mc = externalModel.getModelClass(packageName2 = this.getClassPackage(node), className2 = this.getClassName(node))) != null) {
                this.wdModel.addUsedModel(externalModel);
            }
            return mc;
        }
        mc = (ModelClass)this.m_exportedNodes.get(node);
        if (mc == null && (mc = this.getOrCreateModelClass(packageName = this.getClassPackage(node), className = this.getClassName(node))) != null) {
            this.m_exportedNodes.put(node, mc);
            node.setAttribute(MODEL_CLASS, className);
            node.setAttribute(MODEL_PACKAGE, packageName);
            this.m_modelDefinitionChanged = true;
            this.exportNode(node, mc);
        }
        return mc;
    }

    private void exportNode(MMRNode node, ModelClass mc) throws MetamodelException, LoadException {
        if (node instanceof MMROperation) {
            this.exportOperation((MMROperation)node, mc);
        } else if (node instanceof MMRDataStructure) {
            this.exportDataStructure((MMRDataStructure)node, mc);
        }
    }

    private MMRInterface findInterface(MMRDataStructure node) {
        MMRApplication app = node.getApplication();
        Collection interfaces = app.getChildrenOfType("ApplicationInterface");
        Iterator itInter = interfaces.iterator();
        while (itInter.hasNext()) {
            MMRInterface inter = (MMRInterface)itInter.next();
            Collection relations = inter.getAllRelations();
            Iterator itRel = relations.iterator();
            while (itRel.hasNext()) {
                MMRRelation rel = (MMRRelation)itRel.next();
                if (rel.getTarget() != node) continue;
                return inter;
            }
        }
        return null;
    }

    private IMMRepositoryObjectProvider findRepositoryObjectProvider() {
        MetamodelManager mgr = MetamodelManager.getMetamodelManager((String)this.wdRoot.getMetamodel().getName());
        IMMRepositoryObjectProvider[] providers = mgr.getRepositoryObjectProvider();
        int i = 0;
        while (i < providers.length) {
            if (providers[i].getRepositoryObject((MainDevelopmentObject)this.wdModel, false) != null) {
                return providers[i];
            }
            ++i;
        }
        return providers[0];
    }

    private void processNode(MMRNode node) throws CreateException, LoadException, MetamodelException {
        if (node instanceof MMRInterface) {
            this.exportInterface((MMRInterface)node);
        } else if (node instanceof MMRApplication) {
            MMRApplication app = (MMRApplication)node;
            Collection interfaces = app.getChildrenOfType("ApplicationInterface");
            interfaces.addAll(app.getChildrenOfType("BusinessEntityInterface"));
            Iterator it = interfaces.iterator();
            while (it.hasNext()) {
                this.exportInterface((MMRInterface)it.next());
            }
        }
    }

    private String revertPackage(String pckg) {
        int idx = pckg.indexOf(".");
        String result = idx < 0 ? pckg : this.revertPackage(pckg.substring(idx + 1)) + "." + pckg.substring(0, idx);
        return result;
    }

    private String toTitleCase(String str) {
        if (str == null || "".equals(str)) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

