/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.webdynpro.mmrexport;

import com.sap.caf.designer.exception.CAFRuntimeException;
import com.sap.caf.designer.webdynpro.mmrexport.MMRApplication;
import com.sap.caf.designer.webdynpro.mmrexport.MMRAttribute;
import com.sap.caf.designer.webdynpro.mmrexport.MMRInterface;
import com.sap.caf.designer.webdynpro.mmrexport.MMRNode;
import com.sap.caf.designer.webdynpro.mmrexport.MMROperation;
import java.util.Collection;

public class MMRDataStructure
extends MMRNode {
    MMRDataStructure(String entityName) {
        super(entityName);
        if (!("DataObject".equals(entityName) || "InputStructure".equals(entityName) || "DataStructure".equals(entityName))) {
            throw new CAFRuntimeException("Incorrect entity name: " + entityName);
        }
    }

    public Collection getAllAttributes() {
        return this.getChildrenOfType("Attribute");
    }

    public MMRApplication getApplication() {
        String entityType = this.getEntityType();
        if ("DataObject".equals(entityType)) {
            return this.getInterface().getApplication();
        }
        if ("DataStructure".equals(entityType)) {
            return (MMRApplication)this.getParentOfType("Application");
        }
        return null;
    }

    public MMRInterface getInterface() {
        if ("DataObject".equals(this.getEntityType())) {
            return (MMRInterface)this.getParentNode();
        }
        return (MMRInterface)this.getParentOfType("ApplicationInterface");
    }

    public MMRAttribute createAttribute(String attrName) {
        return (MMRAttribute)this.appendChild("Attribute", attrName);
    }

    public MMRAttribute findAttribute(String attrName) {
        return (MMRAttribute)this.getChild("Attribute", attrName);
    }

    public boolean removeAttribute(String attrName) {
        return this.removeChild("Attribute", attrName);
    }

    protected MMRNode createChild(String entityType) {
        if ("Attribute".equals(entityType)) {
            return new MMRAttribute();
        }
        if ("DataStructure".equals(entityType)) {
            return new MMRDataStructure(entityType);
        }
        if (!"InputStructure".equals(this.getEntityType()) && "Operation".equals(entityType)) {
            return new MMROperation();
        }
        return super.createChild(entityType);
    }
}

