/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.webdynpro;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.CAFRuntimeException;
import com.sap.caf.designer.webdynpro.mmrexport.MMRApplication;
import com.sap.caf.designer.webdynpro.mmrexport.MMRAttribute;
import com.sap.caf.designer.webdynpro.mmrexport.MMRDataStructure;
import com.sap.caf.designer.webdynpro.mmrexport.MMRExporter;
import com.sap.caf.designer.webdynpro.mmrexport.MMRInterface;
import com.sap.caf.designer.webdynpro.mmrexport.MMRModel;
import com.sap.caf.designer.webdynpro.mmrexport.MMRNode;
import com.sap.caf.designer.webdynpro.mmrexport.MMROperation;
import com.sap.caf.designer.webdynpro.mmrexport.MMRRelation;
import com.sap.caf.designer.webdynpro.mmrexport.VelocityTools;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.metamodel.Property;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ip.mmr.Connection;
import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.ResourceException;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.JmiException;
import org.eclipse.core.runtime.IProgressMonitor;

public class MMRConverter {
    public static final String MODEL_PCKG = "com.sap.caf.metamodel";
    public static final String APPLICATION_MODEL_PCKG = "com.sap.caf.metamodel.Application";
    public static final String BEI_MODEL_PCKG = "com.sap.caf.metamodel.BusinessEntityInterface";
    public static final String AI_MODEL_PCKG = "com.sap.caf.metamodel.ApplicationInterface";
    public static final String DS_MODEL_PCKG = "com.sap.caf.metamodel.DataStructure";
    public static final String DO_MODEL_PCKG = "com.sap.caf.metamodel.DataObject";
    public static final String COLLECTION_ATTRIBUTE_NAME = "value";
    public static final String QUERY_WITH_SIMPLE_RESULT_TYPE_ATTRIBUTE_NAME = "value";
    public static final int DEFAULT_MIN_OCCURS = 0;
    public static final int DEFAULT_MAX_OCCURS = 1;
    public static final int MIN_OCCURS_FOR_ACTION_TO_INPUT_ASPECT_RELATION = 0;
    public static final int MAX_OCCURS_FOR_ACTION_TO_INPUT_ASPECT_RELATION = -1;
    public static final int MIN_OCCURS_FOR_QUERY_TO_RESULT_ASPECT_RELATION = 0;
    public static final int MAX_OCCURS_FOR_QUERY_TO_RESULT_ASPECT_RELATION = -1;
    public static final int MIN_OCCURS_FOR_INTERFACE_TO_USED_ASPECT_RELATION = 0;
    public static final int MAX_OCCURS_FOR_INTERFACE_TO_USED_ASPECT_RELATION = -1;
    private static final Integer CARDINALITY_N = new Integer(-1);
    private static final Integer PATTERN_CUSTOM = new Integer(0);
    private static final Integer PATTERN_CREATE = new Integer(1);
    private static final Integer PATTERN_FIND_BY = new Integer(5);
    public static int OT_INVALID_OPERATION = -1;
    public static int OT_CRUD = 0;
    public static int OT_SIMPLE_ACTION = 1;
    public static int OT_ACTION_WITH_KEY_LIST = 2;
    public static int OT_QUERY_WITH_DS_AS_RESULT = 3;
    public static int OT_QUERY_WITH_SIMPLE_TYPE_AS_RESULT = 4;
    private static final String INVALID_ATTRIBUTE_DICT_TYPE_0 = "";
    private static final String INVALID_ATTRIBUTE_DICT_TYPE_1 = "*";
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$webdynpro$MMRConverter == null ? (class$com$sap$caf$designer$webdynpro$MMRConverter = MMRConverter.class$("com.sap.caf.designer.webdynpro.MMRConverter")) : class$com$sap$caf$designer$webdynpro$MMRConverter);
    private MMRExporter m_exporter = new MMRExporter();
    private Model m_exportedModel;
    private IProgressMonitor m_monitor;
    private Map structureDescriptorsCashe = new HashMap();
    private Map aspectDescriptorsCashe = new HashMap();
    private Map mmrObjectsCache = new HashMap();
    private MMRModel m_mmrModel = MMRModel.newModel();
    private List relationsToBeCreated = new ArrayList();
    static /* synthetic */ Class class$com$sap$caf$designer$webdynpro$MMRConverter;

    public static boolean isCollectionAttribute(Attribute attr) {
        if (attr == null) {
            return false;
        }
        return attr.getTypeJavaDdic() != null && CARDINALITY_N.equals(attr.getMaxOccurs());
    }

    public static boolean isComplexAttribute(Attribute attr) {
        if (attr == null) {
            return false;
        }
        DataStructure dataStructure = attr.getReferencedObject();
        return dataStructure != null && dataStructure instanceof DataObject && ((DataObject)dataStructure).getBusinessEntityInterface() == null;
    }

    public static boolean isRelationAttribute(Attribute attr) {
        if (attr == null) {
            return false;
        }
        DataStructure dataStructure = attr.getReferencedObject();
        return dataStructure != null && (dataStructure instanceof DataObject && ((DataObject)dataStructure).getBusinessEntityInterface() != null || !(dataStructure instanceof DataObject));
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.m_monitor = monitor;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.m_monitor;
    }

    public void setTemplatesPath(String templatesPath) throws CAFBaseException {
        VelocityTools.defaultVT.initialize(templatesPath);
    }

    public boolean containsApplication(String appName) {
        return this.m_mmrModel.getApplication(appName) != null;
    }

    public Model doConvert(String appName, String modelName, WebDynproRoot wdRoot, DtDictionaryRoot dictRoot) throws MetamodelException {
        return this.doConvert(appName, modelName, wdRoot, dictRoot, null);
    }

    public Model doConvert(String appName, String modelName, WebDynproRoot wdRoot, DtDictionaryRoot dictRoot, Map usedModels) throws MetamodelException {
        MMRApplication app;
        this.normalize();
        this.m_exporter.setWdRoot(wdRoot);
        this.m_exporter.setDtDictRoot(dictRoot);
        this.m_exporter.clearUsedModels();
        if (usedModels != null) {
            Iterator it = usedModels.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.m_exporter.addUsedModel((String)entry.getKey(), (Model)entry.getValue());
            }
        }
        if ((app = this.m_mmrModel.getApplication(appName)) == null) {
            throw new CAFRuntimeException("Invalid application name specified: " + appName);
        }
        this.m_exportedModel = this.m_exporter.exportToWDModel(app, modelName);
        return this.m_exportedModel;
    }

    public Map generateJavaClasses(String appName, String modelName, String destPath, boolean preparing) throws CAFBaseException {
        MMRApplication app;
        Map res = this.m_exporter.generateMCInterfaces(destPath, preparing);
        if (!this.m_exporter.modelDefinitionChanged()) {
            return res;
        }
        if (!(destPath = destPath.replace('\\', '/')).endsWith("/")) {
            destPath = destPath + "/";
        }
        if ((app = this.m_mmrModel.getApplication(appName)) == null) {
            throw new CAFRuntimeException("Invalid application name specified: " + appName);
        }
        String pckg = this.m_exporter.getClassPackage(app);
        destPath = destPath + pckg.replace('.', '/') + '/';
        HashMap<String, Object> appCtx = new HashMap<String, Object>();
        appCtx.put("modelPackage", pckg);
        appCtx.put("modelName", modelName);
        appCtx.put("node", app);
        String destFile = destPath + modelName + "Definition.java";
        File dest = new File(destFile);
        if (!preparing || dest.exists() && !dest.canWrite()) {
            if (preparing || !dest.exists()) {
                res.put(pckg + '.' + modelName + "Definition", this.m_exportedModel);
            }
            if (!preparing) {
                VelocityTools.defaultVT.runTemplate(destPath + modelName + "Definition.java", appCtx, "ModelDefinition.vm");
            }
        }
        return res;
    }

    public void loadMetaData(IConnection metaDataConnection) {
        Collection apps = this.getApplications(metaDataConnection);
        this.process(apps);
    }

    public void loadMetaData(Application app) {
        ArrayList<Application> apps = new ArrayList<Application>();
        apps.add(app);
        this.process(apps);
    }

    public void loadMetaData(String[] metaData) throws CAFBaseException {
        this.loadMetaData(MMRConverter.getReadOnlyMMRConnectionForPaths(Arrays.asList(metaData)));
    }

    public MMRModel process(Collection applications) {
        Iterator appIt = applications.iterator();
        while (appIt.hasNext()) {
            Application application = (Application)appIt.next();
            MMRApplication mmrApplication = this.m_mmrModel.createApplication(application.getObjectName());
            this.processApplication(application, mmrApplication);
        }
        this.processRelationsOnDataStructures();
        return this.m_mmrModel;
    }

    public void processApplication(Application application, MMRApplication mmrApplication) {
        this.applyBaseObjectAttributes((BaseObject)application, mmrApplication);
        this.putMMRObjectToCache(mmrApplication);
        try {
            if (application != null) {
                ArrayList<BaseObject> businessInterfaces = new ArrayList<BaseObject>();
                ArrayList<BaseObject> applicationInterfaces = new ArrayList<BaseObject>();
                ArrayList<BaseObject> dataStructures = new ArrayList<BaseObject>();
                if (this.m_monitor != null) {
                    this.m_monitor.beginTask("Reading metadata for " + application.getObjectName(), application.getBaseObjects().size());
                }
                int progress = 0;
                Iterator it = application.getBaseObjects().iterator();
                while (it.hasNext()) {
                    BaseObject obj = (BaseObject)it.next();
                    if (obj instanceof BusinessEntityInterface) {
                        businessInterfaces.add(obj);
                    } else if (obj instanceof ApplicationInterface) {
                        applicationInterfaces.add(obj);
                    } else if (obj instanceof DataStructure && !(obj instanceof DataObject)) {
                        dataStructures.add(obj);
                    }
                    if (this.m_monitor == null) continue;
                    this.m_monitor.worked(++progress);
                }
                if (this.m_monitor != null) {
                    this.m_monitor.done();
                }
                int dataStructuresSize = dataStructures.size();
                int i = 0;
                while (i < dataStructuresSize) {
                    DataStructure dataStructure = (DataStructure)dataStructures.get(i);
                    MMRDataStructure mmrDataStructure = mmrApplication.createDataStructure(dataStructure.getObjectName());
                    this.processDataStructure(dataStructure, mmrDataStructure);
                    ++i;
                }
                int businessInterfacesSize = businessInterfaces.size();
                int i2 = 0;
                while (i2 < businessInterfacesSize) {
                    BusinessEntityInterface mofInterface = (BusinessEntityInterface)businessInterfaces.get(i2);
                    MMRInterface mmrInterface = mmrApplication.createBEI(mofInterface.getObjectName(), mofInterface.getBusinessEntity().getObjectName());
                    this.processMOFInterface((MOFInterface)mofInterface, mmrInterface);
                    ++i2;
                }
                int applicationInterfacesSize = applicationInterfaces.size();
                int i3 = 0;
                while (i3 < applicationInterfacesSize) {
                    ApplicationInterface mofInterface = (ApplicationInterface)applicationInterfaces.get(i3);
                    MMRInterface mmrInterface = mmrApplication.createAI(mofInterface.getObjectName());
                    this.processMOFInterface((MOFInterface)mofInterface, mmrInterface);
                    ++i3;
                }
            }
        }
        catch (Exception e) {
            logger.errorT("An error has occured while processing application " + application.getName());
            e.printStackTrace();
        }
    }

    public void processMOFInterface(MOFInterface mofInterfaceImpl, MMRInterface mmrInterface) {
        MMRDataStructure defaultAspect = null;
        if (mofInterfaceImpl instanceof ApplicationInterface) {
            defaultAspect = (MMRDataStructure)mmrInterface.appendChild("DataStructure", mmrInterface.getNodeName());
        } else if (mofInterfaceImpl instanceof BusinessEntityInterface) {
            DataObject dataObject = ((BusinessEntityInterface)mofInterfaceImpl).getBusinessEntity();
            defaultAspect = mmrInterface.getUnderlyingDO();
            this.processDataStructure((DataStructure)dataObject, defaultAspect);
        } else {
            return;
        }
        List operations = mofInterfaceImpl.getOperations();
        ArrayList<MMROperation> actionsList = new ArrayList<MMROperation>();
        ArrayList<MMROperation> queriesList = new ArrayList<MMROperation>();
        ArrayList<DataStructure> externalDSs = new ArrayList<DataStructure>();
        ArrayList<MMRDataStructure> createdSimpleDSs = new ArrayList<MMRDataStructure>();
        int size = operations.size();
        int i = 0;
        while (i < size) {
            try {
                int operationCOOLType;
                Operation operation = (Operation)operations.get(i);
                if (operation != null && (operationCOOLType = this.getOperationCOOLType(operation)) != OT_INVALID_OPERATION && operationCOOLType != OT_CRUD) {
                    MMROperation mmrOperation = null;
                    Message outputMessage = operation.getOutput();
                    Message inputMessage = operation.getInput();
                    List outputMessageAttributes = null;
                    if (outputMessage != null) {
                        outputMessageAttributes = outputMessage.getMessageParts();
                    }
                    int outputMessageSize = 0;
                    if (outputMessageAttributes != null) {
                        outputMessageSize = outputMessageAttributes.size();
                    }
                    mmrOperation = mmrInterface.createOperation(operation.getObjectName());
                    mmrOperation.setAttribute("operationCOOLType", String.valueOf(operationCOOLType));
                    this.applyBaseObjectAttributes((BaseObject)operation, mmrOperation);
                    Attribute inputDSParameterAttribute = this.processInputMessage(mmrOperation, operation);
                    if (operationCOOLType == OT_SIMPLE_ACTION || operationCOOLType == OT_ACTION_WITH_KEY_LIST) {
                        if (inputDSParameterAttribute != null) {
                            DataStructure referedStructure = inputDSParameterAttribute.getReferencedObject();
                            if (!defaultAspect.getIdAttribute().equals(referedStructure.getObjectId())) {
                                externalDSs.add(referedStructure);
                            }
                        }
                        actionsList.add(mmrOperation);
                    } else if (operationCOOLType == OT_QUERY_WITH_DS_AS_RESULT) {
                        DataStructure outputDataStructure = null;
                        Attribute outputAttribute = null;
                        int j = 0;
                        while (j < outputMessageSize) {
                            Attribute attr = (Attribute)outputMessageAttributes.get(j);
                            if (attr != null && attr.getReferencedObject() != null) {
                                outputAttribute = attr;
                                break;
                            }
                            ++j;
                        }
                        outputDataStructure = outputAttribute.getReferencedObject();
                        MMRRelation resultRelation = this.addRelationFromQueryToResultDS(mmrOperation);
                        String outputID = outputDataStructure.getObjectId();
                        if (outputID != null && !outputID.equals(defaultAspect.getNodeId())) {
                            externalDSs.add(outputDataStructure);
                            this.addDSRelationToCache(outputAttribute.getReferencedObject(), resultRelation);
                        } else {
                            resultRelation.setTarget(defaultAspect);
                        }
                        queriesList.add(mmrOperation);
                    } else if (operationCOOLType == OT_QUERY_WITH_SIMPLE_TYPE_AS_RESULT) {
                        Attribute outputAttribute = (Attribute)outputMessageAttributes.get(0);
                        String operationName = operation.getObjectName();
                        String outputAttrName = outputAttribute.getObjectName();
                        String structName = operationName + "_" + outputAttrName;
                        MMRRelation resultRelation = this.addRelationFromQueryToResultDS(mmrOperation);
                        MMRDataStructure outputDS = (MMRDataStructure)mmrInterface.appendChild("DataStructure", structName);
                        this.getNewMOFID(outputDS);
                        resultRelation.setTarget(outputDS);
                        MMRAttribute valueAttr = outputDS.createAttribute("value");
                        this.applyBaseObjectAttributes((BaseObject)outputAttribute, valueAttr);
                        valueAttr.setNodeName("value");
                        createdSimpleDSs.add(outputDS);
                        queriesList.add(mmrOperation);
                    }
                }
            }
            catch (Exception e) {
                logger.errorT("An error occured while processing MOF interface.Error is:" + e.getMessage());
                e.printStackTrace();
            }
            ++i;
        }
        this.addRelationFromInterfaceToUsedDS(mmrInterface, defaultAspect);
        Iterator externalDSsIt = externalDSs.iterator();
        while (externalDSsIt.hasNext()) {
            DataStructure ds = (DataStructure)externalDSsIt.next();
            MMRRelation usedDSRelation = this.addRelationFromInterfaceToUsedDS(mmrInterface, ds);
            this.addDSRelationToCache(ds, usedDSRelation);
        }
    }

    public void processRelationsOnDataStructures() {
        List entries = this.relationsToBeCreated;
        Iterator entriesIt = entries.iterator();
        while (entriesIt.hasNext()) {
            DataStructureAndRelation entry = (DataStructureAndRelation)entriesIt.next();
            DataStructure ds = entry.dataStructure;
            MMRRelation relation = entry.mmrRelation;
            String relatedMOFID = ds.getObjectId();
            MMRDataStructure relatedDataStructure = (MMRDataStructure)this.getMMRObjectFromCache(relatedMOFID);
            if (relatedDataStructure == null) continue;
            relation.setTarget(relatedDataStructure);
            entriesIt.remove();
        }
    }

    protected MMRRelation addRelationFromActionToDS(MMROperation mmrOperation) {
        return mmrOperation.addRelation("RelatedAspect", null, 0, -1);
    }

    protected MMRRelation addRelationFromInterfaceToUsedDS(MMRInterface mmrInterface, DataStructure ds) {
        String relationName = ds.getObjectId() + "_" + ds.getObjectName();
        return mmrInterface.addRelation(relationName, null, 0, -1);
    }

    protected MMRRelation addRelationFromInterfaceToUsedDS(MMRInterface mmrInterface, MMRDataStructure ds) {
        String relationName = ds.getNodeId() + "_" + ds.getNodeName();
        return mmrInterface.addRelation(relationName, ds, 0, -1);
    }

    protected MMRRelation addRelationFromQueryToResultDS(MMROperation mmrOperation) {
        return mmrOperation.addRelation("Result", null, 0, -1);
    }

    protected void applyApplicationAttributes(Application mmrObject, MMRNode mmrNode) throws JmiException {
        mmrNode.setAttribute("providerName", mmrObject.getProviderName());
    }

    protected void applyApplicationInterfaceAttributes(ApplicationInterface mmrObject, MMRNode mmrNode) throws JmiException {
        mmrNode.setAttribute("remoteEnabled", String.valueOf(mmrObject.isRemoteEnabled()));
    }

    protected void applyAttributeAttributes(Attribute mmrObject, MMRNode mmrNode) throws JmiException {
        if (mmrObject.getReferencedObject() != null) {
            mmrNode.setAttribute("typeJavaDDic", "com.sap.caf.core.longText");
        } else {
            mmrNode.setAttribute("typeJavaDDic", mmrObject.getTypeJavaDdic());
        }
        mmrNode.setAttribute("listType", this.getStringOrNull(mmrObject.getListType()));
        mmrNode.setAttribute("maxOccurs", this.getStringOrNull(mmrObject.getMaxOccurs()));
        mmrNode.setAttribute("minOccurs", this.getStringOrNull(mmrObject.getMinOccurs()));
        mmrNode.setAttribute("relationType", this.getStringOrNull(mmrObject.getRelationType()));
        if (mmrObject instanceof Property) {
            this.applyPropertyAttributes((Property)mmrObject, mmrNode);
        }
    }

    protected void applyBaseObjectAttributes(BaseObject mmrObject, MMRNode mmrNode) throws JmiException {
        mmrNode.setNodeName(mmrObject.getObjectName());
        mmrNode.setNodeId(mmrObject.getObjectId());
        mmrNode.setAttribute("createdAt", mmrObject.getCreatedAt());
        mmrNode.setAttribute("createdBy", mmrObject.getCreatedBy());
        mmrNode.setAttribute("lastChangedAt", mmrObject.getLastChangedAt());
        mmrNode.setAttribute("lastChangedBy", mmrObject.getLastChangedBy());
        if (mmrObject instanceof Application) {
            this.applyApplicationAttributes((Application)mmrObject, mmrNode);
        } else if (mmrObject instanceof MOFInterface) {
            this.applyInterfaceAttributes((MOFInterface)mmrObject, mmrNode);
        } else if (mmrObject instanceof DataStructure) {
            this.applyDataStructureAttributes((DataStructure)mmrObject, mmrNode);
        } else if (mmrObject instanceof Attribute) {
            this.applyAttributeAttributes((Attribute)mmrObject, mmrNode);
        }
        if (mmrObject instanceof Operation) {
            this.applyOperationAttributes((Operation)mmrObject, mmrNode);
        }
    }

    protected void applyBusinessEntityInterfaceAttributes(BusinessEntityInterface mmrObject, MMRNode mmrNode) throws JmiException {
        mmrNode.setAttribute("backend", this.getStringOrNull(mmrObject.getBackend()));
        mmrNode.setAttribute("instancePermission", this.getStringOrNull(mmrObject.getInstancePermission()));
    }

    protected void applyDataObjectAttributes(DataObject mmrObject, MMRNode mmrNode) throws JmiException {
        mmrNode.setAttribute("lockMode", this.getStringOrNull(mmrObject.getLockMode()));
    }

    protected void applyDataStructureAttributes(DataStructure mmrObject, MMRNode mmrNode) throws JmiException {
        if (mmrObject instanceof DataObject) {
            this.applyDataObjectAttributes((DataObject)mmrObject, mmrNode);
        }
    }

    protected void applyInterfaceAttributes(MOFInterface mmrObject, MMRNode mmrNode) throws JmiException {
        if (mmrObject instanceof BusinessEntityInterface) {
            this.applyBusinessEntityInterfaceAttributes((BusinessEntityInterface)mmrObject, mmrNode);
        } else if (mmrObject instanceof ApplicationInterface) {
            this.applyApplicationInterfaceAttributes((ApplicationInterface)mmrObject, mmrNode);
        }
    }

    protected void applyOperationAttributes(Operation mmrObject, MMRNode mmrNode) throws JmiException {
        mmrNode.setAttribute("coding", this.getStringOrNull(mmrObject.getPatternType()));
        mmrNode.setAttribute("transactionType", this.getStringOrNull(mmrObject.getTransactionType()));
    }

    protected void applyPropertyAttributes(Property mmrObject, MMRNode mmrNode) throws JmiException {
        mmrNode.setAttribute("isHollow", this.getStringOrNull(mmrObject.isHollow()));
        mmrNode.setAttribute("languageDependent", this.getStringOrNull(mmrObject.isLanguageDependent()));
        mmrNode.setAttribute("timeDependent", this.getStringOrNull(mmrObject.isTimeDependent()));
        mmrNode.setAttribute("keyType", this.getStringOrNull(mmrObject.getKeyType()));
    }

    protected Attribute processInputMessage(MMROperation mmrOperation, Operation operation) {
        Message inputMessage = operation.getInput();
        if (inputMessage == null) {
            return null;
        }
        List messageParts = inputMessage.getMessageParts();
        Attribute inputDSParameterAttribute = null;
        if (messageParts != null && messageParts.size() > 0) {
            MMRDataStructure inputParameter = mmrOperation.getInput();
            MOFInterface mofInterface = operation.getMOFInterface();
            DataObject outputDataStructure = null;
            if (mofInterface instanceof BusinessEntityInterface) {
                outputDataStructure = ((BusinessEntityInterface)mofInterface).getBusinessEntity();
            } else {
                Object retVal;
                List outputMessageParts;
                Message outputMessage = operation.getOutput();
                if (outputMessage != null && (outputMessageParts = outputMessage.getMessageParts()) != null && outputMessageParts.size() > 0 && (retVal = outputMessageParts.get(0)) != null) {
                    outputDataStructure = ((Attribute)retVal).getReferencedObject();
                }
            }
            Iterator paramsIt = messageParts.iterator();
            while (paramsIt.hasNext()) {
                Attribute parameterAttr = (Attribute)paramsIt.next();
                if (parameterAttr == null) continue;
                if (parameterAttr.getReferencedObject() != null && PATTERN_FIND_BY.equals(operation.getPatternType()) && outputDataStructure != null) {
                    parameterAttr = this.getAttributeForName((DataStructure)outputDataStructure, parameterAttr.getObjectName());
                } else if (parameterAttr.getReferencedObject() != null) {
                    if (!(parameterAttr.getReferencedObject() instanceof DataObject) || inputDSParameterAttribute != null) continue;
                    inputDSParameterAttribute = parameterAttr;
                    continue;
                }
                MMRAttribute mmrAttr = inputParameter.createAttribute(parameterAttr.getObjectName());
                this.applyBaseObjectAttributes((BaseObject)parameterAttr, mmrAttr);
            }
        }
        return inputDSParameterAttribute;
    }

    private static IConnection getReadOnlyMMRConnection(String mmrPath) throws CAFBaseException {
        try {
            ConnectionFactory connFactory = new ConnectionFactory();
            ConnectionSpec connSpec = new ConnectionSpec();
            Connection connection = connFactory.getConnection((javax.resource.cci.ConnectionSpec)connSpec);
            Workspace workspace = new Workspace("WORKSPACE_TEST");
            workspace.setPath(mmrPath);
            workspace.setReadOnly(true);
            connection.getConnectionSpec().getWorkspacesM1().add(workspace);
            RepositoryServer.getRepositoryServer().registerWorkspace(workspace, 1);
            return connection;
        }
        catch (Exception ex) {
            throw new CAFBaseException(ex);
        }
    }

    private static IConnection getReadOnlyMMRConnectionForPaths(List paths) throws CAFBaseException {
        try {
            ConnectionFactory connFactory = new ConnectionFactory();
            ConnectionSpec connSpec = new ConnectionSpec();
            Connection connection = connFactory.getConnection((javax.resource.cci.ConnectionSpec)connSpec);
            int i = 0;
            Iterator it = paths.iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                Workspace workspace = new Workspace("WORKSPACE_" + i);
                workspace.setPath(path);
                workspace.setReadOnly(true);
                connection.getConnectionSpec().getWorkspacesM1().add(workspace);
                RepositoryServer.getRepositoryServer().registerWorkspace(workspace, 1);
                ++i;
            }
            return connection;
        }
        catch (Exception ex) {
            throw new CAFBaseException(ex);
        }
    }

    private Collection getApplications(IConnection connection) {
        List typeList = Utilities.getUtilities().decodeQualifiedName(APPLICATION_MODEL_PCKG);
        List applications = null;
        try {
            applications = connection.queryM1(typeList, null, true);
        }
        catch (ResourceException ex) {
            logger.errorT("An error has occured while getting applications from MMR repository.Error is:" + ex.getMessage());
            ex.printStackTrace();
            return applications;
        }
        return applications;
    }

    private Attribute getAttributeForName(DataStructure dataStructure, String name) {
        List attributes;
        List keys;
        int pointIndex = -1;
        if (name != null) {
            pointIndex = name.indexOf(".");
        }
        if ((keys = dataStructure.getKeys()) != null) {
            int keysSize = keys.size();
            int i = 0;
            while (i < keysSize) {
                DataStructure ds;
                Attribute attr = (Attribute)keys.get(i);
                if (pointIndex == -1) {
                    if (attr != null && name.equals(attr.getObjectName())) {
                        return attr;
                    }
                } else if (attr != null && name.substring(0, pointIndex).equals(attr.getObjectName()) && (ds = attr.getReferencedObject()) != null) {
                    return this.getAttributeForName(ds, name.substring(pointIndex + 1));
                }
                ++i;
            }
        }
        if ((attributes = dataStructure.getAttributes()) != null) {
            int attributesSize = attributes.size();
            int i = 0;
            while (i < attributesSize) {
                DataStructure ds;
                Attribute attr = (Attribute)attributes.get(i);
                if (pointIndex == -1) {
                    if (attr != null && name.equals(attr.getObjectName())) {
                        return attr;
                    }
                } else if (attr != null && name.substring(0, pointIndex).equals(attr.getObjectName()) && (ds = attr.getReferencedObject()) != null) {
                    return this.getAttributeForName(ds, name.substring(pointIndex + 1));
                }
                ++i;
            }
        }
        return null;
    }

    private boolean isCRUDOperation(Operation operation) {
        Integer patternType;
        return operation != null && (patternType = operation.getPatternType()) != null && patternType >= 1 && patternType <= 4;
    }

    private MMRNode getMMRObjectFromCache(String mmrObjectKey) {
        return (MMRNode)this.mmrObjectsCache.get(mmrObjectKey);
    }

    private String getMMRObjectKey(MMRNode mmrObject) {
        return mmrObject.getNodeId();
    }

    private int getMaxOccursValueOrDefault(Integer maxOccurs) {
        return maxOccurs != null ? maxOccurs : 1;
    }

    private int getMinOccursValueOrDefault(Integer minOccurs) {
        return minOccurs != null ? minOccurs : 0;
    }

    private String getNewMOFID(MMRNode mmrObject) {
        String guid = System.currentTimeMillis() + " _" + System.currentTimeMillis();
        mmrObject.setIdAttribute("NEW_" + guid);
        return guid;
    }

    private int getOperationCOOLType(Operation operation) {
        Integer patternType;
        List inputMessageAttributes;
        int size;
        List outputMessageAttributes;
        if (this.isCRUDOperation(operation)) {
            return OT_CRUD;
        }
        if (!this.checkOperation(operation)) {
            return OT_INVALID_OPERATION;
        }
        Message outputMessage = operation.getOutput();
        Message inputMessage = operation.getInput();
        boolean outputEmpty = true;
        boolean outputDS = false;
        boolean inputWithKeyList = false;
        if (outputMessage != null && (outputMessageAttributes = outputMessage.getMessageParts()) != null && (size = outputMessageAttributes.size()) > 0) {
            outputEmpty = false;
            Attribute attr = (Attribute)outputMessageAttributes.get(0);
            outputDS = attr.getReferencedObject() != null;
        }
        if (inputMessage != null && (inputMessageAttributes = inputMessage.getMessageParts()) != null) {
            size = inputMessageAttributes.size();
            int j = 0;
            while (j < size) {
                Attribute attr = (Attribute)inputMessageAttributes.get(j);
                if (!(attr == null || attr.getReferencedObject() == null || PATTERN_FIND_BY.equals(operation.getPatternType()) && outputDS)) {
                    inputWithKeyList = true;
                    break;
                }
                ++j;
            }
        }
        if (!PATTERN_FIND_BY.equals(patternType = operation.getPatternType()) || outputEmpty) {
            // empty if block
        }
        if (outputEmpty || inputWithKeyList) {
            // empty if block
        }
        if (!outputEmpty) {
            if (outputDS) {
                return OT_QUERY_WITH_DS_AS_RESULT;
            }
            return OT_QUERY_WITH_SIMPLE_TYPE_AS_RESULT;
        }
        if (inputWithKeyList) {
            return OT_ACTION_WITH_KEY_LIST;
        }
        return OT_SIMPLE_ACTION;
    }

    private String getStringOrNull(Object value) {
        return value == null ? null : value.toString();
    }

    private void addDSRelationToCache(DataStructure ds, MMRRelation mmrRelation) {
        this.relationsToBeCreated.add(new DataStructureAndRelation(ds, mmrRelation));
    }

    private boolean checkOperation(Operation op) {
        if (!this.isCRUDOperation(op)) {
            List inputMessageAttributes;
            String attrType;
            Attribute attr;
            int j;
            int size;
            List outputMessageAttributes;
            Message outputMessage = op.getOutput();
            Message inputMessage = op.getInput();
            if (outputMessage != null && (outputMessageAttributes = outputMessage.getMessageParts()) != null) {
                size = outputMessageAttributes.size();
                j = 0;
                while (j < size) {
                    attr = (Attribute)outputMessageAttributes.get(j);
                    if (attr != null) {
                        attrType = attr.getTypeJavaDdic();
                        if (attr.getReferencedObject() == null && (attrType == null || INVALID_ATTRIBUTE_DICT_TYPE_0.equals(attrType) || INVALID_ATTRIBUTE_DICT_TYPE_1.equals(attrType))) {
                            return false;
                        }
                    }
                    ++j;
                }
            }
            if (inputMessage != null && (inputMessageAttributes = inputMessage.getMessageParts()) != null) {
                size = inputMessageAttributes.size();
                j = 0;
                while (j < size) {
                    attr = (Attribute)inputMessageAttributes.get(j);
                    if (attr != null) {
                        attrType = attr.getTypeJavaDdic();
                        if (attr.getReferencedObject() == null && (attrType == null || INVALID_ATTRIBUTE_DICT_TYPE_0.equals(attrType) || INVALID_ATTRIBUTE_DICT_TYPE_1.equals(attrType))) {
                            return false;
                        }
                    }
                    ++j;
                }
            }
        }
        return true;
    }

    private void normalize() {
        Iterator entriesIt = this.relationsToBeCreated.iterator();
        while (entriesIt.hasNext()) {
            DataStructureAndRelation entry = (DataStructureAndRelation)entriesIt.next();
            MMRRelation relation = entry.mmrRelation;
            relation.getSource().removeRelation(relation.getName());
            entriesIt.remove();
            relation.getSource().removeRelation(relation.getName());
        }
    }

    private void processDataStructure(DataStructure dataStructure, MMRDataStructure mmrDataStructure) {
        this.applyBaseObjectAttributes((BaseObject)dataStructure, mmrDataStructure);
        this.putMMRObjectToCache(mmrDataStructure);
        List attributes = dataStructure.getAttributes();
        int attrSize = attributes.size();
        int i = 0;
        while (i < attrSize) {
            Attribute attribute = (Attribute)attributes.get(i);
            if (MMRConverter.isComplexAttribute(attribute)) {
                DataObject complexDO = (DataObject)attribute.getReferencedObject();
                MMRDataStructure complexAttr = (MMRDataStructure)mmrDataStructure.appendChild("DataStructure", attribute.getObjectName());
                this.processDataStructure((DataStructure)complexDO, complexAttr);
                this.applyBaseObjectAttributes((BaseObject)attribute, complexAttr);
            } else if (MMRConverter.isCollectionAttribute(attribute)) {
                MMRDataStructure collAttr = (MMRDataStructure)mmrDataStructure.appendChild("DataStructure", attribute.getObjectName());
                this.applyBaseObjectAttributes((BaseObject)attribute, collAttr);
                this.getNewMOFID(collAttr);
                MMRAttribute valueAttr = collAttr.createAttribute("value");
                this.applyBaseObjectAttributes((BaseObject)attribute, valueAttr);
                valueAttr.setNodeName("value");
            } else if (MMRConverter.isRelationAttribute(attribute)) {
                MMRRelation relation = mmrDataStructure.addRelation(attribute.getObjectName(), null, this.getMinOccursValueOrDefault(attribute.getMinOccurs()), this.getMaxOccursValueOrDefault(attribute.getMaxOccurs()));
                this.addDSRelationToCache(attribute.getReferencedObject(), relation);
            } else {
                String customType = attribute.getTypeJavaDdic();
                MMRAttribute mmrAttribute = mmrDataStructure.createAttribute(attribute.getObjectName());
                this.applyBaseObjectAttributes((BaseObject)attribute, mmrAttribute);
            }
            ++i;
        }
    }

    private void putMMRObjectToCache(MMRNode mmrObject) {
        this.mmrObjectsCache.put(this.getMMRObjectKey(mmrObject), mmrObject);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DataStructureAndRelation {
        public DataStructure dataStructure;
        public MMRRelation mmrRelation;

        DataStructureAndRelation(DataStructure ds, MMRRelation relation) {
            this.dataStructure = ds;
            this.mmrRelation = relation;
        }
    }
}

