/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.views;

import com.sap.caf.designer.AppDesignerPerspective;
import com.sap.caf.designer.Logger;
import com.sap.caf.designer.StatusLineMessage;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.ApplicationInterfaceEditorInput;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditorInput;
import com.sap.caf.designer.editors.ExternalInterfaceEditorInput;
import com.sap.caf.designer.editors.NoLicenseEditor;
import com.sap.caf.designer.editors.NoLicenseEditorInput;
import com.sap.caf.designer.exception.CAFNullPointerException;
import com.sap.caf.designer.generation.utils.GenerationUtilsDt;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFApplicationInterface;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFExternalInterface;
import com.sap.caf.designer.views.BOMTreeUtil;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelChangeListener;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.YesManFilter;
import com.tssap.selena.model.extension.ui.treeviewer.GenericDataModelFilteredTreeViewer;
import com.tssap.selena.model.ui.DefaultElementWrapper;
import com.tssap.selena.model.ui.ElementWrapperSelectionConverter;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.IElementWrapperConverter;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ModelTreeViewer
extends ViewPart
implements IResourceChangeListener,
ModelChangeListener {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static List instances = new ArrayList();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$views$ModelTreeViewer == null ? (class$com$sap$caf$designer$views$ModelTreeViewer = ModelTreeViewer.class$("com.sap.caf.designer.views.ModelTreeViewer")) : class$com$sap$caf$designer$views$ModelTreeViewer);
    private GenericDataModelFilteredTreeViewer treeViewer;
    private BOMSystem.BOMListener m_BOMListener = null;
    private List bomSystems = new ArrayList();
    private Action m_refreshAction;
    private StatusLineMessage slm = new StatusLineMessage();
    private boolean openedNoLicenseEditor = false;
    static /* synthetic */ Class class$com$sap$caf$designer$views$ModelTreeViewer;

    public ModelTreeViewer() {
        logger.infoT("Constructor ModelTreeViewer" + (Object)((Object)this));
        instances.add(this);
        this.m_BOMListener = new BOMSystemListener();
        if (!AppDesignerPerspective.getLicense().isValid()) {
            this.createNoLicensePage();
        }
    }

    public void setFocus() {
        try {
            if (AppDesignerPerspective.getLicense().isValid()) {
                if (this.treeViewer != null) {
                    this.treeViewer.getTree().setFocus();
                }
            } else if (!this.openedNoLicenseEditor) {
                this.createNoLicensePage();
            }
        }
        catch (SWTException e) {
            logger.errorT(e.getMessage());
        }
    }

    public static ModelTreeViewer getInstance() {
        return (ModelTreeViewer)((Object)instances.get(0));
    }

    public void createPartControl(Composite parent) {
        if (AppDesignerPerspective.getLicense().isValid()) {
            IProject[] projects = this.identifyCAFProjects();
            PropertyMap[] proojects_map = this.getProjectsFilteredRoots(projects);
            this.createTreeViewer(parent, proojects_map);
            this.createToolBar();
            this.addDoubleClickListener();
            this.addSelectionProvider();
            this.initBOMSystems(projects);
        } else {
            parent.setBackground(new Color(null, 255, 255, 255));
        }
    }

    public void deepRefreshInstance() {
        String[] bomNames = BOMSystem.getBomSystemNames();
        int i = 0;
        while (i < bomNames.length) {
            BOMSystem m_BOMSystem = BOMSystem.getBOMSystem(bomNames[i]);
            if (m_BOMSystem != null) {
                m_BOMSystem.refreshStatus();
                String strOldProjName = m_BOMSystem.getProjectName();
                String strProjType = "";
                if (strProjType == null) {
                    this.deleteProject(strOldProjName);
                    MetamodelProvider.unRegisterMetamodelProvider(strOldProjName);
                }
            }
            ++i;
        }
        this.deepRefreshTreeViewer();
        ModelTreeViewer.refreshInstances();
        this.treeViewer.refresh();
        this.treeViewer.getTreeViewer().refresh();
    }

    public static void deepRefreshInstances() {
        int iSize = instances.size();
        int ic1 = 0;
        while (ic1 < iSize) {
            ModelTreeViewer mTreeView = (ModelTreeViewer)((Object)instances.get(ic1));
            mTreeView.deepRefreshInstance();
            ++ic1;
        }
    }

    public void dispose() {
        String[] bomNames = BOMSystem.getBomSystemNames();
        int i = 0;
        while (i < bomNames.length) {
            BOMSystem m_BOMSystem = BOMSystem.getBOMSystem(bomNames[i]);
            if (m_BOMSystem != null) {
                m_BOMSystem.removeSystemListener(this.m_BOMListener);
            }
            ++i;
        }
        super.dispose();
        instances.remove((Object)this);
    }

    public IProject[] identifyCAFProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        Vector<IProject> vectorFilteredRoots = new Vector<IProject>();
        int i = 0;
        while (i < projects.length) {
            if (GenerationUtilsDt.isCAFProject(projects[i])) {
                vectorFilteredRoots.addElement(projects[i]);
            }
            ++i;
        }
        return vectorFilteredRoots.toArray(new IProject[0]);
    }

    public void modelChanged(ModelChangeEvent changeEvent) {
        logger.infoT("Model changed: " + changeEvent.getModel());
        Model model = changeEvent.getModel();
        ModelDeltaNode delta = changeEvent.getRootDelta();
        Object source = changeEvent.getSource();
        logger.infoT("Model = " + model + " delta " + delta + " source " + source);
    }

    public static void refreshInstances() {
        int n = instances.size();
        int i = 0;
        while (i < n) {
            ModelTreeViewer m = (ModelTreeViewer)((Object)instances.get(i));
            if (m.treeViewer != null) {
                m.treeViewer.refresh();
            }
            ++i;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResource resource = event.getResource();
        if (resource != null) {
            int iType = event.getType();
            if (iType == 2 || iType == 4) {
                String strProjectName = resource.getName();
            } else {
                logger.infoT("Resource changed! " + event.getDelta().getKind() + " type = " + resource.getType() + ", name = " + resource.getName());
            }
        }
        this.deepRefreshTreeViewer();
    }

    protected void initBOMSystems(IProject[] projects) {
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            try {
                BOMSystem bomSystem = BOMSystem.getBOMSystem(project.getName());
                bomSystem.addSystemListener(this.m_BOMListener);
            }
            catch (Exception e) {
                logger.errorT("Project:" + project.getName() + " is unavailable for this SP!");
                logger.errorT(e.getMessage());
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected void initBOMSystems() {
        IProject[] projects = this.identifyCAFProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            try {
                BOMSystem bomSystem = BOMSystem.getBOMSystem(project.getName());
                bomSystem.addSystemListener(this.m_BOMListener);
                IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
            }
            catch (Exception e) {
                logger.errorT("Project:" + project.getName() + " is unavailable for this SP!");
                logger.errorT(e.getMessage());
            }
            ++i;
        }
    }

    void createNoLicensePage() {
        if (NoLicenseEditor.getSingleInstance() == null) {
            try {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage workbenchActivePage = window.getActivePage();
                if (workbenchActivePage != null) {
                    workbenchActivePage.openEditor((IEditorInput)new NoLicenseEditorInput(), "com.sap.caf.designer.editors.NoLicenseEditor");
                }
            }
            catch (PartInitException e) {
                logger.errorT(e.getMessage());
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
                throw new CAFNullPointerException(ex);
            }
        }
        if (NoLicenseEditor.getSingleInstance() != null) {
            NoLicenseEditor.getSingleInstance().setFocus();
            this.openedNoLicenseEditor = true;
        }
    }

    private PropertyMap[] getProjectsFilteredRoots(IProject[] projects) {
        ArrayList<Model> fRootsCollection = new ArrayList<Model>();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project != null) {
                try {
                    BOMSystem bomsystem = BOMSystem.getBOMSystem(project.getName());
                    String appName = "";
                    logger.debugT("ModelTreeViewer -getProjectsFilteredRoots poject Name= " + project.getName());
                    appName = bomsystem != null ? bomsystem.getApplicationName() + " (" + BOMSystem.getBOMSystem(project.getName()).getApplication().getProviderName() + ")" : project.getName();
                    if (project.isOpen()) {
                        UniqueName project_UN = com.sap.caf.designer.model.ModelAccess.createUniqueName("CAF", "Project", null, appName, new String[]{project.getName()});
                        fRootsCollection.add(ModelAccess.createModel((UniqueName)project_UN));
                    }
                }
                catch (Exception e) {
                    logger.errorT("Project:" + project.getName() + "  is unable to load!");
                    logger.errorT(e.getMessage());
                }
            }
            ++i;
        }
        PropertyMap[] filteredRoots = new PropertyMap[fRootsCollection.size()];
        int i2 = 0;
        Iterator iterator = fRootsCollection.iterator();
        while (iterator.hasNext()) {
            filteredRoots[i2++] = (PropertyMap)iterator.next();
        }
        return filteredRoots;
    }

    private PropertyMap[] getProjectsFilteredRoots() {
        IProject[] objects = this.identifyCAFProjects();
        return this.getProjectsFilteredRoots(objects);
    }

    private void addDoubleClickListener() {
        this.treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                Tree tree = (Tree)event.getSource();
                TreeItem[] items = tree.getSelection();
                if (items == null || items.length == 0) {
                    return;
                }
                Object obj = items[0].getData();
                if (obj instanceof Entity) {
                    UniqueName uniqueName = ((Entity)obj).getUniqueName();
                    String subDomain = uniqueName.getSubDomain();
                    Object eInput = null;
                    String editorName = null;
                    Object ownerName = null;
                    boolean localPersistency = false;
                    boolean indexSearch = false;
                    Object selAttributes = null;
                    if (subDomain.equals("Business Entity Service")) {
                        eInput = new BusinessEntityInterfaceEditorInput((CAFBusinessEntityInterface)BOMSystem.getBOMSystem(uniqueName.getParameter(0)).getBusinessEntityInterfaces().get(uniqueName.getName()));
                        editorName = "com.sap.caf.designer.editors.BusinessEntityInterfaceEditor";
                    }
                    if (subDomain.equals("Application Service")) {
                        eInput = new ApplicationInterfaceEditorInput((CAFApplicationInterface)BOMSystem.getBOMSystem(uniqueName.getParameter(0)).getApplicationInterfaces().get(uniqueName.getName()));
                        editorName = "com.sap.caf.designer.editors.ApplicationInterfaceEditor";
                    }
                    if (subDomain.equals("External Service")) {
                        eInput = new ExternalInterfaceEditorInput((CAFExternalInterface)BOMSystem.getBOMSystem(uniqueName.getParameter(0)).getExternalInterfaces().get(uniqueName.getName()));
                        editorName = "com.sap.caf.designer.editors.ExternalInterfaceEditor";
                        if (uniqueName != null && uniqueName.getParametersCount() > 0 && "ExternalRfcService".equals(uniqueName.getParameter(1))) {
                            editorName = "com.sap.caf.designer.editors.ExternalInterfaceEditorRfc";
                        }
                    }
                    if (eInput != null) {
                        IWorkbenchWindow window = ModelTreeViewer.this.getSite().getWorkbenchWindow();
                        try {
                            IWorkbenchPage workbActivePage = window.getActivePage();
                            if (workbActivePage != null) {
                                workbActivePage.openEditor((IEditorInput)eInput, editorName);
                            }
                        }
                        catch (PartInitException e) {
                            MessageDialog.openError((Shell)window.getShell(), (String)"Editor could not be opened", (String)e.getMessage());
                        }
                    }
                }
            }
        });
    }

    private void addSelectionProvider() {
        ElementWrapperSelectionConverter converter = new ElementWrapperSelectionConverter((ISelectionProvider)this.treeViewer.getTreeViewer(), new IElementWrapperConverter(){

            public IElementWrapper getWrapper(Object object) {
                if (object instanceof Element) {
                    return new DefaultElementWrapper((Element)object);
                }
                return null;
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)converter);
    }

    private void createToolBar() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.m_refreshAction = new Action(){

            public void run() {
                ModelTreeViewer.this.deepRefreshTreeViewer();
                ModelTreeViewer.refreshInstances();
                ModelTreeViewer.this.treeViewer.refresh();
                ModelTreeViewer.this.treeViewer.getTreeViewer().refresh();
            }
        };
        this.m_refreshAction.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)SapImage.ICON_REFRESH));
        this.m_refreshAction.setToolTipText(mTextPool.getText("BOM_ALL_0015"));
        toolBarManager.add((IAction)this.m_refreshAction);
    }

    private void createTreeViewer(Composite parent, PropertyMap[] filteredRoots) {
        this.treeViewer = (GenericDataModelFilteredTreeViewer)BOMTreeUtil.createTreeViewer(parent, filteredRoots, true, true);
        this.treeViewer.setFilter((IFilter)new YesManFilter(){

            public boolean isAvailable(PropertyMap propertyMap) {
                boolean ret = true;
                if (propertyMap instanceof Element) {
                    Element element = (Element)propertyMap;
                    UniqueName uniqueName = element.getUniqueName();
                    if (!uniqueName.getDomain().equals("CAF")) {
                        ret = false;
                    } else {
                        String sd = uniqueName.getSubDomain();
                        if ("Sub Catalog".equals(sd) || "Object Root".equals(sd) || "ASService Catalog".equals(sd) || "Create Data Structure".equals(sd) || "Attributes Type Catalog".equals(sd) || "Value Set Root".equals(sd) || "ASService Core Catalog".equals(sd) || "AS Operation Parameters".equals(sd) || "ES Operations Parameters Subdomain".equals(sd) || "Entity Operations Parameters Subdomain".equals(sd)) {
                            ret = false;
                        }
                    }
                }
                return ret;
            }
        });
    }

    private void deepRefreshTreeViewer() {
        if (this.treeViewer != null) {
            Tree tree = this.treeViewer.getTree();
            if (tree == null || tree.isDisposed()) {
                return;
            }
            Display display1 = tree.getDisplay();
            if (display1 == null || display1.isDisposed()) {
                return;
            }
            display1.syncExec(new Runnable(){

                public void run() {
                    PropertyMap[] propMap = ModelTreeViewer.this.getProjectsFilteredRoots();
                    ModelTreeViewer.this.treeViewer.setRoots(propMap);
                    if (BOMSystem.getBomSystemNames().length == 0) {
                        ModelTreeViewer.this.initBOMSystems();
                    }
                }
            });
            this.printMessage(mTextPool.getText("BOM_STATUSLINE_0007") + ".");
        }
    }

    private void deleteProject(final String strProjName) {
        Tree tree = this.treeViewer.getTree();
        if (tree == null || tree.isDisposed()) {
            return;
        }
        Display display1 = tree.getDisplay();
        if (display1 == null || display1.isDisposed()) {
            return;
        }
        display1.syncExec(new Runnable(){

            public void run() {
                MetamodelProvider.setDirty(strProjName, false);
                BOMSystem bomSys = BOMSystem.getBOMSystem(strProjName);
                bomSys.notifyCloseProject();
                int i = 0;
                while (i < BOMSystem.getBomSystemNames().length) {
                    BOMSystem m_BOMSystem = BOMSystem.getBOMSystem(BOMSystem.getBomSystemNames()[i]);
                    if (bomSys == m_BOMSystem) {
                        m_BOMSystem.removeSystemListener(ModelTreeViewer.this.m_BOMListener);
                        m_BOMSystem = null;
                    }
                    ++i;
                }
                UniqueName project = com.sap.caf.designer.model.ModelAccess.createUniqueName("CAF", "Project", null, strProjName + " ", new String[]{strProjName});
                ModelTreeViewer.this.treeViewer.removeRoot((PropertyMap)ModelAccess.createModel((UniqueName)project));
                bomSys.closeSystem();
                bomSys.deleteSystem();
            }
        });
        this.deepRefreshTreeViewer();
    }

    private void printMessage(String messageText) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IStatusLineManager slm = actionBars.getStatusLineManager();
        if (slm == null) {
            return;
        }
        slm.setMessage(messageText);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class BOMSystemListener
    implements BOMSystem.BOMListener {
        protected BOMSystemListener() {
        }

        public void systemChanged(BOMSystem.BOMEvent e) {
            switch (e.getType()) {
                case 4: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 17: 
                case 19: 
                case 21: 
                case 23: {
                    ModelTreeViewer.refreshInstances();
                    break;
                }
            }
        }
    }
}

