/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.utils.metadata;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class MigrateMetadata {
    public static String[][] tags = new String[][]{{"ID", "id"}, {"DBTableName", "DbTableName"}, {"DBFieldName", "DbFieldName"}};
    File _root;

    protected MigrateMetadata(String root) {
        this._root = new File(root);
    }

    public static void main(String[] args) {
        MigrateMetadata mm = new MigrateMetadata(args[0]);
        mm.startMigration();
    }

    protected void migrate(File directory) {
        File[] files = directory.listFiles();
        Vector<File> subDirs = new Vector<File>();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                subDirs.add(files[i]);
            } else {
                String fName = files[i].getName();
                if (fName.endsWith("_I.xml")) {
                    this.migrateTags(files[i]);
                }
                if (fName.endsWith(".ser")) {
                    files[i].delete();
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < subDirs.size()) {
            this.migrate((File)subDirs.get(i2));
            ++i2;
        }
    }

    protected void migrateTags(File file) {
        FileReader fr = null;
        char[] content = null;
        boolean changed = false;
        try {
            String strContent;
            fr = new FileReader(file);
            content = new char[(int)file.length()];
            fr.read(content);
            fr.close();
            String newContent = strContent = new String(content);
            int i = 0;
            while (i < tags.length) {
                newContent = this.replaceTag(tags[i], newContent);
                ++i;
            }
            if (!strContent.equals(newContent)) {
                FileWriter fw = new FileWriter(file);
                fw.write(newContent.toCharArray());
                fw.close();
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    protected String replaceTag(String[] tag, String content) {
        int n = content.indexOf(tag[0]);
        if (n == -1) {
            return content;
        }
        String subBefore = content.substring(0, n);
        String subAfter = content.substring(n + tag[0].length(), content.length());
        content = subBefore + tag[1] + subAfter;
        return content;
    }

    protected void startMigration() {
        this.migrate(this._root);
        File[] files = this._root.listFiles();
        int i = 0;
        while (i < files.length) {
            if (!files[i].isDirectory()) {
                this.migrateTags(files[i]);
            }
            ++i;
        }
    }
}

