/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.utils;

import java.util.StringTokenizer;

public class WildcardExpression {
    private String[] parts;
    private static final String WILDCARDCHAR = "*";

    public WildcardExpression(String wildcard) {
        if (wildcard.length() == 0) {
            this.parts = new String[0];
            return;
        }
        StringTokenizer tokens = new StringTokenizer(wildcard, WILDCARDCHAR);
        int nTokenLen = tokens.countTokens();
        int offset = 0;
        boolean bInTheBeginning = wildcard.substring(0, 1).equals(WILDCARDCHAR);
        boolean bInTheEnd = wildcard.substring(wildcard.length() - 1, wildcard.length()).equals(WILDCARDCHAR);
        this.parts = new String[nTokenLen + (bInTheBeginning ? 1 : 0) + (bInTheEnd ? 1 : 0)];
        if (bInTheBeginning) {
            this.parts[0] = "";
            offset = 1;
        }
        int i = 0;
        while (i < nTokenLen) {
            this.parts[i + offset] = tokens.nextToken();
            ++i;
        }
        if (bInTheEnd) {
            this.parts[this.parts.length - 1] = "";
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        if (this.parts.length > 0) {
            buff.append(this.parts[0]);
            int i = 1;
            while (i < this.parts.length) {
                buff.append(WILDCARDCHAR);
                buff.append(this.parts[i]);
                ++i;
            }
        }
        return buff.toString();
    }

    public boolean match(String src) {
        if (this.parts == null || this.parts.length == 0) {
            return false;
        }
        int i = 0;
        int nPos = -1;
        if ((nPos = src.indexOf(this.parts[0], nPos)) != 0) {
            return false;
        }
        nPos += this.parts[0].length();
        i = 1;
        while (i < this.parts.length - 1) {
            if ((nPos = src.indexOf(this.parts[i], nPos)) == -1) {
                return false;
            }
            nPos += this.parts[i].length();
            ++i;
        }
        String lastFragment = this.parts[this.parts.length - 1];
        if (lastFragment.length() == 0) {
            return true;
        }
        int nLastFrmStartIndex = src.length() - lastFragment.length();
        if (nPos > nLastFrmStartIndex) {
            return false;
        }
        return src.substring(nLastFrmStartIndex, src.length()).equals(lastFragment);
    }
}

