/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.utils;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;

public class TableColumnResizer
extends ControlAdapter {
    private Table table;
    private double[] widthWeights;
    private boolean inEvent;
    private int oldWidth;

    public TableColumnResizer(Table table, int[] widthWeights) {
        this.table = table;
        int sum = 0;
        int i = 0;
        while (i < widthWeights.length) {
            sum += widthWeights[i];
            ++i;
        }
        this.widthWeights = new double[this.table.getColumnCount()];
        i = 0;
        while (i < this.widthWeights.length) {
            this.widthWeights[i] = i < widthWeights.length ? (double)widthWeights[i] / (double)sum : 0.0;
            ++i;
        }
        this.inEvent = false;
        this.oldWidth = -1;
    }

    public void controlResized(ControlEvent e) {
        int i;
        if (this.inEvent) {
            return;
        }
        this.inEvent = true;
        Rectangle area = this.table.getParent().getClientArea();
        Point preferredSize = this.table.computeSize(-1, -1);
        int width = area.width - 2 * this.table.getBorderWidth();
        if (preferredSize.y > area.height) {
            width -= this.table.getVerticalBar().getSize().x;
        }
        if (this.oldWidth >= 0) {
            i = 0;
            while (i < this.widthWeights.length) {
                this.widthWeights[i] = (double)this.table.getColumn(i).getWidth() / (double)this.oldWidth;
                ++i;
            }
        }
        if (this.oldWidth <= width) {
            this.table.setSize(area.width, area.height);
        }
        i = 0;
        while (i < this.widthWeights.length) {
            this.table.getColumn(i).setWidth((int)(this.widthWeights[i] * (double)width));
            ++i;
        }
        if (this.oldWidth > width) {
            this.table.setSize(area.width, area.height);
        }
        this.oldWidth = width;
        this.inEvent = false;
    }
}

