/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.utils;

import com.sap.caf.designer.utils.WildcardExpression;
import com.tssap.config.ConfigPlugin;
import com.tssap.config.ProxySettings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Preferences;

public class ProxyConfig {
    public URL urlHttpProxy;
    public String[] skipProxyAddresses;

    public boolean checkNeedProxy(URL url) {
        if (this.urlHttpProxy == null) {
            return false;
        }
        if (this.skipProxyAddresses == null) {
            return true;
        }
        String host = url.getHost();
        int i = 0;
        while (i < this.skipProxyAddresses.length) {
            WildcardExpression wildcard = new WildcardExpression(this.skipProxyAddresses[i]);
            if (wildcard.match(host)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static ProxySettings readProxySettingsConfig() {
        Preferences tssapConfig = ConfigPlugin.getInstance().getPluginPreferences();
        return ProxySettings.loadFromPreferences((Preferences)tssapConfig);
    }

    public static ProxyConfig loadFromPrefereces() {
        ProxySettings proxyPref = ProxyConfig.readProxySettingsConfig();
        ProxyConfig proxyConf = new ProxyConfig();
        proxyConf.urlHttpProxy = ProxyConfig.formProxyURL(proxyPref);
        if (proxyConf.urlHttpProxy != null) {
            proxyConf.skipProxyAddresses = ProxyConfig.getAddressesBypassProxy(proxyPref);
        }
        return proxyConf;
    }

    private static URL formProxyURL(ProxySettings proxyPref) {
        URL res = null;
        if (proxyPref.isProxySet()) {
            try {
                res = new URL("http", proxyPref.getHost(), proxyPref.getPort(), "/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return res;
    }

    private static String[] getAddressesBypassProxy(ProxySettings proxyPref) {
        String listofsites;
        if (proxyPref.isApplyNoProxy() && (listofsites = proxyPref.getNoProxy()) != null && listofsites.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(listofsites, ";");
            int nLen = tokens.countTokens();
            String[] res = new String[nLen];
            int i = 0;
            while (i < nLen) {
                res[i] = tokens.nextToken().trim();
                ++i;
            }
            return res;
        }
        return null;
    }
}

