/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.utils;

import com.sap.caf.designer.exception.CAFNullPointerException;
import java.util.HashSet;
import java.util.StringTokenizer;

public class OpenSQLReservedWords {
    private static final HashSet wordSet;

    public static boolean isWordReserved(String name) {
        if (name == null) {
            throw new CAFNullPointerException("An illegal null value passed as a parameter of OpenSQLReservedWords.isWordReserved( String name ) method.");
        }
        return wordSet.contains(name.toUpperCase().trim());
    }

    static {
        String osqlResvWordSource = " ALL, ALTER, AND, ANY, AS, ASC, AT, AVG, BETWEEN, BIT_LENGTH, BOTH, BY, CASE, CAST, CHAR_LENGTH, CHARACTER_LENGTH, COALESCE, COLLATE, COMMIT, CONNECT, CONVERT, CORRESPONDING, COUNT, CREATE, CROSS, CURRENT_DATE, CURRENT_TIME, CURRENT_TIMESTAMP, CURRENT_USER, DATE, DAY, DECLARE, DEFAULT, DELETE, DESC, DISCONNECT, DISTINCT, DROP,  ELSE, END, ESCAPE, EXCEPT, EXISTS, EXTRACT, FALSE, FOR, FROM, FULL, GRANT, GROUP, HAVING, HOUR, IN, INDICATOR, INNER, INSERT, INTERSECT, INTERVAL, INTO, IS, JOIN, LEADING, LEFT, LIKE, LOCAL, LOWER, MATCH, MAX, MIN, MINUTE, MODULE, MONTH, NATURAL, NOT, NULL, NULLIF, OCTET_LENGTH, OF, ON, OR, ORDER, OUTER, OVERLAPS, PARTIAL, POSITION,  REVOKE, RIGHT, ROLLBACK, SECOND, SELECT, SESSION_USER, SET, SOME, SUBSTRING, SUM, SYSTEM_USER, TABLE, THEN, TIME, TIMESTAMP, TIMEZONE_HOUR, TIMEZONE_MINUTE, TO, TRAILING, TRANSLATE, TRIM, TRUE, UNION, UNIQUE, UNKNOWN, UPDATE, UPPER, USER, USING, VALUE, VALUES, WHEN, WHERE, WORK, YEAR, ZONE,  ABSOLUTE, ACTION, ACTOR, ADD, AFTER, ALIAS, ALLOCATE, ARE, ASSERTION, ASYNC, ATTRIBUTES, AUTHORIZATION, BEFORE, BEGIN, BIT, BOOLEAN, BREADTH, CASCADE, CASCADED, CATALOG, CHAR, CHARACTER, CHECK, CLASS, CLOSE, COLLATION, COLUMN, COMPLETION, CONNECTION, CONSTRAINT, CONSTRAINTS, CONSTRUCTOR, CONTINUE, CURRENT, CURRENT_PATH, CURSOR,  CYCLE, DATA, DEALLOCATE, DEC, DECIMAL, DEFERRABLE, DEFERRED, DEPTH, DESCRIBE, DESCRIPTOR, DESIGNATOR, DESTROY, DESTRUCTOR, DIAGNOSTICS, DICTIONARY, DOMAIN, DOUBLE, EACH, ELEMENT, END-EXEC, EQUALS, EXCEPTION, EXEC, EXECUTE, EXTERNAL, FACTOR, FETCH, FIRST, FLOAT, FOREIGN, FOUND, FUNCTION, GENERAL, GET, GLOBAL, GO, GOTO, IDENTITY,  IGNORE, IMMEDIATE, INITIALLY, INOUT, INPUT, INSENSITIVE, INSTEAD, INT, INTEGER, ISOLATION, KEY, LANGUAGE, LAST, LESS, LEVEL, LIMIT, LIST, MODIFY, MOVE, MULTISET, NAMES, NATIONAL, NCHAR, NEW, NEW_TABLE, NEXT, NO, NONE, NUMERIC, OFF, OID, OLD, OLD_TABLE, ONLY, OPEN, OPERATION, OPERATOR, OPERATORS, OPTION, OUT, OUTPUT, PAD, PARAMETERS,  PATH, PENDANT, POSTFIX, PRECISION, PREFIX, PREORDER, PREPARE, PRESERVE, PRIMARY, PRIOR, PRIVATE, PRIVILEGES, PROCEDURE, PROTECTED, PUBLIC, READ, REAL, RECURSIVE, REFERENCES, REFERENCING, RELATIVE, REPRESENTATION, RESTRICT, ROLE, ROUTINE, ROW, ROWS, SAVEPOINT, SCHEMA, SCROLL, SEARCH, SECTION, SENSITIVE, SEQUENCE, SESSION, SIMILAR, SIZE,  SMALLINT, SPACE, SPECIFIC, SQL, SQLCODE, SQLERROR, SQLEXCEPTION, SQLSTATE, SQLWARNING, START, STATE, STRUCTURE, SYMBOL, TEMPLATE, TEMPORARY, TERM, TEST, THAN, THERE, TRANSACTION, TRANSLATION, TRIGGER, TYPE, UNDER, USAGE, VARCHAR, VARIABLE, VARIANT, VARYING, VIEW, VIRTUAL, VISIBLE, WAIT, WHENEVER, WITH, WITHOUT, WRITE";
        StringTokenizer tokenizer = new StringTokenizer(osqlResvWordSource, ",", false);
        wordSet = new HashSet(tokenizer.countTokens() + 1);
        while (tokenizer.hasMoreTokens()) {
            String rsvWord = tokenizer.nextToken().trim().toUpperCase();
            if (rsvWord.length() <= 0) continue;
            wordSet.add(rsvWord);
        }
    }
}

