/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.utils;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.dtr.IResourceChangeListener;
import com.sap.caf.designer.generation.CAFProjectLocations;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ModifiedServicesList {
    private static final String ORIGINAL_FILE = "ModifiedServicesList.orig";
    private static final String BACKUP_FILE = "ModifiedServicesList.bckp";
    private static final String SUCCESS = "SUCCESS";
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$utils$ModifiedServicesList == null ? (class$com$sap$caf$designer$utils$ModifiedServicesList = ModifiedServicesList.class$("com.sap.caf.designer.utils.ModifiedServicesList")) : class$com$sap$caf$designer$utils$ModifiedServicesList);
    private HashSet hashSet;
    private IResourceChangeListener changeListener = null;
    private String pathToGeneratedFilesList = "";
    static /* synthetic */ Class class$com$sap$caf$designer$utils$ModifiedServicesList;

    public ModifiedServicesList(CAFProjectLocations cafProjectLocations, Application app, IResourceChangeListener listener) {
        this.pathToGeneratedFilesList = cafProjectLocations.getEarProjectPath();
        this.changeListener = listener;
        this.loadDirtyList(app);
    }

    public Set getFileList() {
        return this.hashSet;
    }

    public synchronized void objectModified(BaseObject object) {
        this.hashSet.add(object);
        this.saveDirtyList();
    }

    public boolean contains(BaseObject object) {
        return this.hashSet.contains(object);
    }

    public synchronized void objectGenerated(BaseObject object) {
        this.hashSet.remove(object);
        this.saveDirtyList();
    }

    public void clearList() {
        this.hashSet.clear();
        this.saveDirtyList();
    }

    /*
     * WARNING - void declaration
     */
    private void loadDirtyList(Application app) {
        this.hashSet = new HashSet();
        try {
            File orig = new File(this.pathToGeneratedFilesList + "/" + ORIGINAL_FILE);
            if (!orig.exists() || !this.validFile(orig)) {
                orig = new File(this.pathToGeneratedFilesList + "/" + BACKUP_FILE);
            }
            if (orig.exists() && this.validFile(orig)) {
                String str;
                BufferedReader in = new BufferedReader(new FileReader(orig));
                block3: while ((str = in.readLine()) != null) {
                    void var4_6;
                    if (SUCCESS.equalsIgnoreCase((String)var4_6)) continue;
                    Iterator it = app.getBaseObjects().iterator();
                    while (it.hasNext()) {
                        BaseObject bo = (BaseObject)it.next();
                        String id = bo.getObjectId();
                        if (!id.equals(var4_6)) continue;
                        this.hashSet.add(bo);
                        continue block3;
                    }
                }
                in.close();
            } else {
                this.saveDirtyList();
            }
        }
        catch (FileNotFoundException e) {
            logger.infoT("FileNotFoundException " + e.getMessage());
        }
        catch (IOException e) {
            logger.infoT("IOException " + e.getMessage());
        }
    }

    private void saveDirtyList() {
        block14: {
            if (this.changeListener != null) {
                HashMap createQueue = new HashMap();
                HashMap updateQueue = new HashMap();
                HashMap deleteQueue = new HashMap();
                FileUtils.addSortedEntry(updateQueue, "/ModifiedServicesList.orig", "ENTERPRISE_APPLICATION");
                FileUtils.addSortedEntry(updateQueue, "/ModifiedServicesList.bckp", "ENTERPRISE_APPLICATION");
                boolean performChanges = this.changeListener.notifyResourceModifications(createQueue, updateQueue, deleteQueue);
                if (!performChanges) {
                    logger.infoT("DTR integration canceled, no changes will be performed");
                    return;
                }
            }
            if (this.hashSet == null) {
                return;
            }
            try {
                try {
                    File orig = new File(this.pathToGeneratedFilesList + "/" + ORIGINAL_FILE);
                    if (orig.exists() && this.validFile(orig)) {
                        File backup = new File(this.pathToGeneratedFilesList + "/" + BACKUP_FILE);
                        backup.delete();
                        File backupForRename = new File(this.pathToGeneratedFilesList + "/" + BACKUP_FILE);
                        orig.renameTo(backupForRename);
                    }
                    PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.pathToGeneratedFilesList + "/" + ORIGINAL_FILE)));
                    Iterator it = this.hashSet.iterator();
                    while (it.hasNext()) {
                        BaseObject bo = (BaseObject)it.next();
                        out.println(bo.getObjectId());
                    }
                    out.println(SUCCESS);
                    out.close();
                }
                catch (FileNotFoundException e) {
                    logger.infoT("FileNotFoundException " + e.getMessage());
                    Object var6_9 = null;
                    if (this.changeListener != null) {
                        this.changeListener.finalizeModifications();
                    }
                    break block14;
                }
                catch (IOException e) {
                    logger.infoT("IOException " + e.getMessage());
                    Object var6_10 = null;
                    if (this.changeListener != null) {
                        this.changeListener.finalizeModifications();
                    }
                }
                Object var6_8 = null;
                if (this.changeListener != null) {
                    this.changeListener.finalizeModifications();
                }
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                if (this.changeListener != null) {
                    this.changeListener.finalizeModifications();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean validFile(File f) {
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(f));
            String tmp = "";
            while ((str = in.readLine()) != null) {
                void var3_5;
                tmp = var3_5;
            }
            in.close();
            if (SUCCESS.equalsIgnoreCase(tmp)) {
                return true;
            }
        }
        catch (FileNotFoundException e) {
            logger.infoT("FileNotFoundException " + e.getMessage());
        }
        catch (IOException e) {
            logger.infoT("IOException " + e.getMessage());
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

