/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.utils;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;

public class ImportsExtractor {
    private ArrayList list;
    private HashSet map;
    private static String IMPORT = "import ";
    private static String CLASS = "class ";

    private ImportsExtractor() {
    }

    public ImportsExtractor(String sourceCode) {
        String source = ImportsExtractor.scrapComments(sourceCode);
        this.extractImports(source);
    }

    public ImportsExtractor(File sourceFile) throws IOException {
        this(ImportsExtractor.loadFile(sourceFile));
    }

    private static String loadFile(File sourceFile) throws IOException {
        StringBuffer sourceCode = new StringBuffer();
        FileReader input = new FileReader(sourceFile);
        char[] buffer = new char[1024];
        try {
            int len = input.read(buffer);
            while (len >= 0) {
                sourceCode.append(buffer, 0, len);
                len = input.read(buffer);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            input.close();
            throw throwable;
        }
        input.close();
        return sourceCode.toString();
    }

    public int getLength() {
        return this.list.size();
    }

    public String getImportName(int i) {
        return (String)this.list.get(i);
    }

    private static boolean isSeparator(char ch) {
        return ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t';
    }

    private static boolean isEOL(char ch) {
        return ch == '\r' || ch == '\n';
    }

    private static String scrapComments(String sourceCode) {
        if (sourceCode == null) {
            return "";
        }
        int nState = 0;
        int nPos = 0;
        int nLen = sourceCode.length();
        StringBuffer result = new StringBuffer(sourceCode.length());
        while (nPos < nLen) {
            char ch = sourceCode.charAt(nPos);
            switch (nState) {
                case 0: {
                    if (ch == '/' && nPos + 1 < nLen && sourceCode.charAt(nPos + 1) == '*') {
                        nState = 1;
                        ++nPos;
                        break;
                    }
                    if (ch == '/' && nPos + 1 < nLen && sourceCode.charAt(nPos + 1) == '/') {
                        nState = 2;
                        ++nPos;
                        break;
                    }
                    if (ImportsExtractor.isSeparator(ch)) {
                        nState = 3;
                        result.append(' ');
                        break;
                    }
                    result.append(ch);
                    break;
                }
                case 1: {
                    if (ch != '*' || nPos + 1 >= nLen || sourceCode.charAt(nPos + 1) != '/') break;
                    nState = 0;
                    ++nPos;
                    break;
                }
                case 2: {
                    if (!ImportsExtractor.isEOL(ch)) break;
                    nState = 0;
                    break;
                }
                case 3: {
                    if (ImportsExtractor.isSeparator(ch)) break;
                    nState = 0;
                    --nPos;
                }
            }
            ++nPos;
        }
        return result.toString();
    }

    private void extractImports(String source) {
        this.list = new ArrayList();
        this.map = new HashSet();
        int nState = 0;
        int nPos = 0;
        int nLen = source.length();
        StringBuffer name = null;
        while (nPos < nLen) {
            switch (nState) {
                case 0: {
                    if (nPos + IMPORT.length() < nLen && source.substring(nPos, nPos + IMPORT.length()).equals(IMPORT)) {
                        nState = 1;
                        nPos += IMPORT.length();
                        name = new StringBuffer();
                        break;
                    }
                    if (nPos + CLASS.length() < nLen && source.substring(nPos, nPos + CLASS.length()).equals(CLASS)) {
                        nPos = nLen;
                        break;
                    }
                    ++nPos;
                    break;
                }
                case 1: {
                    if (source.charAt(nPos) == ';') {
                        nState = 0;
                        String importClassName = name.toString();
                        if (!this.map.contains(importClassName)) {
                            this.list.add(importClassName);
                            this.map.add(importClassName);
                        }
                    } else {
                        name.append(source.charAt(nPos));
                    }
                    ++nPos;
                }
            }
        }
    }

    public void removeImport(String name) {
        if (this.map.contains(name)) {
            ((AbstractCollection)this.list).remove(name);
            this.map.remove(name);
        }
    }

    public Object clone() {
        ImportsExtractor copied = new ImportsExtractor();
        copied.list = new ArrayList(this.list);
        copied.map = new HashSet(this.map);
        return copied;
    }
}

