/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.utils;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.generation.CAFProjectLocations;
import com.sap.caf.tools.velocity.utils.StringUtils;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class GeneratedFilesList {
    public static final String GENERATED_ORIGINAL_FILE = "GeneratedFilesList.orig";
    public static final String GENERATED_BACKUP_FILE = "GeneratedFilesList.bckp";
    private static final String SUCCESS = "SUCCESS";
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$utils$GeneratedFilesList == null ? (class$com$sap$caf$designer$utils$GeneratedFilesList = GeneratedFilesList.class$("com.sap.caf.designer.utils.GeneratedFilesList")) : class$com$sap$caf$designer$utils$GeneratedFilesList);
    private HashSet hashSet;
    private String pathToRoot = "";
    private String pathToGeneratedFilesList = "";
    String applicationServicesPathEnds = "";
    String dictionaryPathEnds = "";
    String earProjectPathEnds = "";
    String umePermissionsProjectPathEnds = "";
    String wdpProjectPathEnds = "";
    String metadataProjectPathEnds = "";
    static /* synthetic */ Class class$com$sap$caf$designer$utils$GeneratedFilesList;

    public GeneratedFilesList(CAFProjectLocations cafProjectLocations) {
        this.pathToGeneratedFilesList = cafProjectLocations.getEarProjectPath();
        String path = cafProjectLocations.getEarProjectPath();
        if (path != null) {
            if (path.lastIndexOf("/") != -1) {
                this.pathToRoot = path.substring(0, path.lastIndexOf("/"));
            }
            this.applicationServicesPathEnds = this.filePathReplacer(cafProjectLocations.getApplicationServicesPath());
            this.dictionaryPathEnds = this.filePathReplacer(cafProjectLocations.getDictionaryPath());
            this.earProjectPathEnds = this.filePathReplacer(cafProjectLocations.getEarProjectPath());
            this.umePermissionsProjectPathEnds = this.filePathReplacer(cafProjectLocations.getUMEPermissionsProjectPath());
            this.wdpProjectPathEnds = this.filePathReplacer(cafProjectLocations.getWdpProjectPath());
            this.metadataProjectPathEnds = this.filePathReplacer(cafProjectLocations.getMetadataPath());
        }
        this.loadFilesList();
    }

    public String[] getDCPathAndType(String fullPath) {
        String relativePath = this.filePathReplacer(fullPath);
        return this.getDCPathAndTypeFromRelativePath(relativePath);
    }

    public Map getFileList() {
        HashMap<String, String> hm = new HashMap<String, String>();
        if (this.hashSet == null) {
            return hm;
        }
        Iterator it = this.hashSet.iterator();
        while (it.hasNext()) {
            String filePath = (String)it.next();
            String[] dcPathAndType = this.getDCPathAndTypeFromRelativePath(filePath);
            if (dcPathAndType == null || dcPathAndType.length != 2 || "".equals(dcPathAndType[0]) || "".equals(dcPathAndType[1])) continue;
            hm.put(dcPathAndType[0], dcPathAndType[1]);
        }
        return hm;
    }

    public String getFullPath(String relativePath, String projectID) {
        String tmp = "";
        if ("EJB".equals(projectID)) {
            tmp = this.applicationServicesPathEnds;
        } else if ("DICT".equals(projectID)) {
            tmp = this.dictionaryPathEnds;
        } else if ("ENTERPRISE_APPLICATION".equals(projectID)) {
            tmp = this.earProjectPathEnds;
        } else if ("UME_PROJECT".equals(projectID)) {
            tmp = this.umePermissionsProjectPathEnds;
        } else if ("WDP_PROJECT".equals(projectID)) {
            tmp = this.wdpProjectPathEnds;
        } else if ("MMR".equals(projectID)) {
            tmp = this.metadataProjectPathEnds;
        }
        return this.pathToRoot + tmp + relativePath;
    }

    public synchronized void addFilePath(String filePath) {
        this.hashSet.add(this.filePathReplacer(filePath));
        this.saveFilesList();
    }

    public boolean canDelete(String filePath) {
        return this.hashSet.contains(this.filePathReplacer(filePath));
    }

    public synchronized void removeFilePath(String filePath) {
        this.hashSet.remove(this.filePathReplacer(filePath));
        this.saveFilesList();
    }

    public String[] getDCPathAndTypeFromRelativePath(String relativePath) {
        String[] dcPathAndType = new String[]{"", ""};
        if (relativePath.startsWith(this.applicationServicesPathEnds)) {
            String tmp;
            dcPathAndType[0] = tmp = relativePath.substring(this.applicationServicesPathEnds.length());
            dcPathAndType[1] = "EJB";
        } else if (relativePath.startsWith(this.dictionaryPathEnds)) {
            String tmp;
            dcPathAndType[0] = tmp = relativePath.substring(this.dictionaryPathEnds.length());
            dcPathAndType[1] = "DICT";
        } else if (relativePath.startsWith(this.earProjectPathEnds)) {
            String tmp;
            dcPathAndType[0] = tmp = relativePath.substring(this.earProjectPathEnds.length());
            dcPathAndType[1] = "ENTERPRISE_APPLICATION";
        } else if (relativePath.startsWith(this.umePermissionsProjectPathEnds)) {
            String tmp;
            dcPathAndType[0] = tmp = relativePath.substring(this.umePermissionsProjectPathEnds.length());
            dcPathAndType[1] = "UME_PROJECT";
        } else if (relativePath.startsWith(this.wdpProjectPathEnds)) {
            String tmp;
            dcPathAndType[0] = tmp = relativePath.substring(this.wdpProjectPathEnds.length());
            dcPathAndType[1] = "WDP_PROJECT";
        } else if (relativePath.startsWith(this.metadataProjectPathEnds)) {
            String tmp;
            dcPathAndType[0] = tmp = relativePath.substring(this.metadataProjectPathEnds.length());
            dcPathAndType[1] = "MMR";
        }
        return dcPathAndType;
    }

    private String filePathReplacer(String filePath) {
        filePath = filePath.replace('\\', '/');
        filePath = StringUtils.replaceAll(filePath, this.pathToRoot, "");
        return filePath;
    }

    /*
     * WARNING - void declaration
     */
    private void loadFilesList() {
        this.hashSet = new HashSet();
        try {
            File orig = new File(this.pathToGeneratedFilesList + "/" + GENERATED_ORIGINAL_FILE);
            if (!orig.exists() || !this.validFile(orig)) {
                orig = new File(this.pathToGeneratedFilesList + "/" + GENERATED_BACKUP_FILE);
            }
            if (orig.exists() && this.validFile(orig)) {
                String str;
                BufferedReader in = new BufferedReader(new FileReader(orig));
                while ((str = in.readLine()) != null) {
                    void var3_5;
                    if (SUCCESS.equalsIgnoreCase((String)var3_5)) continue;
                    this.hashSet.add(var3_5);
                }
                in.close();
            }
        }
        catch (FileNotFoundException e) {
            logger.infoT("FileNotFoundException " + e.getMessage());
        }
        catch (IOException e) {
            logger.infoT("IOException " + e.getMessage());
        }
    }

    private void saveFilesList() {
        if (this.hashSet == null) {
            return;
        }
        try {
            File orig = new File(this.pathToGeneratedFilesList + "/" + GENERATED_ORIGINAL_FILE);
            if (orig.exists() && this.validFile(orig)) {
                File backup = new File(this.pathToGeneratedFilesList + "/" + GENERATED_BACKUP_FILE);
                backup.delete();
                File backupForRename = new File(this.pathToGeneratedFilesList + "/" + GENERATED_BACKUP_FILE);
                orig.renameTo(backupForRename);
            }
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.pathToGeneratedFilesList + "/" + GENERATED_ORIGINAL_FILE)));
            Iterator it = this.hashSet.iterator();
            while (it.hasNext()) {
                out.println("" + it.next());
            }
            out.println(SUCCESS);
            out.close();
        }
        catch (FileNotFoundException e) {
            logger.infoT("FileNotFoundException " + e.getMessage());
        }
        catch (IOException e) {
            logger.infoT("IOException " + e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean validFile(File f) {
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(f));
            String tmp = "";
            while ((str = in.readLine()) != null) {
                void var3_5;
                tmp = var3_5;
            }
            in.close();
            if (SUCCESS.equalsIgnoreCase(tmp)) {
                return true;
            }
        }
        catch (FileNotFoundException e) {
            logger.infoT("FileNotFoundException " + e.getMessage());
        }
        catch (IOException e) {
            logger.infoT("IOException " + e.getMessage());
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

